/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.SourcePanel;
import com.arm.streamline.model.SourceFileUiUtils;
import com.arm.streamline.model.iterable.SourceReferenceSelectionIterator;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenSourceFileAction
extends Action
implements ISelectionChangedListener {
    private ISelectionProvider mProvider;
    private ContextMenu mContextMenu;
    private final @NonNull Runnable showPathSubstitutionDialogRunner;

    public OpenSourceFileAction(ContextMenu cm, @NonNull Runnable showPathSubstitutionDialogRunner) {
        super(PluginMessages.EDIT_SOURCE, StreamlinePlugin.getImageDescriptor("EditSource.png"));
        this.showPathSubstitutionDialogRunner = showPathSubstitutionDialogRunner;
        this.mContextMenu = cm;
        this.selectionChanged(null);
    }

    public OpenSourceFileAction(ISelectionProvider provider, @NonNull Runnable showPathSubstitutionDialogRunner) {
        super(PluginMessages.EDIT_SOURCE, StreamlinePlugin.getImageDescriptor("EditSource.png"));
        this.showPathSubstitutionDialogRunner = showPathSubstitutionDialogRunner;
        this.mProvider = provider;
        this.selectionChanged(null);
        this.mProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        try {
            HashMap<@NonNull SourceFile, @NonNull ISourceReference> map = new HashMap<SourceFile, ISourceReference>();
            for (ISourceReference ref : new SourceReferenceSelectionIterator(this.getSelection())) {
                SourceFile file = ref.getSourceFile();
                if (file.isBinary()) continue;
                ISourceReference mapRef = (ISourceReference)map.get(file);
                if (mapRef == null) {
                    map.put(file, ref);
                    continue;
                }
                int diff = mapRef.getStartLine() - ref.getStartLine();
                if (diff > 0) {
                    map.put(file, ref);
                    continue;
                }
                if (diff != 0 || mapRef.getStartColumn() <= ref.getStartColumn()) continue;
                map.put(file, ref);
            }
            SourceFile file = null;
            boolean notFound = false;
            for (Map.Entry entry : map.entrySet()) {
                file = (SourceFile)entry.getKey();
                IEditorInput input = SourceFileUiUtils.createEditorInput(file);
                if (input == null) {
                    notFound = true;
                    continue;
                }
                IEditorPart editor = SourceFileUiUtils.openWithDefaultEditor(input);
                if (!(editor instanceof ITextEditor)) continue;
                ISourceReference reference = (ISourceReference)entry.getValue();
                SourceFileUiUtils.select((ITextEditor)editor, reference);
            }
            if (notFound && MessageDialog.openQuestion(null, (String)PluginMessages.WARNING, (String)PluginMessages.NOT_FOUND) && file != null) {
                this.showPathSubstitutionDialogRunner.run();
            }
        }
        catch (Exception exception) {
            Error.show(exception);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (ISourceReference file : new SourceReferenceSelectionIterator(this.getSelection())) {
            SourceFile sourceFile = file.getSourceFile();
            if (sourceFile.isBinary()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private ISelection getSelection() {
        ISelection selection;
        ISelection iSelection = selection = this.mProvider != null ? this.mProvider.getSelection() : this.mContextMenu.getSelection();
        if (selection.isEmpty()) {
            SourceFile file;
            ISelectionProvider provider = this.mProvider;
            if (provider == null) {
                provider = this.mContextMenu.getHandlerControl();
            }
            if (provider instanceof CodeTab) {
                provider = ((CodeTab)provider).getSourcePanel();
            }
            if (provider instanceof SourcePanel && (file = ((SourcePanel)provider).getSourceFile()) != null) {
                selection = new StructuredSelection((Object)file);
            }
        }
        return selection;
    }
}

