/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class InstructionCounterOutlineUpdater<T, C extends IColumnEnum<T, Void>>
implements IValueChangeListener<IInstructionCounterSource> {
    protected final @NonNull AnalysisOutline<T> outline;
    private final @NonNull Map<@NonNull IInstructionCounterSource, @NonNull String> currentColumnConfiguration = new HashMap<IInstructionCounterSource, String>();

    public InstructionCounterOutlineUpdater(@NonNull AnalysisOutline<T> outline, @Nullable IInstructionCounterSource instructionCounterSource) {
        this.outline = outline;
        this.updateInstructionCounterSource(null, instructionCounterSource);
    }

    public final void handleValueChange(ValueChangeEvent<? extends @Nullable IInstructionCounterSource> event) {
        this.updateInstructionCounterSource((IInstructionCounterSource)event.diff.getOldValue(), (IInstructionCounterSource)event.diff.getNewValue());
    }

    protected abstract @NonNull Iterable<@NonNull C> aggregateColumns(@Nullable IInstructionCounterSource var1);

    protected abstract void populateOutline(@Nullable IInstructionCounterSource var1);

    private void updateInstructionCounterSource(@Nullable IInstructionCounterSource previousCounterSource, @Nullable IInstructionCounterSource instructionCounterSource) {
        String config;
        if (previousCounterSource != null) {
            assert (this.currentColumnConfiguration != null);
            this.currentColumnConfiguration.put(previousCounterSource, this.outline.getConfig());
        }
        this.outline.getModel().removeAllColumns();
        ColumnUtils.createColumns(this.outline.getModel(), this.aggregateColumns(instructionCounterSource), null);
        this.populateOutline(instructionCounterSource);
        if (instructionCounterSource != null && (config = this.currentColumnConfiguration.get(instructionCounterSource)) != null) {
            this.outline.applyConfig(config, false, false);
        }
    }
}

