/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.Badges;
import com.arm.streamline.editortabs.HelpAction;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.IAnalysisListener;
import com.arm.streamline.model.IAnalysisProvider;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.utils.NullChecking;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class EditorTab
extends Composite
implements IAnalysisProvider,
IAnalysisListener,
DisposeListener {
    private @Nullable Map<String, IAction> mActionMap;
    private @Nullable Analysis mAnalysis;
    private final @Nullable BaseTimelineContent mBaseTimelineContent;
    private @Nullable AnalysisEditor mEditor;
    private final @NonNull CustomToolbar mToolbar;
    protected final @NonNull DataBindingContext ctx = new DataBindingContext();

    protected EditorTab(@NonNull AnalysisEditor editor) {
        this(editor, null);
    }

    protected EditorTab(@NonNull AnalysisEditor editor, @Nullable BaseTimelineContent baseTimelineContent) {
        super(editor.getContainer(), 0);
        this.mEditor = editor;
        this.mAnalysis = (Analysis)NullChecking.neverNull((Object)this.mEditor.getAnalysis());
        this.mBaseTimelineContent = baseTimelineContent;
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        this.mToolbar = new CustomToolbar(this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mToolbar);
    }

    protected final void init() {
        Composite content = this.createContent();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)content);
        this.fillToolbar();
        this.addDisposeListener(this);
        this.getAnalysis().addListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, this.getHelpID());
    }

    public final Map<String, IAction> getActionMap() {
        if (this.mActionMap == null) {
            this.mActionMap = new HashMap<String, IAction>();
            this.initActionMap(this.mActionMap);
        }
        return this.mActionMap;
    }

    @Override
    public final @NonNull Analysis getAnalysis() {
        return (Analysis)NullChecking.neverNull((Object)this.mAnalysis);
    }

    public final @Nullable AnalysisEditor getEditor() {
        return this.mEditor;
    }

    public abstract ISelectionProvider getSelectionProvider();

    public CustomToolbar getToolbar() {
        return this.mToolbar;
    }

    public final @NonNull AnalysisEditor requireEditor() {
        return (AnalysisEditor)NullChecking.neverNull((Object)this.mEditor);
    }

    @Override
    public void sourceFilePathChanged(SourceFile[] files) {
    }

    public void dispose() {
        this.ctx.dispose();
        super.dispose();
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.mEditor != null) {
            this.getAnalysis().removeListener(this);
            this.mEditor = null;
            this.mAnalysis = null;
        }
    }

    protected abstract Composite createContent();

    protected abstract void fillToolbar(CustomToolbar var1);

    protected @Nullable BaseTimelineContent getBaseTimelineContent() {
        return this.mBaseTimelineContent;
    }

    protected EventBasedSampleInfo getEBSInfo() {
        return this.getAnalysis().getEventBasedSampleInfo();
    }

    protected abstract String getHelpID();

    protected abstract void initActionMap(Map<String, IAction> var1);

    protected boolean needDividerBelowToolbar() {
        return true;
    }

    private void fillToolbar() {
        Badges.create(this.mToolbar, this.getAnalysis());
        this.fillToolbar(this.mToolbar);
        boolean hasFlexibleGap = false;
        Control[] children = this.mToolbar.getChildren();
        int i = children.length;
        while (--i >= 0) {
            Object data = children[i].getLayoutData();
            if (!(data instanceof CustomToolbar.LayoutData) || !((CustomToolbar.LayoutData)data).mFlexibleGap) continue;
            hasFlexibleGap = true;
            break;
        }
        if (!hasFlexibleGap) {
            this.mToolbar.addFlexibleSpace();
        }
        this.mToolbar.addAction(new HelpAction());
    }
}

