/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.EditorTabsMessages;
import com.arm.streamline.editortabs.warnings.WarningBadge;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.IBadgeInfoProvider;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.ToolbarBadge;
import java.text.MessageFormat;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class Badges {
    private static final int GAP_AFTER_BADGES = 2;
    private final @NonNull IBadgeInfoProvider mProvider;
    private final @NonNull CustomToolbar mToolbar;
    private final @NonNull IWarnings mWarnings;

    public static Badges create(@NonNull CustomToolbar toolbar, @NonNull IBadgeInfoProvider provider) {
        return new Badges(toolbar, provider);
    }

    private Badges(@NonNull CustomToolbar toolbar, @NonNull IBadgeInfoProvider provider) {
        this.mToolbar = toolbar;
        this.mWarnings = provider.getWarnings();
        this.mWarnings.addListener(this::updateOnUiThread);
        this.mProvider = provider;
        Runnable listener = this::updateOnUiThread;
        provider.addListener(listener);
        toolbar.addDisposeListener(event -> provider.removeListener(listener));
        this.update();
    }

    private void addApplicationTracingBadge() {
        this.mToolbar.setLeftMargin(0);
        ToolbarBadge badge = new ToolbarBadge(this.mToolbar, Colors.create(StreamlineImages.APPLICATION_TRACING_BADGE_BACKGROUND), StreamlinePlugin.getImage("WhiteA.png"));
        badge.setToolTipText(EditorTabsMessages.Badges_APPLICATION_TRACING);
        badge.setLayoutData(new CustomToolbar.LayoutData().setFillRowHeight());
        this.moveToFront(badge);
    }

    private void addBareMetalBadge() {
        this.mToolbar.setLeftMargin(0);
        ToolbarBadge badge = new ToolbarBadge(this.mToolbar, Colors.create(StreamlineImages.BARE_METAL_BADGE_BACKGROUND), StreamlinePlugin.getImage("WhiteB.png"));
        badge.setToolTipText(EditorTabsMessages.Badges_BARE_METAL);
        badge.setLayoutData(new CustomToolbar.LayoutData().setFillRowHeight());
        this.moveToFront(badge);
    }

    private void addEbsBadge(@NonNull EventBasedSampleInfo ebs) {
        if (ebs.getEvents().isEmpty()) {
            return;
        }
        this.mToolbar.setLeftMargin(0);
        StringBuilder names = new StringBuilder();
        for (EventBasedSampleInfo.Event event : ebs.getEvents()) {
            names.append("\n - ").append(event.getCounter()).append(" :: ").append(event.getThreshold());
        }
        ToolbarBadge badge = new ToolbarBadge(this.mToolbar, Colors.create(StreamlineImages.EBS_BADGE_BACKGROUND), StreamlinePlugin.getImage("EBS.png"));
        badge.setToolTipText(MessageFormat.format(this.mProvider.isLive() ? EditorTabsMessages.EBS_TOOLTIP_LIVE : EditorTabsMessages.EBS_TOOLTIP, names));
        badge.setLayoutData(new CustomToolbar.LayoutData().setFillRowHeight());
        this.moveToFront(badge);
    }

    private void addSystemWideBadge() {
        this.mToolbar.setLeftMargin(0);
        ToolbarBadge badge = new ToolbarBadge(this.mToolbar, Colors.create(StreamlineImages.SYSTEM_WIDE_BADGE_BACKGROUND), StreamlinePlugin.getImage("WhiteS.png"));
        badge.setToolTipText(EditorTabsMessages.Badges_SYSTEM_WIDE);
        badge.setLayoutData(new CustomToolbar.LayoutData().setFillRowHeight());
        this.moveToFront(badge);
    }

    private boolean applyGap() {
        boolean refresh = false;
        int gap = 2;
        Control[] children = this.mToolbar.getChildren();
        int i = children.length;
        while (--i >= 0) {
            if (children[i] instanceof ToolbarBadge) {
                CustomToolbar.LayoutData layout = (CustomToolbar.LayoutData)children[i].getLayoutData();
                if (layout.mGap != gap) {
                    layout.mGap = gap;
                    refresh = true;
                }
                gap = 0;
                continue;
            }
            gap = 2;
        }
        return refresh;
    }

    private boolean moveToFront(ToolbarBadge badge) {
        boolean refresh = false;
        Control[] children = this.mToolbar.getChildren();
        if (children[0] instanceof WarningBadge) {
            if (children[1] != badge) {
                badge.moveBelow(children[0]);
                refresh = true;
            }
        } else if (children[0] != badge) {
            badge.moveAbove(null);
            refresh = true;
        }
        return refresh;
    }

    private void update() {
        if (!this.mToolbar.isDisposed()) {
            Stream.of(this.mToolbar.getChildren()).filter(x -> x instanceof ToolbarBadge || x instanceof WarningBadge).forEach(Widget::dispose);
            this.mToolbar.setLeftMargin(3);
            switch (this.mProvider.getProtocolType()) {
                case PERF: {
                    if (this.mProvider.isApplicationTracingMode()) {
                        this.addApplicationTracingBadge();
                        break;
                    }
                    this.addSystemWideBadge();
                    break;
                }
                case BARMAN: {
                    this.addBareMetalBadge();
                    break;
                }
                default: {
                    throw new AssertionError(this.mProvider.getProtocolType());
                }
            }
            EventBasedSampleInfo ebsInfo = this.mProvider.getEventBasedSampleInfo();
            if (ebsInfo != null) {
                this.addEbsBadge(ebsInfo);
            }
            int warningsCount = this.mWarnings.size();
            Control[] children = this.mToolbar.getChildren();
            if (children.length > 0 && children[0] instanceof WarningBadge) {
                if (warningsCount == 0) {
                    children[0].dispose();
                    if (children.length > 1 && !(children[1] instanceof ToolbarBadge)) {
                        this.mToolbar.setLeftMargin(3);
                    }
                }
            } else if (warningsCount > 0) {
                this.mToolbar.setLeftMargin(0);
                WarningBadge badge = new WarningBadge(this.mToolbar, this.mWarnings);
                badge.setLayoutData(new CustomToolbar.LayoutData().setFillRowHeight());
                badge.moveAbove(null);
            }
            this.applyGap();
            SafeUpdate.layout(this.mToolbar);
        }
    }

    private void updateOnUiThread() {
        Task.scheduleOnUIThread(this::update);
    }
}

