/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.callpath.Utilities;
import com.arm.streamline.editortabs.histogram.HistogramCellDataProvider;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.report.model.icounters.HistogramDataPoint;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterDecimalColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterHistogramColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterNumberColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterRatioColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterRatioColumnWithValuePercentSubColumns;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.report.model.icounters.RatioValue;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterRatioColumnWithValueAndPercentSubColumns;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.HistogramCell;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.streamline.widget.outline.RatioCell;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.StreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractInstructionCounterColumn<T, X>
implements IColumnEnum<T, X> {
    protected final @NonNull IInstructionCounterColumn<T> counterColumn;
    private final @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> cellSupplier;
    private final @NonNull List<? extends @NonNull IColumnEnum<T, X>> derivedFromColumns;
    private final boolean hiddenFromExport;
    private final boolean hiddenFromUi;
    private @Nullable AbstractInstructionCounterColumn<T, X> parent;
    private final @NonNull IRowValueMapper<T> rowValueMapper;
    private final boolean visibleByDefault;

    protected static <T, X, C extends AbstractInstructionCounterColumn<T, X>> @NonNull List<@NonNull C> factory(final @NonNull IConstructor<T, X, C> constructor, @NonNull IInstructionCounterColumn<T> counterColumn) {
        return (List)counterColumn.acceptDisplayTypeVisitor(new IInstructionCounterColumnDisplayTypeVisitor<T, IInstructionCounterColumn<T>, List<C>, RuntimeException>(){

            public @NonNull List<@NonNull C> displayAsHistogram(@NonNull IInstructionCounterColumn<T> data, @NonNull IInstructionCounterHistogramColumn<T> column) throws RuntimeException {
                @NonNull Function<@NonNull Object, long @Nullable []> mapper = arg_0 -> column.mapToHistogram(arg_0);
                AbstractInstructionCounterColumn[] abstractInstructionCounterColumnArray = new AbstractInstructionCounterColumn[1];
                abstractInstructionCounterColumnArray[0] = constructor.create(column, false, false, column.isVisibleByDefault(), Collections.emptyList(), AbstractInstructionCounterColumn.histogramCellSupplier(column.getDatapoints(), column.shouldScaleRelativeToLimit(), column.getColour(), column.getUnits(), (arg_0, arg_1) -> column.getScalingLimit(arg_0, arg_1), mapper), AbstractInstructionCounterColumn.rowMapperFromHistogram(column.getDatapoints(), mapper));
                return Arrays.asList(abstractInstructionCounterColumnArray);
            }

            public @NonNull List<@NonNull C> displayAsNumber(@NonNull IInstructionCounterColumn<T> data, @NonNull IInstructionCounterNumberColumn<T> column) throws RuntimeException {
                @NonNull Function<@NonNull Object, @Nullable Long> mapper = arg_0 -> column.mapToNumber(arg_0);
                return Arrays.asList(constructor.create(column, false, false, column.isVisibleByDefault(), Collections.emptyList(), AbstractInstructionCounterColumn.numberCellSupplier(mapper), AbstractInstructionCounterColumn.rowMapperFromNumber(mapper)));
            }

            public @NonNull List<@NonNull C> displayAsDecimal(@NonNull IInstructionCounterColumn<T> data, @NonNull IInstructionCounterDecimalColumn<T> column) throws RuntimeException {
                @NonNull Function<@NonNull Object, @Nullable Double> mapper = arg_0 -> column.mapToNumber(arg_0);
                return Arrays.asList(constructor.create(column, false, false, column.isVisibleByDefault(), Collections.emptyList(), AbstractInstructionCounterColumn.decimalCellSupplier(mapper), AbstractInstructionCounterColumn.rowMapperFromDecimal(mapper)));
            }

            public @NonNull List<@NonNull C> displayAsPercent(@NonNull IInstructionCounterColumn<T> data, @NonNull IInstructionCounterPercentColumn<T> column) throws RuntimeException {
                @NonNull Function<@NonNull Object, @Nullable Double> mapper = arg_0 -> column.mapToPercent(arg_0);
                return Arrays.asList(constructor.create(column, false, false, column.isVisibleByDefault(), Collections.emptyList(), AbstractInstructionCounterColumn.percentCellSupplierFromPercent(mapper), AbstractInstructionCounterColumn.rowMapperFromPercent(mapper)));
            }

            public @NonNull List<@NonNull C> displayAsPercentAndValue(@NonNull IInstructionCounterColumn<T> data, @NonNull IInstructionCounterPercentAndValueColumn<T> column) throws RuntimeException {
                return this.createPercentAndValue(true, column);
            }

            public @NonNull List<@NonNull C> displayAsRatio(@NonNull IInstructionCounterColumn<T> data, @NonNull IInstructionCounterRatioColumn<T> column) throws RuntimeException {
                // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IInstructionCounterRatioColumn.IInstructionCounterRatioNumberSubColumn @NonNull [] valueSubColumns = column.valueSubColumns();
                if (valueSubColumns.length == 0) {
                    return Collections.emptyList();
                }
                @NonNull ArrayList<@NonNull C> childrenColumns = new ArrayList(valueSubColumns.length);
                IInstructionCounterRatioColumn.IInstructionCounterRatioNumberSubColumn[] iInstructionCounterRatioNumberSubColumnArray = valueSubColumns;
                int n = valueSubColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstructionCounterRatioColumn.IInstructionCounterRatioNumberSubColumn valueSubColumn = iInstructionCounterRatioNumberSubColumnArray[n2];
                    boolean visibleByDefault = column.isVisibleByDefault() ? false : valueSubColumn.isVisibleByDefault();
                    @NonNull Function<@NonNull Object, @Nullable Long> valueMapper = arg_0 -> ((IInstructionCounterRatioColumn.IInstructionCounterRatioNumberSubColumn)valueSubColumn).mapToNumber(arg_0);
                    @NonNull C valueColumn = constructor.create(valueSubColumn, false, false, visibleByDefault, Collections.emptyList(), AbstractInstructionCounterColumn.numberCellSupplier(valueMapper), AbstractInstructionCounterColumn.rowMapperFromNumber(valueMapper));
                    childrenColumns.add(valueColumn);
                    ++n2;
                }
                @NonNull Function<@NonNull Object, @NonNull RatioValue @Nullable []> mapper = arg_0 -> column.mapRatioValue(arg_0);
                @NonNull C uiColumn = constructor.create(column, false, true, column.isVisibleByDefault(), childrenColumns, AbstractInstructionCounterColumn.ratioCellSupplier(mapper), AbstractInstructionCounterColumn.rowMapperFromRatio(mapper));
                for (AbstractInstructionCounterColumn childColumn : childrenColumns) {
                    childColumn.setParent(uiColumn);
                }
                return StreamUtils.concat((Stream[])new Stream[]{Stream.of(uiColumn), childrenColumns.stream()}).collect(Collectors.toList());
            }

            public @NonNull List<@NonNull C> displayAsRatioWithValueAndPercentSubColumns(@NonNull IInstructionCounterColumn<T> data, @NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<T> column) throws RuntimeException {
                // Could not load outer class - annotation placement on inner may be incorrect
                 @NonNull IInstructionCounterRatioColumnWithValuePercentSubColumns.IInstructionCounterRatioPercentAndValueSubColumn @NonNull [] valueSubColumns = column.valueSubColumns();
                if (valueSubColumns.length == 0) {
                    return Collections.emptyList();
                }
                @NonNull ArrayList<@NonNull C> childrenColumns = new ArrayList(valueSubColumns.length);
                IInstructionCounterRatioColumnWithValuePercentSubColumns.IInstructionCounterRatioPercentAndValueSubColumn[] iInstructionCounterRatioPercentAndValueSubColumnArray = valueSubColumns;
                int n = valueSubColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstructionCounterRatioColumnWithValuePercentSubColumns.IInstructionCounterRatioPercentAndValueSubColumn valueSubColumn = iInstructionCounterRatioPercentAndValueSubColumnArray[n2];
                    boolean visibleByDefault = column.isVisibleByDefault() ? false : valueSubColumn.isVisibleByDefault();
                    childrenColumns.addAll(this.createPercentAndValue(visibleByDefault, (IInstructionCounterPercentAndValueColumn)valueSubColumn));
                    ++n2;
                }
                @NonNull Function<@NonNull Object, @NonNull RatioValue @Nullable []> mapper = arg_0 -> column.mapRatioValue(arg_0);
                @NonNull C uiColumn = constructor.create(column, false, true, column.isVisibleByDefault(), childrenColumns, AbstractInstructionCounterColumn.ratioCellSupplier(mapper), AbstractInstructionCounterColumn.rowMapperFromRatio(mapper));
                for (AbstractInstructionCounterColumn childColumn : childrenColumns) {
                    childColumn.setParent(uiColumn);
                }
                return StreamUtils.concat((Stream[])new Stream[]{Stream.of(uiColumn), childrenColumns.stream()}).collect(Collectors.toList());
            }

            private @NonNull List<@NonNull C> createPercentAndValue(boolean visibleByDefault, @NonNull IInstructionCounterPercentAndValueColumn<T> column) throws RuntimeException {
                @NonNull IInstructionCounterNumberColumn valueSubColumn = column.valueSubColumn();
                @NonNull Function<@NonNull Object, @Nullable Long> valueMapper = arg_0 -> ((IInstructionCounterNumberColumn)valueSubColumn).mapToNumber(arg_0);
                @NonNull C valueColumn = constructor.create(valueSubColumn, true, false, false, Collections.emptyList(), AbstractInstructionCounterColumn.numberCellSupplier(valueMapper), AbstractInstructionCounterColumn.rowMapperFromNumber(valueMapper));
                @NonNull IInstructionCounterPercentColumn percentSubColumn = column.percentSubColumn();
                @NonNull Function<@NonNull Object, @Nullable Double> percentMapper = arg_0 -> ((IInstructionCounterPercentColumn)percentSubColumn).mapToPercent(arg_0);
                @NonNull C percentColumn = constructor.create(percentSubColumn, true, false, false, Collections.emptyList(), AbstractInstructionCounterColumn.percentCellSupplierFromPercent(percentMapper), AbstractInstructionCounterColumn.rowMapperFromPercent(percentMapper));
                @NonNull Function<@NonNull Object, @Nullable PercentAndValue> mapper = arg_0 -> column.mapToPercentAndValue(arg_0);
                @NonNull C uiColumn = constructor.create(column, false, true, column.isVisibleByDefault() && visibleByDefault, Arrays.asList(valueColumn, percentColumn), AbstractInstructionCounterColumn.percentCellSupplierFromPercentAndValue(mapper), AbstractInstructionCounterColumn.rowMapperFromPercentAndValue(mapper));
                return Arrays.asList(valueColumn, percentColumn, uiColumn);
            }
        }, counterColumn);
    }

    protected static <T> int getPreferredWidth(@NonNull IInstructionCounterSource source, @NonNull IInstructionCounterColumn<T> counterColumn) {
        return (Integer)counterColumn.acceptDisplayTypeVisitor(new IInstructionCounterColumnDisplayTypeVisitor<T, IInstructionCounterSource, Integer, RuntimeException>(){

            public @NonNull Integer displayAsHistogram(@NonNull IInstructionCounterSource data, @NonNull IInstructionCounterHistogramColumn<T> column) throws RuntimeException {
                return Utilities.getHistogramPreferredWidth(column.getDatapoints(), column.getMaxPossibleDisplayValues());
            }

            public @NonNull Integer displayAsNumber(@NonNull IInstructionCounterSource data, @NonNull IInstructionCounterNumberColumn<T> column) throws RuntimeException {
                return Utilities.getValuePreferredWidth(column.getMaxPossibleDisplayValue());
            }

            public @NonNull Integer displayAsDecimal(@NonNull IInstructionCounterSource data, @NonNull IInstructionCounterDecimalColumn<T> column) throws RuntimeException {
                return Utilities.getValuePreferredWidth(column.getMaxPossibleDisplayValue());
            }

            public @NonNull Integer displayAsPercent(@NonNull IInstructionCounterSource data, @NonNull IInstructionCounterPercentColumn<T> column) throws RuntimeException {
                return Utilities.getPercentPreferredWidth();
            }

            public @NonNull Integer displayAsPercentAndValue(@NonNull IInstructionCounterSource data, @NonNull IInstructionCounterPercentAndValueColumn<T> column) throws RuntimeException {
                return Utilities.getValueAndPercentagePreferredWidth(column.valueSubColumn().getMaxPossibleDisplayValue());
            }

            public @NonNull Integer displayAsRatio(@NonNull IInstructionCounterSource data, @NonNull IInstructionCounterRatioColumn<T> column) throws RuntimeException {
                return Utilities.getRatioPreferredWidth(column.getMaxPossibleDisplayValues());
            }

            public @NonNull Integer displayAsRatioWithValueAndPercentSubColumns(@NonNull IInstructionCounterSource data, @NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<T> column) throws RuntimeException {
                return Utilities.getRatioPreferredWidth(column.getMaxPossibleDisplayValues());
            }
        }, (Object)source);
    }

    protected static <T> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> histogramCellSupplier(@NonNull HistogramDataPoint @NonNull [] datapoints, boolean scaleRelativeToLimit, @Nullable Integer colour, @NonNull String units, @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier, @NonNull Function<@NonNull T, long @Nullable []> mapper) {
        return () -> new HistogramCell(new HistogramCellDataProvider(datapoints, scaleRelativeToLimit, colour, units, limitSupplier, mapper));
    }

    protected static <T> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> numberCellSupplier(final @NonNull Function<@NonNull T, @Nullable Long> mapper) {
        return () -> new TextCell<EnumColumn<T>>(131072, IColumnCompareType.INTEGER()){

            @Override
            protected String getData(@Nullable Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column, boolean nullOK) {
                Object value;
                Long number;
                if (row != null && (number = (Long)mapper.apply(value = ((ReportRow)row).getModelObject())) != null) {
                    return NumberUtils.prettyFormat((long)number);
                }
                if (!nullOK) {
                    return "";
                }
                return null;
            }
        };
    }

    protected static <T> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> decimalCellSupplier(final @NonNull Function<@NonNull T, @Nullable Double> mapper) {
        return () -> new TextCell<EnumColumn<T>>(131072, IColumnCompareType.FLOAT()){

            @Override
            protected String getData(@Nullable Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column, boolean nullOK) {
                Object value;
                Double number;
                if (row != null && (number = (Double)mapper.apply(value = ((ReportRow)row).getModelObject())) != null) {
                    return NumberUtils.prettyFormat((double)number);
                }
                if (!nullOK) {
                    return "";
                }
                return null;
            }
        };
    }

    protected static <T> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> percentCellSupplierFromPercent(final @NonNull Function<@NonNull T, @Nullable Double> mapper) {
        return () -> new PercentageCell<EnumColumn<T>>(50, false, true){

            @Override
            public double getPercentage(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                @NonNull T value = ((ReportRow)row).getModelObject();
                @Nullable Double percent = (Double)mapper.apply(value);
                return percent != null ? percent : -1.0;
            }

            @Override
            public @Nullable PercentAndValue getPercentAndValue(@NonNull Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public long getValue(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return 0L;
            }
        };
    }

    protected static <T> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> percentCellSupplierFromPercentAndValue(final @NonNull Function<@NonNull T, @Nullable PercentAndValue> mapper) {
        return () -> new PercentageCell<EnumColumn<T>>(50, false, false){

            @Override
            public double getPercentage(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                @Nullable PercentAndValue result = this.getPercentAndValue(row, column);
                return result != null ? result.percent : -1.0;
            }

            @Override
            public @Nullable PercentAndValue getPercentAndValue(@NonNull Row<EnumColumn<T>> row, @NonNull EnumColumn<T> column) {
                @NonNull T value = ((ReportRow)row).getModelObject();
                return (PercentAndValue)mapper.apply(value);
            }

            @Override
            public long getValue(Row<EnumColumn<T>> row, EnumColumn<T> column) {
                @Nullable PercentAndValue result = this.getPercentAndValue(row, column);
                return result != null ? result.value : 0L;
            }
        };
    }

    protected static <T> @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> ratioCellSupplier(@NonNull Function<@NonNull T, @NonNull RatioValue @Nullable []> mapper) {
        return () -> new RatioCell(row -> {
            @NonNull T value = ((ReportRow)row).getModelObject();
            return (RatioValue[])mapper.apply(value);
        });
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromHistogram(@NonNull HistogramDataPoint @NonNull [] datapoints, final @NonNull Function<@NonNull T, long @Nullable []> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                return 0.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                return 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                long @Nullable [] values = (long[])mapper.apply(data);
                if (values == null) {
                    return "";
                }
                return Arrays.stream(values).mapToObj(NumberUtils::prettyFormat).collect(Collectors.joining(":"));
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromNumber(final @NonNull Function<@NonNull T, @Nullable Long> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable Long number = (Long)mapper.apply(data);
                return number != null ? number.doubleValue() : 0.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable Long number = (Long)mapper.apply(data);
                return number != null ? number : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable Long number = (Long)mapper.apply(data);
                return number != null ? NumberUtils.prettyFormat((long)number) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromDecimal(final @NonNull Function<@NonNull T, @Nullable Double> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable Double number = (Double)mapper.apply(data);
                return number != null ? number : 0.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable Double number = (Double)mapper.apply(data);
                return number != null ? number.longValue() : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable Double number = (Double)mapper.apply(data);
                return number != null ? NumberUtils.prettyFormat((double)number) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromPercent(final @NonNull Function<@NonNull T, @Nullable Double> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable Double percent = (Double)mapper.apply(data);
                return percent != null ? percent : -1.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable Double percent = (Double)mapper.apply(data);
                return percent != null ? percent.longValue() : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable Double percent = (Double)mapper.apply(data);
                return percent != null ? NumberUtils.formatPercentage((double)percent, (boolean)false) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromPercentAndValue(final @NonNull Function<@NonNull T, @Nullable PercentAndValue> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                @Nullable PercentAndValue percentAndValue = (PercentAndValue)mapper.apply(data);
                return percentAndValue != null ? percentAndValue.percent : -1.0;
            }

            @Override
            public long getLong(@NonNull T data) {
                @Nullable PercentAndValue percentAndValue = (PercentAndValue)mapper.apply(data);
                return percentAndValue != null ? percentAndValue.value : 0L;
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @Nullable PercentAndValue percentAndValue = (PercentAndValue)mapper.apply(data);
                return percentAndValue != null ? String.format("%s\t%s", percentAndValue.value, percentAndValue.percent) : "";
            }
        };
    }

    protected static <T> @NonNull IRowValueMapper<T> rowMapperFromRatio(final @NonNull Function<@NonNull T, @NonNull RatioValue @Nullable []> mapper) {
        return new IRowValueMapper<T>(){

            @Override
            public double getDouble(@NonNull T data) {
                return this.getLong(data);
            }

            @Override
            public long getLong(@NonNull T data) {
                @NonNull Object @Nullable [] ratioValues = (RatioValue[])mapper.apply(data);
                return StreamUtils.emptyIfNullOfArray((Object[])ratioValues).mapToLong(v -> v.value).sum();
            }

            @Override
            public @NonNull String getText(@NonNull T data) {
                @NonNull Object @Nullable [] ratioValues = (RatioValue[])mapper.apply(data);
                return StreamUtils.emptyIfNullOfArray((Object[])ratioValues).map(x -> Long.toUnsignedString(x.value)).collect(Collectors.joining(":"));
            }
        };
    }

    protected AbstractInstructionCounterColumn(@NonNull IInstructionCounterColumn<T> counterColumn, boolean hiddenFromUi, boolean hiddenFromExport, boolean visibleByDefault, @NonNull List<? extends @NonNull IColumnEnum<T, X>> derivedFromColumns, @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> cellSupplier, @NonNull IRowValueMapper<T> rowValueMapper) {
        this.counterColumn = counterColumn;
        this.hiddenFromUi = hiddenFromUi;
        this.hiddenFromExport = hiddenFromExport;
        this.visibleByDefault = visibleByDefault;
        this.derivedFromColumns = derivedFromColumns;
        this.cellSupplier = cellSupplier;
        this.rowValueMapper = rowValueMapper;
    }

    @Override
    public @NonNull ICell<EnumColumn<T>> getCell(X data) {
        return this.cellSupplier.get();
    }

    @Override
    public double getDataAsDouble(ReportRow<T> row) {
        return this.rowValueMapper.getDouble(row.getModelObject());
    }

    @Override
    public long getDataAsLong(ReportRow<T> row) {
        return this.rowValueMapper.getLong(row.getModelObject());
    }

    @Override
    public @NonNull String getDataAsText(ReportRow<T> row) {
        return this.rowValueMapper.getText(row.getModelObject());
    }

    @Override
    public @NonNull List<? extends @NonNull IColumnEnum<T, X>> getDerivedFromColumns() {
        return this.derivedFromColumns;
    }

    @Override
    public @NonNull String getHeader(X data) {
        return this.counterColumn.getTitle();
    }

    @Override
    public final @Nullable AbstractInstructionCounterColumn<T, X> getHeirarchicalParentColumn() {
        return this.parent;
    }

    @Override
    public @Nullable Image getImage(ReportRow<T> row) {
        return null;
    }

    @Override
    public int getInitialSortSequence() {
        return -1;
    }

    @Override
    public @Nullable String getToolTip(ReportRow<T> row) {
        return this.counterColumn.getValueTooltip(row.getModelObject());
    }

    @Override
    public @NonNull String getToolTip(X data) {
        return this.counterColumn.getTitleTooltip();
    }

    @Override
    public boolean isHiddenFromExport() {
        return this.hiddenFromExport;
    }

    @Override
    public boolean isHiddenFromUi() {
        return this.hiddenFromUi;
    }

    @Override
    public boolean isInitialSortAscending() {
        return false;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    protected final void setParent(@NonNull AbstractInstructionCounterColumn<T, X> parent) {
        this.parent = parent;
    }

    @FunctionalInterface
    protected static interface IConstructor<T, X, C extends AbstractInstructionCounterColumn<T, X>> {
        public @NonNull C create(@NonNull IInstructionCounterColumn<T> var1, boolean var2, boolean var3, boolean var4, @NonNull List<? extends @NonNull IColumnEnum<T, X>> var5, @NonNull Supplier<@NonNull ICell<EnumColumn<T>>> var6, @NonNull IRowValueMapper<T> var7);
    }

    protected static interface IRowValueMapper<T> {
        public double getDouble(@NonNull T var1);

        public long getLong(@NonNull T var1);

        public @NonNull String getText(@NonNull T var1);
    }
}

