/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.coresight.ds5_trace_dump.ITMTraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceDumpTraceStream;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.STMTraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.TraceDumpDirectory;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.trace_dump_import.TraceDumpImportClassification;
import com.arm.streamline.dataimport.AbstractTraceDumpImportJob;
import com.arm.streamline.dataimport.IFileTypeChecker;
import com.arm.streamline.dataimport.ImportAPCDirectoryJob;
import com.arm.streamline.dataimport.ImportBarmanCaptureJob;
import com.arm.streamline.dataimport.ImportBarmanITMJob;
import com.arm.streamline.dataimport.ImportBarmanSTMJob;
import com.arm.streamline.dataimport.ImportCaptureJob;
import com.arm.streamline.dataimport.ImportFileType;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.dataimport.ImportPerfCaptureJob;
import com.arm.utils.IterUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImportJobFactory {
    public static @NonNull List<@NonNull Job> createImportJobs(@NonNull IImportJobConfigurationSupplier barmanXmlSelector, @NonNull IFileTypeChecker fileChecker, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath, @NonNull ImportFileType fileType, boolean importAsSynchronized) throws ImportJobCreationException {
        if (files.size() == 0) {
            throw new ImportJobCreationException(ImportMessages.NO_FILES_TO_IMPORT);
        }
        ImportJobFactory.assertFilesExist(files);
        if (!apcOutputPath.isDirectory()) {
            throw new ImportJobCreationException(MessageFormat.format(ImportMessages.AbstractTraceDumpImportJob_PATH_IS_NOT_A_DIRECTORY, apcOutputPath.getPath()));
        }
        switch (fileType) {
            case BARMAN_RAW: {
                return Arrays.asList(new Job[]{ImportJobFactory.createBarmanCaptureJob(fileChecker, files, apcOutputPath)});
            }
            case STPv2_DUMP: {
                @Nullable ImportBarmanSTMJob job = ImportJobFactory.createBarmanSTMJob(barmanXmlSelector, files, apcOutputPath);
                return job != null ? Arrays.asList(new Job[]{job}) : Collections.emptyList();
            }
            case PERF_DATA: {
                return Arrays.asList(new Job[]{ImportJobFactory.createPerfJob(fileChecker, files, apcOutputPath)});
            }
            case ZIP_APC: {
                return Arrays.asList(new Job[]{ImportJobFactory.createApcZipCaptureJob(fileChecker, files, apcOutputPath)});
            }
            case ITM_DUMP: {
                @Nullable ImportBarmanITMJob job = ImportJobFactory.createBarmanITMJob(barmanXmlSelector, files, apcOutputPath, importAsSynchronized);
                return job != null ? Arrays.asList(new Job[]{job}) : Collections.emptyList();
            }
            case ALL_SUPPORTED_TYPES: 
            case TRACE_DUMP: {
                Map<ImportFileClassification, Set<File>> classifiedFiles;
                try {
                    classifiedFiles = ImportFileClassification.classifyImportTypes(fileChecker, files);
                }
                catch (IOException exception) {
                    throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, exception);
                }
                return ImportJobFactory.createJobsFromClassification(barmanXmlSelector, apcOutputPath, importAsSynchronized, classifiedFiles);
            }
        }
        throw new AssertionError((Object)fileType);
    }

    private static void assertFilesExist(@NonNull Collection<@NonNull File> files) throws ImportJobCreationException {
        for (File f : files) {
            if (f.exists()) continue;
            throw new ImportJobCreationException(MessageFormat.format(ImportMessages.FILE_NOT_FOUND, f));
        }
    }

    public static @NonNull List<@NonNull Job> createJobsFromClassification(@NonNull IImportJobConfigurationSupplier barmanXmlSelector, @NonNull File apcOutputPath, boolean importAsSynchronized, @NonNull Map<@NonNull ImportFileClassification, @NonNull Set<@NonNull File>> classifiedFiles) throws ImportJobCreationException {
        @NonNull ArrayList<@NonNull Job> jobs = new ArrayList<Job>();
        try {
            block11: for (Map.Entry<ImportFileClassification, Set<File>> entry : classifiedFiles.entrySet()) {
                switch (entry.getKey()) {
                    case APC_ZIP_FILE: {
                        jobs.add(ImportJobFactory.createApcZipCaptureJob(null, (Collection<File>)entry.getValue(), apcOutputPath));
                        break;
                    }
                    case BARMAN_RAW_FILE: {
                        jobs.add(ImportJobFactory.createBarmanCaptureJob(null, (Collection<File>)entry.getValue(), apcOutputPath));
                        break;
                    }
                    case PERF_RECORD_FILE: {
                        jobs.add(ImportJobFactory.createPerfJob(null, (Collection<File>)entry.getValue(), apcOutputPath));
                        break;
                    }
                    case TRACE_DUMP_DIR: {
                        @Nullable Job job = ImportJobFactory.createTraceDumpJob(barmanXmlSelector, (Collection<File>)entry.getValue(), apcOutputPath, importAsSynchronized);
                        if (job == null) continue block11;
                        jobs.add(job);
                        break;
                    }
                    case NONE: {
                        @NonNull Set<@NonNull File> entryFiles = entry.getValue();
                        if (entryFiles.size() == 1) {
                            AbstractTraceDumpImportJob job;
                            @NonNull File entryFile = (File)IterUtils.getNth(entryFiles, (int)0);
                            if (entryFile.getName().matches("^.*ITM.*\\.bin$")) {
                                job = ImportJobFactory.createBarmanITMJob(barmanXmlSelector, entryFiles, apcOutputPath, importAsSynchronized);
                                if (job == null) continue block11;
                                jobs.add(job);
                                break;
                            }
                            if (entryFile.getName().matches("^.*STM.*\\.bin$")) {
                                job = ImportJobFactory.createBarmanSTMJob(barmanXmlSelector, entryFiles, apcOutputPath);
                                if (job == null) continue block11;
                                jobs.add(job);
                                break;
                            }
                        }
                        throw new ImportJobCreationException(MessageFormat.format(ImportMessages.UNSUPPORTED_FILE_TYPE, entry.getValue().stream().map(f -> f.getName()).collect(Collectors.joining())));
                    }
                    case APC_DIRECTORY: {
                        break;
                    }
                    case CAPTURES_DIRECTORY: {
                        @NonNull Set<@NonNull File> capturesDirectories = entry.getValue();
                        DocumentScanner.INSTANCE.addToWatchSet(capturesDirectories);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)entry.getKey());
                    }
                }
            }
            @Nullable Set<@NonNull File> entryFiles = classifiedFiles.get((Object)ImportFileClassification.APC_DIRECTORY);
            if (entryFiles != null) {
                jobs.add(new ImportAPCDirectoryJob(apcOutputPath, entryFiles));
            }
        }
        catch (Throwable t) {
            ImportJobFactory.cancelJobs(jobs);
            throw t;
        }
        return jobs;
    }

    private static void cancelJobs(@NonNull List<@NonNull Job> jobs) {
        for (Job job : jobs) {
            job.cancel();
        }
    }

    private static @NonNull ImportCaptureJob createApcZipCaptureJob(@Nullable IFileTypeChecker fileChecker, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath) throws ImportJobCreationException {
        ArrayList<@NonNull File> perfFiles = new ArrayList<File>();
        for (File file : files) {
            try {
                if (fileChecker == null || fileChecker.isZipFile(file)) {
                    perfFiles.add(file);
                    continue;
                }
                throw new ImportJobCreationException(ImportMessages.NOT_A_ZIP_FILE);
            }
            catch (IOException exception) {
                throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, exception);
            }
        }
        return new ImportCaptureJob(perfFiles, apcOutputPath);
    }

    private static @NonNull ImportBarmanCaptureJob createBarmanCaptureJob(@Nullable IFileTypeChecker fileChecker, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath) throws ImportJobCreationException {
        ArrayList<@NonNull File> barmanFiles = new ArrayList<File>();
        for (File file : files) {
            try {
                if (fileChecker == null || fileChecker.isBarmanFile(file)) {
                    barmanFiles.add(file);
                    continue;
                }
                throw new ImportJobCreationException(ImportMessages.NOT_A_BARMAN_FILE);
            }
            catch (IOException exception) {
                throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, exception);
            }
        }
        return new ImportBarmanCaptureJob(barmanFiles, apcOutputPath);
    }

    private static @NonNull ImportBarmanITMJob createBarmanITMJob(@NonNull File apcOutputPath, boolean importAsSynchronized, @NonNull ITraceDumpDirectory directory, @NonNull BarmanXmlAndAgentImage barmanXmlAndAgentImage) throws ImportJobCreationException {
        File barmanXml = barmanXmlAndAgentImage.barmanXml;
        BarmanConfiguration barmanConfig = barmanXmlAndAgentImage.barmanConfig;
        if (barmanXml == null && barmanConfig == null) {
            throw new AssertionError();
        }
        File agentImage = barmanXmlAndAgentImage.agentImage;
        try {
            return new ImportBarmanITMJob(apcOutputPath, barmanXml, barmanConfig, directory, agentImage, importAsSynchronized);
        }
        catch (IOException e) {
            throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, e);
        }
    }

    private static @Nullable ImportBarmanITMJob createBarmanITMJob(@NonNull IImportJobConfigurationSupplier barmanXmlSelector, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath, boolean importAsSynchronized) throws ImportJobCreationException {
        if (files.size() == 1) {
            @NonNull File file = files.iterator().next();
            @NonNull ITraceDumpDirectory directory = ImportJobFactory.createOrWrapTraceDumpFile(file, "ITM", stream -> ITMTraceSourceStreamWrapper.tryCreateITMTraceStream((ITraceDumpTraceStream)stream));
            @NonNull EnumMap<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> classifications = new EnumMap<TraceDumpImportClassification, Collection<ITraceSourceStreamWrapper>>(TraceDumpImportClassification.class);
            classifications.put(TraceDumpImportClassification.BARMAN_ITM, directory.getAllTraceSourceStreamWrappers());
            classifications.put(TraceDumpImportClassification.BARMAN_ITM_AGENTLESS_DWT, directory.getAllTraceSourceStreamWrappers());
            @Nullable BarmanXmlAndAgentImage barmanXmlAndAgentImage = (BarmanXmlAndAgentImage)NullChecking.applyIfNonNull((Object)barmanXmlSelector.selectTraceDumpImportConfiguration(directory, classifications), ITraceDumpImportConfiguration::getBarmanXmlAndAgentImage);
            if (barmanXmlAndAgentImage != null) {
                return ImportJobFactory.createBarmanITMJob(apcOutputPath, importAsSynchronized, directory, barmanXmlAndAgentImage);
            }
            return null;
        }
        throw new ImportJobCreationException(ImportMessages.ONLY_ONE_ALLOWED);
    }

    private static @NonNull ImportBarmanSTMJob createBarmanSTMJob(@NonNull File apcOutputPath, @NonNull ITraceDumpDirectory directory, @NonNull BarmanXmlAndAgentImage barmanXmlAndAgentImage) throws ImportJobCreationException {
        File barmanXml = (File)NullChecking.neverNull((Object)barmanXmlAndAgentImage.barmanXml);
        File agentImage = barmanXmlAndAgentImage.agentImage;
        try {
            return new ImportBarmanSTMJob(apcOutputPath, barmanXml, directory, agentImage);
        }
        catch (IOException e) {
            throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, e);
        }
    }

    private static @Nullable ImportBarmanSTMJob createBarmanSTMJob(@NonNull IImportJobConfigurationSupplier barmanXmlSelector, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath) throws ImportJobCreationException {
        if (files.size() == 1) {
            Map<TraceDumpImportClassification, Collection<ITraceSourceStreamWrapper>> classifications;
            @NonNull File file = files.iterator().next();
            @NonNull ITraceDumpDirectory directory = ImportJobFactory.createOrWrapTraceDumpFile(file, "STM", stream -> STMTraceSourceStreamWrapper.tryCreateSTMTraceStream((ITraceDumpTraceStream)stream));
            @Nullable BarmanXmlAndAgentImage barmanXmlAndAgentImage = (BarmanXmlAndAgentImage)NullChecking.applyIfNonNull((Object)barmanXmlSelector.selectTraceDumpImportConfiguration(directory, classifications = Collections.singletonMap(TraceDumpImportClassification.BARMAN_STM, directory.getAllTraceSourceStreamWrappers())), ITraceDumpImportConfiguration::getBarmanXmlAndAgentImage);
            if (barmanXmlAndAgentImage != null) {
                return ImportJobFactory.createBarmanSTMJob(apcOutputPath, directory, barmanXmlAndAgentImage);
            }
            return null;
        }
        throw new ImportJobCreationException(ImportMessages.ONLY_ONE_ALLOWED);
    }

    private static <U extends ITraceSourceStreamWrapper> @NonNull ITraceDumpDirectory createOrWrapTraceDumpFile(@NonNull File file, @NonNull String format, @NonNull Function<@NonNull ITraceDumpTraceStream, @Nullable U> wrappedStreamFactory) throws ImportJobCreationException {
        @NonNull File absoluteFile = file.getAbsoluteFile();
        @NonNull File directory = absoluteFile.isDirectory() ? absoluteFile : (File)NullChecking.neverNull((Object)absoluteFile.getParentFile());
        try {
            return new TraceDumpDirectory(directory);
        }
        catch (IOException e) {
            if (file.isFile()) {
                return new WrappedFileTraceDumpDirectory<U>(file, format, wrappedStreamFactory);
            }
            throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, e);
        }
    }

    private static @NonNull ImportPerfCaptureJob createPerfJob(@Nullable IFileTypeChecker fileChecker, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath) throws ImportJobCreationException {
        ArrayList<@NonNull File> perfFiles = new ArrayList<File>();
        for (File file : files) {
            try {
                if (fileChecker == null || fileChecker.isPerfFile(file)) {
                    perfFiles.add(file);
                    continue;
                }
                throw new ImportJobCreationException(ImportMessages.NOT_A_PERF_DATA_FILE);
            }
            catch (IOException exception) {
                throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, exception);
            }
        }
        return new ImportPerfCaptureJob(perfFiles, apcOutputPath);
    }

    private static @Nullable Job createTraceDumpJob(@NonNull IImportJobConfigurationSupplier barmanXmlSelector, @NonNull Collection<@NonNull File> files, @NonNull File apcOutputPath, boolean importAsSynchronized) throws ImportJobCreationException {
        ITraceDumpImportConfiguration traceDumpImportConfiguration;
        TraceDumpDirectory directory;
        block8: {
            try {
                Map<TraceDumpImportClassification, Collection<ITraceSourceStreamWrapper>> classifications;
                if (files.size() != 1) {
                    throw new ImportJobCreationException(ImportMessages.ONLY_ONE_ALLOWED);
                }
                @NonNull File directoryPath = files.iterator().next();
                directory = new TraceDumpDirectory(directoryPath);
                traceDumpImportConfiguration = barmanXmlSelector.selectTraceDumpImportConfiguration((ITraceDumpDirectory)directory, classifications = TraceDumpImportClassification.classify((ITraceDumpDirectory)directory));
                if (traceDumpImportConfiguration != null) break block8;
                return null;
            }
            catch (IOException e) {
                throw new ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, e);
            }
        }
        switch (traceDumpImportConfiguration.getImportClassification()) {
            case BARMAN_ITM: 
            case BARMAN_ITM_AGENTLESS_DWT: {
                return ImportJobFactory.createBarmanITMJob(apcOutputPath, importAsSynchronized, (ITraceDumpDirectory)directory, traceDumpImportConfiguration.getBarmanXmlAndAgentImage());
            }
            case BARMAN_STM: {
                return ImportJobFactory.createBarmanSTMJob(apcOutputPath, (ITraceDumpDirectory)directory, traceDumpImportConfiguration.getBarmanXmlAndAgentImage());
            }
        }
        throw new AssertionError((Object)traceDumpImportConfiguration.getImportClassification());
    }

    public static class BarmanXmlAndAgentImage {
        public final @Nullable File agentImage;
        public final @Nullable BarmanConfiguration barmanConfig;
        public final @Nullable File barmanXml;

        public BarmanXmlAndAgentImage(@Nullable File barmanXml, @Nullable File agentImage, @Nullable BarmanConfiguration barmanConfig) {
            this.barmanXml = barmanXml;
            this.agentImage = agentImage;
            this.barmanConfig = barmanConfig;
        }
    }

    public static interface IImportJobConfigurationSupplier {
        public @Nullable ITraceDumpImportConfiguration selectTraceDumpImportConfiguration(@NonNull ITraceDumpDirectory var1, @NonNull Map<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> var2) throws ImportJobCreationException;
    }

    public static interface ITraceDumpImportConfiguration {
        public @NonNull BarmanXmlAndAgentImage getBarmanXmlAndAgentImage() throws AssertionError;

        public @NonNull TraceDumpImportClassification getImportClassification();
    }

    public static enum ImportFileClassification {
        APC_DIRECTORY{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
                if (!1.isAPCDirectory(file)) {
                    return null;
                }
                return FileUtils.canonicalise((File)file);
            }
        }
        ,
        APC_ZIP_FILE{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
                if (!fileTypeChecker.isZipFile(file)) {
                    return null;
                }
                return FileUtils.canonicalise((File)file);
            }
        }
        ,
        BARMAN_RAW_FILE{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
                if (!fileTypeChecker.isBarmanFile(file)) {
                    return null;
                }
                return FileUtils.canonicalise((File)file);
            }
        }
        ,
        CAPTURES_DIRECTORY{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
                if (!4.isCapturesDirectory(file)) {
                    return null;
                }
                return FileUtils.canonicalise((File)file);
            }
        }
        ,
        NONE{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) {
                return null;
            }
        }
        ,
        PERF_RECORD_FILE{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
                if (!fileTypeChecker.isPerfFile(file)) {
                    return null;
                }
                return FileUtils.canonicalise((File)file);
            }
        }
        ,
        TRACE_DUMP_DIR{

            @Override
            protected @Nullable File classify(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
                if (fileTypeChecker.isTraceDumpDirectory(file)) {
                    return FileUtils.canonicalise((File)file);
                }
                @Nullable File parentDir = file.getParentFile();
                if (parentDir != null && fileTypeChecker.isTraceDumpDirectory(parentDir)) {
                    return parentDir.getCanonicalFile();
                }
                return null;
            }
        };


        public static @NonNull ClassifyImportTypeResult classifyImportType(@NonNull IFileTypeChecker fileTypeChecker, @NonNull File file) throws IOException {
            ImportFileClassification[] importFileClassificationArray = ImportFileClassification.values();
            int n = importFileClassificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportFileClassification classification = importFileClassificationArray[n2];
                @Nullable File classifiedFile = classification.classify(fileTypeChecker, file);
                if (classifiedFile != null) {
                    return new ClassifyImportTypeResult(classification, classifiedFile);
                }
                ++n2;
            }
            return new ClassifyImportTypeResult(NONE, file);
        }

        public static @NonNull Map<@NonNull ImportFileClassification, @NonNull Set<@NonNull File>> classifyImportTypes(@NonNull IFileTypeChecker fileTypeChecker, @NonNull Collection<@NonNull File> files) throws IOException {
            @NonNull HashMap<@NonNull ImportFileClassification, @NonNull Set<@NonNull File>> result = new HashMap<ImportFileClassification, Set<File>>();
            for (File file : files) {
                @NonNull ClassifyImportTypeResult classification = ImportFileClassification.classifyImportType(fileTypeChecker, file);
                ImportFileClassification.put(result, classification.classification, classification.classifiedFile);
            }
            return result;
        }

        public static boolean isAPCDirectory(@NonNull File file) {
            return file.isDirectory() && file.getName().toLowerCase().endsWith(".apc");
        }

        public static boolean isCapturesDirectory(@NonNull File file) {
            if (!file.isDirectory()) {
                return false;
            }
            @NonNull File @Nullable [] children = file.listFiles(f -> ImportFileClassification.isAPCDirectory(f));
            return children != null && children.length != 0;
        }

        private static void put(@NonNull Map<@NonNull ImportFileClassification, @NonNull Set<@NonNull File>> map, @NonNull ImportFileClassification classification, @NonNull File file) {
            Set<@NonNull File> set = map.get((Object)classification);
            if (set == null) {
                set = new HashSet<File>();
                map.put(classification, set);
            }
            set.add(file);
        }

        protected abstract @Nullable File classify(@NonNull IFileTypeChecker var1, @NonNull File var2) throws IOException;

        public static final class ClassifyImportTypeResult {
            public final @NonNull ImportFileClassification classification;
            public final @NonNull File classifiedFile;

            public ClassifyImportTypeResult(@NonNull ImportFileClassification classification, @NonNull File classifiedFile) {
                this.classification = classification;
                this.classifiedFile = classifiedFile;
            }
        }
    }

    public static class ImportJobCreationException
    extends Exception {
        public ImportJobCreationException(@NonNull String message) {
            super(message);
        }

        public ImportJobCreationException(@NonNull String message, Throwable t) {
            super(message, t);
        }
    }

    private static class WrappedFileTraceDumpDirectory<U extends ITraceSourceStreamWrapper>
    implements ITraceDumpDirectory {
        final @NonNull File file;
        final @NonNull ITraceDumpTraceStream stream;
        final @NonNull U wrappedStream;

        public WrappedFileTraceDumpDirectory(final @NonNull File file, final @NonNull String format, @NonNull Function<@NonNull ITraceDumpTraceStream, @Nullable U> wrappedStreamFactory) throws ImportJobCreationException {
            this.file = file;
            this.stream = new ITraceDumpTraceStream(){

                public @NonNull List<@NonNull File> getPrimaryStreamFiles() {
                    return Arrays.asList(file);
                }

                public @NonNull List<@NonNull File> getSecondaryStreamFiles() {
                    return Collections.emptyList();
                }

                public @Nullable String getSourceCore() {
                    return null;
                }

                public @NonNull String getSourceFormat() {
                    return format;
                }

                public @NonNull String getStreamName() {
                    return file.getName();
                }

                public @NonNull ITraceDumpDirectory getTraceDumpDirectory() {
                    return this;
                }
            };
            @Nullable ITraceSourceStreamWrapper wrappedStream = (ITraceSourceStreamWrapper)wrappedStreamFactory.apply(this.stream);
            if (wrappedStream == null) {
                throw new ImportJobCreationException(MessageFormat.format(ImportMessages.UNSUPPORTED_FILE_TYPE, file.getAbsolutePath()));
            }
            this.wrappedStream = wrappedStream;
        }

        public @NonNull List<@NonNull ITraceSourceStreamWrapper> getAllTraceSourceStreamWrappers() {
            return Arrays.asList(this.wrappedStream);
        }

        public @NonNull List<@NonNull ITraceSourceStreamWrapper> getAllTraceSourceStreamWrappers(@NonNull Predicate<@NonNull ITraceSourceStreamWrapper> filter) {
            return this.getAllTraceSourceStreamWrappers().stream().filter(filter).collect(Collectors.toList());
        }

        public @Nullable String getContentsIniProperty(@NonNull String sectionName, @NonNull String keyName) {
            return null;
        }

        public @NonNull File getDirectory() {
            return this.file;
        }

        public @Nullable String getMetadataProperty(@NonNull String sectionName, @NonNull String keyName) {
            return null;
        }

        public @NonNull Map<@NonNull String, ? extends @NonNull ITraceDumpTraceStream> getTraceStreams() {
            return Collections.unmodifiableMap(new HashMap<String, ITraceDumpTraceStream>(){
                {
                    this.put(wrappedFileTraceDumpDirectory.stream.getStreamName(), wrappedFileTraceDumpDirectory.stream);
                }
            });
        }
    }
}

