/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.streamline.databrowser.DocumentsMessages;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public enum ImportFileType {
    ALL_SUPPORTED_TYPES("*.zip;*.raw;*.barman;*.bin;*ITM*.bin;*STM*.bin;contents.ini;trace.ini;*perf.data*;*.data;*.perf", DocumentsMessages.ALL_SUPPORTED_IMPORTS),
    BARMAN_RAW("*.raw;*.barman;*.bin", DocumentsMessages.BARMAN_CAPTURES),
    ITM_DUMP("*ITM*.bin;contents.ini;trace.ini", DocumentsMessages.ITM_TRACES),
    PERF_DATA("*perf.data*;*.data;*.perf", DocumentsMessages.PERF_RECORDINGS),
    STPv2_DUMP("*STM*.bin;contents.ini;trace.ini", DocumentsMessages.STM_TRACES),
    TRACE_DUMP("*ITM*.bin;*STM*.bin;contents.ini;trace.ini", DocumentsMessages.TRACE_DUMP),
    ZIP_APC("*.zip", DocumentsMessages.ZIP_FILES);

    private final @NonNull String extensionFilterPattern;
    private final @NonNull String extensionFilterText;

    public static String[] getFilterDescriptions() {
        @NonNull ImportFileType @NonNull [] enums = ImportFileType.values();
        String[] result = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            result[i] = String.format("%s (%s)", enums[i].extensionFilterText, enums[i].extensionFilterPattern);
            ++i;
        }
        return result;
    }

    public static String[] getFilterExtensions() {
        @NonNull ImportFileType @NonNull [] enums = ImportFileType.values();
        String[] result = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            result[i] = enums[i].extensionFilterPattern;
            ++i;
        }
        return result;
    }

    private ImportFileType(String extensionFilterPattern, String extensionFilterText) {
        this.extensionFilterPattern = Arrays.stream(extensionFilterPattern.split(";")).distinct().sorted().collect(Collectors.joining(";", "", ""));
        this.extensionFilterText = extensionFilterText;
    }

    private static class FileNamePatterns {
        private static final @NonNull String PATTERN_BARMAN_RAW = "*.raw;*.barman;*.bin";
        private static final @NonNull String PATTERN_ITM_DUMP = "*ITM*.bin";
        private static final @NonNull String PATTERN_PERF_DATA = "*perf.data*;*.data;*.perf";
        private static final @NonNull String PATTERN_STPv2_DUMP = "*STM*.bin";
        private static final @NonNull String PATTERN_TRACE_DUMP_SHARED = "contents.ini;trace.ini";
        private static final @NonNull String PATTERN_ZIP_APC = "*.zip";

        private FileNamePatterns() {
        }
    }
}

