/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.dataimport.ImportJob;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.dataimport.ImportingApcFile;
import com.arm.streamline.dataimport.MonitorWrapper;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImportAPCDirectoryJob
extends Job {
    private final @NonNull File apcOutputPath;
    private final @NonNull Set<@NonNull File> entryFiles;

    public ImportAPCDirectoryJob(@NonNull File apcOutputPath, @NonNull Set<@NonNull File> entryFiles) {
        super(ImportMessages.COPYING_CAPTURES);
        this.apcOutputPath = apcOutputPath;
        this.entryFiles = entryFiles;
    }

    protected IStatus run(@NonNull IProgressMonitor monitor) {
        DocumentScanner.INSTANCE.addToWatchSet(this.apcOutputPath);
        @NonNull List<@NonNull T> captureDirectories = DocumentScanner.INSTANCE.getWatchList().stream().map(FileUtils::canonicalise).collect(Collectors.toList());
        @NonNull Set<@NonNull T> filesToCopy = this.entryFiles.stream().filter(f -> {
            @Nullable File p = f.getParentFile();
            return p != null && !captureDirectories.contains(FileUtils.canonicalise((File)p));
        }).collect(Collectors.toSet());
        if (filesToCopy.isEmpty()) {
            return Status.OK_STATUS;
        }
        @NonNull ArrayList<@NonNull File> createdTargets = new ArrayList<File>();
        @NonNull MonitorWrapper monitorWrapper = new MonitorWrapper(monitor, ImportMessages.COPYING_CAPTURES, filesToCopy.size());
        for (File fileToCopy : filesToCopy) {
            monitorWrapper.subTask(fileToCopy.getName(), null);
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (@NonNull ImportingApcFile apcFile = ImportJob.getApcFile(this.apcOutputPath, fileToCopy.getName());){
                    File targetPath;
                    block20: {
                        targetPath = apcFile.getFile();
                        try {
                            if (!monitor.isCanceled()) break block20;
                            return Status.CANCEL_STATUS;
                        }
                        catch (Throwable t) {
                            try {
                                StreamlineFileUtils.deleteAsynchronously(targetPath, true);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw t;
                        }
                    }
                    @NonNull FileFilter filter = f -> {
                        if (monitor.isCanceled()) {
                            throw new RuntimeException();
                        }
                        if (!f.isDirectory()) {
                            return true;
                        }
                        String name = f.getName();
                        if (name.equals(".git") || name.equals(".svn") || name.equals(".DS_Store")) {
                            return false;
                        }
                        @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)fileToCopy);
                        @NonNull File reportDirectory = new File(fileToCopy, "report");
                        return !f.equals(dbDirectory) && !f.equals(reportDirectory);
                    };
                    long totalFiles = CommonFileUtils.countFileTree((File)fileToCopy, (FileFilter)filter);
                    long[] copiedFiles = new long[1];
                    CommonFileUtils.copyFileTree((File)fileToCopy, (File)targetPath, f -> {
                        if (!filter.accept(f)) {
                            return false;
                        }
                        if (f.isFile()) {
                            lArray[0] = copiedFiles[0] + 1L;
                            monitorWrapper.progress(lArray[0], totalFiles, 0L);
                        }
                        return true;
                    });
                    createdTargets.add(targetPath);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return new Status(4, "com.arm.streamline", ImportMessages.EXCEPTION_THROWN, t);
            }
        }
        DocumentScanner.INSTANCE.updateAndSelect(createdTargets);
        DocumentsView.makeVisible();
        return Status.OK_STATUS;
    }
}

