/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.TraceDumpDirectory;
import com.arm.streamline.databrowser.trace_dump_import.TraceDumpImportClassification;
import com.arm.streamline.dataimport.ImportBarmanCaptureJob;
import com.arm.streamline.dataimport.ImportCaptureJob;
import com.arm.streamline.dataimport.ImportPerfCaptureJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public interface IFileTypeChecker {
    public static final @NonNull IFileTypeChecker DEFAULT = new IFileTypeChecker(){

        @Override
        public boolean isBarmanFile(@NonNull File file) throws FileNotFoundException, IOException {
            return ImportBarmanCaptureJob.isBarmanFile(file);
        }

        @Override
        public boolean isPerfFile(@NonNull File file) throws IOException {
            return ImportPerfCaptureJob.isPerfFile(file);
        }

        @Override
        public boolean isTraceDumpDirectory(@NonNull File file) throws IOException {
            try {
                TraceDumpDirectory directory = new TraceDumpDirectory(file);
                @NonNull Map<TraceDumpImportClassification, Collection<@NonNull ITraceSourceStreamWrapper>> classifications = TraceDumpImportClassification.classify((ITraceDumpDirectory)directory);
                if (!classifications.isEmpty()) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public boolean isZipFile(@NonNull File file) {
            return ImportCaptureJob.isZipFile(file);
        }
    };

    public boolean isBarmanFile(@NonNull File var1) throws IOException;

    public boolean isPerfFile(@NonNull File var1) throws IOException;

    public boolean isTraceDumpDirectory(@NonNull File var1) throws IOException;

    public boolean isZipFile(@NonNull File var1) throws IOException;
}

