/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.view;

import com.arm.databinding.swt.TypedColumnLabelProviderAdapter;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.databrowser.model.FileOrDirectoryListPanelModel;
import com.arm.streamline.databrowser.view.Messages;
import com.arm.streamline.utility.io.Images;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FileOrDirectoryListPanel
extends Composite {
    private DataBindingContext m_bindingContext;
    private final @NonNull FileOrDirectoryListPanelModel model;
    private CheckboxTableViewer mtblDirectoryList_Viewer;
    private ToolItem mtliRemoveSelected;

    public FileOrDirectoryListPanel(Composite parent, @NonNull FileOrDirectoryListPanelModel model) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.model = model;
        this.createContents();
    }

    protected void do_tliAddNew_widgetSelected(SelectionEvent e) {
        @Nullable File path = this.model.commandShowAddDialog(this.getShell());
        if (path != null) {
            this.model.commandAddPath(path);
        }
    }

    protected void do_tliCheckAll_widgetSelected(SelectionEvent e) {
        this.model.commandCheckAll();
    }

    protected void do_tliRemoveSelected_widgetSelected(SelectionEvent e) {
        this.model.commandRemoveSelected();
    }

    protected void do_tliUncheckAll_widgetSelected(SelectionEvent e) {
        this.model.commandUncheckAll();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue mtblDirectoryList_ViewerObserveSingleSelection = ViewerProperties.singleSelection().observe((Viewer)this.mtblDirectoryList_Viewer);
        bindingContext.bindValue((IObservableValue)mtblDirectoryList_ViewerObserveSingleSelection, this.model.getPropertyCurrentSelection(), null, null);
        IViewerObservableSet mtblDirectoryList_ViewerObserveCheckedElements = ViewerProperties.checkedElements(File.class).observe((Viewer)this.mtblDirectoryList_Viewer);
        bindingContext.bindSet((IObservableSet)mtblDirectoryList_ViewerObserveCheckedElements, this.model.getPropertyCheckedPaths(), null, null);
        ISWTObservableValue mtliRemoveSelected_WidgetObserveEnabled = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.mtliRemoveSelected));
        bindingContext.bindValue((IObservableValue)mtliRemoveSelected_WidgetObserveEnabled, this.model.getPropertyCanRemoveSelection(), null, null);
        return bindingContext;
    }

    private void createContents() {
        GridLayoutFactory.fillDefaults().spacing(2, 2).applyTo((Composite)this);
        ToolBar tbrButtons = new ToolBar((Composite)this, 0x820000);
        tbrButtons.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        ToolItem tliCheckAll = new ToolItem(tbrButtons, 8);
        tliCheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOrDirectoryListPanel.this.do_tliCheckAll_widgetSelected(e);
            }
        });
        tliCheckAll.setImage(StreamlinePlugin.getImage("CheckAll.gif"));
        tliCheckAll.setToolTipText(Messages.FileOrDirectoryListPanel_CheckAll_ToolTip);
        ToolItem tliUncheckAll = new ToolItem(tbrButtons, 8);
        tliUncheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOrDirectoryListPanel.this.do_tliUncheckAll_widgetSelected(e);
            }
        });
        tliUncheckAll.setImage(StreamlinePlugin.getImage("CheckNone.gif"));
        tliUncheckAll.setToolTipText(Messages.FileOrDirectoryListPanel_UncheckAll_ToolTip);
        ToolItem tliAddNew = new ToolItem(tbrButtons, 8);
        tliAddNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOrDirectoryListPanel.this.do_tliAddNew_widgetSelected(e);
            }
        });
        tliAddNew.setImage(StreamlinePlugin.getImage("ProgramFileNew.png"));
        tliAddNew.setText(Messages.FileOrDirectoryListPanel_AddNew_Label);
        this.mtliRemoveSelected = new ToolItem(tbrButtons, 8);
        this.mtliRemoveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileOrDirectoryListPanel.this.do_tliRemoveSelected_widgetSelected(e);
            }
        });
        ImageDescriptor deleteImageDescriptor = Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE");
        this.mtliRemoveSelected.setImage(deleteImageDescriptor.createImage());
        this.mtliRemoveSelected.setText(Messages.FileOrDirectoryListPanel_Remove_Label);
        Table tblDirectoryList = new Table((Composite)this, 67616);
        this.mtblDirectoryList_Viewer = new CheckboxTableViewer(tblDirectoryList);
        this.mtblDirectoryList_Viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        tblDirectoryList.setHeaderVisible(true);
        tblDirectoryList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn colCheck_Viewer = new TableViewerColumn((TableViewer)this.mtblDirectoryList_Viewer, 0x1000000);
        colCheck_Viewer.setLabelProvider((CellLabelProvider)new ColumnCheckLabelProvider());
        TableColumn colCheck = colCheck_Viewer.getColumn();
        colCheck.setResizable(true);
        colCheck.setText(Messages.FileOrDirectoryListPanel_ColUse_Title);
        TableViewerColumn colPath_Viewer = new TableViewerColumn((TableViewer)this.mtblDirectoryList_Viewer, 16384);
        colPath_Viewer.setLabelProvider((CellLabelProvider)new ColumnPathLabelProvider(this.model::getPathLabel, this.model::isValidPath));
        TableColumn colPath = colPath_Viewer.getColumn();
        colPath.setText(Messages.FileOrDirectoryListPanel_ColName_Title);
        this.mtblDirectoryList_Viewer.setInput(this.model.getPropertyAllPaths());
        this.m_bindingContext = this.initDataBindings();
        TableColumn[] tableColumns = tblDirectoryList.getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            tableColumns[i].pack();
            ++i;
        }
    }

    public static final class ColumnCheckLabelProvider
    extends TypedColumnLabelProviderAdapter<File> {
        public ColumnCheckLabelProvider() {
            super(f -> "");
        }
    }

    public static final class ColumnPathLabelProvider
    extends TypedColumnLabelProviderAdapter<File> {
        public ColumnPathLabelProvider(@NonNull Function<@NonNull File, @NonNull String> labelProvider, @NonNull Predicate<@NonNull File> isValidPredicate) {
            super(labelProvider, null, f -> isValidPredicate.test((File)f) ? null : StreamlinePlugin.getImage("WarningHigh.png"));
        }
    }
}

