/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel;

import com.arm.databinding.wizard.IBindableWizardStep;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.databrowser.trace_dump_import.wizard.TraceDumpImportWizardVM;
import com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel.AbstractTraceDumpImportWizardVM;
import com.arm.streamline.dataimport.ImportJobFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanXmlAndAgentConfigurationVM
extends AbstractTraceDumpImportWizardVM {
    private final @NonNull IObservableValue<@NonNull Supplier<@Nullable InputStream>> barmanXmlSupplier;
    private final @NonNull IObservableValue<@Nullable IBindableWizardStep> nextStep;
    private final @NonNull IObservableValue<@Nullable File> propertyAgentImageFile = new WritableValue(null, File.class);
    private final @NonNull IObservableValue<@Nullable BarmanConfiguration> propertyBarmanConfig;
    private final @NonNull IObservableValue<@Nullable File> propertyBarmanXmlFile = new WritableValue(null, File.class);
    private final @NonNull IObservableValue<@NonNull Boolean> propertyCanFinish;
    private final @NonNull IObservableValue<@NonNull Boolean> propertyCanMoveToNextStep;
    private final @NonNull IObservableValue<@NonNull Boolean> propertyRequireBarmanXml;
    private final @NonNull IObservableValue< @Nullable ImportJobFactory.BarmanXmlAndAgentImage> propertyResult;

    public BarmanXmlAndAgentConfigurationVM(@NonNull TraceDumpImportWizardVM wizardModel, @NonNull IObservableValue<@NonNull Boolean> propertyRequireBarmanXml, @NonNull IObservableValue<@NonNull Boolean> propertyRequireBarmanConfig, @NonNull IObservableValue<@Nullable BarmanConfiguration> propertyBarmanConfig, @NonNull IObservableValue<@Nullable IBindableWizardStep> nextStep) {
        super(wizardModel);
        this.propertyBarmanConfig = propertyBarmanConfig;
        this.propertyRequireBarmanXml = propertyRequireBarmanXml;
        this.nextStep = nextStep;
        this.barmanXmlSupplier = ComputedValue.create(() -> {
            File xml = (File)this.propertyBarmanXmlFile.getValue();
            return () -> {
                if (xml == null) {
                    return null;
                }
                try {
                    return new FileInputStream(xml);
                }
                catch (FileNotFoundException exception) {
                    return null;
                }
            };
        });
        this.propertyResult = ComputedValue.create(() -> {
            boolean requireBarmanXml = (Boolean)propertyRequireBarmanXml.getValue();
            boolean requireBarmanConfig = (Boolean)propertyRequireBarmanConfig.getValue();
            @Nullable File agentImageFile = (File)this.propertyAgentImageFile.getValue();
            @Nullable File barmanXmlFile = (File)this.propertyBarmanXmlFile.getValue();
            @Nullable BarmanConfiguration barmanConfig = (BarmanConfiguration)propertyBarmanConfig.getValue();
            if (requireBarmanXml && (barmanXmlFile == null || !barmanXmlFile.isFile())) {
                return null;
            }
            if (requireBarmanConfig && barmanConfig == null) {
                return null;
            }
            return new ImportJobFactory.BarmanXmlAndAgentImage(barmanXmlFile, agentImageFile, barmanConfig);
        });
        this.propertyCanFinish = ComputedValue.create(() -> this.propertyResult.getValue() != null);
        this.propertyCanMoveToNextStep = ComputedValue.create(() -> nextStep.getValue() != null);
    }

    public @NonNull IObservableValue<@NonNull Boolean> canFinish() {
        return this.propertyCanFinish;
    }

    public @NonNull IObservableValue<@NonNull Boolean> canMoveToNextStep() {
        return this.propertyCanMoveToNextStep;
    }

    public @NonNull IObservableValue<@Nullable File> getAgentImageFile() {
        return this.propertyAgentImageFile;
    }

    public @NonNull IObservableValue<@Nullable BarmanConfiguration> getBarmanConfig() {
        return this.propertyBarmanConfig;
    }

    public @NonNull IObservableValue<@Nullable File> getBarmanXmlFile() {
        return this.propertyBarmanXmlFile;
    }

    public @NonNull IObservableValue<@NonNull Supplier<@Nullable InputStream>> getBarmanXmlSupplier() {
        return this.barmanXmlSupplier;
    }

    public @Nullable IBindableWizardStep getNextStep() {
        return (IBindableWizardStep)this.nextStep.getValue();
    }

    public @NonNull IObservableValue<@NonNull Boolean> getRequireBarmanXml() {
        return this.propertyRequireBarmanXml;
    }

    public @NonNull IObservableValue< @Nullable ImportJobFactory.BarmanXmlAndAgentImage> getResult() {
        return this.propertyResult;
    }
}

