/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.utils.function.IThrowingConsumer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class UdpTargetBrowserService {
    private static int ANS_PORT = 30003;
    private static final byte[] DST_REQ;
    private static final @NonNull UdpTargetBrowserService INSTANCE;
    private static final int PING_TIMEOUT_IN_SECONDS = 1;
    private static int REQ_PORT;
    private final @NonNull List<@NonNull ITargetBrowserClient> clients = new ArrayList<ITargetBrowserClient>();
    private final @NonNull Map<@NonNull BrowseResult, @NonNull Long> lastSeenNsByResult = new HashMap<BrowseResult, Long>();
    private final @NonNull Object lock = new Object();
    private final @NonNull Thread pingThread;
    private final @NonNull SocketListenerThread socketListenerThread = new SocketListenerThread((IThrowingConsumer<DatagramSocket, IOException>)((IThrowingConsumer)this::readResponses));

    static {
        byte[] byArray = new byte[12];
        byArray[0] = 68;
        byArray[1] = 83;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 82;
        byArray[5] = 69;
        byArray[6] = 81;
        byArray[7] = 32;
        byArray[11] = 100;
        DST_REQ = byArray;
        INSTANCE = new UdpTargetBrowserService();
        REQ_PORT = 30002;
    }

    public static @NonNull UdpTargetBrowserService get() {
        return INSTANCE;
    }

    private static @NonNull Set<@NonNull InetAddress> getBroadcastAddresses() {
        HashSet<@NonNull InetAddress> result = new HashSet<InetAddress>();
        try {
            InetAddress multicastAddr = InetAddress.getByAddress(new byte[]{-1, -1, -1, -1});
            if (multicastAddr != null) {
                result.add(multicastAddr);
            }
        }
        catch (UnknownHostException multicastAddr) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces != null && networkInterfaces.hasMoreElements()) {
                List<InterfaceAddress> interfaceAddresses;
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp() || (interfaceAddresses = networkInterface.getInterfaceAddresses()) == null) continue;
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress broadcastAddress = interfaceAddress.getBroadcast();
                    if (broadcastAddress == null) continue;
                    result.add(broadcastAddress);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private UdpTargetBrowserService() {
        this.pingThread = new Thread(this::runPing, UdpTargetBrowserService.class.getSimpleName() + " Pinger");
        this.pingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(@NonNull ITargetBrowserClient client) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.add(client);
            for (BrowseResult entry : this.lastSeenNsByResult.keySet()) {
                client.foundNewDebugHardware(entry);
            }
            this.lock.notify();
        }
    }

    public void close() {
        this.socketListenerThread.interrupt();
        this.pingThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(@NonNull ITargetBrowserClient client) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(@NonNull BrowseResult entry) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeenNsByResult.put(entry, System.nanoTime());
            for (ITargetBrowserClient client : this.clients) {
                client.foundNewDebugHardware(entry);
            }
        }
    }

    private void createOne(final int port, final @NonNull String version, byte @NonNull [] data, final @NonNull InetAddress packetAddress) {
        StringBuilder connectionBuilder = new StringBuilder();
        int i = 28;
        while (i < data.length && data[i] != 0) {
            connectionBuilder.append((char)data[i]);
            ++i;
        }
        final String displayName = connectionBuilder.toString();
        Task.callOnAnotherThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String ipAddr;
                String targetAddress = ipAddr = packetAddress.getHostAddress();
                try {
                    InetAddress hostnameAddress = InetAddress.getByName(displayName);
                    if (hostnameAddress.equals(packetAddress)) {
                        targetAddress = displayName;
                    }
                }
                catch (UnknownHostException hostnameAddress) {
                    // empty catch block
                }
                TargetAddressString connection = port > 0 ? new TargetAddressString(targetAddress + ":" + port) : new TargetAddressString(targetAddress);
                BrowseResult result = new BrowseResult(connection, displayName, version, ipAddr, null, null, true, ConnectionType.STREAMLINE);
                UdpTargetBrowserService.this.addEntry(result);
            }
        });
    }

    private void readResponses(@NonNull DatagramSocket socket) throws IOException {
        byte[] data = new byte[84];
        DatagramPacket packet = new DatagramPacket(data, data.length);
        socket.receive(packet);
        if (packet.getAddress().isAnyLocalAddress()) {
            return;
        }
        if (data[3] != 95 || data[4] != 65 || data[5] != 78 || data[6] != 83 || data[7] != 32) {
            return;
        }
        if (data[0] == 83 && data[1] == 84 && data[2] == 82) {
            try {
                int port = BufferUtils.readLEInt((byte[])data, (int)72);
                String version = Integer.toString(BufferUtils.readLEInt((byte[])data, (int)76));
                this.createOne(port, version, data, packet.getAddress());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runPing() {
        try {
            block11: while (true) {
                Iterator<ITargetBrowserClient> iterator;
                Object object = this.lock;
                synchronized (object) {
                    if (this.clients.isEmpty()) {
                        this.lock.wait();
                    }
                }
                try {
                    Iterator<ITargetBrowserClient> iterator2 = this.clients.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            this.socketListenerThread.ping();
                            long limitNs = (long)Math.max(2, 2) * 1000000000L;
                            long now = System.nanoTime();
                            Object object2 = this.lock;
                            synchronized (object2) {
                                Iterator<Map.Entry<BrowseResult, Long>> it = this.lastSeenNsByResult.entrySet().iterator();
                                block13: while (true) {
                                    if (!it.hasNext()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 2, 18, 3, 19, 5, 11, 12, 13] lbl26 : MonitorExitStatement: MONITOREXIT : var5_6
                                    }
                                    Map.Entry<BrowseResult, Long> entry = it.next();
                                    long delta = now - entry.getValue();
                                    if (delta < limitNs) continue;
                                    BrowseResult browseResult = entry.getKey();
                                    Iterator<ITargetBrowserClient> iterator3 = this.clients.iterator();
                                    while (true) {
                                        if (!iterator3.hasNext()) {
                                            it.remove();
                                            continue block13;
                                        }
                                        ITargetBrowserClient client = iterator3.next();
                                        client.removeDebugHardware(browseResult);
                                    }
                                    break;
                                }
                            }
                        }
                        ITargetBrowserClient client = iterator2.next();
                        client.beginBrowse(ConnectionType.STREAMLINE);
                    }
                }
                finally {
                    iterator = this.clients.iterator();
                }
                while (true) {
                    if (!iterator.hasNext()) {
                        Thread.sleep(1000L);
                        continue block11;
                    }
                    ITargetBrowserClient client = iterator.next();
                    client.endBrowse(ConnectionType.STREAMLINE);
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static final class SocketListenerThread {
        private final @NonNull AtomicBoolean enabled = new AtomicBoolean(true);
        private final @NonNull Object lock = new Object();
        private final @NonNull IThrowingConsumer<@NonNull DatagramSocket, IOException> scannerLoopFunction;
        private final @NonNull AtomicReference<DatagramSocket> socket = new AtomicReference();
        private final @NonNull Thread thread;

        private static @Nullable DatagramSocket tryCreateSocket() {
            try {
                DatagramSocket result = new DatagramSocket(REQ_PORT, InetAddress.getByAddress(new byte[4]));
                try {
                    result.setReuseAddress(true);
                    result.setBroadcast(true);
                }
                catch (Throwable t) {
                    result.close();
                    throw t;
                }
                return result;
            }
            catch (SocketException | UnknownHostException e) {
                return null;
            }
        }

        public SocketListenerThread(@NonNull IThrowingConsumer<@NonNull DatagramSocket, IOException> scannerLoopFunction) {
            this.scannerLoopFunction = scannerLoopFunction;
            this.thread = new Thread(this::run, UdpTargetBrowserService.class.getSimpleName() + " Scanner");
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt() {
            this.enabled.set(false);
            this.cleanupSocket();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void ping() {
            DatagramSocket socket = this.socket.get();
            if (socket != null) {
                try {
                    for (InetAddress broadcastAddress : UdpTargetBrowserService.getBroadcastAddresses()) {
                        socket.send(new DatagramPacket(DST_REQ, DST_REQ.length, broadcastAddress, ANS_PORT));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void cleanupSocket() {
            DatagramSocket socket = this.socket.getAndSet(null);
            if (socket != null) {
                socket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void run() {
            block15: {
                try {
                    try {
                        block16: {
                            socket = null;
                            while (this.enabled.get() && socket == null) {
                                socket = this.socket.get();
                                if (socket != null) continue;
                                socket = SocketListenerThread.tryCreateSocket();
                                if (socket != null) {
                                    this.socket.set(socket);
                                    continue;
                                }
                                var2_3 = this.lock;
                                synchronized (var2_3) {
                                    this.lock.wait(1000L);
                                }
                            }
                            break block16;
                            while (true) {
                                try {
                                    this.scannerLoopFunction.accept((Object)socket);
                                }
                                catch (IOException e) {
                                    if (this.enabled.get()) {
                                        CommonPlugin.error((Throwable)e);
                                    }
                                    break block15;
                                }
                                break;
                            }
                        }
                        if (this.enabled.get()) {
                            if (socket != null) ** continue;
                        }
                    }
                    catch (InterruptedException e) {
                        this.enabled.set(false);
                        this.cleanupSocket();
                    }
                }
                finally {
                    this.cleanupSocket();
                }
            }
        }
    }
}

