/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.common.xml.gatorConfig.GatorCurrentConfig;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.deviceconn.adb.utils.AdbDevice;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BrowseResult {
    private boolean m_available = true;
    private final @NonNull ConnectionType m_cType;
    private String m_details;
    private final String m_device_id;
    private final String m_displayName;
    private final @NonNull TargetAddressString m_targetAddressStr;
    private String m_tools_tip_text = null;
    private final String m_version;
    private final boolean m_gatorRunning;
    private final @NonNull Optional<// Could not load outer class - annotation placement on inner may be incorrect
    AdbDevice.AdbDeviceState> m_adbDeviceState;
    private final @NonNull Optional<@NonNull GatorCurrentConfig> m_gatorConfigInfo;
    private final @Nullable Integer m_configurationStreamlineVersion;
    private final boolean m_maliGpuDetected;

    public BrowseResult(BrowseResult hardware) {
        this(hardware.m_targetAddressStr, hardware.m_displayName, hardware.m_version, hardware.m_details, hardware.m_device_id, hardware.m_tools_tip_text, hardware.m_available, hardware.m_gatorRunning, hardware.m_cType, hardware.m_adbDeviceState, hardware.m_gatorConfigInfo, hardware.m_configurationStreamlineVersion, hardware.m_maliGpuDetected);
    }

    public BrowseResult(@NonNull TargetAddressString targetAddressStr, String displayName, String version, String details, String device_id, String tools_tip_text, boolean available, @NonNull ConnectionType cType) {
        this(targetAddressStr, displayName, version, details, device_id, tools_tip_text, available, true, cType, Optional.empty(), Optional.empty(), null, false);
    }

    private BrowseResult(@NonNull TargetAddressString targetAddressStr, String displayName, String version, String details, String device_id, String tools_tip_text, boolean available, boolean gatorRunning, @NonNull ConnectionType cType, @NonNull Optional<// Could not load outer class - annotation placement on inner may be incorrect
    AdbDevice.AdbDeviceState> status, @NonNull Optional<@NonNull GatorCurrentConfig> gatorConfigInfo, @Nullable Integer configurationStreamlineVersion, boolean maliGpuDetected) {
        this.m_targetAddressStr = targetAddressStr;
        this.m_displayName = displayName;
        this.m_version = version;
        this.m_details = details;
        this.m_device_id = device_id;
        this.m_tools_tip_text = tools_tip_text;
        this.m_available = available;
        this.m_gatorRunning = gatorRunning;
        this.m_cType = cType;
        this.m_adbDeviceState = status;
        this.m_gatorConfigInfo = gatorConfigInfo;
        this.m_configurationStreamlineVersion = configurationStreamlineVersion;
        this.m_maliGpuDetected = maliGpuDetected;
    }

    public static @NonNull BrowseResult adbBrowseResult(@NonNull TargetAddressString targetAddress, @NonNull String serialNumber, @Nullable String version, @Nullable String deviceModel, boolean gatorRunning, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AdbDevice.AdbDeviceState status, @NonNull Optional<@NonNull GatorCurrentConfig> gatorConfigInfo) {
        Optional<AdbDevice.AdbDeviceState> opt = Optional.of(status);
        return new BrowseResult(targetAddress, serialNumber, version, deviceModel, serialNumber, null, AdbDevice.AdbDeviceState.AVAILABLE.equals((Object)status), gatorRunning, ConnectionType.ADB, opt, gatorConfigInfo, null, false);
    }

    public static @NonNull BrowseResult adbBrowseResult(@NonNull TargetAddressString targetAddress, @NonNull String serialNumber, @Nullable String version, @Nullable String deviceModel, boolean gatorRunning, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AdbDevice.AdbDeviceState status, @NonNull Optional<@NonNull GatorCurrentConfig> gatorConfigInfo, @Nullable Integer configurationRevision, boolean isMaliGpuDetected) {
        Optional<AdbDevice.AdbDeviceState> opt = Optional.of(status);
        return new BrowseResult(targetAddress, serialNumber, version, deviceModel, serialNumber, null, AdbDevice.AdbDeviceState.AVAILABLE.equals((Object)status), gatorRunning, ConnectionType.ADB, opt, gatorConfigInfo, configurationRevision, isMaliGpuDetected);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BrowseResult) {
            return ((BrowseResult)obj).m_targetAddressStr.equals(this.m_targetAddressStr);
        }
        return false;
    }

    public boolean getAvailable() {
        return this.m_available;
    }

    public String getCategory() {
        return this.m_device_id == null ? this.m_cType.toString() : this.m_displayName;
    }

    public @NonNull ConnectionType getCType() {
        return this.m_cType;
    }

    public String getDetails() {
        return this.m_details;
    }

    public String getDeviceId() {
        return this.m_device_id;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public @NonNull TargetAddressString getTargetAddressString() {
        return this.m_targetAddressStr;
    }

    public String getToolsTipText() {
        return this.m_tools_tip_text;
    }

    public String getVersion() {
        return this.m_version;
    }

    public boolean isGatorRunning() {
        return this.m_gatorRunning;
    }

    public @Nullable Integer getConfigurationStreamlineVersion() {
        return this.m_configurationStreamlineVersion;
    }

    public int hashCode() {
        return this.m_targetAddressStr.hashCode();
    }

    public void setAvailable(boolean flag) {
        this.m_available = flag;
    }

    public void setDetails(String details) {
        this.m_details = details;
    }

    public String setToolsTipText(String text) {
        this.m_tools_tip_text = text;
        return this.m_tools_tip_text;
    }

    public @NonNull Optional<// Could not load outer class - annotation placement on inner may be incorrect
    AdbDevice.AdbDeviceState> getAdbDeviceState() {
        return this.m_adbDeviceState;
    }

    public @NonNull Optional<@NonNull GatorCurrentConfig> getGatorCurrentConfig() {
        return this.m_gatorConfigInfo;
    }

    public @NonNull BrowseResult withTargetAddress(@NonNull TargetAddressString revisedAddress) {
        return new BrowseResult(revisedAddress, this.m_displayName, this.m_version, this.m_details, this.m_device_id, this.m_tools_tip_text, this.m_available, this.m_gatorRunning, this.m_cType, this.m_adbDeviceState, this.m_gatorConfigInfo, this.m_configurationStreamlineVersion, this.m_maliGpuDetected);
    }

    public boolean isMaliGpuDetected() {
        return this.m_maliGpuDetected;
    }
}

