/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.IDirtyFlag;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.databrowser.IElfImageStore;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SessionImage;
import com.arm.streamline.utility.io.Images;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import com.arm.streamline.utility.ui.SimpleLastFilterPathStore;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class ImagesOptionsPanel
extends Composite
implements ISelectionChangedListener {
    private static Map<ElfImage.Availability, Image> statusImages = new HashMap<ElfImage.Availability, Image>();
    private static Map<ElfImage.Availability, String> statusTooltips = new HashMap<ElfImage.Availability, String>();
    private @Nullable Job importingJob;
    private final @NonNull ToolItem mAddProgramButton;
    private final @NonNull ToolItem mAddSeparateDebugImageButton;
    private final @NonNull ToolItem mCheckAllButton;
    private final @NonNull ToolItem mRemoveSelectedButton;
    private final @NonNull ToolItem mUncheckAllButton;
    private final @NonNull IImagesOptionsPanelViewModel mViewModel;
    private final @NonNull Table table;
    private final @NonNull ToolBar toolBar;

    static {
        ImagesOptionsPanel.addAvailabilityPresentation(ElfImage.Availability.AVAILABLE, "ElfDetailsAvailable.png", DocumentsMessages.IMAGE_STATUS_PRESENT);
        ImagesOptionsPanel.addAvailabilityPresentation(ElfImage.Availability.BROKEN, "ElfDetailsBroken.png", DocumentsMessages.IMAGE_STATUS_NOT_AVAILABLE);
        ImagesOptionsPanel.addAvailabilityPresentation(ElfImage.Availability.NOT_AVAILABLE, "ElfDetailsNotAvailable.png", DocumentsMessages.IMAGE_STATUS_NOT_AVAILABLE);
        ImagesOptionsPanel.addAvailabilityPresentation(ElfImage.Availability.SEPARATE_FILE_REQUIRED, "ElfDetailsSeparate.gif", DocumentsMessages.IMAGE_STATUS_SEPARATE_FILE_REQUIRED);
        ImagesOptionsPanel.addAvailabilityPresentation(ElfImage.Availability.UNKNOWN, "ElfDetailsUnknown.gif", DocumentsMessages.IMAGE_STATUS_UNKNOWN);
        ImagesOptionsPanel.addAvailabilityPresentation(ElfImage.Availability.UNSET, null, null);
    }

    public static @NonNull ImagesOptionsPanel create(Composite parent, @NonNull IElfImageStore imagesStore, @NonNull IAnalysisInputSettings settings, @NonNull IDirtyFlag dirtyFlag, boolean titleBorder) {
        return new ImagesOptionsPanel(parent, new DefaultViewModel(imagesStore, settings, dirtyFlag), titleBorder);
    }

    private static void addAvailabilityPresentation(ElfImage.Availability availability, String imageId, String tooltipText) {
        statusImages.put(availability, StreamlinePlugin.getImage(imageId));
        statusTooltips.put(availability, tooltipText);
    }

    private static void addPathForPlatform(String pathForPlatform, List<String> results, List<String> badPaths) {
        if (pathForPlatform.endsWith(".apk")) {
            results.add(pathForPlatform);
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (RandomAccessFile raf = new RandomAccessFile(pathForPlatform, "r");){
                    byte[] bytes = new byte[18];
                    raf.readFully(bytes);
                    boolean add = false;
                    if (bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70) {
                        int type = 0;
                        if (bytes[5] == 1) {
                            type = (bytes[17] & 0xFF) << 8 | bytes[16] & 0xFF;
                        } else if (bytes[5] == 2) {
                            type = (bytes[16] & 0xFF) << 8 | bytes[17] & 0xFF;
                        }
                        add |= type == 3;
                        add |= type == 2;
                        add |= type == 1;
                    }
                    if (add) {
                        results.add(pathForPlatform);
                    } else {
                        badPaths.add(pathForPlatform);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                badPaths.add(pathForPlatform);
            }
        }
    }

    private static @NonNull ToolItem createButton(@NonNull ToolBar parent, @Nullable Image image, @Nullable String title, @Nullable String tooltipText) {
        @NonNull ToolItem button = new ToolItem(parent, 8);
        if (title != null) {
            button.setText(title);
        }
        if (tooltipText != null) {
            button.setToolTipText(tooltipText);
        }
        button.setImage(image);
        button.setEnabled(false);
        return button;
    }

    private static void reportAnyErrors(List<String> badPaths) {
        int count = badPaths.size();
        if (count > 0) {
            StringBuilder buffer = new StringBuilder();
            for (String path : badPaths) {
                buffer.append(path);
                buffer.append('\n');
            }
            String format = count > 1 ? DocumentsMessages.BAD_PROGRAMS : DocumentsMessages.BAD_PROGRAM;
            Error.show(MessageFormat.format(format, buffer.toString()));
        }
    }

    public ImagesOptionsPanel(Composite parent, @NonNull IImagesOptionsPanelViewModel viewModel, boolean titleBorder) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.mViewModel = viewModel;
        BorderedComposite group = titleBorder ? new BorderedComposite(this, DocumentsMessages.IMAGES) : new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(2, 2).applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
        this.toolBar = new ToolBar((Composite)group, 8519744);
        GridLayoutFactory.fillDefaults().numColumns(5).spacing(2, 0).applyTo((Composite)this.toolBar);
        GridDataFactory.fillDefaults().applyTo((Control)this.toolBar);
        this.mCheckAllButton = ImagesOptionsPanel.createButton(this.toolBar, StreamlinePlugin.getImage("CheckAll.gif"), null, DocumentsMessages.IMAGE_USE_ALL_TOOLTIP);
        this.mCheckAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagesOptionsPanel.this.selectAll(true);
            }
        });
        this.mUncheckAllButton = ImagesOptionsPanel.createButton(this.toolBar, StreamlinePlugin.getImage("CheckNone.gif"), null, DocumentsMessages.IMAGE_USE_NONE_TOOLTIP);
        this.mUncheckAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagesOptionsPanel.this.selectAll(false);
            }
        });
        this.mAddProgramButton = ImagesOptionsPanel.createButton(this.toolBar, StreamlinePlugin.getImage("ProgramFileNew.png"), DocumentsMessages.ADD_PROGRAM, DocumentsMessages.IMAGE_ADD_PROGRAM_TOOLTIP);
        this.mAddSeparateDebugImageButton = ImagesOptionsPanel.createButton(this.toolBar, StreamlinePlugin.getImage("ProgramFileNewSeparate.png"), DocumentsMessages.IMAGE_SELECT_SEPARATE_FILE, DocumentsMessages.IMAGE_IMAGE_SELECT_SEPARATE_FILE_TOOLTIP);
        ImageDescriptor desc = Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE");
        this.mRemoveSelectedButton = ImagesOptionsPanel.createButton(this.toolBar, desc.createImage(), DocumentsMessages.IMAGE_REMOVE, DocumentsMessages.IMAGE_IMAGE_REMOVE_TOOLTIP);
        this.mRemoveSelectedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagesOptionsPanel.this.deleteSelectionRequested();
                ImagesOptionsPanel.this.adjustState();
                ImagesOptionsPanel.this.table.setFocus();
                ImagesOptionsPanel.this.updateSettings();
            }
        });
        this.mAddProgramButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagesOptionsPanel.this.addPrograms();
            }
        });
        this.mAddSeparateDebugImageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImagesOptionsPanel.this.addSeparateDebugImage();
            }
        });
        this.table = new Table((Composite)group, 68386);
        this.table.setHeaderVisible(true);
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(column.getTitle());
            ++n2;
        }
        this.pack();
        this.repackColumns();
        GridDataFactory.fillDefaults().grab(true, true).minSize(100, 150).applyTo((Control)this.table);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 32: {
                        ImagesOptionsPanel.this.updateSettings();
                        break;
                    }
                    default: {
                        ImagesOptionsPanel.this.adjustState();
                    }
                }
            }
        });
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        if (event.index != Column.COLUMN_1_NAME.ordinal()) break;
                        event.width += 16;
                        break;
                    }
                }
            }
        });
        this.table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                if (ImagesOptionsPanel.this.table.getSelectionCount() > 0) {
                    Menu menu = new Menu((Control)ImagesOptionsPanel.this.table);
                    MenuItem selectSeparateDebugGileItem = new MenuItem(menu, 0);
                    selectSeparateDebugGileItem.setText(DocumentsMessages.IMAGE_SELECT_SEPARATE_FILE);
                    selectSeparateDebugGileItem.setImage(StreamlinePlugin.getImage("ProgramFileNewSeparate.png"));
                    selectSeparateDebugGileItem.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            ImagesOptionsPanel.this.addSeparateDebugImage();
                        }
                    });
                    selectSeparateDebugGileItem.setEnabled(ImagesOptionsPanel.this.mAddSeparateDebugImageButton.isEnabled());
                    ImageDescriptor removeItemImageDescriptor = Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE");
                    MenuItem itemRemoveSelected = new MenuItem(menu, 0);
                    itemRemoveSelected.setText(DocumentsMessages.REMOVE);
                    itemRemoveSelected.setImage(removeItemImageDescriptor.createImage());
                    itemRemoveSelected.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            ImagesOptionsPanel.this.removeSelected();
                        }
                    });
                    menu.setLocation(event.x, event.y);
                    menu.setVisible(true);
                }
            }
        });
    }

    public boolean addData(ElfImage image, boolean isCheked) {
        if (this.table.isDisposed()) {
            return false;
        }
        TableItem item = new TableItem(this.table, 0);
        this.updateItem(image, item);
        item.setData((Object)image);
        item.setChecked(isCheked);
        return true;
    }

    public String checkValidity() {
        if (this.importingJob != null) {
            return DocumentsMessages.IMPORTING_IMAGES_IN_PROGRESS;
        }
        return null;
    }

    public void deleteSelectionRequested() {
        Set<@NonNull ElfImage> images = this.getSelectedImges();
        for (ElfImage image : images) {
            this.mViewModel.removeELFImage(image);
            this.removeSelected();
        }
        this.mViewModel.markDirty();
    }

    public Set<@NonNull ElfImage> getSelectedImges() {
        int[] indices;
        HashSet<@NonNull ElfImage> result = new HashSet<ElfImage>();
        int[] nArray = indices = this.table.getSelectionIndices();
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            @NonNull ElfImage image = (ElfImage)NullChecking.neverNull((Object)((ElfImage)this.table.getItem(i).getData()));
            result.add(image);
            ++n2;
        }
        return result;
    }

    public void initializeContent() {
        final Collection<@NonNull ElfImage> images = this.mViewModel.getAvailableELFImages();
        if (!images.isEmpty()) {
            Job job;
            this.importingJob = job = new Job(DocumentsMessages.IMAGES_IMPORTING_JOB){
                final @NonNull Display display;
                {
                    super($anonymous0);
                    this.display = (Display)NullChecking.neverNull((Object)PlatformUI.getWorkbench().getDisplay());
                }

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)images.size());
                    for (ElfImage image : images) {
                        if (subMonitor.isCanceled()) break;
                        subMonitor.setTaskName(image.getName());
                        try {
                            image.processFile();
                        }
                        catch (CodecException | NativeException | IOException exception) {
                            Error.show(exception.getMessage());
                        }
                        boolean selected = ImagesOptionsPanel.this.mViewModel.isELFImageSelectedInSession(image);
                        this.display.syncExec(() -> {
                            if (!ImagesOptionsPanel.this.addData(image, selected)) {
                                subMonitor.setCanceled(true);
                                subMonitor.done();
                            }
                        });
                        subMonitor.worked(1);
                    }
                    if (subMonitor.isCanceled()) {
                        this.display.syncExec(() -> {
                            ImagesOptionsPanel.this.importingJob = null;
                        });
                        return Status.CANCEL_STATUS;
                    }
                    this.display.syncExec(() -> {
                        ImagesOptionsPanel.this.importingJob = null;
                        ImagesOptionsPanel.this.adjustState();
                        ImagesOptionsPanel.this.mViewModel.markDirty();
                        ImagesOptionsPanel.this.repackColumns();
                    });
                    return Status.OK_STATUS;
                }
            };
            this.adjustState();
            this.mViewModel.markDirty();
            job.schedule();
        } else {
            this.adjustState();
            this.repackColumns();
        }
    }

    public void removeSelected() {
        this.table.remove(this.table.getSelectionIndices());
        this.table.deselectAll();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.adjustState();
    }

    public void updateSettings() {
        HashSet<@NonNull ElfImage> sessionImages = new HashSet<ElfImage>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            @NonNull ElfImage elfImage = (ElfImage)NullChecking.neverNull((Object)((ElfImage)item.getData()));
            if (item.getChecked()) {
                sessionImages.add(elfImage);
            }
            ++n2;
        }
        this.mViewModel.setImagesSelectedInSession(sessionImages);
    }

    private void addPrograms() {
        final List<String> paths = this.chooseFile(DocumentsMessages.PROGRAM_PROMPT, null, 2);
        if (paths.size() > 0) {
            Job job;
            this.importingJob = job = new Job(DocumentsMessages.IMAGES_IMPORTING_JOB){
                final @NonNull Display display;
                {
                    super($anonymous0);
                    this.display = (Display)NullChecking.neverNull((Object)PlatformUI.getWorkbench().getDisplay());
                }

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)paths.size());
                    for (String path : paths) {
                        if (subMonitor.isCanceled()) break;
                        subMonitor.setTaskName(path);
                        File file = new File(path);
                        try {
                            ElfImage image = ImagesOptionsPanel.this.mViewModel.importELFImage(file);
                            image.processFile();
                            this.display.syncExec(() -> {
                                if (!ImagesOptionsPanel.this.addData(image, true)) {
                                    subMonitor.setCanceled(true);
                                    subMonitor.done();
                                }
                            });
                        }
                        catch (CodecException | NativeException | IOException | InterruptedException exception) {
                            Error.show(exception.getMessage());
                        }
                        subMonitor.worked(1);
                    }
                    if (subMonitor.isCanceled()) {
                        this.display.syncExec(() -> {
                            ImagesOptionsPanel.this.importingJob = null;
                        });
                        return Status.CANCEL_STATUS;
                    }
                    this.display.syncExec(() -> {
                        ImagesOptionsPanel.this.table.setFocus();
                        ImagesOptionsPanel.this.repackColumns();
                        ImagesOptionsPanel.this.importingJob = null;
                        ImagesOptionsPanel.this.adjustState();
                        ImagesOptionsPanel.this.mViewModel.markDirty();
                        ImagesOptionsPanel.this.updateSettings();
                    });
                    return Status.OK_STATUS;
                }
            };
            this.adjustState();
            this.mViewModel.markDirty();
            job.schedule();
        }
    }

    private void addSeparateDebugImage() {
        @NonNull ElfImage selectedElfImage = this.getSelectedImges().iterator().next();
        @Nullable File separateDebugFile = selectedElfImage.getSeparateDebugFile();
        if (separateDebugFile != null) {
            @NonNull String imageName = separateDebugFile.getName();
            List<String> paths = this.chooseFile(DocumentsMessages.PROGRAM_PROMPT, new String[]{imageName, selectedElfImage.getName()}, 0);
            if (paths.size() > 0) {
                File file = new File(paths.get(0));
                try {
                    this.mViewModel.appendSeparateDebugFile(selectedElfImage, file);
                    this.updateTableItem(selectedElfImage);
                }
                catch (CodecException | NativeException | IOException | InterruptedException exception) {
                    Error.show(exception.getMessage());
                }
                this.mViewModel.markDirty();
                this.table.setFocus();
            }
        }
    }

    private void adjustState() {
        this.toolBar.setEnabled(this.importingJob == null);
        this.mAddProgramButton.setEnabled(true);
        Set<@NonNull ElfImage> selectedImages = this.getSelectedImges();
        boolean isSomethingSelected = !selectedImages.isEmpty();
        boolean isOneItemSelected = selectedImages.size() == 1;
        this.mRemoveSelectedButton.setEnabled(isSomethingSelected);
        if (isOneItemSelected) {
            @NonNull ElfImage selectedElfImage = this.getSelectedImges().iterator().next();
            this.mAddSeparateDebugImageButton.setEnabled(selectedElfImage.getSeparateDebugFile() != null);
        } else {
            this.mAddSeparateDebugImageButton.setEnabled(false);
        }
        this.mAddProgramButton.setForeground(this.mAddProgramButton.getParent().getForeground());
        if (this.mRemoveSelectedButton.isEnabled()) {
            this.mRemoveSelectedButton.setForeground(this.mRemoveSelectedButton.getParent().getForeground());
        } else {
            this.mRemoveSelectedButton.setForeground(Colors.getDarkGray());
        }
        if (this.mAddSeparateDebugImageButton.isEnabled()) {
            this.mAddSeparateDebugImageButton.setForeground(this.mAddSeparateDebugImageButton.getParent().getForeground());
        } else {
            this.mAddSeparateDebugImageButton.setForeground(Colors.getDarkGray());
        }
        this.mCheckAllButton.setEnabled(true);
        this.mUncheckAllButton.setEnabled(true);
    }

    private List<String> chooseFile(String prompt, @NonNull String @Nullable [] nameFilter, int style) {
        ArrayList<String> results = new ArrayList<String>();
        FileDialog dialog = new FileDialog(this.getShell(), 0x11000 | style);
        if (nameFilter != null) {
            dialog.setFilterExtensions(nameFilter);
        }
        dialog.setText(prompt);
        dialog.setFilterPath(this.mViewModel.getLastFilterPathStore().getLastFilterPath().getAbsolutePath());
        if (dialog.open() != null) {
            String lastPath = dialog.getFilterPath();
            this.mViewModel.getLastFilterPathStore().setLastFilterPath(new File(lastPath));
            ArrayList<String> badPaths = new ArrayList<String>();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String pathForPlatform = FilePath.getPathForPlatform((String)FilePath.getFullPath((String)lastPath, (String)path));
                ImagesOptionsPanel.addPathForPlatform(pathForPlatform, results, badPaths);
                ++n2;
            }
            ImagesOptionsPanel.reportAnyErrors(badPaths);
        }
        return results;
    }

    private void repackColumns() {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void selectAll(boolean checked) {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(checked);
            ++n2;
        }
        this.updateSettings();
    }

    private void updateItem(ElfImage image, TableItem item) {
        item.setText(Column.COLUMN_1_NAME.ordinal(), image.getName());
        item.setImage(Column.COLUMN_1_NAME.ordinal(), StreamlinePlugin.getImage("ProgramFile.png"));
        ElfImage.Availability code = image.getExecSectionStatus();
        this.updateItemColumn(Column.COLUMN_2_CODE, item, code);
        ElfImage.Availability symbols = image.getSymbolsStatus();
        this.updateItemColumn(Column.COLUMN_3_SYMBOLS, item, symbols);
        ElfImage.Availability debugInfo = image.getDebugInfoStatus();
        this.updateItemColumn(Column.COLUMN_4_DEBUG_INFO, item, debugInfo);
        ElfImage.Availability debugFrames = image.getDebugFrameStatus();
        this.updateItemColumn(Column.COLUMN_5_DEBUG_CFI, item, debugFrames);
        ElfImage.Availability execStatus = image.getExecSectionStatus();
        @NonNull String remarks = image.getDebugInfoStatus() == ElfImage.Availability.SEPARATE_FILE_REQUIRED ? DocumentsMessages.IMAGES_SEPARATE_DEBUG_FILES : (execStatus == ElfImage.Availability.NOT_AVAILABLE ? DocumentsMessages.IMAGES_NO_TEXT_SECTION : "");
        item.setText(Column.COLUMN_6_REMARKS.ordinal(), remarks);
    }

    private void updateItemColumn(Column column, TableItem item, ElfImage.Availability symbols) {
        item.setImage(column.ordinal(), statusImages.get((Object)symbols));
    }

    private void updateTableItem(ElfImage selectedElfImage) {
        int[] nArray = this.table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            @NonNull TableItem item = (TableItem)NullChecking.neverNull((Object)this.table.getItem(index));
            @NonNull ElfImage image = (ElfImage)NullChecking.neverNull((Object)((ElfImage)item.getData()));
            if (image == selectedElfImage) {
                this.updateItem(image, item);
            }
            ++n2;
        }
    }

    private static enum Column {
        COLUMN_0_USE(DocumentsMessages.IMAGE_COLUMN_USE),
        COLUMN_1_NAME(DocumentsMessages.IMAGE_COLUMN_NAME),
        COLUMN_2_CODE(DocumentsMessages.IMAGE_COLUMN_CODE),
        COLUMN_3_SYMBOLS(DocumentsMessages.IMAGE_COLUMN_SYMBOLS),
        COLUMN_4_DEBUG_INFO(DocumentsMessages.IMAGE_COLUMN_DEBUG_INFO),
        COLUMN_5_DEBUG_CFI(DocumentsMessages.IMAGE_COLUMN_DEBUG_CFI),
        COLUMN_6_REMARKS(DocumentsMessages.IMAGE_COLUMN_REMARKS);

        private final @NonNull String title;

        private Column(String title) {
            this.title = title;
        }

        public @NonNull String getTitle() {
            return this.title;
        }
    }

    public static final class DefaultViewModel
    implements IImagesOptionsPanelViewModel {
        private static final @NonNull SimpleLastFilterPathStore LAST_PATH_STORE = new SimpleLastFilterPathStore();
        private final @NonNull IElfImageStore imagesStore;
        private final @NonNull IDirtyFlag mDirtyFlag;
        private final @NonNull IAnalysisInputSettings mSettings;

        public DefaultViewModel(@NonNull IElfImageStore imagesStore, @NonNull IAnalysisInputSettings settings, @NonNull IDirtyFlag dirtyFlag) {
            this.imagesStore = imagesStore;
            this.mSettings = settings;
            this.mDirtyFlag = dirtyFlag;
        }

        @Override
        public void appendSeparateDebugFile(@NonNull ElfImage selectedElfImage, @NonNull File file) throws IOException, InterruptedException, CodecException {
            this.imagesStore.appendSeparateDebugFile(selectedElfImage, file);
        }

        @Override
        public @NonNull Collection<@NonNull ElfImage> getAvailableELFImages() {
            return this.imagesStore.getAvailableImages();
        }

        @Override
        public @NonNull ILastFilterPathStore getLastFilterPathStore() {
            return LAST_PATH_STORE;
        }

        @Override
        public @NonNull ElfImage importELFImage(@NonNull File file) throws IOException, InterruptedException {
            return this.imagesStore.importImage(file);
        }

        @Override
        public boolean isELFImageSelectedInSession(ElfImage image) {
            for (SessionImage sessionImage : this.mSettings.getImages()) {
                if (!sessionImage.getImageName().equals(image.getFile().getName())) continue;
                return sessionImage.loadSymbols();
            }
            return false;
        }

        @Override
        public void markDirty() {
            this.mDirtyFlag.markDirty();
        }

        @Override
        public void removeELFImage(@NonNull ElfImage image) {
            this.imagesStore.removeImage(image);
        }

        @Override
        public void setImagesSelectedInSession(@NonNull Set<@NonNull ElfImage> selectedImages) {
            this.mSettings.getImages().clear();
            for (ElfImage elfImage : this.imagesStore.getAvailableImages()) {
                boolean selected = selectedImages.stream().anyMatch(s -> s.getFile().equals(elfImage.getFile()));
                @NonNull SessionImage image = new SessionImage(elfImage.getName(), selected);
                this.mSettings.getImages().add(image);
            }
        }
    }

    public static interface IImagesOptionsPanelViewModel {
        public void appendSeparateDebugFile(@NonNull ElfImage var1, @NonNull File var2) throws IOException, InterruptedException, CodecException;

        public @NonNull Collection<@NonNull ElfImage> getAvailableELFImages();

        public @NonNull ILastFilterPathStore getLastFilterPathStore();

        public @NonNull ElfImage importELFImage(@NonNull File var1) throws IOException, InterruptedException;

        public boolean isELFImageSelectedInSession(@NonNull ElfImage var1);

        public void markDirty();

        public void removeELFImage(@NonNull ElfImage var1);

        public void setImagesSelectedInSession(@NonNull Set<@NonNull ElfImage> var1);
    }
}

