/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.IButtonPathHandler;
import com.arm.streamline.databrowser.ISessionOwner;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.model.session.EnergyCaptureChannel;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import com.arm.streamline.model.session.EnergyCaptureType;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.utility.text.VariableResolver;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.TextField;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class EnergyCaptureOptionsPanel
extends Composite
implements SelectionListener,
IButtonPathHandler {
    private ISessionOwner mOwner;
    private BorderedComposite mGroup;
    private Combo mTypeCombo;
    private TextField mDevicePath;
    private TextField mPortField;
    private TextField mCommandPath;
    private TextField[] mResistance = new TextField[40];
    private Button[] mEnergyEnabled = new Button[40];
    private Button[] mPowerEnabled = new Button[40];
    private Button[] mVoltageEnabled = new Button[40];
    private Button[] mCurrentEnabled = new Button[40];
    private boolean mSyncAllowed = true;
    private final boolean mHasLicense;
    private final @NonNull Collection<@NonNull Control> mOtherControls = new ArrayList<Control>();

    private static Composite createWrapper(Composite parent, int columns) {
        Composite wrapper = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)wrapper);
        GridLayoutFactory.fillDefaults().numColumns(columns).spacing(5, 2).applyTo(wrapper);
        return wrapper;
    }

    public EnergyCaptureOptionsPanel(Composite parent, ISessionOwner owner, boolean hasLicense) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.mOwner = owner;
        this.mHasLicense = hasLicense;
        this.mGroup = new BorderedComposite(this, DocumentsMessages.ENERGY_CAPTURE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mGroup);
        GridLayoutFactory.fillDefaults().margins(5, 2).extendedMargins(0, 0, 0, 2).spacing(5, 2).applyTo((Composite)this.mGroup);
        Composite wrapperDevice = EnergyCaptureOptionsPanel.createWrapper(this.mGroup, 5);
        this.mTypeCombo = SWTUtils.createCombo(wrapperDevice, "", (Object[])EnergyCaptureType.values(), this);
        this.mTypeCombo.setEnabled(this.mHasLicense);
        this.mOtherControls.add((Control)SWTUtils.createLabel(wrapperDevice, DocumentsMessages.DEVICE_TITLE, DocumentsMessages.DEVICE_TOOLTIP, 10));
        this.mDevicePath = SWTUtils.createTextField(wrapperDevice, DocumentsMessages.DEVICE_TOOLTIP, DocumentsMessages.AUTO_DETECT);
        this.mDevicePath.addFieldModifiedListener(field -> {
            if (this.mSyncAllowed) {
                this.mOwner.getSession().getEnergyCaptureSettings().setDevicePath(field.getText());
                this.mOwner.markDirty();
            }
        });
        this.mOtherControls.add((Control)SWTUtils.createLabel(wrapperDevice, DocumentsMessages.PORT_TITLE, DocumentsMessages.PORT_TOOLTIP, 10));
        this.mPortField = SWTUtils.createTextField(wrapperDevice, DocumentsMessages.PORT_TOOLTIP, Integer.toString(8081));
        this.mPortField.addFieldModifiedListener(field -> {
            if (this.mSyncAllowed) {
                this.mOwner.getSession().getEnergyCaptureSettings().setPort(NumberUtils.getLocalizedInteger((String)field.getText().trim(), (int)8081));
                this.mOwner.markDirty();
            }
        });
        Composite wrapperToolPath = EnergyCaptureOptionsPanel.createWrapper(this.mGroup, 2);
        this.mOtherControls.add((Control)SWTUtils.createLabel(wrapperToolPath, DocumentsMessages.ENERGY_CAPTURE_TOOL_TITLE, DocumentsMessages.ENERGY_CAPTURE_TOOL_TOOLTIP, 0));
        this.createCommandPathField(wrapperToolPath);
        ScrolledComposite scroller = new ScrolledComposite((Composite)this.mGroup, 2560);
        Composite wrapperChannels = EnergyCaptureOptionsPanel.createWrapper((Composite)scroller, 8);
        GridLayout gridLayout = (GridLayout)wrapperChannels.getLayout();
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        ControlHacks.setBackground((Control)wrapperChannels, Colors.lighten(wrapperChannels.getBackground(), 20));
        scroller.setContent((Control)wrapperChannels);
        int i = 0;
        while (i < 40) {
            this.mOtherControls.add((Control)SWTUtils.createLabel(wrapperChannels, MessageFormat.format(DocumentsMessages.CHANNEL_TITLE, i), "", 0));
            this.mEnergyEnabled[i] = SWTUtils.createCheckbox(wrapperChannels, DocumentsMessages.ENERGY, DocumentsMessages.ENERGY_TOOLTIP, this);
            this.mPowerEnabled[i] = SWTUtils.createCheckbox(wrapperChannels, DocumentsMessages.POWER, DocumentsMessages.POWER_TOOLTIP, this);
            this.mVoltageEnabled[i] = SWTUtils.createCheckbox(wrapperChannels, DocumentsMessages.VOLTAGE, DocumentsMessages.VOLTAGE_TOOLTIP, this);
            this.mCurrentEnabled[i] = SWTUtils.createCheckbox(wrapperChannels, DocumentsMessages.CURRENT, DocumentsMessages.CURRENT_TOOLTIP, this);
            this.mOtherControls.add((Control)SWTUtils.createLabel(wrapperChannels, DocumentsMessages.RESISTANCE, DocumentsMessages.RESISTANCE_TOOLTIP, 10));
            this.mResistance[i] = SWTUtils.createTextField(wrapperChannels, DocumentsMessages.RESISTANCE_TOOLTIP, Integer.toString(20));
            this.mResistance[i].setData(i);
            this.mResistance[i].addFieldModifiedListener(field -> {
                if (this.mSyncAllowed) {
                    int resistance = NumberUtils.getLocalizedInteger((String)field.getText(), (int)20);
                    if (resistance < 1) {
                        resistance = 20;
                    }
                    this.mOwner.getSession().getEnergyCaptureSettings().getChannel((Integer)field.getData()).setResistance(resistance);
                    this.mOwner.markDirty();
                }
            });
            this.mOtherControls.add((Control)SWTUtils.createLabel(wrapperChannels, DocumentsMessages.SCALE, DocumentsMessages.RESISTANCE_TOOLTIP, 0));
            ++i;
        }
        if (!hasLicense) {
            String tooltip = DocumentsMessages.NOT_SUPPORTED_WITH_CURRENT_LICENSE;
            this.mOtherControls.forEach(c -> c.setEnabled(false));
            Stream.of(new Composite[]{this.mGroup, wrapperDevice, wrapperToolPath, wrapperChannels, scroller}).forEach(c -> c.setToolTipText(tooltip));
            Stream.concat(Stream.of(this.mCommandPath, this.mDevicePath, this.mPortField), Stream.of(this.mResistance)).forEach(r -> r.setCompositeTipText(tooltip));
        }
        wrapperChannels.pack();
        int lineHeight = this.mResistance[0].getSize().y + 2;
        int scrollHeight = 3 * lineHeight + 2;
        scroller.setShowFocusedControl(true);
        scroller.setExpandHorizontal(true);
        scroller.getVerticalBar().setIncrement(lineHeight);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, scrollHeight).minSize(-1, scrollHeight).align(4, 0x1000000).applyTo((Control)scroller);
    }

    public String checkValidity() {
        File file;
        String path;
        if (!(this.mOwner.getSession().getEnergyCaptureSettings().getType() == EnergyCaptureType.NONE || (path = VariableResolver.resolve(this.mCommandPath.getText())).isEmpty() || (file = new File(path)).isFile() && file.canExecute())) {
            return DocumentsMessages.BAD_CMD_PATH;
        }
        return null;
    }

    @Override
    public String getButtonPath(Button button) {
        return VariableResolver.resolve(this.mCommandPath.getText().trim());
    }

    public void initializeContent() {
        boolean allowSync = this.mSyncAllowed;
        this.mSyncAllowed = false;
        try {
            this.adjustControls();
        }
        finally {
            this.mSyncAllowed = allowSync;
        }
    }

    @Override
    public void setButtonPath(Button button, String path) {
        this.mCommandPath.setText(VariableResolver.reverseResolve(FilePath.getPathForPlatform((String)path.trim())));
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.mSyncAllowed) {
            EnergyCaptureSettings settings = this.mOwner.getSession().getEnergyCaptureSettings();
            if (event.widget == this.mTypeCombo) {
                settings.setType(EnergyCaptureType.values()[this.mTypeCombo.getSelectionIndex()]);
                this.adjustControls();
            } else {
                int i = 0;
                while (i < 40) {
                    if (event.widget == this.mEnergyEnabled[i]) {
                        settings.getChannel(i).setCollectEnergy(this.mEnergyEnabled[i].getSelection());
                        break;
                    }
                    if (event.widget == this.mPowerEnabled[i]) {
                        settings.getChannel(i).setCollectPower(this.mPowerEnabled[i].getSelection());
                        break;
                    }
                    if (event.widget == this.mVoltageEnabled[i]) {
                        settings.getChannel(i).setCollectVoltage(this.mVoltageEnabled[i].getSelection());
                        break;
                    }
                    if (event.widget == this.mCurrentEnabled[i]) {
                        settings.getChannel(i).setCollectCurrent(this.mCurrentEnabled[i].getSelection());
                        break;
                    }
                    ++i;
                }
            }
            this.mOwner.markDirty();
        }
    }

    private void adjustControls() {
        EnergyCaptureSettings settings = this.mOwner.getSession().getEnergyCaptureSettings();
        EnergyCaptureType type = settings.getType();
        this.mTypeCombo.select(type.ordinal());
        boolean enabled = this.mHasLicense && type != EnergyCaptureType.NONE;
        this.mCommandPath.setText(settings.getCommandPath());
        this.mCommandPath.setEnabled(enabled);
        this.mDevicePath.setText(settings.getDevicePath());
        this.mDevicePath.setEnabled(enabled);
        this.mPortField.setText(settings.getPort() != 8081 ? Integer.toString(settings.getPort()) : "");
        this.mPortField.setEnabled(enabled);
        int i = 0;
        while (i < 40) {
            EnergyCaptureChannel channel = settings.getChannel(i);
            this.mEnergyEnabled[i].setSelection(channel.isCollectEnergy());
            this.mEnergyEnabled[i].setEnabled(enabled);
            this.mPowerEnabled[i].setSelection(channel.isCollectPower());
            this.mPowerEnabled[i].setEnabled(enabled);
            this.mVoltageEnabled[i].setSelection(channel.isCollectVoltage());
            this.mVoltageEnabled[i].setEnabled(enabled);
            this.mCurrentEnabled[i].setSelection(channel.isCollectCurrent());
            this.mCurrentEnabled[i].setEnabled(enabled);
            int resistance = channel.getResistance();
            this.mResistance[i].setText(resistance == 20 ? "" : Integer.toString(resistance));
            this.mResistance[i].setEnabled(enabled);
            ++i;
        }
    }

    private void createCommandPathField(Composite parent) {
        this.mCommandPath = new TextField(parent, StreamlinePlugin.getImage("Browse.png"));
        this.mCommandPath.setWatermark(EnergyCaptureSettings.getDefaultCommandPath());
        this.mCommandPath.setToolTipText(DocumentsMessages.ENERGY_CAPTURE_TOOL_TOOLTIP);
        this.mCommandPath.setImageToolTipText(DocumentsMessages.BROWSE_ENERGY_CAPTURE_TOOL_TOOLTIP);
        this.mCommandPath.addFieldModifiedListener(field -> {
            if (this.mSyncAllowed) {
                this.mOwner.getSession().getEnergyCaptureSettings().setCommandPath(field.getText());
                this.mOwner.markDirty();
            }
        });
        this.mCommandPath.addClickListener(textField -> {
            FileDialog dialog = new FileDialog(this.getShell(), 69632);
            String path = VariableResolver.resolve(this.mCommandPath.getText().trim());
            if (path != null && path.length() > 0) {
                dialog.setFilterPath(FilePath.getParent((String)path));
                dialog.setFileName(FilePath.getLeafName((String)path));
            }
            dialog.setText(DocumentsMessages.BROWSE_ENERGY_CAPTURE_TOOL_TOOLTIP);
            path = dialog.open();
            if (path != null) {
                this.mCommandPath.setText(VariableResolver.reverseResolve(FilePath.getPathForPlatform((String)path.trim())));
            }
        });
        GridDataFactory.swtDefaults().minSize(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.mCommandPath);
    }
}

