/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DuplicateJob
extends Job {
    private File mSrc;
    private File mDst;
    private IProgressMonitor mMonitor;
    private int mReported;
    private long mLastReport;

    private static int count(File path) {
        File[] children;
        int count = 1;
        if (path.isDirectory() && (children = path.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                count += DuplicateJob.count(child);
                ++n2;
            }
        }
        return count;
    }

    public DuplicateJob(File src, File dst) {
        super(MessageFormat.format(DocumentsMessages.DUPLICATING_TITLE, src.getName()));
        this.setUser(true);
        this.setSystem(false);
        this.mSrc = src;
        this.mDst = dst;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.mMonitor = monitor;
        int count = 1 + DuplicateJob.count(this.mSrc);
        this.mMonitor.beginTask(MessageFormat.format(DocumentsMessages.COPYING, NumberUtils.format((long)count)), count);
        File tmp = new File(this.mDst.getParentFile(), this.mDst.getName() + ".tmp");
        try {
            try {
                this.copyFileTree(this.mSrc, tmp);
                if (this.mReported > 0) {
                    this.mMonitor.worked(this.mReported);
                }
                this.mMonitor.subTask(DocumentsMessages.FINISHING);
                tmp.renameTo(this.mDst);
                this.mMonitor.worked(1);
            }
            catch (Exception exception) {
                try {
                    StreamlineFileUtils.deleteAsynchronously(tmp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Status status = new Status(4, "com.arm.streamline", DocumentsMessages.ERROR_UNABLE_TO_DUPLICATE, (Throwable)exception);
                this.mMonitor.done();
                return status;
            }
        }
        finally {
            this.mMonitor.done();
        }
        DocumentScanner.INSTANCE.update(true);
        return Status.OK_STATUS;
    }

    private void copyFileTree(File src, File dst) throws IOException, InterruptedException {
        this.updateProgress(src.getAbsolutePath());
        if (src.isDirectory()) {
            if (!dst.isDirectory() && !dst.mkdirs()) {
                throw new IOException(String.format(DocumentsMessages.CANNOT_CREATE_DIRECTORY, dst));
            }
            File[] files = src.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.copyFileTree(file, new File(dst, file.getName()));
                    ++n2;
                }
            }
        } else {
            CommonFileUtils.copyFile((File)src, (File)dst);
        }
        ++this.mReported;
    }

    private void updateProgress(String msg) {
        long now = System.currentTimeMillis();
        if (now - this.mLastReport > 200L) {
            if (this.mReported > 0) {
                this.mMonitor.worked(this.mReported);
                this.mReported = 0;
            }
            this.mMonitor.subTask(msg);
            this.mLastReport = now;
        }
    }
}

