/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.actions.ShowPreferencesAction;
import com.arm.streamline.application.preferences.DataLocationsPage;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.AnalyzeDialog;
import com.arm.streamline.databrowser.BarmanTraceDumpFilesDialog;
import com.arm.streamline.databrowser.DeleteJob;
import com.arm.streamline.databrowser.DocumentPanel;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsToolbar;
import com.arm.streamline.databrowser.DuplicateJob;
import com.arm.streamline.databrowser.ElfImageStatus;
import com.arm.streamline.databrowser.ExportCaptureJob;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.IDocumentScanListener;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.model.JitDumpsPathsFileOrDirectoryListPanelModel;
import com.arm.streamline.databrowser.trace_dump_import.TraceDumpImportClassification;
import com.arm.streamline.databrowser.trace_dump_import.wizard.TraceDumpImportWizardDialog;
import com.arm.streamline.dataimport.IFileTypeChecker;
import com.arm.streamline.dataimport.ImportFileType;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.dataimport.OutputPathProvider;
import com.arm.streamline.editortabs.AnalysisInput;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.live.LiveEditor;
import com.arm.streamline.model.live.CaptureInput;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.utility.io.Images;
import com.arm.streamline.utility.ui.SimpleLastFilterPathStore;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.TextField;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.selection.IStdSelectionOwner;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;

public class DocumentsView
extends ViewPart
implements IStdSelectionOwner,
FocusListener,
KeyListener,
MouseListener,
ISelectionProvider,
ICommandTarget,
IDocumentScanListener,
IInputValidator,
IPropertyChangeListener {
    public static final String ID = "streamline.view.LauncherView";
    private static final String[] ARCHIVE_DESCRIPTIONS = new String[]{DocumentsMessages.ZIP_FILES};
    private static final String[] ARCHIVE_EXTENSIONS = new String[]{"*.zip"};
    private static final String CMD_ANALYZE = "analyze";
    private static final String CMD_CLEAN_DB_AND_REPORT = "clear_db_and_report";
    private static final String CMD_COLLAPSE_ALL = "collapse";
    private static final String CMD_COPY = ActionFactory.COPY.getId();
    private static final String CMD_DELETE = ActionFactory.DELETE.getId();
    private static final String CMD_DUPLICATE = "duplicate";
    private static final String CMD_EXPAND_ALL = "expand";
    private static final String CMD_EXPORT = "export";
    private static final String CMD_IMPORT = "import";
    private static final String CMD_LOCATIONS = "locations";
    private static final String CMD_MOVE = "move";
    private static final String CMD_OPEN = "org.eclipse.ui.navigator.Open";
    private static final String CMD_REFRESH = ActionFactory.REFRESH.getId();
    private static final String CMD_RENAME = ActionFactory.RENAME.getId();
    private static final String CMD_SELECT_ALL = ActionFactory.SELECT_ALL.getId();
    private static String DEFAULT_PATH = null;
    protected ScrolledComposite mScroller;
    private CommandAction mAnalyzeAction;
    private CommandAction mCleanDbReportAction;
    private CommandAction mCollapseAllAction;
    private CommandAction mCopyAction;
    private CommandAction mDeleteAction;
    private Composite mDocumentArea;
    private CommandAction mDuplicateAction;
    private CommandAction mExpandAllAction;
    private CommandAction mExportAction;
    private List<DocumentPanel> mFilteredDocumentPanels = new ArrayList<DocumentPanel>();
    private boolean mFirstTimeFocus = true;
    private boolean mHasBeenDisposed;
    private CommandAction mImportAction;
    private Set<ISelectionChangedListener> mListeners = new HashSet<ISelectionChangedListener>();
    private CommandAction mLocationsAction;
    private CommandAction mMoveAction;
    private CommandAction mOpenAction;
    private CommandAction mRefreshAction;
    private CommandAction mRenameAction;
    private CommandAction mSelectAllAction;
    private StdSelection mSelection = new StdSelection(this);
    private int mSelectOnMouseUp = -1;
    private DocumentsToolbar mToolbar;
    private boolean scannerIsBusy;

    public static void analyze(@NonNull ICapture capture) {
        if (capture.isValid()) {
            @NonNull File captureDir = capture.getApcDirectory();
            try {
                @NonNull IAnalysisInputSettings settings = capture.getAnalisysSettings();
                @NonNull List<@NonNull ElfImageStatus> previousElfImages = ElfImageStatus.getElfImagesFromSettings(settings);
                ICapture store = capture;
                @NonNull JitDumpsPathsFileOrDirectoryListPanelModel jitdumpFilesPanelModel = new JitDumpsPathsFileOrDirectoryListPanelModel(captureDir, settings.getJitDumpFilePaths());
                AnalyzeDialog dialog = new AnalyzeDialog(store, settings, jitdumpFilesPanelModel, (String)NullChecking.neverNull((Object)capture.toString()), capture.isJitDumpProfilingSupported());
                dialog.create();
                if (dialog.open() != 1) {
                    settings.setJitDumpFilePaths(jitdumpFilesPanelModel.getPathsWithEnabledFlag());
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.closeEditors(page.findEditors((IEditorInput)new AnalysisInput(captureDir), "com.arm.streamline.editor.apd", 3), false);
                    Task.callOnAnotherThread(() -> {
                        try {
                            settings.save();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        @NonNull List<@NonNull ElfImageStatus> currentElfImages = ElfImageStatus.getElfImagesFromSettings(settings);
                        @NonNull boolean elfImagesHaveChanged = !previousElfImages.equals(currentElfImages);
                        boolean elfImagesDifferInDbDirectory = ElfImageStatus.elfImagesInDbDifferFromImagesDirectory(capture);
                        if (elfImagesHaveChanged || elfImagesDifferInDbDirectory) {
                            capture.cleanDbAndReport();
                        }
                        capture.analyze(settings, new SessionProcessor(), capture, DocumentScanner.INSTANCE, (IErrorHandler)CommonPlugin.errorHandler, true);
                    });
                }
            }
            catch (Exception exception) {
                Error.show(exception);
            }
        }
    }

    public static void doRefresh() {
        DocumentScanner.INSTANCE.update(true);
    }

    public static final void makeVisible() {
        if (PlatformUI.isWorkbenchRunning()) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(() -> {
                    DocumentsView documentsView = DocumentsView.showView();
                });
            } else {
                DocumentsView.showView();
            }
        }
    }

    public static void open(@NonNull ICapture capture) {
        block12: {
            try {
                if (capture.isValid()) {
                    if (capture.hasReport(true)) {
                        try {
                            AnalysisInput input = new AnalysisInput(capture.getApcDirectory());
                            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            if (activePage == null) break block12;
                            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                            int n = iEditorReferenceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IEditorReference wbPage = iEditorReferenceArray[n2];
                                IEditorInput editorInput = wbPage.getEditorInput();
                                if (editorInput instanceof CaptureInput) {
                                    @NonNull String liveOutputCannonicalPath = new File(((CaptureInput)editorInput).getTargetLauncher().getOutputPath()).getCanonicalPath();
                                    if (capture.getApcDirectory().getCanonicalPath().contentEquals(liveOutputCannonicalPath)) {
                                        activePage.closeEditor(wbPage.getEditor(false), false);
                                        break;
                                    }
                                }
                                ++n2;
                            }
                            IEditorPart activeEditor = activePage.getActiveEditor();
                            boolean activate = !(activeEditor instanceof LiveEditor);
                            activePage.openEditor((IEditorInput)input, "com.arm.streamline.editor.apd", activate, 3);
                            if (!activate) {
                                activePage.bringToTop((IWorkbenchPart)activeEditor);
                            }
                            break block12;
                        }
                        catch (PartInitException exception) {
                            throw exception;
                        }
                        catch (Exception exception) {
                            break block12;
                        }
                    }
                    DocumentsView.analyze(capture);
                    break block12;
                }
                Object errorMessage = DocumentsMessages.ERROR_INVALID_CAPTURE;
                if (capture.getInvalidReason() != null) {
                    errorMessage = (String)errorMessage + capture.getInvalidReason();
                }
                Error.show(String.format((String)errorMessage, capture.getApcDirectory().getName()));
            }
            catch (Exception exception) {
                Error.show(exception);
            }
        }
    }

    public static final @Nullable DocumentsView showView() {
        try {
            IWorkbenchPage page;
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
                return (DocumentsView)page.showView(ID, null, 2);
            }
        }
        catch (Exception exception) {
            CommonPlugin.error((String)"Unable to display view: streamline.view.LauncherView", (Throwable)exception);
        }
        return null;
    }

    private static void doLocations() {
        if (!WidgetUtils.isModalDialogShowing()) {
            ShowPreferencesAction action = new ShowPreferencesAction(DataLocationsPage.ID);
            action.run();
        }
    }

    private static @NonNull String getDefaultPath() {
        if (DEFAULT_PATH == null) {
            File dir = new File(System.getProperty("user.home", ".")).getAbsoluteFile();
            File desktop = new File(dir, "Desktop");
            if (desktop.isDirectory()) {
                dir = desktop;
            }
            DEFAULT_PATH = FilePath.getFullPath((File)dir);
        }
        return (String)NullChecking.neverNull((Object)DEFAULT_PATH);
    }

    private static void setDefaultPath(String path) {
        DEFAULT_PATH = FilePath.getParent((String)FilePath.getFullPath(null, (String)path));
    }

    static @Nullable ImportJobFactory.BarmanXmlAndAgentImage getBarmanXmlAndAgentImage(Shell shell, boolean requireBarmanXml, boolean requireAgentImage) {
        BarmanTraceDumpFilesDialog dialog = new BarmanTraceDumpFilesDialog(shell, requireBarmanXml, DocumentsView.getDefaultPath());
        @Nullable ImportJobFactory.BarmanXmlAndAgentImage result = dialog.getResult();
        if (result != null) {
            DocumentsView.setDefaultPath(dialog.getLastPath());
        }
        return result;
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mListeners.add(listener);
    }

    public void adjustActions() {
        @NonNull List<@NonNull ICapture> selection = this.getSelectedDocuments();
        int selectionSize = selection.size();
        boolean hasPlaceholders = false;
        boolean hasUnreadable = false;
        boolean atLeastOneHasBeenAnalysed = false;
        for (ICapture doc : selection) {
            boolean isPlaceholder;
            boolean bl = isPlaceholder = doc instanceof ILiveCapture && ((ILiveCapture)doc).isPlaceholder();
            if (isPlaceholder) {
                hasPlaceholders = true;
                if (hasUnreadable) break;
            }
            if (!doc.isValid()) {
                hasUnreadable = true;
                if (hasPlaceholders) break;
            }
            if (!doc.hasDb() && !doc.hasReport(false)) continue;
            atLeastOneHasBeenAnalysed = true;
        }
        boolean enabled = selectionSize > 0 && !hasPlaceholders;
        boolean enabledAndNoInvalid = enabled && !hasUnreadable;
        boolean oneEnabled = enabledAndNoInvalid && selectionSize == 1;
        this.mOpenAction.setEnabled(enabledAndNoInvalid);
        this.mDuplicateAction.setEnabled(oneEnabled);
        this.mAnalyzeAction.setEnabled(enabledAndNoInvalid);
        this.mDeleteAction.setEnabled(enabled);
        this.mCleanDbReportAction.setEnabled(atLeastOneHasBeenAnalysed);
        this.mRenameAction.setEnabled(oneEnabled);
        this.mRefreshAction.setEnabled(!this.scannerIsBusy);
        this.mMoveAction.setEnabled(oneEnabled);
        this.mLocationsAction.setEnabled(true);
        this.mSelectAllAction.setEnabled(true);
        this.mImportAction.setEnabled(true);
        this.mExportAction.setEnabled(enabled);
        this.mCopyAction.setEnabled(this.mToolbar.getFilterField().isFocused() || enabled);
        int count = this.getAllExpandedDocuments().size();
        this.mExpandAllAction.setEnabled(count != this.mDocumentArea.getChildren().length);
        this.mCollapseAllAction.setEnabled(count > 0);
    }

    public void createPartControl(Composite parent) {
        this.createActions();
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        this.mToolbar = new DocumentsToolbar(parent, this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mToolbar);
        this.mScroller = new ScrolledComposite(parent, 512);
        this.mScroller.setExpandHorizontal(true);
        this.mScroller.getVerticalBar().setIncrement(DocumentPanel.getTypicalHeight());
        ControlHacks.setBackground((Control)this.mScroller, Colors.getWhite());
        this.mDocumentArea = new Composite((Composite)this.mScroller, 0x20000000);
        this.mDocumentArea.addMouseListener((MouseListener)this);
        this.mDocumentArea.addKeyListener((KeyListener)this);
        this.mDocumentArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Composite composite = (Composite)event.getSource();
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    Rectangle bounds = child.getBounds();
                    if (bounds.width == 0 && bounds.height == 0) {
                        if (composite.isLayoutDeferred()) {
                            Composite deferred = composite;
                            while (deferred != null && !deferred.getLayoutDeferred()) {
                                deferred = deferred.getParent();
                            }
                            if (deferred != null) {
                                while (deferred.getLayoutDeferred()) {
                                    deferred.setLayoutDeferred(false);
                                }
                                composite.redraw();
                            }
                        } else {
                            composite.layout(true, true);
                            composite.redraw();
                        }
                        return;
                    }
                    ++n2;
                }
            }
        });
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.mDocumentArea);
        DropTarget dropTarget = new DropTarget((Control)this.mScroller, 19);
        final FileTransfer dndFileTransfer = FileTransfer.getInstance();
        dropTarget.setTransfer(new Transfer[]{dndFileTransfer});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if ((event.operations & 1) != 0) {
                    event.detail = 1;
                    event.feedback = 1;
                    TransferData[] transferDataArray = event.dataTypes;
                    int n = event.dataTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TransferData dataType = transferDataArray[n2];
                        if (dndFileTransfer.isSupportedType(dataType)) {
                            event.currentDataType = dataType;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    event.detail = 0;
                    event.feedback = 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if ((event.operations & 1) != 0) {
                    event.detail = 1;
                    event.feedback = 1;
                } else {
                    event.detail = 0;
                    event.feedback = 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (dndFileTransfer.isSupportedType(event.currentDataType)) {
                    if (event.data == null) {
                        CommonPlugin.errorHandler.reportError(new Throwable(ImportMessages.DND_FAILED));
                    } else {
                        Set<@NonNull File> files = Arrays.stream((String[])event.data).map(File::new).collect(Collectors.toSet());
                        DocumentsView.this.doImportDnDFileList(files);
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.mScroller.setContent((Control)this.mDocumentArea);
        this.createContextMenu((Control)this.mDocumentArea);
        this.hookGlobalActions();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mScroller);
        for (ICapture doc : DocumentScanner.INSTANCE.getDocuments()) {
            this.createDocumentPanel(doc, false);
        }
        this.mSelection.setSize(this.mDocumentArea.getChildren().length);
        this.mToolbar.getFilterField().addFocusListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        DocumentScanner.INSTANCE.addDocumentScanListener(this);
        this.documentListUpdated(DocumentScanner.INSTANCE.getDocuments(), new ArrayList<ICapture>());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.arm.streamline.documents");
        this.mScroller.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DocumentsView.this.mScroller.getVerticalBar().setPageIncrement(DocumentsView.this.mScroller.getClientArea().height);
            }
        });
        this.adjustActions();
    }

    public void dispose() {
        this.mHasBeenDisposed = true;
        DocumentScanner.INSTANCE.removeDocumentScanListener(this);
        StreamlinePlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public void documentListUpdated(List<ICapture> documents, List<ICapture> select) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            @NonNull Display display = workbench.getDisplay();
            display.asyncExec(() -> this.updateDocumentList(select));
        }
    }

    public int documentToIndex(ICapture doc) {
        Control[] children = this.mDocumentArea.getChildren();
        int i = 0;
        while (i < children.length) {
            if (doc.equals(((DocumentPanel)children[i]).getDocument())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void doImportCommand() {
        this.obeyCommand(this.mImportAction);
    }

    public void focusGained(FocusEvent event) {
        this.adjustActions();
    }

    public void focusLost(FocusEvent event) {
        this.adjustActions();
    }

    public Set<ICapture> getAllDocuments() {
        HashSet<ICapture> all = new HashSet<ICapture>();
        Control[] controlArray = this.mDocumentArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            all.add(((DocumentPanel)child).getDocument());
            ++n2;
        }
        return all;
    }

    public CommandAction getCollapseAllAction() {
        return this.mCollapseAllAction;
    }

    public CommandAction getDeleteAction() {
        return this.mDeleteAction;
    }

    public @Nullable DocumentPanel getDocumentPanelFor(ICapture document) {
        if (this.mDocumentArea != null && !this.mDocumentArea.isDisposed()) {
            Control[] controlArray = this.mDocumentArea.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                DocumentPanel docPanel = (DocumentPanel)child;
                ICapture doc = docPanel.getDocument();
                if (doc.equals(document)) {
                    return docPanel;
                }
                ++n2;
            }
            for (DocumentPanel panel : this.mFilteredDocumentPanels) {
                ICapture doc = panel.getDocument();
                if (!doc.equals(document)) continue;
                return panel;
            }
        }
        return null;
    }

    public CommandAction getExpandAllAction() {
        return this.mExpandAllAction;
    }

    public CommandAction getExportAction() {
        return this.mExportAction;
    }

    public CommandAction getImportAction() {
        return this.mImportAction;
    }

    public CommandAction getLocationsAction() {
        return this.mLocationsAction;
    }

    public CommandAction getRefreshAction() {
        return this.mRefreshAction;
    }

    @Override
    public ICapture getSelectableObjectAtIndex(int index) {
        Control[] children = this.mDocumentArea.getChildren();
        if (index >= 0 && index < children.length) {
            return ((DocumentPanel)children[index]).getDocument();
        }
        return null;
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.getSelectedDocuments());
    }

    public DocumentsToolbar getToolbar() {
        return this.mToolbar;
    }

    public @Nullable String isValid(@Nullable String inputText) {
        ICapture doc = this.getSelectedDocuments().get(0);
        File previousApcDir = doc.getApcDirectory();
        String revisedFilename = DocumentsView.ensureExtension(inputText, ".apc");
        String nameCheck = new FileRenameValidator().isValid(revisedFilename);
        if (nameCheck != null) {
            return nameCheck;
        }
        if (revisedFilename.equalsIgnoreCase(previousApcDir.getName())) {
            return null;
        }
        @NonNull File parent = (File)NullChecking.neverNull((Object)previousApcDir.getParentFile());
        if (parent.exists()) {
            String[] stringArray = (String[])NullChecking.neverNull((Object[])parent.list());
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                if (revisedFilename.equalsIgnoreCase(child)) {
                    return MessageFormat.format(DocumentsMessages.ERROR_EXISTS, previousApcDir.getName(), revisedFilename);
                }
                ++n2;
            }
            return null;
        }
        return MessageFormat.format(DocumentsMessages.ERROR_NOPARENT, parent);
    }

    private static String ensureExtension(@Nullable String newText, @NonNull String extension) {
        if (newText == null) {
            return extension;
        }
        if (!newText.toLowerCase().endsWith(extension)) {
            return newText + extension;
        }
        return newText;
    }

    public void keyPressed(KeyEvent event) {
        this.handleKeyDown(event);
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        this.mSelection.deselect();
    }

    public void mouseUp(MouseEvent event) {
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (CMD_OPEN.equals(command)) {
            this.doOpen();
        } else if (CMD_COPY.equals(command)) {
            this.doCopy();
        } else if (CMD_DUPLICATE.equals(command)) {
            this.doDuplicate();
        } else if (CMD_ANALYZE.equals(command)) {
            this.doAnalyze();
        } else if (CMD_DELETE.equals(command)) {
            this.doDelete();
        } else if (CMD_CLEAN_DB_AND_REPORT.equals(command)) {
            this.doCleanDbAndReportsFromSelectedCaptures();
        } else if (CMD_RENAME.equals(command)) {
            this.doRename();
        } else if (CMD_REFRESH.equals(command)) {
            DocumentsView.doRefresh();
        } else if (CMD_MOVE.equals(command)) {
            this.doMove();
        } else if (CMD_LOCATIONS.equals(command)) {
            DocumentsView.doLocations();
        } else if (CMD_SELECT_ALL.equals(command)) {
            this.doSelectAll();
        } else if (CMD_IMPORT.equals(command)) {
            this.doImport();
        } else if (CMD_EXPORT.equals(command)) {
            this.doExport();
        } else if (CMD_COLLAPSE_ALL.equals(command)) {
            this.setExpansion(false);
        } else if (CMD_EXPAND_ALL.equals(command)) {
            this.setExpansion(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("com.arm.streamline.theme_id".equals(event.getProperty())) {
            SafeUpdate.pack(this.mDocumentArea);
        }
    }

    @Override
    public void redrawDocuments() {
        SafeUpdate.redraw((Control)this.mDocumentArea);
    }

    @Override
    public void reLayout() {
        SafeUpdate.pack(this.mDocumentArea);
    }

    public synchronized void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void selectionAboutToChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionDidChange() {
        ISelectionChangedListener[] listeners;
        DocumentsView documentsView = this;
        synchronized (documentsView) {
            listeners = this.mListeners.toArray(new ISelectionChangedListener[this.mListeners.size()]);
        }
        if (listeners.length > 0) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            ISelectionChangedListener[] iSelectionChangedListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionChangedListener listener = iSelectionChangedListenerArray[n2];
                listener.selectionChanged(event);
                ++n2;
            }
        }
        SafeUpdate.redraw((Control)this.mDocumentArea);
        this.adjustActions();
    }

    public void setFocus() {
        if (this.mFirstTimeFocus) {
            this.mFirstTimeFocus = false;
        } else {
            this.mToolbar.setFocus();
        }
    }

    public void setSelection(ISelection selection) {
    }

    public void updateDocumentList(List<ICapture> select) {
        if (this.mDocumentArea != null && !this.mDocumentArea.isDisposed()) {
            Set<ICapture> previous = this.getAllDocuments();
            List<ICapture> current = select.isEmpty() ? this.getSelectedDocuments() : select;
            Set<ICapture> expanded = this.getAllExpandedDocuments();
            expanded.addAll(select);
            this.mDocumentArea.setRedraw(false);
            WidgetUtils.disposeAllChildren(this.mDocumentArea);
            ArrayList<ICapture> placeholders = new ArrayList<ICapture>();
            Pattern pattern = this.mToolbar.getFilterPattern();
            this.mFilteredDocumentPanels.clear();
            for (ICapture doc : DocumentScanner.INSTANCE.getDocuments()) {
                if (doc.isInProgress()) {
                    placeholders.add(doc);
                }
                DocumentPanel panel = this.createDocumentPanel(doc, expanded.contains(doc));
                if (pattern.matcher(FilePath.getLeafName((String)doc.getApcDirectory().getName(), (boolean)false)).find()) continue;
                this.mFilteredDocumentPanels.add(panel);
                panel.dispose();
            }
            boolean empty = placeholders.isEmpty();
            if (!empty && select.isEmpty()) {
                current.clear();
                for (ICapture capture : placeholders) {
                    current.add(capture);
                }
            }
            TIntArrayList list = new TIntArrayList();
            for (ICapture doc : current) {
                int pos = this.documentToIndex(doc);
                if (pos == -1) continue;
                list.add(pos);
            }
            Control[] children = this.mDocumentArea.getChildren();
            this.mSelection.setSize(children.length);
            int[] selectedIndexes = list.toArray();
            this.mSelection.select(selectedIndexes, false);
            this.mDocumentArea.setRedraw(true);
            this.mDocumentArea.setSize(this.mDocumentArea.computeSize(this.mScroller.getClientArea().width, -1, true));
            this.mDocumentArea.layout(true, true);
            this.mDocumentArea.redraw();
            if (selectedIndexes.length > 0) {
                int[] nArray = selectedIndexes;
                int n = selectedIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean isLiveCapturing;
                    int index = nArray[n2];
                    ICapture one = ((DocumentPanel)children[index]).getDocument();
                    boolean bl = isLiveCapturing = one instanceof ILiveCapture && ((ILiveCapture)one).isCapturing();
                    if (!select.isEmpty() || isLiveCapturing && !previous.contains(one)) {
                        this.keyScroll(index, false);
                        break;
                    }
                    ++n2;
                }
            }
            this.adjustActions();
            this.closeOrphanEditors();
            StreamlinePlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            StreamlinePlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected boolean closeEditors(List<ICapture> selection) {
        boolean closed = false;
        IWorkbenchPage page = this.getSite().getPage();
        for (ICapture doc : selection) {
            try {
                boolean retval;
                AnalysisInput analysisInput = new AnalysisInput(doc.getApcDirectory().toURI());
                IEditorReference[] refs = page.findEditors((IEditorInput)analysisInput, "com.arm.streamline.editor.apd", 3);
                if (refs.length <= 0 || !(retval = page.closeEditors(refs, false))) continue;
                closed = true;
            }
            catch (CoreException exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return closed;
    }

    protected void doImportDnDFileList(@NonNull Set<@NonNull File> paths) {
        try {
            @NonNull Map<@NonNull ImportJobFactory.ImportFileClassification, @NonNull Set<@NonNull File>> classifiedPaths = ImportJobFactory.ImportFileClassification.classifyImportTypes(IFileTypeChecker.DEFAULT, paths);
            Shell shell = this.getSite().getShell();
            ImportConfigurationSupplier barmanXmlFileSelector = new ImportConfigurationSupplier(shell);
            @NonNull IPreferences preferences = StreamlinePreferences.getApplicationPreferences();
            boolean importAsSynchronized = preferences.importItmAsSychronizedTrace();
            @NonNull List<@NonNull Job> jobs = ImportJobFactory.createJobsFromClassification(barmanXmlFileSelector, OutputPathProvider.getApcOutputPath(), importAsSynchronized, classifiedPaths);
            for (Job job : jobs) {
                job.schedule();
            }
        }
        catch (ImportJobFactory.ImportJobCreationException | IOException exception) {
            Error.show(exception);
        }
    }

    private void closeOrphanEditors() {
        try {
            IWorkbenchPage page = this.getSite().getPage();
            ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = page.findEditors(null, "com.arm.streamline.editor.apd", 2);
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                URI uri;
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorInput input = ref.getEditorInput();
                if (input instanceof IURIEditorInput && (uri = ((IURIEditorInput)input).getURI()) != null && !(file = new File(uri)).exists()) {
                    toClose.add(ref);
                }
                ++n2;
            }
            page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), false);
        }
        catch (CoreException exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    private boolean confirmDelete(List<ICapture> selection) {
        selection.removeIf(capture -> !capture.getApcDirectory().exists());
        int size = selection.size();
        if (size == 0) {
            return false;
        }
        if (!StreamlinePreferences.showDeleteConfirmDialog()) {
            return true;
        }
        Object msg = size == 1 ? "'" + selection.get(0).getApcDirectory().getName() + "'" : MessageFormat.format(DocumentsMessages.DELETE_MESSAGE_CONTENT, String.valueOf(size));
        msg = MessageFormat.format(DocumentsMessages.DELETE_MESSAGE, msg);
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getSite().getShell(), DocumentsMessages.DELETE_TITLE, null, (String)msg, 4, new String[]{DocumentsMessages.DELETE, DocumentsMessages.CANCEL}, 1, DocumentsMessages.ALWAYS, false);
        if (dialog.open() >= 256) {
            if (dialog.getToggleState()) {
                StreamlinePreferences.setShowDeleteConfirmDialog(false);
            }
            return true;
        }
        return false;
    }

    private void createActions() {
        this.mOpenAction = new CommandAction(CMD_OPEN, DocumentsMessages.OPEN, StreamlinePlugin.getImageDescriptor("AnalysisFile.gif"), this);
        this.mSelectAllAction = new CommandAction(CMD_SELECT_ALL, this);
        this.mCopyAction = new CommandAction(CMD_COPY, DocumentsMessages.COPY, Images.getEclipseSharedImageDescriptor("IMG_TOOL_COPY"), Images.getEclipseSharedImageDescriptor("IMG_TOOL_COPY_DISABLED"), this);
        this.mDuplicateAction = new CommandAction(CMD_DUPLICATE, DocumentsMessages.DUPLICATE, this);
        this.mAnalyzeAction = new CommandAction(CMD_ANALYZE, DocumentsMessages.REANALYZE, this);
        this.mDeleteAction = new CommandAction(CMD_DELETE, DocumentsMessages.DELETE, Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE"), Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE_DISABLED"), this);
        this.mCleanDbReportAction = new CommandAction(CMD_CLEAN_DB_AND_REPORT, DocumentsMessages.CLEAN_DB_AND_REPORT, Images.getEclipseSharedImageDescriptor("IMG_ETOOL_CLEAR"), Images.getEclipseSharedImageDescriptor("IMG_ETOOL_CLEAR_DISABLED"), this);
        this.mRenameAction = new CommandAction(CMD_RENAME, DocumentsMessages.RENAME, this);
        this.mRefreshAction = new CommandAction(CMD_REFRESH, DocumentsMessages.REFRESH, StreamlinePlugin.getImageDescriptor("RefreshArrows.gif"), this);
        this.mMoveAction = new CommandAction(CMD_MOVE, DocumentsMessages.MOVE, this);
        this.mLocationsAction = new CommandAction(CMD_LOCATIONS, DocumentsMessages.LOCATIONS, Images.getEclipseSharedImageDescriptor("IMG_OBJ_FOLDER"), this);
        this.mExportAction = new CommandAction(CMD_EXPORT, DocumentsMessages.EXPORT, StreamlinePlugin.getImageDescriptor("Export.gif"), this);
        this.mImportAction = new CommandAction(CMD_IMPORT, DocumentsMessages.IMPORT, StreamlinePlugin.getImageDescriptor("Import.gif"), this);
        this.mExpandAllAction = new CommandAction(CMD_EXPAND_ALL, DocumentsMessages.EXPAND_ALL, StreamlinePlugin.getImageDescriptor("ExpandAll.gif"), this);
        this.mCollapseAllAction = new CommandAction(CMD_COLLAPSE_ALL, DocumentsMessages.COLLAPSE_ALL, StreamlinePlugin.getImageDescriptor("CollapseAll.gif"), this);
    }

    private DocumentPanel createDocumentPanel(@NonNull ICapture doc, boolean startExpanded) {
        return new DocumentPanel(this, this.mDocumentArea, doc, startExpanded);
    }

    private void doAnalyze() {
        for (ICapture doc : this.getSelectedDocuments()) {
            DocumentsView.analyze(doc);
        }
    }

    private void doCleanDbAndReportsFromSelectedCaptures() {
        this.closeEditors(this.getSelectedDocuments());
        @NonNull List<@NonNull ICapture> selectedCaptures = this.getSelectedDocuments();
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        try {
            class DbAndReportDeleter
            implements IRunnableWithProgress {
                final @NonNull List<@NonNull ICapture> selectedCaptures = new ArrayList<ICapture>();

                public DbAndReportDeleter(List<ICapture> selectedCaptures) {
                    this.selectedCaptures.addAll(selectedCaptures);
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int worked = 0;
                    monitor.beginTask(DocumentsMessages.CLEANING_ANALYSIS_DATA, this.selectedCaptures.size());
                    for (ICapture capture : this.selectedCaptures) {
                        if (monitor.isCanceled()) continue;
                        capture.cleanDbAndReport();
                        DocumentsView.this.redrawDocuments();
                        monitor.worked(++worked);
                    }
                    Task.callOnUIThread(() -> DocumentsView.this.adjustActions());
                    monitor.done();
                }
            }
            ps.busyCursorWhile((IRunnableWithProgress)new DbAndReportDeleter(selectedCaptures));
        }
        catch (InterruptedException | InvocationTargetException exception) {
            CommonPlugin.error((String)exception.getMessage());
        }
    }

    private void doCopy() {
        TextField field = this.mToolbar.getFilterField();
        if (field.isFocused()) {
            field.copy();
        } else {
            ArrayList<String> files = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            for (ICapture doc : this.getSelectedDocuments()) {
                File file = doc.getApcDirectory();
                if (!file.exists()) continue;
                files.add(file.getAbsolutePath());
                if (buffer.length() > 0) {
                    buffer.append(System.getProperty("line.separator"));
                }
                buffer.append(file.getName());
            }
            if (!files.isEmpty()) {
                Clipboard clipboard = new Clipboard(this.getSite().getShell().getDisplay());
                Transfer[] transfers = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
                clipboard.setContents(new Object[]{files.toArray(new String[files.size()]), buffer.toString()}, transfers);
                clipboard.dispose();
            }
        }
    }

    private void doDelete() {
        List<ICapture> selection = this.getSelectedDocuments();
        if (this.confirmDelete(selection)) {
            this.closeEditors(selection);
            DeleteJob job = new DeleteJob(selection);
            job.schedule();
        }
    }

    private void doDuplicate() {
        Object newFileName;
        List<ICapture> selection = this.getSelectedDocuments();
        ICapture doc = selection.get(0);
        Shell shell = this.getSite().getShell();
        InputDialog dialog = new InputDialog(shell, DocumentsMessages.NEW_NAME, DocumentsMessages.DUPLICATE_DESCRIPTION, (String)(newFileName = FilePath.getLeafName((String)CommonPreferences.chooseUniqueName((File)((File)NullChecking.neverNull((Object)doc.getApcDirectory().getParentFile())), (String)doc.getApcDirectory().getName()), (boolean)false)), (IInputValidator)this);
        if (dialog.open() == 0) {
            File file = doc.getApcDirectory();
            String fileName = file.getName();
            if (!file.exists() || !file.canRead()) {
                MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_DUPLICATE_TITLE, (String)MessageFormat.format(DocumentsMessages.ERROR_READ, fileName));
            } else {
                boolean caseChange;
                newFileName = dialog.getValue();
                String extension = FilePath.getExtension((String)doc.getApcDirectory().getName());
                if (!((String)newFileName).toLowerCase().endsWith(extension)) {
                    newFileName = (String)newFileName + extension;
                }
                if ((caseChange = ((String)newFileName).equalsIgnoreCase(fileName)) && ((String)newFileName).equals(fileName)) {
                    MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_DUPLICATE_TITLE, (String)DocumentsMessages.CANNOT_DUPLICATE_TO_SELF);
                } else {
                    File dest = new File(file.getParent(), (String)newFileName);
                    if (!caseChange && dest.exists()) {
                        MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_DUPLICATE_TITLE, (String)MessageFormat.format(DocumentsMessages.ERROR_EXISTS2, dest.getPath()));
                    } else {
                        DuplicateJob job = new DuplicateJob(file, dest);
                        job.schedule();
                    }
                }
            }
        }
    }

    private void doExport() {
        if (!WidgetUtils.isModalDialogShowing()) {
            for (ICapture document : this.getSelectedDocuments()) {
                File file;
                ILiveCapture liveCapture;
                if (document instanceof ILiveCapture && (liveCapture = (ILiveCapture)document).isPlaceholder() || !(file = document.getApcDirectory()).exists()) continue;
                FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
                dialog.setFilterExtensions(ARCHIVE_EXTENSIONS);
                dialog.setOverwrite(true);
                dialog.setFilterPath(DocumentsView.getDefaultPath());
                dialog.setFileName(file.getName() + ".zip");
                dialog.setFilterNames(ARCHIVE_DESCRIPTIONS);
                String fileName = dialog.open();
                if (fileName == null) break;
                DocumentsView.setDefaultPath(fileName);
                try {
                    File dest = new File(fileName);
                    if (dest.getCanonicalPath().equals(file.getCanonicalPath())) {
                        Error.show(DocumentsMessages.CANNOT_OVERWRITE_SELF);
                        continue;
                    }
                    if (dest.exists()) {
                        dest.delete();
                    }
                    ExportCaptureJob job = new ExportCaptureJob(file, dest);
                    job.schedule();
                }
                catch (Exception exception) {
                    Error.show(exception);
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void doImport() {
        if (!WidgetUtils.isModalDialogShowing()) {
            FileDialog dialog = new FileDialog(this.getSite().getShell(), 4098);
            dialog.setFilterExtensions(ImportFileType.getFilterExtensions());
            dialog.setFilterNames(ImportFileType.getFilterDescriptions());
            dialog.setFilterPath(DocumentsView.getDefaultPath());
            @Nullable String firstFileName = dialog.open();
            if (firstFileName != null) {
                DocumentsView.setDefaultPath(firstFileName);
                String @NonNull [] fileNames = (String[])NullChecking.neverNull((Object[])dialog.getFileNames());
                String dir = dialog.getFilterPath();
                @NonNull @NonNull Collection files = Stream.of(fileNames).map(f -> FilePath.getFile((String)dir, (String)f)).collect(Collectors.toList());
                Shell shell = this.getSite().getShell();
                ImportConfigurationSupplier barmanXmlFileSelector = new ImportConfigurationSupplier(shell);
                @NonNull IPreferences preferences = StreamlinePreferences.getApplicationPreferences();
                try {
                    @NonNull List<@NonNull Job> jobs = ImportJobFactory.createImportJobs(barmanXmlFileSelector, IFileTypeChecker.DEFAULT, files, OutputPathProvider.getApcOutputPath(), ImportFileType.ALL_SUPPORTED_TYPES, preferences.importItmAsSychronizedTrace());
                    for (Job job : jobs) {
                        job.schedule();
                    }
                }
                catch (ImportJobFactory.ImportJobCreationException exception) {
                    Error.show(exception);
                }
            }
        }
    }

    private void doMove() {
        File dir;
        List<ICapture> selection = this.getSelectedDocuments();
        ICapture doc = selection.get(0);
        Shell shell = this.getSite().getShell();
        File file = doc.getApcDirectory();
        if (!file.exists()) {
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(shell, 0);
        dialog.setText(DocumentsMessages.MOVE_TITLE);
        dialog.setMessage(DocumentsMessages.MOVE_DESCRIPTION);
        dialog.setFilterPath(((File)NullChecking.neverNull((Object)file.getParentFile())).getAbsolutePath());
        String dirName = dialog.open();
        if (dirName != null && (dir = new File(dirName)).isDirectory()) {
            File dest = new File(dir, file.getName());
            if (dest.exists()) {
                String msg = MessageFormat.format(DocumentsMessages.ERROR_EXISTS3, dest.getPath());
                MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_MOVE_TITLE, (String)msg);
            }
            File ancestor = dir;
            while (ancestor != null) {
                if (ancestor.equals(file)) {
                    MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_MOVE_TITLE, (String)DocumentsMessages.ERROR_SELF_DEST);
                    return;
                }
                ancestor = ancestor.getParentFile();
            }
            boolean closed = this.closeEditors(selection);
            if (file.renameTo(dest)) {
                doc.setFile(dest);
                this.updateDocumentList(selection);
                DocumentScanner.INSTANCE.addToWatchSet(dest);
                this.adjustActions();
                if (closed) {
                    DocumentsView.open(doc);
                }
            } else {
                String msg = MessageFormat.format(DocumentsMessages.ERROR_MOVE_TEXT, file.getPath(), dest.getPath());
                MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_MOVE_TITLE, (String)msg);
            }
        }
    }

    private void doOpen() {
        for (ICapture doc : this.getSelectedDocuments()) {
            DocumentsView.open(doc);
        }
    }

    private void doRename() {
        List<ICapture> selection = this.getSelectedDocuments();
        ICapture doc = selection.get(0);
        Shell shell = this.getSite().getShell();
        InputDialog dialog = new InputDialog(shell, DocumentsMessages.NEW_NAME, DocumentsMessages.RENAME_MESSAGE, doc.toString(), (IInputValidator)this);
        if (dialog.open() == 0) {
            boolean caseChange;
            File file = doc.getApcDirectory();
            String fileName = file.getName();
            if (!file.exists() || !file.canRead()) {
                String msg = MessageFormat.format(DocumentsMessages.ERROR_READ, fileName);
                MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_RENAME_TITLE, (String)msg);
                return;
            }
            Object newFileName = dialog.getValue();
            String extension = FilePath.getExtension((String)doc.getApcDirectory().getName());
            if (!((String)newFileName).toLowerCase().endsWith(extension)) {
                newFileName = (String)newFileName + extension;
            }
            if ((caseChange = ((String)newFileName).equalsIgnoreCase(fileName)) && ((String)newFileName).equals(fileName)) {
                return;
            }
            File dest = new File(file.getParent(), (String)newFileName);
            if (!caseChange && dest.exists()) {
                String msg = MessageFormat.format(DocumentsMessages.ERROR_EXISTS2, dest.getPath());
                MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_RENAME_TITLE, (String)msg);
                return;
            }
            boolean closed = this.closeEditors(selection);
            if (file.renameTo(dest)) {
                doc.setFile(dest);
                this.updateDocumentList(selection);
                this.adjustActions();
                if (closed) {
                    DocumentsView.open(doc);
                }
            } else {
                MessageDialog.openError((Shell)shell, (String)DocumentsMessages.ERROR_RENAME_TITLE, (String)DocumentsMessages.ERROR_RENAME_TEXT);
            }
        }
    }

    private void doSelectAll() {
        TextField field = this.mToolbar.getFilterField();
        if (field.isFocused()) {
            field.selectAll();
        } else {
            this.mSelection.select();
        }
    }

    private Set<ICapture> getAllExpandedDocuments() {
        HashSet<ICapture> expanded = new HashSet<ICapture>();
        Control[] controlArray = this.mDocumentArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            DocumentPanel panel = (DocumentPanel)child;
            if (panel.isExpanded()) {
                expanded.add(panel.getDocument());
            }
            ++n2;
        }
        return expanded;
    }

    private int getRowHeight() {
        Control[] children = this.mDocumentArea.getChildren();
        return children.length > 0 ? Math.max(children[0].getBounds().height, 1) : 1;
    }

    private @NonNull List<@NonNull ICapture> getSelectedDocuments() {
        @NonNull ArrayList<@NonNull ICapture> selection = new ArrayList<ICapture>();
        int i = this.mSelection.firstSelectedIndex();
        while (i != -1) {
            ICapture doc = this.getSelectableObjectAtIndex(i);
            if (doc != null) {
                selection.add(doc);
            }
            i = this.mSelection.nextSelectedIndex(i + 1);
        }
        return selection;
    }

    private void hookGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(this.mOpenAction.getCommand(), (IAction)this.mOpenAction);
        actionBars.setGlobalActionHandler(this.mSelectAllAction.getCommand(), (IAction)this.mSelectAllAction);
        actionBars.setGlobalActionHandler(this.mCopyAction.getCommand(), (IAction)this.mCopyAction);
        actionBars.setGlobalActionHandler(this.mDeleteAction.getCommand(), (IAction)this.mDeleteAction);
        actionBars.setGlobalActionHandler(this.mRenameAction.getCommand(), (IAction)this.mRenameAction);
        actionBars.setGlobalActionHandler(this.mRefreshAction.getCommand(), (IAction)this.mRefreshAction);
        actionBars.updateActionBars();
    }

    private void keyScroll(int scrollTo, boolean grabFocus) {
        if (scrollTo != -1) {
            Control child = this.mDocumentArea.getChildren()[scrollTo];
            if (grabFocus) {
                child.setFocus();
            }
            this.mScroller.showControl(child);
        }
    }

    private void setExpansion(boolean expanded) {
        Control[] controlArray = this.mDocumentArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            DocumentPanel panel = (DocumentPanel)child;
            if (panel.isExpanded() != expanded) {
                panel.setExpanded(expanded);
            }
            ++n2;
        }
        SafeUpdate.pack(this.mDocumentArea);
        this.adjustActions();
    }

    private void setSelectionExpanded(boolean expanded) {
        int i = this.mSelection.firstSelectedIndex();
        Control[] children = this.mDocumentArea.getChildren();
        boolean changed = false;
        while (i != -1) {
            DocumentPanel docPanel = (DocumentPanel)children[i];
            if (docPanel.isExpanded() != expanded) {
                docPanel.setExpanded(expanded);
                changed = true;
            }
            i = this.mSelection.nextSelectedIndex(i + 1);
        }
        if (changed) {
            SafeUpdate.pack(this.mDocumentArea);
            this.adjustActions();
        }
    }

    void createContextMenu(Control control) {
        if (!this.mHasBeenDisposed) {
            Menu menu = new Menu(control);
            new ActionContributionItem((IAction)this.mOpenAction).fill(menu, -1);
            ContextMenu.createSeparator(menu);
            new ActionContributionItem((IAction)this.mAnalyzeAction).fill(menu, -1);
            new ActionContributionItem((IAction)this.mCleanDbReportAction).fill(menu, -1);
            ContextMenu.createSeparator(menu);
            new ActionContributionItem((IAction)this.mCopyAction).fill(menu, -1);
            new ActionContributionItem((IAction)this.mDuplicateAction).fill(menu, -1);
            new ActionContributionItem((IAction)this.mDeleteAction).fill(menu, -1);
            new ActionContributionItem((IAction)this.mMoveAction).fill(menu, -1);
            new ActionContributionItem((IAction)this.mRenameAction).fill(menu, -1);
            ContextMenu.createSeparator(menu);
            new ActionContributionItem((IAction)this.mExportAction).fill(menu, -1);
            control.setMenu(menu);
        }
    }

    void handleKeyDown(KeyEvent event) {
        boolean doit = false;
        boolean shiftDown = (event.stateMask & 0x20000) != 0;
        switch (event.keyCode) {
            case 0x100000B: {
                this.doRename();
                break;
            }
            case 0x1000001: {
                this.keyScroll(this.mSelection.selectUp(shiftDown, false), true);
                break;
            }
            case 0x1000002: {
                this.keyScroll(this.mSelection.selectDown(shiftDown, false), true);
                break;
            }
            case 0x1000003: {
                this.setSelectionExpanded(false);
                break;
            }
            case 0x1000004: {
                this.setSelectionExpanded(true);
                break;
            }
            case 0x1000007: {
                this.keyScroll(this.mSelection.selectToHome(shiftDown), true);
                break;
            }
            case 0x1000008: {
                this.keyScroll(this.mSelection.selectToEnd(shiftDown), true);
                break;
            }
            case 0x1000005: {
                this.keyScroll(this.mSelection.selectToPageUp(Math.max(1, this.mScroller.getClientArea().height / this.getRowHeight() - 1), shiftDown), true);
                break;
            }
            case 0x1000006: {
                this.keyScroll(this.mSelection.selectToPageDown(Math.max(1, this.mScroller.getClientArea().height / this.getRowHeight() - 1), shiftDown), true);
                break;
            }
            case 10: 
            case 13: 
            case 0x1000050: {
                this.doOpen();
                break;
            }
            case 8: 
            case 127: {
                this.doDelete();
                break;
            }
            default: {
                doit = true;
            }
        }
        event.doit = doit;
    }

    void handleMouseDown(MouseEvent event, ICapture doc) {
        int method = 0;
        if ((event.stateMask & 0x20000) != 0) {
            method |= 1;
        }
        if (event.button == 1 && (event.stateMask & WorkspaceUtils.getCommandKey()) != 0) {
            method |= 2;
        }
        this.mSelectOnMouseUp = this.mSelection.selectByMouse(this.documentToIndex(doc), method);
        if (event.button != 1) {
            this.mSelectOnMouseUp = -1;
        }
    }

    void handleMouseUp() {
        if (this.mSelectOnMouseUp != -1) {
            this.mSelection.select(this.mSelectOnMouseUp, false);
            this.mSelectOnMouseUp = -1;
        }
    }

    boolean isSelected(ICapture doc) {
        return this.mSelection.isSelected(this.documentToIndex(doc));
    }

    @Override
    public void scannerBusy(boolean scannerIsBusy) {
        this.scannerIsBusy = scannerIsBusy;
        @Nullable Display display = Display.getCurrent();
        @Nullable CommandAction refreshAction = this.mRefreshAction;
        if (display != null && refreshAction != null) {
            display.asyncExec(() -> refreshAction.setEnabled(!scannerIsBusy));
        }
    }

    static class FileRenameValidator
    implements IInputValidator {
        FileRenameValidator() {
        }

        public @Nullable String isValid(@Nullable String newText) {
            if (newText == null) {
                return DocumentsMessages.ERROR_NOTARGETS;
            }
            if (newText.trim().length() == 0) {
                return DocumentsMessages.ERROR_INVALID;
            }
            if (newText.indexOf(92) >= 0) {
                return DocumentsMessages.ERROR_INVALID;
            }
            if (newText.indexOf(47) >= 0) {
                return DocumentsMessages.ERROR_INVALID;
            }
            if (newText.stripLeading().equalsIgnoreCase(".apc")) {
                return DocumentsMessages.ERROR_INVALID;
            }
            if (!newText.toLowerCase().endsWith(".apc")) {
                return DocumentsMessages.ERROR_INVALID;
            }
            return null;
        }
    }

    private static class ImportConfigurationSupplier
    implements ImportJobFactory.IImportJobConfigurationSupplier {
        private final @Nullable Shell shell;

        public ImportConfigurationSupplier(@Nullable Shell shell) {
            this.shell = shell;
        }

        @Override
        public @Nullable ImportJobFactory.ITraceDumpImportConfiguration selectTraceDumpImportConfiguration(@NonNull ITraceDumpDirectory directory, @NonNull Map<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> classifications) throws ImportJobFactory.ImportJobCreationException {
            int nClassifications = classifications.size();
            if (nClassifications <= 0) {
                throw new ImportJobFactory.ImportJobCreationException(ImportMessages.UNSUPPORTED_FILE_TYPE);
            }
            SimpleLastFilterPathStore lastPathStore = new SimpleLastFilterPathStore(new File(DocumentsView.getDefaultPath()));
            try {
                @Nullable ImportJobFactory.ITraceDumpImportConfiguration result = TraceDumpImportWizardDialog.show(this.shell, directory, classifications, lastPathStore);
                if (result != null) {
                    DocumentsView.setDefaultPath(lastPathStore.getLastFilterPath().getAbsolutePath());
                }
                return result;
            }
            catch (IOException e) {
                throw new ImportJobFactory.ImportJobCreationException(ImportMessages.EXCEPTION_THROWN, e);
            }
        }
    }
}

