/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.utility.text.TextFilter;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.TextField;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.widgets.Composite;

public class DocumentsToolbar
extends CustomToolbar {
    private DocumentsView mOwner;
    private TextField mFilterField;
    private Pattern mFilterPattern = Pattern.compile("");

    public DocumentsToolbar(Composite parent, DocumentsView owner) {
        super(parent);
        this.mOwner = owner;
        this.addAction(this.mOwner.getRefreshAction()).setLayoutData(new CustomToolbar.LayoutData().setStartNewRow());
        this.addAction(this.mOwner.getExpandAllAction());
        this.addAction(this.mOwner.getCollapseAllAction()).setLayoutData(new CustomToolbar.LayoutData().setGap(1));
        this.mFilterField = new TextField(this);
        this.mFilterField.setToolTipText(DocumentsMessages.FILTER_TOOLTIP);
        this.mFilterField.setWatermark(DocumentsMessages.FILTER_WATERMARK);
        this.mFilterField.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(this.mFilterField.getRecommendedMinimumWidth()).setGap(1));
        this.mFilterField.addFieldModifiedListener(field -> {
            String text = TextFilter.enableCaseInsensitivityIfNoDirectivesPresent(field.getText().trim());
            try {
                Pattern pattern = Pattern.compile(text);
                if (!pattern.pattern().equals(this.mFilterPattern.pattern())) {
                    this.mFilterPattern = pattern;
                    this.mOwner.updateDocumentList(new ArrayList<ICapture>());
                }
                field.setValid(true);
            }
            catch (PatternSyntaxException exception) {
                field.setValid(false);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
                field.setValid(false);
            }
        });
        this.addAction(this.mOwner.getDeleteAction());
        this.addAction(this.mOwner.getLocationsAction());
        this.addAction(this.mOwner.getExportAction());
        this.addAction(this.mOwner.getImportAction());
    }

    public TextField getFilterField() {
        return this.mFilterField;
    }

    public Pattern getFilterPattern() {
        return this.mFilterPattern;
    }
}

