/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.utils.IterUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DocumentScannerCaptureList {
    private final @NonNull Function<@NonNull File, @Nullable ICapture> captureFactory;
    private final @NonNull AtomicReference<@NonNull ICapture[]> capturesInProgressAndPlaceholdersArrayRef = new AtomicReference();
    private final @NonNull List<@NonNull File> excludedCapturePaths = new CopyOnWriteArrayList<File>();
    private final @NonNull AtomicReference<Comparator<@NonNull ICapture>> comparatorRef = new AtomicReference();
    private final @NonNull AtomicReference<List<@NonNull ICapture>> currentCaptureListRef = new AtomicReference();
    private final @NonNull ICaptureListConsumer documentsListConsumer;
    private final @NonNull BooleanSupplier interruptedSupplier;
    private final @NonNull AtomicBoolean forceUpdate = new AtomicBoolean(false);

    private static boolean compareChanged(@NonNull ICapture newCapture, @NonNull ICapture currentCapture) {
        boolean currentIsPlaceholder;
        if (!newCapture.equals(currentCapture)) {
            return true;
        }
        boolean newIsPlaceholder = newCapture instanceof ILiveCapture && ((ILiveCapture)newCapture).isPlaceholder();
        boolean bl = currentIsPlaceholder = currentCapture instanceof ILiveCapture && ((ILiveCapture)currentCapture).isPlaceholder();
        if (newIsPlaceholder != currentIsPlaceholder) {
            return true;
        }
        return newCapture.isValid() != currentCapture.isValid() || newCapture.getCreatedOnSeconds() != currentCapture.getCreatedOnSeconds() || newCapture.getDurationInTimeUnits() != currentCapture.getDurationInTimeUnits() || !newCapture.getApcDirectory().getName().equals(currentCapture.getApcDirectory().getName());
    }

    private static boolean updateDocumentListAndCheckForChanges(@NonNull List<@NonNull ICapture> newCaptureList, @NonNull List<@NonNull ICapture> currentCaptureList) {
        int sizeCurrentCaptureList;
        int sizeNewCaptureList = newCaptureList.size();
        if (sizeNewCaptureList != (sizeCurrentCaptureList = currentCaptureList.size())) {
            return true;
        }
        int i = 0;
        while (i < sizeNewCaptureList) {
            ICapture currentCapture;
            @NonNull ICapture newCapture = newCaptureList.get(i);
            if (DocumentScannerCaptureList.compareChanged(newCapture, currentCapture = newCaptureList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DocumentScannerCaptureList(@NonNull Function<@NonNull File, @Nullable ICapture> captureFactory, @NonNull BooleanSupplier interruptedSupplier, @NonNull ICaptureListConsumer documentsListConsumer) {
        this.captureFactory = captureFactory;
        this.interruptedSupplier = interruptedSupplier;
        this.documentsListConsumer = documentsListConsumer;
    }

    public @NonNull List<@NonNull ICapture> getCurrentCaptureList() {
        @Nullable List<@NonNull ICapture> result = this.currentCaptureListRef.get();
        return result != null ? result : Collections.emptyList();
    }

    public void setCapturesInProgressAndPlaceholders(@NonNull ICapture @NonNull [] capturesInProgressAndPlaceholders) {
        this.capturesInProgressAndPlaceholdersArrayRef.set(capturesInProgressAndPlaceholders);
    }

    public void setComparator(@NonNull Comparator<@NonNull ICapture> comparator) {
        this.comparatorRef.set(comparator);
    }

    public boolean update(@NonNull Set<@NonNull File> captureDirectories) {
        ArrayList<ICapture> captures;
        @NonNull Set<@NonNull ICapture> capturesInProgressAndPlaceholders = this.getCapturesInProgressAndPlaceholders();
        if (!IterUtils.forEachInterruptable(captureDirectories, (BooleanSupplier)this.interruptedSupplier, arg_0 -> this.lambda$0(capturesInProgressAndPlaceholders, captures = new ArrayList<ICapture>(capturesInProgressAndPlaceholders), arg_0))) {
            return false;
        }
        Collections.sort(captures, this.getComparator());
        if (this.interruptedSupplier.getAsBoolean()) {
            return false;
        }
        @NonNull List<@NonNull ICapture> currentCaptureList = this.getCurrentCaptureList();
        boolean changed = DocumentScannerCaptureList.updateDocumentListAndCheckForChanges(captures, currentCaptureList);
        if (this.interruptedSupplier.getAsBoolean()) {
            return false;
        }
        if (changed || this.forceUpdate.getAndSet(false)) {
            this.currentCaptureListRef.set(captures);
            this.documentsListConsumer.consume(!capturesInProgressAndPlaceholders.isEmpty(), captures);
        }
        return true;
    }

    private void createCapture(@NonNull File captureDirectory, @NonNull Set<@NonNull ICapture> capturesInProgressAndPlaceholders, @NonNull List<@NonNull ICapture> captures) {
        if (this.excludedCapturePaths.contains(captureDirectory)) {
            return;
        }
        try {
            @Nullable ICapture capture = this.captureFactory.apply(captureDirectory);
            if (capture != null && !capturesInProgressAndPlaceholders.contains(capture)) {
                captures.add(capture);
            }
        }
        catch (Throwable t) {
            StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)("Failed to create capture object for path: " + String.valueOf(captureDirectory)), (Throwable)t);
        }
    }

    private @NonNull Set<@NonNull ICapture> getCapturesInProgressAndPlaceholders() {
        @NonNull ICapture @Nullable [] capturesInProgressAndPlaceholdersArray = this.capturesInProgressAndPlaceholdersArrayRef.get();
        @NonNull HashSet<@NonNull ICapture> result = new HashSet<ICapture>();
        if (capturesInProgressAndPlaceholdersArray != null) {
            result.addAll(Arrays.asList(capturesInProgressAndPlaceholdersArray));
        }
        return result;
    }

    private @NonNull Comparator<@NonNull ICapture> getComparator() {
        @Nullable Comparator<@NonNull ICapture> result = this.comparatorRef.get();
        return result != null ? result : Comparator.naturalOrder();
    }

    public void forceUpdate() {
        this.forceUpdate.set(true);
    }

    public void addExcludedCapturePath(@NonNull File copyInProgress) {
        this.excludedCapturePaths.add(copyInProgress);
    }

    public void removeexcludedCapturePath(@NonNull File path) {
        this.excludedCapturePaths.remove(path);
    }

    public void removeExcludedCapturePaths(@NonNull List<@NonNull File> paths) {
        this.excludedCapturePaths.removeAll(paths);
    }

    private /* synthetic */ void lambda$0(Set set, List list, File captureDirectory) {
        this.createCapture(captureDirectory, set, list);
    }

    @FunctionalInterface
    public static interface ICaptureListConsumer {
        public void consume(boolean var1, @NonNull List<@NonNull ICapture> var2);
    }
}

