/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.CaptureDirectoryScannerThread;
import com.arm.streamline.databrowser.DocumentScannerCaptureList;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.IDocumentScanListener;
import com.arm.streamline.databrowser.IDocumentScanner;
import com.arm.utils.LazyConstructor;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DocumentScanner
implements IDocumentScanner {
    public static final @NonNull IDocumentScanner INSTANCE = new DocumentScanner();
    private final @NonNull AtomicReference<CaptureDirectoryScannerThread> captureDirectoryScannerThreadRef = new AtomicReference();
    private final @NonNull DocumentScannerCaptureList captureList;
    private final @NonNull AtomicReference<Set<@NonNull File>> capturesToSelectRef = new AtomicReference();
    private final @NonNull Set<@NonNull ICapture> docsInProgressOrPlaceholders = new HashSet<ICapture>();
    private final @NonNull Set<@NonNull IDocumentScanListener> listeners = new HashSet<IDocumentScanListener>();
    private final @NonNull AtomicInteger pauseCounter = new AtomicInteger(0);
    private final @NonNull LazyConstructor<SpinnerThread> spinnerThreadRef = new LazyConstructor(() -> new SpinnerThread());
    private final @NonNull List<@NonNull File> watchList = new ArrayList<File>();

    private DocumentScanner() {
        this.captureList = new DocumentScannerCaptureList(ICapture::createCapture, this::isDirectoryScannerInterrupted, this::consumeCapturesList);
        this.reloadWatchsetFromPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocumentScanListener(@NonNull IDocumentScanListener listener) {
        Set<IDocumentScanListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        this.startSpinnerThread();
        this.update(true);
    }

    @Override
    public void addPlaceholder(@NonNull ICapture capture) {
        this.addToInProgress(capture);
    }

    @Override
    public void addExcludedCapturePath(@NonNull File capture) {
        this.captureList.addExcludedCapturePath(FileUtils.canonicalise((File)capture));
    }

    @Override
    public void removeExcludedCapturePath(@NonNull File capture) {
        this.captureList.removeexcludedCapturePath(FileUtils.canonicalise((File)capture));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToInProgress(@NonNull ICapture capture) {
        boolean shouldUpdate;
        Set<ICapture> set = this.docsInProgressOrPlaceholders;
        synchronized (set) {
            if (this.docsInProgressOrPlaceholders.add(capture)) {
                this.captureList.setCapturesInProgressAndPlaceholders(this.docsInProgressOrPlaceholders.toArray(new ICapture[this.docsInProgressOrPlaceholders.size()]));
                shouldUpdate = true;
            } else {
                shouldUpdate = false;
            }
        }
        if (shouldUpdate) {
            this.update(true);
        }
    }

    @Override
    public void addToWatchSet(@NonNull File directory) {
        this.addToWatchSet(new HashSet<File>(Arrays.asList(directory)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToWatchSet(@NonNull Set<@NonNull File> directories) {
        @NonNull HashSet<@NonNull File> directoriesToAdd = new HashSet<File>();
        for (File capturesDirectory : directories) {
            String name = (capturesDirectory = FileUtils.canonicalise((File)capturesDirectory)).getName();
            if (FilePath.getExtension((String)name).equalsIgnoreCase(".apc")) {
                capturesDirectory = FileUtils.canonicalise((File)((File)NullChecking.neverNull((Object)capturesDirectory.getParentFile())));
            } else {
                @NonNull File parent = FileUtils.canonicalise((File)((File)NullChecking.neverNull((Object)capturesDirectory.getParentFile())));
                if (FilePath.getExtension((String)parent.getName()).equalsIgnoreCase(".apc")) {
                    capturesDirectory = FileUtils.canonicalise((File)((File)NullChecking.neverNull((Object)parent.getParentFile())));
                }
            }
            directoriesToAdd.add(capturesDirectory);
        }
        List<File> list = this.watchList;
        synchronized (list) {
            for (File directory : directoriesToAdd) {
                if (this.watchList.contains(directory)) continue;
                this.watchList.add(directory);
            }
            StreamlinePreferences.setDataLocations(this.watchList);
            this.updateScannerWatchList();
        }
    }

    @Override
    public @NonNull List<@NonNull ICapture> getDocuments() {
        return this.captureList.getCurrentCaptureList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<@NonNull File> getWatchList() {
        List<File> list = this.watchList;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<File>(this.watchList));
        }
    }

    @Override
    public void pause() {
        this.pauseCounter.incrementAndGet();
    }

    @Override
    public void reloadWatchsetFromPreferences() {
        this.setWatchSet(StreamlinePreferences.getDataLocations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocumentScanListener(@NonNull IDocumentScanListener listener) {
        Set<IDocumentScanListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromInProgress(@NonNull ICapture capture) {
        boolean shouldUpdate;
        Set<ICapture> set = this.docsInProgressOrPlaceholders;
        synchronized (set) {
            if (this.docsInProgressOrPlaceholders.remove(capture)) {
                this.captureList.setCapturesInProgressAndPlaceholders(this.docsInProgressOrPlaceholders.toArray(new ICapture[this.docsInProgressOrPlaceholders.size()]));
                shouldUpdate = true;
            } else {
                shouldUpdate = false;
            }
        }
        if (shouldUpdate) {
            this.update(true);
            this.notifyToRedrawDocuments();
        }
    }

    @Override
    public void removePlaceholder(@NonNull ICapture capture) {
        this.removeFromInProgress(capture);
    }

    @Override
    public void resume() {
        int currentValue;
        do {
            if ((currentValue = this.pauseCounter.get()) != 0) continue;
            return;
        } while (!this.pauseCounter.compareAndSet(currentValue, currentValue - 1));
        if (currentValue == 1) {
            this.update(false);
        }
    }

    @Override
    public void stop() {
        @Nullable CaptureDirectoryScannerThread thread = this.captureDirectoryScannerThreadRef.get();
        if (thread != null) {
            thread.stop();
        }
        this.spinnerThreadRef.consumeIfAvailable(spinnerThread -> spinnerThread.stop());
    }

    @Override
    public void update(boolean force) {
        this.updateAndSelect(force, null);
    }

    @Override
    public void updateAndSelect(@Nullable List<@NonNull File> capturesToSelect) {
        this.updateAndSelect(true, capturesToSelect);
    }

    protected void updateSpinners() {
        this.notifyToRedrawDocuments();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void consumeCapturesList(boolean hasPlaceholdersOrInprogress, @NonNull List<@NonNull ICapture> captures) {
        IDocumentScanListener[] listeners;
        if (this.pauseCounter.get() != 0) {
            return;
        }
        @Nullable @NonNull Set capturesToSelect = this.capturesToSelectRef.getAndSet(null);
        @NonNull ArrayList<@NonNull ICapture> selection = new ArrayList<ICapture>();
        if (capturesToSelect != null) {
            for (ICapture capture : captures) {
                if (!capturesToSelect.contains(capture.getApcDirectory())) continue;
                selection.add(capture);
            }
        }
        IDocumentScanListener[] iDocumentScanListenerArray = listeners = this.getCurrentListenersArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentScanListener listener = iDocumentScanListenerArray[n2];
            listener.documentListUpdated(captures, selection);
            ++n2;
        }
        this.setSpinnerEnabled(hasPlaceholdersOrInprogress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable CaptureDirectoryScannerThread getCaptureDirectoryScannerThread() {
        CaptureDirectoryScannerThread result = this.captureDirectoryScannerThreadRef.get();
        if (result != null) {
            return result;
        }
        if (WorkspaceUtils.isHeadless() || !this.hasListeners()) {
            return null;
        }
        List<File> list = this.watchList;
        synchronized (list) {
            @NonNull File @NonNull [] watchArray = this.watchList.toArray(new File[this.watchList.size()]);
            result = this.captureDirectoryScannerThreadRef.get();
            if (result != null) {
                return result;
            }
            result = new CaptureDirectoryScannerThread(watchArray, this.captureList::update, this::updateScannerBusyState);
            this.captureDirectoryScannerThreadRef.set(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull IDocumentScanListener @NonNull [] getCurrentListenersArray() {
        Set<IDocumentScanListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(new IDocumentScanListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasListeners() {
        Set<IDocumentScanListener> set = this.listeners;
        synchronized (set) {
            return !this.listeners.isEmpty();
        }
    }

    private boolean isDirectoryScannerInterrupted() {
        @Nullable CaptureDirectoryScannerThread thread = this.captureDirectoryScannerThreadRef.get();
        return thread != null ? thread.interrupted() : false;
    }

    private void notifyToRedrawDocuments() {
        IDocumentScanListener[] listeners;
        IDocumentScanListener[] iDocumentScanListenerArray = listeners = this.getCurrentListenersArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentScanListener listener = iDocumentScanListenerArray[n2];
            listener.redrawDocuments();
            ++n2;
        }
    }

    private void setSpinnerEnabled(boolean busy) {
        this.spinnerThreadRef.consumeIfAvailable(spinnerThread -> {
            if (spinnerThread.setSpinnerEnabled(busy)) {
                this.notifyToRedrawDocuments();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWatchSet(@NonNull List<@NonNull File> watchList) {
        watchList = watchList.stream().map(FileUtils::canonicalise).distinct().collect(Collectors.toList());
        List<File> list = this.watchList;
        synchronized (list) {
            this.watchList.clear();
            this.watchList.addAll(watchList);
            this.updateScannerWatchList();
        }
    }

    private void startSpinnerThread() {
        if (!WorkspaceUtils.isHeadless()) {
            return;
        }
        this.spinnerThreadRef.get();
    }

    private void updateAndSelect(boolean force, @Nullable List<@NonNull File> capturesToSelect) {
        CaptureDirectoryScannerThread directoryScanner;
        if (capturesToSelect != null && !capturesToSelect.isEmpty()) {
            @NonNull Set<@NonNull T> capturesToSelectSet = capturesToSelect.stream().map(FileUtils::canonicalise).collect(Collectors.toSet());
            @Nullable Set<@NonNull T> previousSet = this.capturesToSelectRef.getAndSet(capturesToSelectSet);
            force |= !NullChecking.equalsNullable(previousSet, capturesToSelectSet);
        }
        if ((directoryScanner = this.getCaptureDirectoryScannerThread()) != null) {
            if (force) {
                this.captureList.forceUpdate();
            }
            directoryScanner.rescan();
        }
    }

    private void updateScannerBusyState(boolean scannerIsBusy) {
        IDocumentScanListener[] listeners;
        IDocumentScanListener[] iDocumentScanListenerArray = listeners = this.getCurrentListenersArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentScanListener listener = iDocumentScanListenerArray[n2];
            listener.scannerBusy(scannerIsBusy);
            ++n2;
        }
    }

    private void updateScannerWatchList() {
        @Nullable CaptureDirectoryScannerThread directoryScanner = this.getCaptureDirectoryScannerThread();
        if (directoryScanner != null) {
            @NonNull File @NonNull [] watchArray = this.watchList.toArray(new File[this.watchList.size()]);
            directoryScanner.setScanDirectories(watchArray);
        }
    }

    private final class SpinnerThread {
        private final @NonNull Object lockObject = new Object();
        private final @NonNull AtomicBoolean spinnerEnabled = new AtomicBoolean(false);
        private final @NonNull AtomicBoolean terminated = new AtomicBoolean(false);
        private final @NonNull Thread thread = new Thread(this::run, SpinnerThread.class.getSimpleName());

        public SpinnerThread() {
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setSpinnerEnabled(boolean busy) {
            Object object = this.lockObject;
            synchronized (object) {
                block4: {
                    if (this.spinnerEnabled.getAndSet(busy) == busy) break block4;
                    this.lockObject.notify();
                    return true;
                }
            }
            return false;
        }

        public void stop() {
            this.terminated.set(true);
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            while (!this.terminated.get()) {
                try {
                    Object object = this.lockObject;
                    synchronized (object) {
                        if (this.spinnerEnabled.get()) {
                            this.lockObject.wait(100L);
                        } else {
                            this.lockObject.wait();
                        }
                    }
                    DocumentScanner.this.updateSpinners();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

