/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.IButtonPathHandler;
import com.arm.streamline.databrowser.ISessionOwner;
import com.arm.streamline.model.session.BufferMode;
import com.arm.streamline.model.session.ExcludeKernel;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.utility.text.VariableResolver;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import com.arm.utils.text.SWTLabelFilter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CaptureOptionsPanel
extends Composite
implements SelectionListener,
IButtonPathHandler {
    private static final int ONE_MINUTE = 60;
    private static final int ONE_HOUR = 3600;
    private static final int MAX_SECONDS = 359999;
    private ISessionOwner mOwner;
    private BorderedComposite mTypeGroup;
    private TextField mDurationField;
    private Combo mSamplesCombo;
    private Combo mBufferModeCombo;
    private Button mEfficientFtraceButton;
    private Button mCallStackUnwindingButton;
    private Button mLiveCaptureOnlyButton;
    private Combo mExcludeKernelEvents;
    private boolean mSyncAllowed = true;

    private static Label createLabel(Composite parent, String title, String tooltip, int indent) {
        Label label = new Label(parent, 131072);
        label.setText(title);
        label.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).indent(indent, 0).applyTo((Control)label);
        return label;
    }

    private static int extractPositiveNumber(String text) {
        int result = Integer.parseInt(text);
        if (result < 0) {
            throw new NumberFormatException();
        }
        return result;
    }

    private static int extractSeconds(String text) {
        int seconds = 0;
        if (!(text = text.trim()).isEmpty()) {
            int colon = text.indexOf(58);
            if (colon == -1) {
                seconds = CaptureOptionsPanel.extractPositiveNumber(text);
            } else {
                seconds = CaptureOptionsPanel.extractPositiveNumber(text.substring(0, colon)) * 60;
                if ((colon = (text = text.substring(colon + 1)).indexOf(58)) == -1) {
                    seconds += CaptureOptionsPanel.extractPositiveNumber(text);
                } else {
                    seconds *= 60;
                    seconds += CaptureOptionsPanel.extractPositiveNumber(text.substring(0, colon)) * 60;
                    seconds += CaptureOptionsPanel.extractPositiveNumber(text.substring(colon + 1));
                }
            }
        }
        return Math.min(seconds, 359999);
    }

    private static String formatSeconds(int seconds) {
        StringBuilder buffer = new StringBuilder();
        boolean hasContent = false;
        if (seconds >= 3600) {
            int hours = seconds / 3600;
            buffer.append(hours);
            seconds -= hours * 3600;
            hasContent = true;
        }
        if (hasContent || seconds >= 60) {
            int minutes = seconds / 60;
            if (hasContent) {
                buffer.append(':');
                if (minutes < 10) {
                    buffer.append('0');
                }
            }
            buffer.append(minutes);
            seconds -= minutes * 60;
            hasContent = true;
        }
        if (hasContent) {
            buffer.append(':');
            if (seconds < 10) {
                buffer.append('0');
            }
        }
        buffer.append(seconds);
        return buffer.toString();
    }

    public CaptureOptionsPanel(Composite parent, ISessionOwner owner) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.mOwner = owner;
        this.mTypeGroup = new BorderedComposite(this, DocumentsMessages.CAPTURE);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.mTypeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mTypeGroup);
        Composite wrapper = new Composite((Composite)this.mTypeGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(6).spacing(5, 2).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        CaptureOptionsPanel.createLabel(wrapper, DocumentsMessages.SAMPLE_RATE, DocumentsMessages.SAMPLE_RATE_TOOLTIP, 0);
        this.mSamplesCombo = SWTUtils.createCombo(wrapper, DocumentsMessages.SAMPLE_RATE_TOOLTIP, (Object[])SampleRate.values(), this);
        ((GridData)this.mSamplesCombo.getLayoutData()).horizontalAlignment = 4;
        this.mCallStackUnwindingButton = SWTUtils.createCheckbox(wrapper, DocumentsMessages.CALL_STACK_UNWINDING, DocumentsMessages.CALL_STACK_UNWINDING_TOOLTIP, this);
        ((GridData)this.mCallStackUnwindingButton.getLayoutData()).horizontalIndent = 10;
        ((GridData)this.mCallStackUnwindingButton.getLayoutData()).horizontalSpan = 2;
        CaptureOptionsPanel.createLabel(wrapper, DocumentsMessages.EXCLUDE_KERNEL_EVENTS, DocumentsMessages.EXCLUDE_KERNEL_EVENTS_TOOLTIP, 5);
        this.mExcludeKernelEvents = SWTUtils.createCombo(wrapper, DocumentsMessages.EXCLUDE_KERNEL_EVENTS_TOOLTIP, (Object[])ExcludeKernel.values(), this);
        CaptureOptionsPanel.createLabel(wrapper, DocumentsMessages.BUFFER_MODE, DocumentsMessages.BUFFER_MODE_TOOLTIP, 0);
        this.mBufferModeCombo = SWTUtils.createCombo(wrapper, DocumentsMessages.BUFFER_MODE_TOOLTIP, (Object[])BufferMode.values(), this);
        this.mLiveCaptureOnlyButton = SWTUtils.createCheckbox(wrapper, DocumentsMessages.DISCARD_DATA, DocumentsMessages.DISCARD_DATA_TOOLTIP, this);
        ((GridData)this.mLiveCaptureOnlyButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.mLiveCaptureOnlyButton.getLayoutData()).horizontalIndent = 10;
        this.mEfficientFtraceButton = SWTUtils.createCheckbox(wrapper, DocumentsMessages.EFFICIENT_FTRACE, DocumentsMessages.EFFICIENT_FTRACE_TOOLTIP, this);
        ((GridData)this.mEfficientFtraceButton.getLayoutData()).horizontalSpan = 2;
        CaptureOptionsPanel.createLabel(wrapper, DocumentsMessages.DURATION, DocumentsMessages.DURATION_TOOLTIP, 10);
        this.mDurationField = this.createDurationField(wrapper);
    }

    public void adjustControls() {
        if (this.mSyncAllowed) {
            this.mSyncAllowed = false;
            try {
                Session session = this.mOwner.getSession();
                SampleRate sampleRate = session.getSampleRate();
                this.mSamplesCombo.select(sampleRate.ordinal());
                this.mSamplesCombo.setEnabled(true);
                this.mBufferModeCombo.select(session.getBufferMode().ordinal());
                this.mBufferModeCombo.setEnabled(true);
                this.mLiveCaptureOnlyButton.setSelection(session.isDiscardEnabled());
                this.mEfficientFtraceButton.setSelection(session.isEfficientFtraceEnabled());
                this.mCallStackUnwindingButton.setSelection(sampleRate != SampleRate.NONE && session.isCallStackUnwindingEnabled());
                this.mCallStackUnwindingButton.setEnabled(sampleRate != SampleRate.NONE);
                ExcludeKernel excludeKernel = session.getExcludeKernelEvents();
                this.mExcludeKernelEvents.select(excludeKernel.ordinal());
                this.mExcludeKernelEvents.setEnabled(true);
                int duration = session.getDurationLimitInSecs();
                this.mDurationField.setText(duration > 0 ? CaptureOptionsPanel.formatSeconds(duration) : "");
                this.mDurationField.setValid(true);
            }
            finally {
                this.mSyncAllowed = true;
            }
        }
    }

    public String checkValidity() {
        return null;
    }

    @Override
    public String getButtonPath(Button button) {
        return FilePath.getParent((String)VariableResolver.resolve(((Text)button.getData()).getText().trim()));
    }

    public void initializeContent() {
        this.adjustControls();
    }

    @Override
    public void setButtonPath(Button button, String path) {
        Text field = (Text)button.getData();
        String leafName = FilePath.getLeafName((String)VariableResolver.resolve(field.getText().trim()));
        path = FilePath.getPathForPlatform((String)FilePath.getFullPath((String)path, (String)leafName));
        field.setText(VariableResolver.reverseResolve(path));
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.mSyncAllowed) {
            Session session = this.mOwner.getSession();
            if (event.widget == this.mSamplesCombo) {
                @NonNull SampleRate sampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.values()[this.mSamplesCombo.getSelectionIndex()])));
                session.setSampleRate(sampleRate);
            } else if (event.widget == this.mBufferModeCombo) {
                @NonNull BufferMode bufferMode = (BufferMode)((Object)NullChecking.neverNull((Object)((Object)BufferMode.values()[this.mBufferModeCombo.getSelectionIndex()])));
                session.setBufferMode(bufferMode);
            } else if (event.widget == this.mLiveCaptureOnlyButton) {
                session.setDiscard(this.mLiveCaptureOnlyButton.getSelection());
            } else if (event.widget == this.mEfficientFtraceButton) {
                session.setEfficientFtrace(this.mEfficientFtraceButton.getSelection());
            } else if (event.widget == this.mCallStackUnwindingButton) {
                session.setCallStackUnwindingEnabled(this.mCallStackUnwindingButton.getSelection());
            } else if (event.widget == this.mExcludeKernelEvents) {
                @NonNull ExcludeKernel excludeKernel = (ExcludeKernel)((Object)NullChecking.neverNull((Object)((Object)ExcludeKernel.values()[this.mExcludeKernelEvents.getSelectionIndex()])));
                session.setExcludeKernelEvents(excludeKernel);
            }
            this.mOwner.markDirty();
            this.adjustControls();
        }
    }

    private TextField createDurationField(Composite parent) {
        TextField field = new TextField(parent);
        field.setWatermark(DocumentsMessages.UNLIMITED);
        field.setToolTipText(DocumentsMessages.DURATION_TOOLTIP);
        field.addFieldModifiedListener(textField -> {
            if (this.mSyncAllowed) {
                try {
                    this.mOwner.getSession().setDurationLimit(CaptureOptionsPanel.extractSeconds(this.mDurationField.getText()));
                    this.mDurationField.setValid(true);
                }
                catch (NumberFormatException nfe) {
                    this.mDurationField.setValid(false);
                }
                this.mOwner.markDirty();
            }
        });
        field.setTextLimit(8);
        FontInfo fontInfo = FontInfo.get(field.getFont());
        field.setDesiredMinimumTextWidth(Math.max(fontInfo.getWidth("0") * 8, fontInfo.getWidth(DocumentsMessages.UNLIMITED)));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)field);
        return field;
    }
}

