/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.session.IDatabaseGenerator;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.topology.IClustersInfo;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractDatabaseGenerator
implements IDatabaseGenerator {
    private boolean mDiscard = false;
    private boolean mStopRequested = false;

    @Override
    public final void generateDatabase(@NonNull IAnalysisInputSettings analysisSettings, @Nullable EnergyCaptureSettings energyCaptureSettings, @NonNull String capturePath, @NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull SessionProcessor sessionProcessor, ICaptureProxy proxy, @NonNull IAnalysisHandler handler, @NonNull AttachedApkEntries attachedApkEntries) throws IOException, Exception {
        this.mDiscard = sessionProcessor.isDiscard();
        try {
            this.checkError();
            this.processRecords(analysisSettings, energyCaptureSettings, analysisSettings.isGenerateSpeSampleLogEnabled(), capturePath, captureDetails, clustersInfo, sessionProcessor, proxy, handler, attachedApkEntries);
            this.checkError();
        }
        catch (Throwable t) {
            handler.cancel();
            throw t;
        }
        this.checkError();
    }

    @Override
    public final void setStop() {
        this.mStopRequested = true;
    }

    protected final void checkError() throws Exception {
        if (this.mDiscard && this.mStopRequested) {
            throw new InterruptedException();
        }
    }

    protected abstract void processRecords(@NonNull IAnalysisInputSettings var1, @Nullable EnergyCaptureSettings var2, boolean var3, @NonNull String var4, @NonNull ICaptureDetails var5, @NonNull IClustersInfo var6, @NonNull SessionProcessor var7, ICaptureProxy var8, @NonNull IAnalysisHandler var9, @NonNull AttachedApkEntries var10) throws Exception;
}

