/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.viewmodel;

import com.arm.databinding.StyledTextProperties;
import com.arm.streamline.common.xml.spe.AbstractSpeEventProperties;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.utils.NullChecking;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.custom.StyleRange;

public class SpeFilterViewModel {
    private final @NonNull WritableValue<@NonNull Boolean> observableIsLoad = new WritableValue();
    private final @NonNull WritableValue<@NonNull Boolean> observableIsStore = new WritableValue();
    private final @NonNull WritableValue<@NonNull Boolean> observableIsBranch = new WritableValue();
    private final @NonNull WritableValue<@NonNull Integer> observableMinLatency = new WritableValue();
    private final @NonNull IObservableValue<@NonNull StyledTextProperties> observableEventInfo;
    private final @NonNull IObservableValue<@NonNull StyledTextProperties> observableOprTypeInfo;
    private final @NonNull IObservableValue<@NonNull IStatus> observableEventWarning;
    final @NonNull IObservableSet<@NonNull SpeFilterEventProperties> observableFilterEventsSelected = new WritableSet();
    final @NonNull IObservableSet<@NonNull SpeFilterEventProperties> observableFilterEventsVisible = new WritableSet();
    final @NonNull Set<@NonNull SpeFilterEventProperties> previousCheckedState = new WritableSet();
    final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SpeFilterConfiguration.OpType, @NonNull Set<@NonNull SpeFilterEventProperties>> opTypeFilterMap = new HashMap<SpeFilterConfiguration.OpType, Set<SpeFilterEventProperties>>();
    final @NonNull Set<@NonNull SpeFilterEventProperties> otherTypeSpeEvents = new HashSet<SpeFilterEventProperties>();
    final @NonNull Set<@NonNull SpeFilterEventProperties> hiddenCheckedEvents = new HashSet<SpeFilterEventProperties>();

    public SpeFilterViewModel(@NonNull SpeFilterConfiguration filterConfiguration) {
        this.observableMinLatency.setValue((Object)filterConfiguration.getMinLatency());
        this.observableMinLatency.addValueChangeListener(e -> filterConfiguration.setMinLatency(((Integer)e.getObservableValue().getValue()).intValue()));
        this.observableIsStore.addValueChangeListener(e -> {
            @NonNull Boolean value = (Boolean)NullChecking.neverNull((Object)((Boolean)e.getObservableValue().getValue()));
            SpeFilterViewModel.updateOpType(value, filterConfiguration, SpeFilterConfiguration.OpType.Store);
        });
        this.observableIsLoad.addValueChangeListener(e -> {
            @NonNull Boolean value = (Boolean)NullChecking.neverNull((Object)((Boolean)e.getObservableValue().getValue()));
            SpeFilterViewModel.updateOpType(value, filterConfiguration, SpeFilterConfiguration.OpType.Load);
        });
        this.observableIsBranch.addValueChangeListener(e -> {
            @NonNull Boolean value = (Boolean)NullChecking.neverNull((Object)((Boolean)e.getObservableValue().getValue()));
            SpeFilterViewModel.updateOpType(value, filterConfiguration, SpeFilterConfiguration.OpType.Branch);
        });
        this.observableFilterEventsSelected.addSetChangeListener(e -> {
            filterConfiguration.removeAllEvents();
            e.getObservableSet().iterator().forEachRemaining(arg_0 -> ((SpeFilterConfiguration)filterConfiguration).addEvent(arg_0));
        });
        this.observableEventInfo = ComputedValue.create(() -> this.updateEventInfo());
        this.observableOprTypeInfo = ComputedValue.create(() -> this.updateOprTypeInfo());
        this.observableEventWarning = ComputedValue.create(() -> {
            boolean b = ((StyledTextProperties)this.observableEventInfo.getValue()).getText().equals(CountersMessages.SAMPLING_ALL_MESSAGE);
            return b ? Status.OK_STATUS : new Status(2, "com.arm.streamline", null);
        });
        this.initOptypeEventMap(filterConfiguration);
        this.observableIsLoad.setValue((Object)filterConfiguration.getOpType().contains(SpeFilterConfiguration.OpType.Load));
        this.observableIsStore.setValue((Object)filterConfiguration.getOpType().contains(SpeFilterConfiguration.OpType.Store));
        this.observableIsBranch.setValue((Object)filterConfiguration.getOpType().contains(SpeFilterConfiguration.OpType.Branch));
        this.observableIsLoad.addValueChangeListener(e -> this.updateEventsVisibleCheckedState((Boolean)this.observableIsLoad.getValue(), (Boolean)this.observableIsStore.getValue(), (Boolean)this.observableIsBranch.getValue(), filterConfiguration));
        this.observableIsStore.addValueChangeListener(e -> this.updateEventsVisibleCheckedState((Boolean)this.observableIsLoad.getValue(), (Boolean)this.observableIsStore.getValue(), (Boolean)this.observableIsBranch.getValue(), filterConfiguration));
        this.observableIsBranch.addValueChangeListener(e -> this.updateEventsVisibleCheckedState((Boolean)this.observableIsLoad.getValue(), (Boolean)this.observableIsStore.getValue(), (Boolean)this.observableIsBranch.getValue(), filterConfiguration));
        this.observableFilterEventsVisible.addAll((Collection)filterConfiguration.getAllSpeFilterEvents());
        this.observableFilterEventsSelected.addAll((Collection)filterConfiguration.getEvents());
        this.updateEventsVisibleCheckedState((Boolean)this.observableIsLoad.getValue(), (Boolean)this.observableIsStore.getValue(), (Boolean)this.observableIsBranch.getValue(), filterConfiguration);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initOptypeEventMap(@NonNull SpeFilterConfiguration filterConfiguration) {
        @NonNull @NonNull Set events = filterConfiguration.getAllSpeFilterEvents();
        @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SpeFilterConfiguration.OpType> asList = Arrays.asList(SpeFilterConfiguration.OpType.values());
        for (SpeFilterConfiguration.OpType list : asList) {
            this.opTypeFilterMap.put(list, new HashSet());
        }
        for (SpeFilterEventProperties pktEvntprop : events) {
            @NonNull SpeFilterEventProperties speFilterEventProperties = events.stream().filter(e -> e.getName().equals(pktEvntprop.getName())).findFirst().get();
            @NonNull @NonNull Set validOpTypes = pktEvntprop.getValidOpTypes();
            if (validOpTypes.isEmpty()) {
                @Nullable Set<@NonNull SpeFilterEventProperties> set = this.opTypeFilterMap.get(SpeFilterConfiguration.OpType.Load);
                ((Set)NullChecking.neverNull(set)).add(speFilterEventProperties);
                set = this.opTypeFilterMap.get(SpeFilterConfiguration.OpType.Store);
                ((Set)NullChecking.neverNull(set)).add(speFilterEventProperties);
                set = this.opTypeFilterMap.get(SpeFilterConfiguration.OpType.Branch);
                ((Set)NullChecking.neverNull(set)).add(speFilterEventProperties);
                continue;
            }
            for (AbstractSpeEventProperties.ValidOpType valOptype : validOpTypes) {
                switch (valOptype.opTypeClass) {
                    case LOAD_STORE: {
                        byte mask = valOptype.subclassMask;
                        byte test = valOptype.subclassTest;
                        if (mask == 1) {
                            if (test == 1) {
                                this.addEventstoMap(SpeFilterConfiguration.OpType.Store, speFilterEventProperties);
                                break;
                            }
                            this.addEventstoMap(SpeFilterConfiguration.OpType.Load, speFilterEventProperties);
                            break;
                        }
                        this.addEventstoMap(SpeFilterConfiguration.OpType.Load, speFilterEventProperties);
                        this.addEventstoMap(SpeFilterConfiguration.OpType.Store, speFilterEventProperties);
                        break;
                    }
                    case BRANCH: {
                        this.addEventstoMap(SpeFilterConfiguration.OpType.Branch, speFilterEventProperties);
                        break;
                    }
                    case OTHER: {
                        this.otherTypeSpeEvents.add(speFilterEventProperties);
                        break;
                    }
                }
            }
        }
    }

    private void addEventstoMap(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SpeFilterConfiguration.OpType type, @NonNull SpeFilterEventProperties speFilterEventProperties) {
        @Nullable Set<@NonNull SpeFilterEventProperties> set = this.opTypeFilterMap.get(type);
        ((Set)NullChecking.neverNull(set)).add(speFilterEventProperties);
    }

    void updateEventsVisibleCheckedState(boolean isLoad, boolean isStore, boolean isBranch, @NonNull SpeFilterConfiguration filterConfiguration) {
        if (!(isLoad || isStore || isBranch)) {
            this.observableFilterEventsVisible.addAll((Collection)filterConfiguration.getAllSpeFilterEvents());
            this.observableFilterEventsSelected.addAll(this.hiddenCheckedEvents);
        } else {
            @NonNull HashSet<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull SpeFilterConfiguration.OpType> toBeAdded = new HashSet<SpeFilterConfiguration.OpType>();
            @NonNull HashSet<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull SpeFilterConfiguration.OpType> toBeRemoved = new HashSet<SpeFilterConfiguration.OpType>();
            if (isLoad) {
                toBeAdded.add(SpeFilterConfiguration.OpType.Load);
            } else {
                toBeRemoved.add(SpeFilterConfiguration.OpType.Load);
            }
            if (isBranch) {
                toBeAdded.add(SpeFilterConfiguration.OpType.Branch);
            } else {
                toBeRemoved.add(SpeFilterConfiguration.OpType.Branch);
            }
            if (isStore) {
                toBeAdded.add(SpeFilterConfiguration.OpType.Store);
            } else {
                toBeRemoved.add(SpeFilterConfiguration.OpType.Store);
            }
            this.setCheckedVisibleStatus(toBeAdded, toBeRemoved);
        }
    }

    private void setCheckedVisibleStatus(@NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SpeFilterConfiguration.OpType> toBeAdded, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SpeFilterConfiguration.OpType> toBeRemoved) {
        @Nullable HashSet<@NonNull E> eventsToBeAdded = new HashSet();
        @NonNull HashSet<@NonNull SpeFilterEventProperties> eventsToBeRemoved = new HashSet<SpeFilterEventProperties>();
        toBeAdded.stream().forEach(type -> {
            @Nullable @Nullable Set<@NonNull @NonNull SpeFilterEventProperties> set2 = this.opTypeFilterMap.get(type);
            if (eventsToBeAdded.isEmpty()) {
                eventsToBeAdded.addAll(set2);
            } else {
                eventsToBeAdded.retainAll(set2);
            }
        });
        eventsToBeRemoved.addAll(this.otherTypeSpeEvents);
        toBeRemoved.stream().forEach(type -> {
            boolean bl = eventsToBeRemoved.addAll((Collection)this.opTypeFilterMap.get(type));
        });
        toBeAdded.stream().forEach(type -> {
            @Nullable Set<@NonNull SpeFilterEventProperties> set3 = this.opTypeFilterMap.get(type);
            if (set3 != null) {
                set3.stream().forEach(e -> {
                    if (!eventsToBeAdded.contains(e)) {
                        eventsToBeRemoved.add((SpeFilterEventProperties)e);
                    }
                });
            }
        });
        @NonNull Set<@NonNull T> toBeRemovedCheckedElements = this.observableFilterEventsSelected.stream().filter(c -> eventsToBeRemoved.contains(c)).collect(Collectors.toSet());
        this.observableFilterEventsSelected.removeAll(toBeRemovedCheckedElements);
        this.hiddenCheckedEvents.addAll(toBeRemovedCheckedElements);
        this.observableFilterEventsVisible.removeAll(eventsToBeRemoved);
        this.observableFilterEventsVisible.addAll(eventsToBeAdded);
        @NonNull Set<@NonNull T> checkedToBeAddedBack = eventsToBeAdded.stream().filter(c -> this.hiddenCheckedEvents.contains(c)).collect(Collectors.toSet());
        this.observableFilterEventsSelected.addAll(checkedToBeAddedBack);
        this.hiddenCheckedEvents.removeAll(checkedToBeAddedBack);
    }

    private @NonNull StyledTextProperties updateEventInfo() {
        @NonNull Object text = "";
        @NonNull StyleRange styleRanges = new StyleRange();
        if (this.observableFilterEventsSelected.size() == 0) {
            text = CountersMessages.SAMPLING_ALL_MESSAGE;
            styleRanges.start = ((String)text).indexOf(CountersMessages.SAMPLING_ALL);
            styleRanges.length = CountersMessages.SAMPLING_ALL.length();
            styleRanges.fontStyle = 1;
        } else if (this.observableFilterEventsSelected.size() == 1) {
            String start = CountersMessages.SAMPLING_SINGLE_SELECTED_MESSAGE_START + " ";
            text = start + ((SpeFilterEventProperties)this.observableFilterEventsSelected.stream().findFirst().get()).getName() + " " + CountersMessages.SAMPLING_SINGLE_SELECTED_MESSAGE_END;
            styleRanges.start = start.length();
            styleRanges.length = ((SpeFilterEventProperties)this.observableFilterEventsSelected.stream().findFirst().get()).getName().length();
            styleRanges.fontStyle = 1;
        } else {
            text = String.format(CountersMessages.SAMPLING_ALL_SELECTED_MESSAGE, CountersMessages.SAMPLING_ALL_SELECTED);
            styleRanges.start = ((String)text).indexOf(CountersMessages.SAMPLING_ALL_SELECTED);
            styleRanges.length = CountersMessages.SAMPLING_ALL_SELECTED.length();
            styleRanges.fontStyle = 1;
        }
        StyledTextProperties styledTextObservable = new StyledTextProperties((String)text, new StyleRange[]{styleRanges});
        return styledTextObservable;
    }

    private @NonNull StyledTextProperties updateOprTypeInfo() {
        String text;
        boolean isStore;
        @NonNull TIntIntHashMap stylePosition = new TIntIntHashMap();
        boolean isLoad = this.observableIsLoad.getValue() != null ? (Boolean)this.observableIsLoad.getValue() : false;
        boolean isBranch = this.observableIsBranch.getValue() != null ? (Boolean)this.observableIsBranch.getValue() : false;
        boolean bl = isStore = this.observableIsStore.getValue() != null ? (Boolean)this.observableIsStore.getValue() : false;
        if (isLoad && isBranch && isStore) {
            text = CountersMessages.SAMPLING_ALL_SELECTED_OPTYPE;
            @NonNull Pattern compile = Pattern.compile(CountersMessages.SAMPLING_OPTYPE_OR);
            @NonNull Matcher matcher = compile.matcher(text);
            while (matcher.find()) {
                stylePosition.put(matcher.start(), CountersMessages.SAMPLING_OPTYPE_OR.length());
            }
        } else if (!(isLoad || isStore || isBranch)) {
            text = CountersMessages.SAMPLING_ALL_MESSAGE_OPTYPE;
            stylePosition.put(text.indexOf(CountersMessages.SAMPLING_ALL), CountersMessages.SAMPLING_ALL.length());
        } else {
            StringBuilder test = new StringBuilder();
            if (isLoad) {
                test.append(CountersMessages.SAMPLING_OPTYPE_LOAD + " " + CountersMessages.SAMPLING_OPTYPE_OR + " ");
            }
            if (isStore) {
                test.append(CountersMessages.SAMPLING_OPTYPE_STORE + " " + CountersMessages.SAMPLING_OPTYPE_OR + " ");
            }
            if (isBranch) {
                test.append(CountersMessages.SAMPLING_OPTYPE_BRANCH + " " + CountersMessages.SAMPLING_OPTYPE_OR + " ");
            }
            test.delete(test.lastIndexOf(CountersMessages.SAMPLING_OPTYPE_OR), test.length());
            text = String.format(CountersMessages.SAMPLING_SELECTED_OPTYPE, test.toString().trim());
            @NonNull Pattern compile = Pattern.compile(CountersMessages.SAMPLING_OPTYPE_OR);
            @NonNull Matcher matcher = compile.matcher(text);
            while (matcher.find()) {
                stylePosition.put(matcher.start(), 2);
            }
        }
        @NonNull StyleRange[] styleRanges = new StyleRange[stylePosition.size()];
        int i = 0;
        int[] nArray = stylePosition.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int start = nArray[n2];
            styleRanges[i] = new StyleRange();
            styleRanges[i].start = start;
            styleRanges[i].length = stylePosition.get(start);
            styleRanges[i].fontStyle = 1;
            ++i;
            ++n2;
        }
        StyledTextProperties styledTextObservable = new StyledTextProperties(text, styleRanges);
        return styledTextObservable;
    }

    private static void updateOpType(@NonNull Boolean value, @NonNull SpeFilterConfiguration value2, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SpeFilterConfiguration.OpType type) {
        value2.removeOpType(type);
        if (value.booleanValue()) {
            value2.addOpType(type);
        }
    }

    public @NonNull IObservableSet<@NonNull SpeFilterEventProperties> getVisibleEvents() {
        return this.observableFilterEventsVisible;
    }

    public @NonNull IObservableSet<@NonNull SpeFilterEventProperties> getEventsChecked() {
        return this.observableFilterEventsSelected;
    }

    public @NonNull WritableValue<@NonNull Boolean> isLoad() {
        return this.observableIsLoad;
    }

    public @NonNull WritableValue<@NonNull Boolean> isStore() {
        return this.observableIsStore;
    }

    public @NonNull WritableValue<@NonNull Boolean> isBranch() {
        return this.observableIsBranch;
    }

    public @NonNull WritableValue<@NonNull Integer> getMinLatency() {
        return this.observableMinLatency;
    }

    public static boolean validateMinLatency(int input) {
        return input >= 0 && input <= 4095;
    }

    public IObservableValue<@NonNull StyledTextProperties> getObservableEventInfo() {
        return this.observableEventInfo;
    }

    public IObservableValue<@NonNull StyledTextProperties> getObservableOprTypeInfo() {
        return this.observableOprTypeInfo;
    }

    public IObservableValue<@NonNull IStatus> getEventInfoWarning() {
        return this.observableEventWarning;
    }
}

