/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.CounterRow;
import com.arm.streamline.counterconfig.outline.IEventConfigurationRow;
import com.arm.streamline.widget.outline.SimpleColumn;
import org.eclipse.jdt.annotation.NonNull;

public class TargetCounterRow
extends CounterRow
implements IEventConfigurationRow {
    private final @NonNull TargetCounter mCounter;
    private final @NonNull String mDisplayTitle;

    public TargetCounterRow(@NonNull TargetCounter counter, @NonNull Events events) {
        this.mCounter = counter;
        this.mDisplayTitle = events.getUniqueDisplayTitle(this.mCounter, true);
    }

    public @NonNull TargetCounter getCounter() {
        return this.mCounter;
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        return this.mDisplayTitle;
    }

    @Override
    public @NonNull StockCounter getStockCounter() {
        return this.mCounter.getDerivedFrom();
    }

    @Override
    public boolean isEbsTarget(@NonNull Configurations configurations) {
        return configurations.ebsIsEnabled(this.mCounter);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }

    @Override
    public IConfiguredEvent getData() {
        return this.mCounter;
    }

    @Override
    public BaseRow getBaseRow() {
        return this;
    }
}

