/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.IAvailableEventsRow;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class SpeTargetDescriptionRow
extends BaseRow
implements IAvailableEventsRow {
    private @NonNull SpeTargetDescription speTraget;
    private @NonNull Configurations configurations;

    public SpeTargetDescriptionRow(@NonNull SpeTargetDescription speTraget, @NonNull Configurations configurations) {
        this.speTraget = speTraget;
        this.configurations = configurations;
    }

    public @NonNull SpeTargetDescription getTargetDescription() {
        return this.speTraget;
    }

    @Override
    public boolean isEnabled() {
        return !this.configurations.isAlreadyAddedToCollectEvents(this.speTraget);
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        return this.speTraget.getName();
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }

    @Override
    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        if (this.isEnabled()) {
            return super.getBackgroundColor(device, selected, active);
        }
        if (selected && active) {
            return Colors.getDarkGray();
        }
        if (selected) {
            return Colors.getGray();
        }
        return Colors.create(224, 224, 224);
    }

    @Override
    public Color getForegroundTextColor(boolean selected, boolean active) {
        return Colors.getText(selected && active);
    }

    @Override
    public @NonNull IAvailableEvent getData() {
        return this.speTraget;
    }

    @Override
    public @NonNull BaseRow getBaseRow() {
        return this;
    }

    @Override
    public @NonNull Set<String> getSources() {
        return new HashSet<String>();
    }
}

