/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.Option;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.CategoryRow;
import com.arm.streamline.counterconfig.outline.CoCategoryRow;
import com.arm.streamline.counterconfig.outline.CounterRow;
import com.arm.streamline.counterconfig.outline.CountersOutline;
import com.arm.streamline.counterconfig.outline.IAvailableEventsRow;
import com.arm.streamline.counterconfig.outline.IEventConfigurationRow;
import com.arm.streamline.counterconfig.outline.IEventRow;
import com.arm.streamline.counterconfig.outline.StockCounterRow;
import com.arm.streamline.counterconfig.outline.TargetCounterRow;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.ICellMouseHandler;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.Platform;
import com.arm.utils.text.NumericStringComparator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CounterCell
implements ICell<SimpleColumn>,
ICellMouseHandler<SimpleColumn> {
    private final @NonNull Image enabledEbsImage;
    private final @NonNull Image disabledEbsImage;
    private final @NonNull Rectangle imgBounds;
    private final @NonNull Configurations configurations;
    private static final int OPTIONS_WIDTH = 12;
    private static final int H_MARGIN = 4;
    private static final int V_MARGIN = 1;

    public CounterCell(@NonNull Configurations configurations) {
        this.configurations = configurations;
        this.enabledEbsImage = StreamlinePlugin.getImage("Target.png");
        this.disabledEbsImage = new Image((Device)Display.getDefault(), this.enabledEbsImage, 1);
        this.imgBounds = this.enabledEbsImage.getBounds();
    }

    private static String getData(@Nullable Row<SimpleColumn> row, @NonNull SimpleColumn column, boolean nullOK) {
        if (row != null) {
            String text = row.getDataAsText(column);
            return text == null ? (nullOK ? null : "") : text;
        }
        return column.toString();
    }

    private static Color getForegroundTextColor(@Nullable Row<SimpleColumn> row, boolean selected, boolean active) {
        if (row instanceof IEventRow && ((IEventRow)((Object)row)).getBaseRow().isHighlighted()) {
            selected = false;
        }
        if (row instanceof BaseRow) {
            return ((BaseRow)row).getForegroundTextColor(selected, active);
        }
        return Colors.getText(selected && active);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Menu getOptionsMenu(@NonNull CountersOutline outline, StockCounterRow row) {
        StockCounter counter = row.getCounter();
        if (CounterCell.hasCombinationsAvailableToChange(counter)) {
            @NonNull @Nullable Collection options = counter.getAllOptions();
            @NonNull @Nullable Collection counterSets = counter.getAllCounterSets();
            boolean showOptions = options.size() > 1;
            boolean showCounterSets = counterSets.size() > 1;
            Menu menu = new Menu((Control)outline);
            for (CounterSet counterSet : counterSets) {
                for (Option option : options) {
                    MenuItem item = new MenuItem(menu, 32);
                    StringBuilder text = new StringBuilder();
                    if (showOptions && option != null) {
                        text.append(option.getName());
                        text.append(" (");
                        text.append(option.getDescription());
                        text.append(")");
                        if (showCounterSets) {
                            text.append(" - ");
                        }
                    }
                    if (showCounterSets && counterSet != null) {
                        text.append(counterSet.getTitle());
                    }
                    item.setText(text.toString());
                    final StockCounter.Combination combo = new StockCounter.Combination(counter, option, counterSet);
                    if (this.configurations.isInUse(counter, option, (Collection<String>)counterSet)) {
                        item.setSelection(true);
                        item.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent event) {
                            }

                            public void widgetSelected(SelectionEvent event) {
                                CounterCell.this.configurations.removeCombination(combo);
                            }
                        });
                    } else {
                        item.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent event) {
                            }

                            public void widgetSelected(SelectionEvent event) {
                                CounterCell.this.configurations.addCombinations(Stream.of(combo));
                            }
                        });
                    }
                    item.setEnabled(true);
                }
            }
            return menu;
        }
        return null;
    }

    private static boolean hasCombinationsAvailableToChange(@NonNull StockCounter counter) {
        return counter.getAllOptions().size() > 1 || counter.getAllCounterSets().size() > 1;
    }

    @Override
    public int compare(SimpleColumn column, Row<SimpleColumn> one, Row<SimpleColumn> two) {
        return NumericStringComparator.caselessCompareStrings((String)one.getDataAsText(column), (String)two.getDataAsText(column));
    }

    private static @NonNull Rectangle getCellBounds(Rectangle bounds) {
        return new Rectangle(bounds.x + 4, bounds.y + 1, bounds.width - 8, bounds.height - 2);
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<SimpleColumn> row, SimpleColumn column, boolean selected, boolean active) {
        StockCounterRow scr;
        BaseRow cr;
        Rectangle cellBounds = CounterCell.getCellBounds(bounds);
        int cellHeight = cellBounds.height;
        int x = cellBounds.x;
        int cellWidth = cellBounds.width;
        int y = cellBounds.y;
        if (row instanceof BaseRow) {
            if (((BaseRow)row).isHighlighted()) {
                gc.setBackground(Colors.lighten(Colors.getYellow(), 75));
                gc.fillRectangle(bounds);
            }
            OutlineModel<SimpleColumn> owner = row.getOwner();
            if (row instanceof IAvailableEventsRow || row instanceof IEventConfigurationRow) {
                int ebsStart = x -= owner.getIndentWidth();
                if (row instanceof CounterRow && (cr = (CounterRow)row).supportsEventBasedSampling()) {
                    boolean ebsTarget = cr.isEbsTarget(this.configurations);
                    Image image = ebsTarget ? this.enabledEbsImage : this.disabledEbsImage;
                    gc.drawImage(image, x, bounds.y + (bounds.height - this.imgBounds.height) / 2);
                }
                cellWidth -= (x += this.imgBounds.width + 4) - ebsStart;
            }
        }
        Font savedFont = gc.getFont();
        gc.setFont(row instanceof CoCategoryRow ? Fonts.getFontWithStyle(Fonts.getNormal(), 2) : Fonts.getNormal());
        gc.setForeground(CounterCell.getForegroundTextColor(row, selected, active));
        int right = TextDrawing.drawString(gc, CounterCell.getData(row, column, false), x, y, cellWidth, cellHeight, 16384, 0x1000000);
        if (row instanceof StockCounterRow && CounterCell.hasCombinationsAvailableToChange((scr = (StockCounterRow)row).getCounter())) {
            int xx = right + 6;
            scr.setPopupCenter(xx);
            y = bounds.y + bounds.height / 2 - 2;
            int offset = Platform.isWindows() ? 5 : 4;
            int i = 0;
            while (i < 5) {
                gc.drawLine(xx + i - 4, y + i, xx + offset - i, y + i);
                ++i;
            }
        }
        if (row instanceof CategoryRow) {
            cr = (CategoryRow)row;
            Image image = row.getImage(column);
            if (image != null) {
                int imageX = right + 4;
                int imageY = bounds.y + bounds.height / 2 - image.getImageData().height / 2;
                gc.drawImage(image, imageX, imageY);
                ((CategoryRow)cr).imageX = imageX;
                ((CategoryRow)cr).imageWidth = image.getImageData().width;
            } else {
                ((CategoryRow)cr).imageX = 0;
                ((CategoryRow)cr).imageWidth = 0;
            }
        }
        gc.setFont(savedFont);
    }

    @Override
    public int getMinimumContentWidth() {
        return 0;
    }

    @Override
    public Point getPreferredSize(Row<SimpleColumn> row, SimpleColumn column) {
        Point size;
        String data = CounterCell.getData(row, column, true);
        Point point = size = data != null ? FontInfo.get(Fonts.getNormal()).getExtent(data) : new Point(0, 0);
        if (row instanceof CounterRow) {
            Rectangle bounds = StreamlinePlugin.getImage("Target.png").getBounds();
            size.x += bounds.width + 4 - row.getOwner().getIndentWidth() + 4;
            if (row instanceof StockCounterRow && CounterCell.hasCombinationsAvailableToChange(((StockCounterRow)row).getCounter())) {
                size.x += 12;
            }
            if (size.y < bounds.height) {
                size.y = bounds.height;
            }
        }
        size.x += 8;
        size.y += 2;
        return size;
    }

    @Override
    public String getToolTipText(Outline<SimpleColumn> outline, Point where, Row<SimpleColumn> row, SimpleColumn column) {
        if (row instanceof CounterRow) {
            if (this.isOverEbsTarget(outline, where, (CounterRow)row, column)) {
                return CountersMessages.EVENT_BASED_SAMPLING;
            }
        } else if (row instanceof CategoryRow && CounterCell.isOverSyncImage(outline, where, (CategoryRow)row, column)) {
            return CountersMessages.SYNCHRONIZED;
        }
        return null;
    }

    @Override
    public boolean handleCellMouseDoubleClick(Outline<SimpleColumn> outline, Point where, int stateMask, int button, Row<SimpleColumn> row, SimpleColumn column) {
        return false;
    }

    @Override
    public boolean handleCellMouseDown(final Outline<SimpleColumn> outline, Point where, int stateMask, int button, Row<SimpleColumn> row, SimpleColumn column) {
        if (row instanceof StockCounterRow) {
            StockCounterRow scr = (StockCounterRow)row;
            Rectangle bounds = outline.getCellBounds(row, column);
            if (CounterCell.hasCombinationsAvailableToChange(scr.getCounter())) {
                Menu menu;
                int space = 16;
                int x = scr.getPopupCenter() - space / 2;
                Rectangle hitArea = new Rectangle(x, bounds.y, space + 1, bounds.height);
                if (hitArea.contains(where) && (menu = this.getOptionsMenu((CountersOutline)outline, scr)) != null) {
                    menu.setLocation(outline.toDisplay(outline.fromVirtual(where)));
                    menu.addMenuListener(new MenuListener(){

                        public void menuHidden(MenuEvent event) {
                            Task.callOnUIThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (!menu.isDisposed()) {
                                        menu.dispose();
                                    }
                                    outline.cellMouseHandlingFinished();
                                }
                            });
                        }

                        public void menuShown(MenuEvent event) {
                        }
                    });
                    menu.setVisible(true);
                    return true;
                }
            }
        }
        if (row instanceof CounterRow) {
            CounterRow counterRow = (CounterRow)row;
            boolean overEbsTarget = this.isOverEbsTarget(outline, where, counterRow, column);
            if (row instanceof TargetCounterRow) {
                TargetCounterRow targetRow = (TargetCounterRow)row;
                boolean ebsIsCurrentlyEnabled = targetRow.isEbsTarget(this.configurations);
                @NonNull TargetCounter counter = ((TargetCounterRow)counterRow).getCounter();
                if (overEbsTarget) {
                    this.configurations.toggleEbs(!ebsIsCurrentlyEnabled, counter);
                }
            } else if (row instanceof StockCounterRow) {
                List<@NonNull T> targetCountersInUse = this.configurations.getCountersOf(counterRow.getStockCounter()).collect(Collectors.toList());
                StockCounterRow targetRow = (StockCounterRow)row;
                boolean ebsTarget = targetRow.isEbsTarget(this.configurations);
                if (targetCountersInUse.size() == 1 && overEbsTarget) {
                    @NonNull TargetCounter targetCounter = (TargetCounter)targetCountersInUse.get(0);
                    this.configurations.toggleEbs(!ebsTarget, targetCounter);
                }
            }
        }
        return false;
    }

    private boolean isOverEbsTarget(Outline<SimpleColumn> outline, Point where, @NonNull CounterRow row, @NonNull SimpleColumn column) {
        if (row.getStockCounter().supportsEventBasedSampling()) {
            Rectangle cellBounds = CounterCell.getCellBounds(outline.getCellBounds(row, column));
            Rectangle hitArea = new Rectangle(cellBounds.x, cellBounds.y, this.imgBounds.width, cellBounds.height);
            return hitArea.contains(where);
        }
        return false;
    }

    private static boolean isOverSyncImage(Outline<SimpleColumn> outline, Point where, @NonNull CategoryRow row, @NonNull SimpleColumn column) {
        Rectangle bounds = outline.getCellBounds(row, column);
        int x = row.imageX;
        int width = row.imageWidth;
        Rectangle hitArea = new Rectangle(x, bounds.y, width, bounds.height);
        return hitArea.contains(where);
    }

    @Override
    public void handleCellMouseMove(Outline<SimpleColumn> outline, Point where, int stateMask) {
    }

    @Override
    public void handleCellMouseUp(Outline<SimpleColumn> outline, Point where, int stateMask) {
    }
}

