/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.IStickyHeader;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.SimpleColumn;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public abstract class CategoryBaseRow
extends BaseRow
implements IStickyHeader {
    private final @NonNull Category mCategory;
    protected final @NonNull Configurations mConfigurations;

    public CategoryBaseRow(@NonNull Configurations configurations, @NonNull Category category) {
        this.mConfigurations = configurations;
        this.mCategory = category;
    }

    protected abstract String getAvailableText();

    @Override
    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        return Colors.getBlack();
    }

    public @NonNull Category getCategory() {
        return this.mCategory;
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        return this.getText();
    }

    private @NonNull String getText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mCategory.getName());
        String availableText = this.getAvailableText();
        if (!availableText.isEmpty()) {
            builder.append(" - [");
            builder.append(availableText);
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public Color getForegroundTextColor(boolean selected, boolean active) {
        return Colors.getWhite();
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }

    public @NonNull String toString() {
        return this.getText();
    }
}

