/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.model;

import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.databrowser.ITargetXml;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CounterConfiguration {
    private final @NonNull Configurations mConfigurations;
    private final @NonNull CounterNames mCounterNames = new CounterNames();
    private final @NonNull Events mEvents;
    private boolean mSupportsEBS = true;
    private final @NonNull ITargetXml mTarget;

    public CounterConfiguration(@NonNull ITargetXml target) throws IOException {
        this(target, true);
    }

    public CounterConfiguration(@NonNull ITargetXml target, boolean load) throws IOException {
        Events events;
        this.mTarget = target;
        this.mCounterNames.load(new ByteArrayInputStream(target.getCountersXml()));
        @NonNull List<@NonNull String> speIds = this.mCounterNames.getSpeIds();
        this.mEvents = events = Events.create((InputStream)new ByteArrayInputStream(this.mTarget.getEventsXml()), this.mCounterNames::contains, speIds::contains, this.mCounterNames.getClusterNames());
        this.mConfigurations = new Configurations(events);
        if (load) {
            this.mConfigurations.load(new ByteArrayInputStream(this.mTarget.getConfigurationXml()));
        }
    }

    public @NonNull Configurations getConfigurations() {
        return this.mConfigurations;
    }

    public @NonNull Events getEvents() {
        return this.mEvents;
    }

    public @NonNull CounterNames getCounterNames() {
        return this.mCounterNames;
    }

    public @NonNull IWarnings getSetupWarnings() {
        return this.mCounterNames.getSetupWarnings();
    }

    public void importConfig(@NonNull String path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(path);){
            this.mConfigurations.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isEbsConfigValid() {
        int ebsCount = this.mConfigurations.getNumberOfEbsCounters();
        if (ebsCount == 0) {
            return true;
        }
        if (!this.mSupportsEBS) {
            return false;
        }
        return ebsCount <= 1 || this.mCounterNames.isSupportsMultipleEbsCounters();
    }

    public void loadDefaults() throws IOException {
        this.mConfigurations.load(new ByteArrayInputStream(this.mTarget.getDefaultsXml()));
    }

    public @Nullable IOException save(boolean discardExisting) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.mConfigurations.save(baos);
        return this.mTarget.sendConfigurationXml(baos.toByteArray(), discardExisting);
    }

    public boolean supportsEBS() {
        return this.mSupportsEBS;
    }
}

