/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.IStickyHeader;
import com.arm.streamline.counterconfig.outline.SpeTargetDescriptionRow;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class SpeRow
extends BaseRow
implements IStickyHeader {
    public SpeRow(@NonNull Collection<@NonNull SpeTargetDescription> values, Pattern filter, @NonNull Configurations configurations) {
        this.setCanHaveChildren(true);
        this.setOpen(true);
        this.addSpeTargets(values, filter, configurations);
    }

    private void addSpeTargets(@NonNull Collection<@NonNull SpeTargetDescription> values, Pattern filter, @NonNull Configurations configurations) {
        values.stream().forEach(spe -> {
            @NonNull CharSequence speName = (CharSequence)NullChecking.neverNull((Object)spe.getName());
            if (spe.isAvailableInTarget() && (filter == null || filter.matcher(speName).find())) {
                this.addChild(new SpeTargetDescriptionRow((SpeTargetDescription)spe, configurations));
            }
        });
    }

    @Override
    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        return Colors.getBlack();
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public Color getForegroundTextColor(boolean selected, boolean active) {
        return Colors.getWhite();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        return CountersMessages.STAT_PROF_EXTN;
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }
}

