/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.outline.CoCategoryRow;
import com.arm.streamline.counterconfig.outline.IStickyHeader;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public abstract class BaseCountersOutline
extends Outline<SimpleColumn> {
    protected BaseCountersOutline(Composite parent, @NonNull OutlineModel<SimpleColumn> model, boolean border) {
        super(parent, model, border, true);
        model.setShowOutline(false);
        this.setPermitDragSelect(false);
        this.setAllowColumnResize(false);
        this.setShowColumnLines(false);
        this.setColumnFill(true);
    }

    @Override
    public Color getRowDividerColor(int rowIndex) {
        Row row;
        OutlineModel model = this.getModel();
        if (rowIndex < model.getRowCount() - 1 && (row = model.getRowAtIndex(rowIndex)) instanceof CoCategoryRow && model.getRowAtIndex(rowIndex + 1) instanceof CoCategoryRow) {
            return row.getBackgroundColor(null, false, false);
        }
        return super.getRowDividerColor(rowIndex);
    }

    @Override
    public int overRowIndex(int y) {
        Point panelZeroPt = this.toVirtual(new Point(0, 0));
        int index = super.overRowIndex(panelZeroPt.y);
        OutlineModel model = this.getModel();
        if (index >= 0) {
            Row row = model.getRowAtIndex(index);
            int upcomingRowIndex = index + 1;
            if (!(row instanceof IStickyHeader) && (row = row.getParent()) instanceof IStickyHeader) {
                index = model.getIndexOfRow(row);
            }
            if (row instanceof IStickyHeader) {
                Row upcomingRow;
                SimpleColumn column = (SimpleColumn)model.getColumnAtIndex(0);
                if (upcomingRowIndex < model.getRowCount() && (upcomingRow = model.getRowAtIndex(upcomingRowIndex)) instanceof IStickyHeader) {
                    Rectangle cellBounds = this.getCellBounds(upcomingRow, column);
                    panelZeroPt.y = cellBounds.y - (cellBounds.height + 1);
                }
                Rectangle cellBounds = this.getCellBounds(row, column);
                if (y >= panelZeroPt.y && y < panelZeroPt.y + cellBounds.height) {
                    return index;
                }
            }
        }
        return super.overRowIndex(y);
    }

    public void setDragStart(DragSourceEvent event, @NonNull LocalObjectTransfer<Row<SimpleColumn>> transfer) {
        super.dragStart(event);
        if (event.doit) {
            ArrayList<Row<SimpleColumn>> rows = new ArrayList<Row<SimpleColumn>>();
            for (Row<SimpleColumn> row : this.getModel().getSelectionAsList()) {
                if (!this.isRowDraggable(row)) continue;
                rows.add(row);
            }
            int n = rows.size();
            if (n > 0) {
                String msg = n == 1 ? CountersMessages.SINGLE_DRAG : String.format(CountersMessages.MULTIPLE_DRAG_COUNT, n);
                event.image = TextDrawing.createTextImage(msg, this.getDisplay());
                event.offsetX = event.image.getBounds().width / 2;
                event.offsetY = -8;
                transfer.setTransferObjects(rows.toArray(new Row[rows.size()]));
            } else {
                event.doit = false;
            }
        }
    }

    public void sizeToFit() {
        this.sizeColumnsToFit();
        this.adjustScrollBarsForContent();
    }

    @Override
    protected void drawMore(GC gc, boolean up, int amt) {
    }

    @Override
    protected void drawRowBackground(GC gc, Rectangle bounds, Row<SimpleColumn> row, boolean selected, boolean active) {
        if (row instanceof IStickyHeader) {
            Pattern pattern = new Pattern(gc.getDevice(), 0.0f, (float)bounds.y, 0.0f, (float)(bounds.y + bounds.height), Colors.getDarkGray(), Colors.getBlack());
            gc.setBackgroundPattern(pattern);
            gc.fillRectangle(bounds);
            pattern.dispose();
        } else {
            super.drawRowBackground(gc, bounds, row, selected, active);
        }
    }

    @Override
    protected void handleKeyDown(Event event) {
        super.handleKeyDown(event);
        if (event.doit && event.keyCode == 27) {
            this.getShell().traverse(2);
        }
    }

    protected abstract boolean isRowDraggable(Row<SimpleColumn> var1);

    @Override
    protected void paintCanvas(GC gc) {
        super.paintCanvas(gc);
        Point panelZeroPt = this.toVirtual(new Point(0, 0));
        int index = super.overRowIndex(panelZeroPt.y);
        OutlineModel<SimpleColumn> model = this.getModel();
        if (index >= 0) {
            Row<SimpleColumn> row = model.getRowAtIndex(index);
            int upcomingRowIndex = index + 1;
            if (!(row instanceof IStickyHeader) && (row = row.getParent()) instanceof IStickyHeader) {
                index = model.getIndexOfRow(row);
            }
            if (row instanceof IStickyHeader) {
                Row upcomingRow;
                if (upcomingRowIndex < model.getRowCount() && (upcomingRow = model.getRowAtIndex(upcomingRowIndex)) instanceof IStickyHeader) {
                    Rectangle cellBounds = this.getCellBounds(upcomingRow, (SimpleColumn)model.getColumnAtIndex(0));
                    panelZeroPt.y = cellBounds.y - (cellBounds.height + 1);
                }
                this.overdraw(gc, row, index, panelZeroPt);
            }
        }
    }

    @Override
    protected Rectangle repaintSelectionInternal() {
        Rectangle bounds = this.getClientArea();
        this.redraw(bounds.x, bounds.y, bounds.width, this.getModel().getRowHeight() + 1, false);
        return super.repaintSelectionInternal();
    }

    private void overdraw(GC gc, @NonNull Row<SimpleColumn> row, int index, Point panelZeroPt) {
        OutlineModel<SimpleColumn> model = this.getModel();
        boolean rowSelected = model.isRowSelected(row);
        boolean active = this.isFocusControl();
        SimpleColumn column = (SimpleColumn)model.getColumnAtIndex(0);
        Rectangle bounds = this.getCellBounds(row, column);
        int indent = model.getIndentWidth(row, column);
        bounds.x = panelZeroPt.x;
        bounds.y = panelZeroPt.y;
        this.drawRowBackground(gc, bounds, row, rowSelected, active);
        bounds.x += indent;
        bounds.width -= indent;
        column.drawRowCell(gc, bounds, row, rowSelected, active);
        bounds.x -= indent;
        bounds.width += indent;
        gc.setForeground(this.getRowDividerColor(index));
        gc.drawLine(bounds.x, bounds.y - 1, bounds.width, bounds.y - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height, bounds.width, bounds.y + bounds.height);
    }
}

