/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.cmdline.CmdLine;
import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.cmdline.ExportDisasm;
import com.arm.streamline.cmdline.IReportPrintStream;
import com.arm.streamline.cmdline.ValueReporting;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.editortabs.callpath.CallPathColumn;
import com.arm.streamline.editortabs.callpath.CallPathRow;
import com.arm.streamline.editortabs.function.FunctionColumn;
import com.arm.streamline.editortabs.function.FunctionRow;
import com.arm.streamline.editortabs.log.LogEntryColumns;
import com.arm.streamline.editortabs.log.LogEntryRow;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.editortabs.report.TableExport;
import com.arm.streamline.editortabs.timeline.ExportHeatMapDataJob;
import com.arm.streamline.editortabs.timeline.HeatmapExportFormatter;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.FilteredInstructionsFile;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.model.cam.CAMJob;
import com.arm.streamline.model.cam.CAMTrack;
import com.arm.streamline.model.cam.CAMViewConfig;
import com.arm.streamline.model.cam.CAM_Model;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.model.timeline.ProcessIdentifierRegex;
import com.arm.streamline.model.timeline.ThreadData;
import com.arm.streamline.protocol.capture.apc.protocol.external.MaliOpenCLCAMGenerator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import com.arm.streamline.utility.text.ScaledFormat;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReportProcessor {
    protected boolean mAnalyzing;
    protected boolean mAnalyzingEarlyStop;
    private @NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> disasmSourcesAndImageNames = Collections.emptyMap();
    private @NonNull Set<@NonNull String> mCallPathSources = Collections.emptySet();
    private boolean mDumpBookmark;
    private boolean mDumpCallPath;
    private boolean mDumpCAM;
    private boolean mDumpFunctions;
    private boolean mDumpHeatmap;
    private boolean mDumpIndividualThreads;
    private boolean mDumpLog;
    private boolean mDumpOpenCL;
    private boolean mDumpTimeline;
    private boolean mDumpWarnings;
    private Format mFormat = Format.COMMAS;
    private @NonNull Set<@NonNull String> mFunctionSources = Collections.emptySet();
    private @NonNull Set<@NonNull String> mHeatmapSourceNames = Collections.emptySet();
    private String mSpecificProcessRegex;
    private String mThreadSpecifier;

    public static void dumpTimelineForEachThread(Analysis analysis, ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, long start, long stop, IReportPrintStream stream, Format format, IProgressMonitor monitor, @NonNull List<@NonNull ThreadData> list) throws IOException {
        for (ThreadData thread : list) {
            int uid = thread.getUID();
            String name = (String)thread.getNameAndTid().first;
            int tid = (Integer)thread.getNameAndTid().second;
            Throwable throwable = null;
            Object var17_16 = null;
            try (PrintStream out = stream.forThreadTimeline(tid);){
                TIntHashSet selectedThread = new TIntHashSet();
                selectedThread.add(uid);
                ReportProcessor.emitTitle(out, String.format("Timeline Counter Values (for thread '%s', tid: %d)", name, tid));
                ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, selectedThread, out, format, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void dumpReportOfFilteredProcessesAndThreads(ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, int start, int stop, IReportPrintStream stream, Format format, PrintStream out, Analysis analysis, String threadSpecifier, Pair<List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filtered, boolean individualThreads) throws ReportException, IOException {
        if (out == null) {
            throw new IOException("Output stream can't be null");
        }
        ReportProcessor.emitThreadProcessData(out, (List)filtered.first, threadSpecifier, analysis);
        TIntHashSet threadDataUids = new TIntHashSet((Collection)((List)filtered.second).stream().map(ThreadData::getUID).collect(Collectors.toList()));
        ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, threadDataUids, out, format, (IProgressMonitor)new NullProgressMonitor());
        if (individualThreads) {
            ReportProcessor.dumpTimelineForEachThread(analysis, valueReporting, zoomLevel, start, stop, stream, format, (IProgressMonitor)new NullProgressMonitor(), (List)filtered.second);
        }
    }

    private static String threadsIn(List<@NonNull ProcessData> processData, Analysis analysis) {
        ArrayList<@NonNull String> allThreadsforProcess = new ArrayList<String>();
        List<@NonNull ThreadData> processThreads = ReportProcessor.getMatchingThreadsForProcesses(processData, null, analysis.getUniqueIdMap());
        for (ThreadData thread : processThreads) {
            @NonNull Pair<@NonNull String, @NonNull Integer> tData = thread.getNameAndTid();
            allThreadsforProcess.add(String.format("%s#%d%n", tData.first, tData.second));
        }
        Collections.sort(allThreadsforProcess, String.CASE_INSENSITIVE_ORDER);
        return String.join((CharSequence)"", allThreadsforProcess);
    }

    private static void dumpReportOfFilteredProcesses(ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, Analysis analysis, int start, int stop, PrintStream out, IReportPrintStream stream, Format format, String processSpecifier, @NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filtered, boolean individualThreads) throws IOException {
        if (out == null) {
            throw new IOException("Output stream can't be null");
        }
        ReportProcessor.emitProcessData(processSpecifier, (List)filtered.first, stream, out);
        ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, ReportProcessor.asProcessUIDSet((List)filtered.first), out, format, (IProgressMonitor)new NullProgressMonitor());
        if (individualThreads) {
            ReportProcessor.dumpTimelineForEachThread(analysis, valueReporting, zoomLevel, start, stop, stream, format, (IProgressMonitor)new NullProgressMonitor(), (List)filtered.second);
        }
    }

    private static void dumpReportUnfiltered(ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, Analysis analysis, int start, int stop, @NonNull PrintStream out, IReportPrintStream stream, Format format, List<@NonNull ProcessData> processes, boolean individualThreads) throws IOException {
        ReportProcessor.emitTitle(out, CmdLineMessages.TIME_TITLE_DEFAULT);
        ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, null, out, format, (IProgressMonitor)new NullProgressMonitor());
        if (individualThreads) {
            List<@NonNull ThreadData> processThreads = ReportProcessor.getMatchingThreadsForProcesses(processes, null, analysis.getUniqueIdMap());
            ReportProcessor.dumpTimelineForEachThread(analysis, valueReporting, zoomLevel, start, stop, stream, format, (IProgressMonitor)new NullProgressMonitor(), processThreads);
        }
    }

    private static @NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filterBySpecifiers(String processSpecifier, String threadSpecifier, Analysis analysis) throws ReportException {
        IProcessDataProvider processDataProvider = analysis.getProcessDataProvider();
        @NonNull List<@NonNull ProcessData> processDataList = ReportProcessor.filterProcesses(processSpecifier, processDataProvider);
        @NonNull ProcessIdentifierRegex threadIdentifierRegex = ReportProcessor.getThreadIdentifierRegex(threadSpecifier);
        @NonNull List<@NonNull ThreadData> threadDataList = ReportProcessor.getMatchingThreadsForProcesses(processDataList, threadIdentifierRegex, analysis.getUniqueIdMap());
        return new Pair(processDataList, threadDataList);
    }

    private static @NonNull List<@NonNull ThreadData> getMatchingThreadsForProcesses(List<@NonNull ProcessData> processDataList, ProcessIdentifierRegex threadIdentifierRegex, @NonNull IUniqueIds map) {
        Stream result = processDataList.stream().map(proc -> ReportProcessor.getThreadsForProcess(map, map.findProcess(proc.getUID()).orElse(null))).flatMap(list -> list.stream());
        if (threadIdentifierRegex == null) {
            return result.collect(Collectors.toList());
        }
        return result.filter(thrd -> threadIdentifierRegex.match(thrd.getNameAndTid())).collect(Collectors.toList());
    }

    private static List<ThreadData> getThreadsForProcess(@NonNull IUniqueIds map, UniqueProcess process) {
        ArrayList<ThreadData> threadData = new ArrayList<ThreadData>();
        map.getThreadsOf(process).forEach(thrd -> threadData.add(new ThreadData(0, thrd.getUid(), ((AbstractPerVmId.PerVmNonUniqueTid)thrd.getNonUid().getId()).id, thrd.getNonUid().getNameOrUnresolved())));
        return threadData;
    }

    private static @NonNull ProcessIdentifierRegex getThreadIdentifierRegex(String threadSpecifier) throws ReportException {
        return threadSpecifier == null ? ProcessIdentifierRegex.MATCH_ANY : ReportProcessor.parseOrThrow(threadSpecifier, "Invalid value for thread specifier: ");
    }

    private static @NonNull List<@NonNull ProcessData> filterProcesses(@Nullable String processSpecifier, @NonNull IProcessDataProvider processProvider) throws ReportException {
        if (processSpecifier != null) {
            try {
                return processProvider.getSpecificProcessData(processSpecifier);
            }
            catch (PatternSyntaxException e) {
                throw new ReportException(String.format("Invalid value for process specifier: %s", e.getMessage()));
            }
        }
        return processProvider.getProcessData();
    }

    private static @NonNull ProcessIdentifierRegex parseOrThrow(@NonNull String matchSpecifier, @NonNull String errorMsgPrefix) throws ReportException {
        try {
            return ProcessIdentifierRegex.parse(matchSpecifier);
        }
        catch (PatternSyntaxException e) {
            throw new ReportException(errorMsgPrefix + e.getMessage());
        }
    }

    private static void emitProcessData(String processSpecifier, List<@NonNull ProcessData> processDataList, IReportPrintStream stream, PrintStream out) throws IOException {
        if (processDataList.size() > 1) {
            stream.message(MessageFormat.format(CmdLineMessages.MORE_THAN_ONE_PROCESSES_FOUND, processSpecifier));
        }
        String matchedProcesses = processDataList.stream().map(processData -> {
            boolean validID = processData.getProcessID() > 0;
            return String.format("<%s%s%s>", processData.getProcessName(), validID ? Character.valueOf('#') : "", validID ? Integer.valueOf(processData.getProcessID()) : "");
        }).collect(Collectors.joining(", "));
        ReportProcessor.emitTitle(out, MessageFormat.format(CmdLineMessages.TIME_TITLE_FILTERED_PROCESS, matchedProcesses.toString()));
    }

    private static void emitThreadProcessData(PrintStream out, List<@NonNull ProcessData> processData, String threadSpecifier, Analysis analysis) throws ReportException {
        @NonNull ProcessIdentifierRegex threadIdentifierRegex = ReportProcessor.getThreadIdentifierRegex(threadSpecifier);
        IUniqueIds map = analysis.getUniqueIdMap();
        StringBuilder result = new StringBuilder();
        Collections.sort(processData, (proc1, proc2) -> {
            int pid2;
            int pid1 = (Integer)proc1.getNameAndPid().second;
            return pid1 < (pid2 = ((Integer)proc2.getNameAndPid().second).intValue()) ? -1 : (pid1 > pid2 ? 1 : 0);
        });
        processData.stream().forEach(proc -> {
            @NonNull List<ThreadData> threadsForProcess = ReportProcessor.getThreadsForProcess(map, map.findProcess(proc.getUID()).orElse(null));
            Collections.sort(threadsForProcess, (thrd1, thrd2) -> {
                int tid2;
                int tid1 = (Integer)thrd1.getNameAndTid().second;
                return tid1 < (tid2 = ((Integer)thrd2.getNameAndTid().second).intValue()) ? -1 : (tid1 > tid2 ? 1 : 0);
            });
            threadsForProcess.stream().filter(thrd -> threadIdentifierRegex.match(thrd.getNameAndTid())).forEach(thrd -> {
                @NonNull Pair<@NonNull String, @NonNull Integer> procNamePid = proc.getNameAndPid();
                @NonNull @NonNull Pair<@NonNull String, @NonNull Integer> thrdNameTid = thrd.getNameAndTid();
                result.append(String.format("<%s#%d.%s#%d>,", procNamePid.first, procNamePid.second, thrdNameTid.first, thrdNameTid.second));
            });
        });
        ReportProcessor.emitTitle(out, MessageFormat.format(CmdLineMessages.TIME_TITLE_FILTERED_THREAD, result.toString()));
    }

    private static void generateProcessError(String processSpecifier, Analysis analysis) throws ReportException {
        Object wrongProcessError = String.format("Specifier '%s' did not match any process. Processes found are:%n", processSpecifier);
        ArrayList<@NonNull String> allAvailableProc = new ArrayList<String>();
        for (ProcessData process : analysis.getProcessDataProvider().getProcessData()) {
            Pair<@NonNull String, @NonNull Integer> processData = process.getNameAndPid();
            allAvailableProc.add(String.format("%s#%d%n", processData.first, processData.second));
        }
        Collections.sort(allAvailableProc, String.CASE_INSENSITIVE_ORDER);
        wrongProcessError = (String)wrongProcessError + String.join((CharSequence)"", allAvailableProc);
        throw new ReportException((String)wrongProcessError);
    }

    public static void dumpTimeline(Analysis analysis, ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, long start, long stop, TIntHashSet selectedProcessAndThreadIds, PrintStream out, Format format, IProgressMonitor monitor) {
        TimeUnit timeUnit = analysis.getTimeUnit();
        TIntHashSet selected = analysis.convertToThreadUIDs((TIntSet)selectedProcessAndThreadIds);
        List<@NonNull IChartDataProvider> timelines = analysis.getCharts().getCharts();
        monitor.beginTask(CmdLineMessages.TIMELINE_PROGRESS_TITLE, (int)(stop - start));
        long nextUpdate = System.currentTimeMillis() + 100L;
        ArrayList<String> titles = new ArrayList<String>();
        TIntArrayList columnMaxes = new TIntArrayList();
        titles.add(MessageFormat.format(CmdLineMessages.TIME, timeUnit.getBaseSymbol()));
        columnMaxes.add(ReportProcessor.formatTimeMaxWidth(stop, zoomLevel, timeUnit));
        for (IChartDataProvider timeline : timelines) {
            @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = timeline.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channels = coreInformationProvider.getChannelDescriptors();
            @NonNull List<@NonNull ISeriesDataProvider> series = timeline.getSeries();
            int sc = 0;
            String chartTitle = timeline.getTitle();
            String text = ScaledFormat.format(valueReporting == ValueReporting.PER_CORE ? timeline.getCoreLimit() : timeline.getAggregateLimit(), timeline.isPercentage(), -1, null);
            int limit = text.length() + 3;
            boolean hasMultipleVms = analysis.hasMultipleVms();
            while (sc < series.size()) {
                String name = series.get(sc).getName();
                String fullName = null;
                if (name != null) {
                    fullName = chartTitle + ':' + name;
                }
                switch (valueReporting) {
                    case PER_CORE: {
                        @Nullable DeviceType deviceType = coreInformationProvider.getDeviceType();
                        if (deviceType != null && channels.length > 1) {
                            ProcessingElementReference[] processingElementReferenceArray = channels;
                            int n = channels.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ProcessingElementReference channel = processingElementReferenceArray[n2];
                                if (name != null) {
                                    Object number;
                                    String vmNameAndNumber;
                                    String vmName;
                                    String string = vmName = hasMultipleVms ? (String)NullChecking.neverNullOr((Object)analysis.getVmName(channel.vmUID), (Object)"") : "";
                                    String string2 = hasMultipleVms ? (vmName.isEmpty() ? Long.toString(channel.vmUID) : String.format("%d: %s", channel.vmUID, name)) : (vmNameAndNumber = "");
                                    if (deviceType.isSystemWide()) {
                                        assert (hasMultipleVms);
                                        number = vmNameAndNumber;
                                    } else if (deviceType.isCPU()) {
                                        @Nullable ProcessingElementTopology topology = coreInformationProvider.getTopology(channel);
                                        number = (String)(hasMultipleVms ? vmNameAndNumber + " " : "") + (topology != null ? Integer.toString(topology.osID) : Integer.toString(channel.deviceNumber));
                                    } else {
                                        number = (String)(hasMultipleVms ? vmNameAndNumber + " " : "") + Integer.toString(channel.deviceNumber);
                                    }
                                    titles.add(MessageFormat.format(CmdLineMessages.PER, fullName, number));
                                } else {
                                    titles.add(null);
                                }
                                columnMaxes.add(limit);
                                ++n2;
                            }
                            break;
                        }
                    }
                    case AGGREGATE: {
                        titles.add(fullName);
                        columnMaxes.add(limit);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown ValueReporting variant: " + String.valueOf((Object)valueReporting));
                    }
                }
                ++sc;
            }
        }
        int cols = titles.size();
        String[] text = titles.toArray(new String[cols]);
        int[] widths = null;
        if (format == Format.SPACES) {
            widths = new int[cols];
            int i = 0;
            while (i < widths.length) {
                if (text[i] != null) {
                    widths[i] = Math.max(text[i].length(), columnMaxes.get(i));
                }
                ++i;
            }
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, text, 0x1000000);
        if (widths != null) {
            int i = 0;
            while (i < widths.length) {
                if (text[i] != null) {
                    text[i] = TableExport.makeFiller(widths[i], '-');
                }
                ++i;
            }
            TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, text, 16384);
        }
        int work = 0;
        if (start < (long)analysis.getBinCount(zoomLevel)) {
            int pos = 0;
            ArrayList<SeriesData> seriesData = new ArrayList<SeriesData>();
            long binIndex = start;
            while (binIndex < stop) {
                int j = 0;
                text[j++] = ReportProcessor.formatTimeForReport(binIndex, zoomLevel, timeUnit);
                if ((binIndex - start) % 1024L == 0L) {
                    seriesData.clear();
                    long end = Math.min(binIndex + 1024L - 1L, Math.min((long)analysis.getBinCountForDensestScale(), stop));
                    for (IChartDataProvider timeline : timelines) {
                        @NonNull List<@NonNull ISeriesDataProvider> series = timeline.getSeries();
                        for (ISeriesDataProvider serie : series) {
                            seriesData.add(new SeriesData(timeline, serie, binIndex, end, selected, valueReporting));
                        }
                    }
                    pos = 0;
                }
                for (SeriesData data : seriesData) {
                    if (data.mCoreData != null) {
                        int k = 0;
                        while (k < data.mCoreCount) {
                            if (text[j] != null) {
                                text[j] = ScaledFormat.formatForReport(data.mCoreData[k][pos], data.isPercentage, -1, null);
                            }
                            ++j;
                            ++k;
                        }
                        continue;
                    }
                    if (text[j] != null) {
                        text[j] = ScaledFormat.formatForReport(data.mData[pos], data.isPercentage, -1, null);
                    }
                    ++j;
                }
                ++pos;
                TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, text, 131072);
                ++work;
                long now = System.currentTimeMillis();
                if (now >= nextUpdate) {
                    nextUpdate = now + 100L;
                    monitor.worked(work);
                    work = 0;
                    if (monitor.isCanceled()) break;
                }
                ++binIndex;
            }
        }
        monitor.worked(work);
        writer.flush();
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpAllCAM(Analysis analysis, int start, int stop, IReportPrintStream stream, Format format, IProgressMonitor monitor) throws IOException {
        Analysis analysis2 = analysis;
        synchronized (analysis2) {
            for (CAMViewConfig config : CAMViewConfig.load(analysis)) {
                @NonNull File viewDir = CAM_Model.findViewPath(analysis.getReportDirectory(), config.getVmUID(), config.getName());
                if (!viewDir.isDirectory()) continue;
                CAM_Model model = new CAM_Model(analysis, viewDir, config);
                PrintStream out = stream.forCAM(config);
                ReportProcessor.emitTitle(out, String.format("%s %s%s", CmdLineMessages.CAM_TITLE, config.getName(), analysis.hasMultipleVms() ? String.format(" [%d - %s]", config.getVmUID(), analysis.getVmName(config.getVmUID())) : ""));
                ReportProcessor.dumpCAM(model, start, stop, out, format, monitor, analysis.getTimeUnit());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpAllOpenCL(Analysis analysis, int start, int stop, @NonNull IReportPrintStream stream, Format format, IProgressMonitor monitor) throws IOException {
        Analysis analysis2 = analysis;
        synchronized (analysis2) {
            for (CAMViewConfig config : CAMViewConfig.load(analysis)) {
                CAM_Model model;
                @NonNull File viewDir = CAM_Model.findViewPath(analysis.getReportDirectory(), config.getVmUID(), config.getName());
                if (!viewDir.isDirectory() || !(model = new CAM_Model(analysis, viewDir, config)).isOpenCL()) continue;
                @NonNull PrintStream out = stream.forOpenCL(config.getVmUID());
                ReportProcessor.emitTitle(out, CmdLineMessages.OPENCL_TITLE);
                ReportProcessor.dumpOpenCL(model, start, stop, out, format, monitor, analysis.getTimeUnit());
                break;
            }
        }
    }

    private static void dumpCAM(CAM_Model model, int start, int stop, PrintStream out, Format format, IProgressMonitor monitor, @NonNull TimeUnit timeUnit) {
        start *= 1000;
        stop *= 1000;
        String[] text = new String[6];
        int[] widths = new int[text.length];
        long nextUpdate = System.currentTimeMillis() + 100L;
        @NonNull List<@NonNull CAMJob> events = model.getAllJobsAsList();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        text[0] = CmdLineMessages.CAM_ID;
        text[1] = CmdLineMessages.CAM_NAME;
        text[2] = CmdLineMessages.CAM_START;
        text[3] = CmdLineMessages.CAM_STOP;
        text[4] = CmdLineMessages.CAM_PRIMARY_DEPENDENCY;
        text[5] = CmdLineMessages.CAM_DEPENDENCIES;
        widths[0] = Long.toString((long)model.getMaxEventId() & 0xFFFFFFFFL).length();
        widths[1] = model.getMaxCommandStringLength();
        widths[2] = timeUnit.maxWidth((double)model.getLastTime(), 1000.0, TimeUnit.Style.NO_UNIT);
        widths[3] = widths[2];
        widths[4] = model.getMaxDependencies() * (widths[0] + 1);
        widths[5] = model.getMaxDependencies() * (widths[0] + 1);
        int i = 0;
        while (i < text.length) {
            widths[i] = Math.max(widths[i], text[i].length());
            ++i;
        }
        TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 0x1000000);
        if (format == Format.SPACES) {
            i = 0;
            while (i < text.length) {
                text[i] = TableExport.makeFiller(widths[i], '-');
                ++i;
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 16384);
        }
        int work = 0;
        for (CAMJob item : events) {
            long startTime = Math.round((double)item.getStartTime() / 1000.0);
            long stopTime = Math.round((double)item.getStopTime() / 1000.0);
            if ((startTime < (long)start || startTime > (long)stop) && (stopTime < (long)start || stopTime > (long)stop)) continue;
            text[0] = Long.toString((long)item.getId() & 0xFFFFFFFFL);
            text[1] = model.getCookie(item.getCookieId());
            text[2] = timeUnit.formatInBase((double)(startTime * 1000L), 1000.0, TimeUnit.Style.NO_UNIT, true);
            text[3] = timeUnit.formatInBase((double)(stopTime * 1000L), 1000.0, TimeUnit.Style.NO_UNIT, true);
            text[4] = item.getPrimaryDependencyID() != -1 ? Long.toString((long)item.getPrimaryDependencyID() & 0xFFFFFFFFL) : "";
            if (item.getDependencyIDs().length == 0) {
                text[5] = "";
            } else {
                StringBuilder depStr = new StringBuilder(Long.toString((long)item.getDependencyIDs()[0] & 0xFFFFFFFFL));
                int i2 = 1;
                while (i2 < item.getDependencyIDs().length) {
                    depStr.append(",");
                    depStr.append(Long.toString((long)item.getDependencyIDs()[i2] & 0xFFFFFFFFL));
                    ++i2;
                }
                text[5] = depStr.toString();
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 131072);
            ++work;
            long now = System.currentTimeMillis();
            if (now < nextUpdate) continue;
            nextUpdate = now + 100L;
            monitor.worked(work);
            work = 0;
            if (monitor.isCanceled()) break;
        }
        monitor.worked(work);
        writer.flush();
        monitor.done();
    }

    private static void dumpOpenCL(CAM_Model model, int start, int stop, PrintStream out, Format format, IProgressMonitor monitor, @NonNull TimeUnit timeUnit) {
        start *= 1000;
        stop *= 1000;
        String[] text = new String[10];
        int[] widths = new int[text.length];
        long nextUpdate = System.currentTimeMillis() + 100L;
        @NonNull List<@NonNull CAMJob> events = model.getAllJobsAsList();
        TIntHashSet completedEventIds = new TIntHashSet();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        text[0] = CmdLineMessages.OPENCL_ID;
        text[1] = CmdLineMessages.OPENCL_COMMAND;
        text[2] = CmdLineMessages.OPENCL_INITIATED_TIME;
        text[3] = CmdLineMessages.OPENCL_TIME_TO_START;
        text[4] = CmdLineMessages.OPENCL_DURATION;
        text[5] = CmdLineMessages.OPENCL_THREAD;
        text[6] = CmdLineMessages.OPENCL_CONTEXT;
        text[7] = CmdLineMessages.OPENCL_DEVICE;
        text[8] = CmdLineMessages.OPENCL_QUEUE;
        text[9] = CmdLineMessages.OPENCL_DEPENDENCIES;
        widths[0] = Long.toString((long)model.getMaxEventId() & 0xFFFFFFFFL).length();
        widths[1] = model.getMaxCommandStringLength();
        widths[2] = timeUnit.maxWidth((double)model.getLastTime(), 1000.0, TimeUnit.Style.NO_UNIT);
        widths[3] = widths[2];
        widths[4] = widths[3];
        widths[5] = 10;
        widths[6] = 10;
        widths[7] = CmdLineMessages.OPENCL_DEVICE.length();
        widths[8] = 10;
        widths[9] = model.getMaxDependencies() * (widths[0] + 1);
        int i = 0;
        while (i < text.length) {
            widths[i] = Math.max(widths[i], text[i].length());
            ++i;
        }
        int maxDeviceTitleLength = widths[7];
        for (CAMTrack track : model.getTrackNonhierarchical()) {
            if (!MaliOpenCLCAMGenerator.isNotSpeciallyNamedOpenCLTrack((String)track.getTitle())) continue;
            maxDeviceTitleLength = Math.max(maxDeviceTitleLength, track.getTitle().length());
        }
        widths[7] = maxDeviceTitleLength;
        TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 0x1000000);
        if (format == Format.SPACES) {
            int i2 = 0;
            while (i2 < text.length) {
                text[i2] = TableExport.makeFiller(widths[i2], '-');
                ++i2;
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 16384);
        }
        int work = 0;
        for (CAMJob eventItem : events) {
            int[] dependencies;
            CAMTrack queueTrack;
            CAMTrack contextTrack;
            CAMJob item = ReportProcessor.getOpenCLRootItem(eventItem, model);
            long startTime = Math.round((double)item.getStartTime() / 1000.0);
            long stopTime = Math.round((double)item.getStopTime() / 1000.0);
            if (completedEventIds.contains(item.getId()) || (startTime < (long)start || startTime > (long)stop) && (stopTime < (long)start || stopTime > (long)stop)) continue;
            String commandName = model.getCookie(item.getCookieId());
            text[0] = Long.toString((long)item.getId() & 0xFFFFFFFFL);
            text[1] = commandName != null ? commandName : " ";
            text[2] = timeUnit.formatInBase((double)(1000L * startTime), 1000.0, TimeUnit.Style.NO_UNIT, true);
            text[3] = timeUnit.formatInBase((double)(1000L * ReportProcessor.getOpenCLCommandTimeToStart(item, model)), 1000.0, TimeUnit.Style.NO_UNIT, true);
            text[4] = timeUnit.formatInBase((double)(1000L * ReportProcessor.getOpenCLCommandDuration(item, model)), 1000.0, TimeUnit.Style.NO_UNIT, true);
            CAMTrack threadTrack = ReportProcessor.getOpenCLTrackForItem(ReportProcessor.getOpenCLRootItem(item, model), model, "Thread ");
            if (threadTrack != null) {
                text[5] = ReportProcessor.getOpenCLTrackNameWithoutPrefix(threadTrack.getTitle(), "Thread ");
            } else {
                threadTrack = model.getTrack(item.getTrackID());
            }
            CAMTrack contextDependentTrack = ReportProcessor.getOpenCLTrackForItem(ReportProcessor.getOpenCLRootItem(item, model), model, "Queue ");
            CAMTrack deviceTrack = null;
            if (contextDependentTrack != null) {
                deviceTrack = model.getTrack(contextDependentTrack.getParentId());
            }
            if (deviceTrack != null && (contextTrack = model.getTrack(deviceTrack.getParentId())) != null) {
                text[6] = ReportProcessor.getOpenCLTrackNameWithoutPrefix(contextTrack.getTitle(), "OpenCL Context: ");
            }
            if (deviceTrack != null) {
                text[7] = deviceTrack.getTitle();
            }
            if ((queueTrack = ReportProcessor.getOpenCLTrackForItem(ReportProcessor.getOpenCLRootItem(item, model), model, "Queue ")) != null) {
                text[8] = ReportProcessor.getOpenCLTrackNameWithoutPrefix(queueTrack.getTitle(), "Queue ");
            }
            if ((dependencies = ReportProcessor.getOpenCLDependencyIdsForEventItem(item, model)).length == 0) {
                text[9] = "";
            } else {
                StringBuilder depStr = new StringBuilder(Long.toString((long)dependencies[0] & 0xFFFFFFFFL));
                int dependenciesLength = dependencies.length;
                int i3 = 1;
                while (i3 < dependenciesLength) {
                    depStr.append(",");
                    depStr.append(Long.toString((long)dependencies[i3] & 0xFFFFFFFFL));
                    ++i3;
                }
                text[9] = depStr.toString();
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 131072);
            ++work;
            long now = System.currentTimeMillis();
            if (now >= nextUpdate) {
                nextUpdate = now + 100L;
                monitor.worked(work);
                work = 0;
                if (monitor.isCanceled()) break;
            }
            ReportProcessor.markOpenCLEventAndItsPrimaryLinksAsCompleted(item, completedEventIds, model);
        }
        monitor.worked(work);
        writer.flush();
        monitor.done();
    }

    private static void emitTitle(PrintStream out, String title) {
        out.println();
        out.println(title);
        out.println();
    }

    private static long getOpenCLCommandDuration(CAMJob item, CAM_Model model) {
        long startTime;
        long endTime = startTime = Math.round((double)item.getStartTime() / 1000.0);
        Stack<CAMJob> stack = new Stack<CAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            CAMJob event;
            CAMJob currentItem = (CAMJob)stack.pop();
            startTime = currentItem.getStartTime();
            endTime = currentItem.getStopTime();
            if (currentItem.getPrimaryDependentID() == -1 || (event = model.getJob(currentItem.getPrimaryDependentID())) == null) continue;
            stack.push(event);
        }
        startTime = Math.round((double)startTime / 1000.0);
        endTime = Math.round((double)endTime / 1000.0);
        return endTime - startTime;
    }

    private static long getOpenCLCommandTimeToStart(CAMJob item, CAM_Model model) {
        CAMJob dependent;
        if (item.getPrimaryDependentID() != -1 && (dependent = model.getJob(item.getPrimaryDependentID())) != null) {
            long startTime = Math.round((double)item.getStartTime() / 1000.0);
            long dependentStartTime = Math.round((double)dependent.getStartTime() / 1000.0);
            return dependentStartTime - startTime;
        }
        return 0L;
    }

    private static int[] getOpenCLDependencyIdsForEventItem(CAMJob item, CAM_Model model) {
        TIntHashSet ids = new TIntHashSet();
        Stack<CAMJob> stack = new Stack<CAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            CAMJob event;
            CAMJob currentItem = (CAMJob)stack.pop();
            int dependentCount = currentItem.getDependencyIDs().length;
            int i = 0;
            while (i < dependentCount) {
                CAMJob dependencyItem = model.getJob(currentItem.getDependencyIDs()[i]);
                if (dependencyItem != null) {
                    ids.add(ReportProcessor.getOpenCLRootItem(dependencyItem, model).getId());
                }
                ++i;
            }
            if (currentItem.getPrimaryDependentID() == -1 || (event = model.getJob(currentItem.getPrimaryDependentID())) == null) continue;
            stack.push(event);
        }
        return ids.toArray();
    }

    private static CAMJob getOpenCLRootItem(CAMJob item, CAM_Model model) {
        Stack<CAMJob> stack = new Stack<CAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            CAMJob currentItem = (CAMJob)stack.pop();
            if (currentItem.getPrimaryDependencyID() == -1) {
                return currentItem;
            }
            CAMJob event = model.getJob(currentItem.getPrimaryDependencyID());
            if (event == null) continue;
            stack.push(event);
        }
        return item;
    }

    private static CAMTrack getOpenCLTrackForItem(CAMJob item, CAM_Model model, String trackName) {
        Stack<CAMJob> stack = new Stack<CAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            CAMJob event;
            String trackLabel;
            CAMJob currentItem = (CAMJob)stack.pop();
            CAMTrack track = model.getTrack(currentItem.getTrackID());
            if (track != null && (trackLabel = track.getTitle()).length() >= trackName.length() && trackLabel.substring(0, trackName.length()).equals(trackName)) {
                return track;
            }
            if (currentItem.getPrimaryDependentID() == -1 || (event = model.getJob(currentItem.getPrimaryDependentID())) == null) continue;
            stack.push(event);
        }
        return null;
    }

    private static String getOpenCLTrackNameWithoutPrefix(String trackName, String prefix) {
        if (trackName.length() >= prefix.length()) {
            return trackName.substring(prefix.length());
        }
        return " ";
    }

    private static void markOpenCLEventAndItsPrimaryLinksAsCompleted(CAMJob item, TIntHashSet completedEventIds, CAM_Model model) {
        Stack<CAMJob> stack = new Stack<CAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            CAMJob event;
            CAMJob currentItem = (CAMJob)stack.pop();
            completedEventIds.add(currentItem.getId());
            if (currentItem.getPrimaryDependentID() == -1 || (event = model.getJob(currentItem.getPrimaryDependentID())) == null) continue;
            stack.push(event);
        }
    }

    static @NonNull String formatTime(long bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatBin(bin, zoomLevel, TimeUnit.Style.NO_UNIT, true);
    }

    static @NonNull String formatTimeForReport(long bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatTimeNonLocalised(bin, zoomLevel);
    }

    static int formatTimeMaxWidth(long bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatBinMaxWidth(bin, zoomLevel, TimeUnit.Style.NO_UNIT);
    }

    public @Nullable Format getFormat() {
        return this.mFormat;
    }

    public void setCallpathSources(@NonNull Set<@NonNull String> sourceNames) {
        this.mCallPathSources = sourceNames;
    }

    public void setDisasmSourcesAndImageNames(@NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> disasmSourcesAndImageNames) {
        this.disasmSourcesAndImageNames = disasmSourcesAndImageNames;
    }

    public void setDumpAll() {
        this.mDumpBookmark = true;
        this.mDumpCallPath = true;
        this.mDumpCAM = true;
        this.mDumpFunctions = true;
        this.mDumpHeatmap = true;
        this.mDumpLog = true;
        this.mDumpOpenCL = true;
        this.mDumpTimeline = true;
        this.mDumpWarnings = true;
    }

    public void setDumpBookmarks(boolean dumpBookmarks) {
        this.mDumpBookmark = dumpBookmarks;
    }

    public void setDumpCallPath(boolean dumpCallPath) {
        this.mDumpCallPath = dumpCallPath;
    }

    public void setDumpCAM(boolean dumpCAM) {
        this.mDumpCAM = dumpCAM;
    }

    public void setDumpFunctions(boolean dumpFunctions) {
        this.mDumpFunctions = dumpFunctions;
    }

    public void setDumpHeatmap(boolean dumpHeatMap) {
        this.mDumpHeatmap = dumpHeatMap;
    }

    public void setDumpIndividualThreads(boolean dumpIndividualThreads) {
        this.mDumpIndividualThreads = dumpIndividualThreads;
    }

    public void setDumpLog(boolean dumpLog) {
        this.mDumpLog = dumpLog;
    }

    public void setDumpOpenCL(boolean dumpOpenCL) {
        this.mDumpOpenCL = dumpOpenCL;
    }

    public void setDumpTimeline(boolean dumpTimeline) {
        this.mDumpTimeline = dumpTimeline;
    }

    public void setDumpWarnings(boolean dumpWarnings) {
        this.mDumpWarnings = dumpWarnings;
    }

    public void setFormat(Format format) {
        this.mFormat = format;
    }

    public void setFunctionSources(@NonNull Set<@NonNull String> sourceNames) {
        this.mFunctionSources = sourceNames;
    }

    public void setHeatmapSources(@NonNull Set<@NonNull String> sourceNames) {
        this.mHeatmapSourceNames = sourceNames;
    }

    public void setProcessSpecifier(String processSpecifier) {
        this.mSpecificProcessRegex = processSpecifier;
    }

    public void setThreadSpecifier(String threadSpecifier) {
        this.mThreadSpecifier = threadSpecifier;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean start(List<String> files, boolean defaultTemplate, @Nullable List<@NonNull String> templatePaths, ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, double startSeconds, double stopSeconds, String bookmarkStart, String bookmarkStop, @NonNull IReportPrintStream stream) throws Exception {
        boolean success = true;
        IProgressObserver nullProgressObserver = new IProgressObserver(){

            @Override
            public void addToInProgress(@NonNull ICapture placeholder) {
            }

            @Override
            public void pause() {
            }

            @Override
            public void removeFromInProgress(@NonNull ICapture placeholder) {
            }

            @Override
            public void resume() {
            }
        };
        if (files.isEmpty()) {
            throw new Exception(CmdLineMessages.CAPTURE_MUST_BE_SPECIFIED);
        }
        if (!(this.mDumpFunctions || this.mDumpCallPath || this.mDumpLog || this.mDumpTimeline || this.mDumpCAM || this.mDumpOpenCL || this.mDumpBookmark || this.mDumpHeatmap)) {
            this.setDumpAll();
        }
        final Thread current = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (ReportProcessor.this.mAnalyzing) {
                    ReportProcessor.this.mAnalyzingEarlyStop = true;
                    System.err.println(CmdLineMessages.STOPPING);
                    current.interrupt();
                    while (ReportProcessor.this.mAnalyzing) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException exception) {
                            break;
                        }
                    }
                }
            }
        });
        for (String fileName : files) {
            boolean firstFile = true;
            File file = new File(fileName);
            if (file.canRead() && file.isDirectory()) {
                ResolutionMode resolutionMode32;
                ICapture capture = ICapture.createCapture(file);
                if (!capture.isValid()) {
                    success = false;
                    System.err.println(MessageFormat.format(CmdLineMessages.ANALYSIS_ERROR, capture.getInvalidReason()));
                    continue;
                }
                System.err.println(MessageFormat.format(CmdLineMessages.PROCESSING, file));
                try {
                    IAnalysisInputSettings settings = capture.getAnalisysSettings();
                    if (zoomLevel.equals((Object)Scales.SUMMARY_RES_ZOOM_LEVELS[0])) {
                        resolutionMode = ResolutionMode.SUMMARY;
                    } else if (ArrayUtils.indexOf((Object[])Scales.LO_RES_ZOOM_LEVELS, (Object)zoomLevel) >= 0) {
                        resolutionMode = ResolutionMode.NORMAL;
                    } else if (ArrayUtils.indexOf((Object[])Scales.HI_RES_ZOOM_LEVELS, (Object)zoomLevel) >= 0) {
                        resolutionMode = ResolutionMode.HIGH;
                    } else {
                        resolutionMode32 = ResolutionMode.ULTRAHIGH;
                    }
                    settings.setResolutionMode(resolutionMode32);
                    CmdLine.ErrorHandler printingErrorHandler = new CmdLine.ErrorHandler();
                    capture.analyze(settings, new SessionProcessor(), capture, nullProgressObserver, printingErrorHandler, true);
                    if (printingErrorHandler.seenError) {
                        success = false;
                        continue;
                    }
                    if (this.mAnalyzingEarlyStop) {
                        StreamlineFileUtils.deleteAsynchronously(new File(capture.getAnalysisPath()));
                        return false;
                    }
                }
                catch (Exception exception) {
                    success = false;
                    System.err.println(MessageFormat.format(CmdLineMessages.ANALYSIS_ERROR, exception.getMessage()));
                    continue;
                }
                if (files.size() > 1) {
                    stream.captureHeader(firstFile, file);
                    firstFile = false;
                }
                try {
                    Throwable exception = null;
                    resolutionMode32 = null;
                    try (Analysis analysis = new Analysis(file);){
                        OutlineModel<EnumColumn<ICallPath>> model;
                        PrintStream out;
                        boolean useDefaultFilename;
                        IInstructionCounterSource instructionCounterSource;
                        Optional<IInstructionCounterSource> source;
                        String sourceNameToMatch;
                        String defaultSource;
                        List sources;
                        IInstructionCounterModel instructionCounterModel;
                        PrintStream out2;
                        int stop;
                        if (templatePaths != null) {
                            TimelineConfig config = new TimelineConfig();
                            for (String templatePath : templatePaths) {
                                TemplateFile template = null;
                                for (TemplateFile currentTemplateFile : analysis.getTemplates()) {
                                    if (!currentTemplateFile.getName().equals(templatePath)) continue;
                                    template = currentTemplateFile;
                                }
                                try {
                                    if (template == null || template.getCharts().isEmpty()) {
                                        TemplatePath path = TemplatePath.resolveTemplatePath(templatePath);
                                        template = new TemplateFile(path, analysis.getSourceToClusterIdMap());
                                    }
                                }
                                catch (Exception exception2) {
                                    throw new ReportException(MessageFormat.format(CmdLineMessages.UNABLE_TO_LOAD_TEMPLATE, templatePath), exception2);
                                }
                                List<@NonNull ChartAndSeriesConfig> chartAndSeriesConfigsToBeApplied = TemplateUtils.getChartAndSeriesConfigsToBeApplied(template, false, analysis);
                                config.addChartAndSeriesConfigs(chartAndSeriesConfigsToBeApplied);
                            }
                            analysis.setTimelineConfiguration(config);
                            analysis.setUseTimelineConfiguration(true);
                            analysis.rebuildChartsModel();
                        }
                        if (defaultTemplate) {
                            analysis.setUseDefaultTemplates(true);
                            analysis.rebuildChartsModel();
                        }
                        int count = analysis.getBinCount(zoomLevel);
                        TimeUnit timeUnit = analysis.getTimeUnit();
                        int start = (int)zoomLevel.convertNanosecondsToBin(Math.round(startSeconds * (double)timeUnit.getNumberPerBase()));
                        boolean validRange = true;
                        if (start < 0 && bookmarkStart != null) {
                            validRange = false;
                            for (Bookmark bookmark : analysis.getBookmarks()) {
                                if (!bookmarkStart.equals(bookmark.getTitle())) continue;
                                start = (int)zoomLevel.convertNanosecondsToBin(bookmark.getTimestamp());
                                validRange = true;
                                break;
                            }
                            if (!validRange) {
                                stream.message(MessageFormat.format(CmdLineMessages.NO_STARTING_BOOKMARK_FOUND, bookmarkStart));
                            }
                        }
                        if ((stop = (int)zoomLevel.convertNanosecondsToBin(Math.round(stopSeconds * (double)timeUnit.getNumberPerBase()))) < 0 && bookmarkStop != null) {
                            for (Bookmark bookmark : analysis.getBookmarks()) {
                                if (!bookmarkStop.equals(bookmark.getTitle())) continue;
                                stop = (int)zoomLevel.convertNanosecondsToBin(bookmark.getTimestamp());
                                break;
                            }
                        }
                        analysis.getScales().setZoomLevel(zoomLevel);
                        if (!analysis.getScales().getZoomLevel().equals((Object)zoomLevel)) {
                            System.err.println(MessageFormat.format(CmdLineMessages.INVALID_SCALE, "scale"));
                            validRange = false;
                        }
                        if (start < 0) {
                            start = 0;
                        }
                        if (stop < 0 || stop >= count) {
                            stop = count;
                        }
                        if (stop <= start) {
                            throw new ReportException(CmdLineMessages.STOP_NOT_GREATER_THAN_START);
                        }
                        if (validRange) {
                            stream.message(MessageFormat.format(CmdLineMessages.TIME_RANGE, timeUnit.formatBin((long)start, zoomLevel, TimeUnit.Style.TEXT_UNIT, false), timeUnit.formatBin((long)stop, zoomLevel, TimeUnit.Style.TEXT_UNIT, false)));
                            if (start != 0 || stop != count) {
                                analysis.setFilterRange(zoomLevel, start, stop);
                            }
                        }
                        while (analysis.isBusy()) {
                            Thread.sleep(10L);
                        }
                        String processSpecifier = this.mSpecificProcessRegex;
                        String threadSpecifier = this.mThreadSpecifier;
                        Pair<List<ProcessData>, List<ThreadData>> filteredProcessesAndThreads = ReportProcessor.filterBySpecifiers(processSpecifier, threadSpecifier, analysis);
                        List filteredProcesses = (List)filteredProcessesAndThreads.first;
                        ReportProcessor.validateProcessAndThreadArgs(analysis, processSpecifier, threadSpecifier, filteredProcessesAndThreads);
                        if (this.mDumpTimeline && validRange) {
                            @Nullable PrintStream out22 = stream.forTimeline();
                            if (processSpecifier == null && threadSpecifier == null) {
                                ReportProcessor.dumpReportUnfiltered(valueReporting, zoomLevel, analysis, start, stop, out22, stream, this.mFormat, filteredProcesses, this.mDumpIndividualThreads);
                            } else if (processSpecifier != null && threadSpecifier == null) {
                                ReportProcessor.dumpReportOfFilteredProcesses(valueReporting, zoomLevel, analysis, start, stop, out22, stream, this.mFormat, processSpecifier, filteredProcessesAndThreads, this.mDumpIndividualThreads);
                            } else if (processSpecifier != null && threadSpecifier != null) {
                                ReportProcessor.dumpReportOfFilteredProcessesAndThreads(valueReporting, zoomLevel, start, stop, stream, this.mFormat, out22, analysis, threadSpecifier, filteredProcessesAndThreads, this.mDumpIndividualThreads);
                            }
                        }
                        if (this.mDumpCAM && validRange) {
                            ReportProcessor.dumpAllCAM(analysis, start, stop, stream, this.mFormat, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (this.mDumpOpenCL && validRange) {
                            ReportProcessor.dumpAllOpenCL(analysis, start, stop, stream, this.mFormat, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (this.mDumpBookmark) {
                            out2 = stream.forBookmarks();
                            this.dumpBookmarks(analysis, out2);
                        }
                        if (this.mDumpWarnings) {
                            out2 = stream.forWarnings();
                            this.dumpWarnings(analysis, out2);
                        }
                        if (this.mDumpCallPath) {
                            instructionCounterModel = analysis.getInstructionCounterModel();
                            sources = instructionCounterModel.getInstructionCounterSources();
                            defaultSource = instructionCounterModel.getDefaultSource();
                            if (defaultSource == null) {
                                throw new ReportException(MessageFormat.format(CmdLineMessages.NO_DATA_SOURCE_ERROR, "callpath", file.getName()));
                            }
                            Set<@NonNull String> callPathSourceNames = this.mCallPathSources.isEmpty() ? Arrays.asList(defaultSource) : this.mCallPathSources;
                            for (String string : callPathSourceNames) {
                                sourceNameToMatch = !string.isEmpty() ? string : defaultSource;
                                source = sources.stream().filter(src -> src.getName().contentEquals(sourceNameToMatch)).findFirst();
                                if (source.isPresent()) {
                                    instructionCounterSource = source.get();
                                    useDefaultFilename = defaultSource.contentEquals(sourceNameToMatch) || string.isEmpty();
                                    out = stream.forCallpath(string, useDefaultFilename);
                                    model = new OutlineModel<EnumColumn<ICallPath>>();
                                    for (ICallPath callchain : instructionCounterSource.getCallPaths().getRootCallPaths()) {
                                        this.addCallchainToCallpath(stream, processSpecifier, threadSpecifier, instructionCounterSource, model, callchain);
                                    }
                                    ColumnUtils.createColumns(model, CallPathColumn.aggregateColumns(instructionCounterSource), null);
                                    this.dumpReport(out, model, CmdLineMessages.CALL_CHAIN_TITLE, true, true);
                                    continue;
                                }
                                throw new ReportException(MessageFormat.format(CmdLineMessages.NO_SUCH_SOURCE_ERROR, sourceNameToMatch, file.getName()));
                            }
                        }
                        if (this.mDumpFunctions) {
                            instructionCounterModel = analysis.getInstructionCounterModel();
                            sources = instructionCounterModel.getInstructionCounterSources();
                            defaultSource = instructionCounterModel.getDefaultSource();
                            if (defaultSource == null) {
                                throw new ReportException(MessageFormat.format(CmdLineMessages.NO_DATA_SOURCE_ERROR, "function", file.getName()));
                            }
                            Set<@NonNull String> functionSourceNames = this.mFunctionSources.isEmpty() ? Arrays.asList(defaultSource) : this.mFunctionSources;
                            for (String string : functionSourceNames) {
                                sourceNameToMatch = !string.isEmpty() ? string : defaultSource;
                                source = sources.stream().filter(src -> src.getName().contentEquals(sourceNameToMatch)).findFirst();
                                if (source.isPresent()) {
                                    instructionCounterSource = source.get();
                                    useDefaultFilename = defaultSource.contentEquals(sourceNameToMatch) || string.isEmpty();
                                    out = stream.forFunctions(string, useDefaultFilename);
                                    model = new OutlineModel();
                                    for (IInstructionCounterFunctionView function : instructionCounterSource.getFunctionViews()) {
                                        model.addRow(new FunctionRow(function));
                                    }
                                    ColumnUtils.createColumns(model, FunctionColumn.aggregateColumns(instructionCounterSource), null);
                                    this.dumpReport(out, model, CmdLineMessages.FUNCTIONS_TITLE, true, true);
                                    continue;
                                }
                                throw new ReportException(MessageFormat.format(CmdLineMessages.NO_SUCH_SOURCE_ERROR, sourceNameToMatch, file.getName()));
                            }
                        }
                        if (this.mDumpLog && validRange) {
                            out2 = stream.forLog();
                            OutlineModel model2 = new OutlineModel();
                            ArrayList<LogEntryRow> rows = new ArrayList<LogEntryRow>();
                            for (LogEntry logEntry : analysis.getLogEntriesFile().getAllLogEntries()) {
                                long marker = logEntry.getTimelineMarker() * (long)zoomLevel.getBps() / 1000000L;
                                if (marker < (long)start || marker >= (long)stop) continue;
                                rows.add(new LogEntryRow(logEntry));
                            }
                            model2.addNonHierarchicalRowsFast(rows);
                            ColumnUtils.createColumns(model2, (IColumnEnum[])LogEntryColumns.values(), (Object)analysis);
                            this.dumpReport(out2, model2, CmdLineMessages.LOG_TITLE, true, true);
                        }
                        if (this.mDumpHeatmap && validRange) {
                            NullProgressMonitor monitor = new NullProgressMonitor();
                            HeatmapExportFormatter formatter = new HeatmapExportFormatter();
                            Analysis dataProvider = analysis;
                            Set<@NonNull String> heatmapSourceNames = this.mHeatmapSourceNames.isEmpty() ? Arrays.asList("CPU Activity") : this.mHeatmapSourceNames;
                            for (String string : heatmapSourceNames) {
                                if (dataProvider.getFocusSources().contains(string)) {
                                    dataProvider.setFocusSource(string);
                                    @NonNull PrintStream out3 = stream.forHeatmap(string);
                                    @NonNull ITimelineMapProvider mapProvider = dataProvider.getMapProvider();
                                    TIntHashSet processDataUids = processSpecifier != null ? ReportProcessor.asProcessUIDSet(filteredProcesses) : null;
                                    @NonNull List<@NonNull ITimelineRowProvider> selectedProviders = ExportHeatMapDataJob.getSelectedProviders(mapProvider.getRootTimelineRows(), processDataUids);
                                    PrintWriter writer = new PrintWriter(out3, true);
                                    ExportHeatMapDataJob.doExport((IProgressMonitor)monitor, this.mFormat, selectedProviders, writer, start, stop, formatter, zoomLevel, timeUnit);
                                    continue;
                                }
                                throw new ReportException(MessageFormat.format(CmdLineMessages.NO_SUCH_FOCUS_SOURCE_ERROR, string, file.getName()));
                            }
                        }
                        if (!this.disasmSourcesAndImageNames.isEmpty()) {
                            @NonNull IInstructionsFile icm = FilteredInstructionsFile.filterScriptAndUnknownFunctions(analysis.getInstructionCounterModel().getInstructionsFile());
                            for (Map.Entry<String, Pair<String, Set<String>>> entry : this.disasmSourcesAndImageNames.entrySet()) {
                                @NonNull String disasmFilename = entry.getKey();
                                @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>> pair = entry.getValue();
                                @Nullable String sourceName = (String)pair.first;
                                @Nullable @NonNull Set imageNames = (Set)pair.second;
                                @NonNull @NonNull List sources2 = analysis.getInstructionCounterModel().getInstructionCounterSources();
                                IInstructionCounterSource sourceToUse = null;
                                if (sourceName == null && !sources2.isEmpty()) {
                                    sourceToUse = (IInstructionCounterSource)sources2.get(0);
                                } else if (sourceName != null) {
                                    for (IInstructionCounterSource source2 : sources2) {
                                        if (!source2.getName().contentEquals(sourceName)) continue;
                                        sourceToUse = source2;
                                        break;
                                    }
                                }
                                if (sourceToUse == null) {
                                    throw new ReportException(MessageFormat.format(CmdLineMessages.NO_DATA_SOURCE_ERROR, "disasm", file.getName()));
                                }
                                @NonNull PrintStream out4 = stream.forDisasm(disasmFilename, sourceName);
                                if (imageNames != null && !imageNames.isEmpty()) {
                                    ExportDisasm.generateCsvFor(icm, sourceToUse, (Set<String>)imageNames, (OutputStream)out4);
                                    continue;
                                }
                                ExportDisasm.generateCsv(icm, sourceToUse, out4);
                            }
                        }
                        stream.captureFooter();
                        continue;
                    }
                    catch (Throwable resolutionMode32) {
                        if (exception == null) {
                            exception = resolutionMode32;
                        } else if (exception != resolutionMode32) {
                            exception.addSuppressed(resolutionMode32);
                        }
                        throw exception;
                    }
                }
                catch (ReportException exception) {
                    Throwable cause = exception.getCause();
                    if (cause != null) {
                        cause.printStackTrace();
                    }
                    throw exception;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new Exception(MessageFormat.format(CmdLineMessages.REPORT_ERROR, file.getAbsolutePath()));
                }
            }
            throw new Exception(MessageFormat.format(CmdLineMessages.BAD_FILE_ERROR, FilePath.getFullPath((File)file)));
        }
        return success;
    }

    private void addCallchainToCallpath(IReportPrintStream stream, String processSpecifier, String threadSpecifier, IInstructionCounterSource instructionCounterSource, OutlineModel<EnumColumn<ICallPath>> model, @NonNull ICallPath callchain) throws ReportException, IOException {
        boolean threadProvided;
        boolean processProvided = processSpecifier != null;
        boolean bl = threadProvided = threadSpecifier != null;
        if (processProvided) {
            Pair<String, Integer> processNameAndPid;
            @NonNull ProcessIdentifierRegex providedProcessRegex = ReportProcessor.getThreadIdentifierRegex(processSpecifier);
            if (providedProcessRegex.match(processNameAndPid = ProcessIdentifierRegex.getNameAndPidPair(callchain.getName()))) {
                this.addCallchainsToCallpathForProvidedProcess(stream, threadSpecifier, instructionCounterSource, model, callchain, threadProvided);
            }
        } else {
            model.addRow(new CallPathRow(callchain), true);
        }
    }

    private void addCallchainsToCallpathForProvidedProcess(IReportPrintStream stream, String threadSpecifier, IInstructionCounterSource instructionCounterSource, OutlineModel<EnumColumn<ICallPath>> model, @NonNull ICallPath callchain, boolean threadProvided) throws ReportException, IOException {
        if (threadProvided) {
            @NonNull ProcessIdentifierRegex providedThreadRegex = ReportProcessor.getThreadIdentifierRegex(threadSpecifier);
            if (this.mDumpIndividualThreads) {
                this.dumpCallpathsForEachThread(stream, instructionCounterSource, callchain, providedThreadRegex);
            }
            model.addRow(new CallPathRow(callchain, providedThreadRegex), true);
        } else {
            if (this.mDumpIndividualThreads) {
                this.dumpCallpathsForEachThread(stream, instructionCounterSource, callchain, ProcessIdentifierRegex.MATCH_ANY);
            }
            model.addRow(new CallPathRow(callchain), true);
        }
    }

    private void dumpCallpathsForEachThread(IReportPrintStream stream, IInstructionCounterSource instructionCounterSource, ICallPath callchain, ProcessIdentifierRegex providedThreadRegex) throws IOException {
        for (ICallPath threadCallchain : callchain.getChildren()) {
            Pair<String, Integer> threadCallchainNameTidPair = ProcessIdentifierRegex.getNameAndPidPair(threadCallchain.getName());
            if (!providedThreadRegex.match(threadCallchainNameTidPair)) continue;
            @NonNull OutlineModel<EnumColumn<T>> thisThreadModel = new OutlineModel();
            thisThreadModel.addRow(new CallPathRow(threadCallchain));
            Pair<String, Integer> threadNameTidPair = ProcessIdentifierRegex.getNameAndPidPair(threadCallchain.getName());
            Throwable throwable = null;
            Object var11_12 = null;
            try (PrintStream threadCallPathOut = stream.forThreadCallpath((Integer)threadNameTidPair.second);){
                ColumnUtils.createColumns(thisThreadModel, CallPathColumn.aggregateColumns(instructionCounterSource), null);
                this.dumpReport(threadCallPathOut, thisThreadModel, CmdLineMessages.CALL_CHAIN_TITLE, true, true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void validateProcessAndThreadArgs(Analysis analysis, String processSpecifier, String threadSpecifier, @NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filteredProcessesAndThreads) throws ReportException {
        if (processSpecifier == null && threadSpecifier != null) {
            throw new ReportException(String.format("The -%s option requires the -%s option to be set also.", "thread", "process"));
        }
        @NonNull @NonNull List filteredProcesses = (List)filteredProcessesAndThreads.first;
        @NonNull @NonNull List filteredThreads = (List)filteredProcessesAndThreads.second;
        if (processSpecifier != null && filteredProcesses.isEmpty()) {
            ReportProcessor.generateProcessError(processSpecifier, analysis);
        }
        if (threadSpecifier != null && filteredThreads.isEmpty()) {
            throw new ReportException(String.format("Specifier '%s' does not match any available thread in the selected process(es).  Threads available are:%n%s", threadSpecifier, ReportProcessor.threadsIn(filteredProcesses, analysis)));
        }
    }

    private static TIntHashSet asProcessUIDSet(@NonNull List<@NonNull ProcessData> processes) {
        return new TIntHashSet((Collection)processes.stream().map(ProcessData::getUID).collect(Collectors.toList()));
    }

    private void dumpBookmarks(Analysis analysis, PrintStream out) throws IOException {
        @NonNull ArrayList<@NonNull SimpleColumn> columns = new ArrayList<SimpleColumn>();
        int i = 0;
        columns.add(new SimpleColumn(i++, MessageFormat.format(CmdLineMessages.TIME, analysis.getTimeUnit().getBaseSymbol()), new TextCell<SimpleColumn>(131072, IColumnCompareType.INTEGER())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.BOOKMARK, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        @NonNull ZoomLevel zoomLevel = analysis.getStateFile().getResolution().toDensestZoomLevel();
        @NonNull TimeUnit timeUnit = analysis.getTimeUnit();
        @NonNull ArrayList<@NonNull BookmarkRow> rows = new ArrayList<BookmarkRow>();
        for (Bookmark bookmark : analysis.getBookmarks()) {
            rows.add(new BookmarkRow(bookmark, zoomLevel, timeUnit));
        }
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        model.addNonHierarchicalRowsFast(rows);
        for (SimpleColumn column : columns) {
            model.addColumn(column);
        }
        this.dumpReport(out, model, CmdLineMessages.BOOKMARK_TITLE, false, false);
    }

    private <C extends Column<C>> void dumpReport(PrintStream out, OutlineModel<C> model, String title, boolean sort, boolean includeChildren) throws IOException {
        ReportProcessor.emitTitle(out, title);
        if (sort) {
            model.sort();
        }
        @NonNull List<@NonNull T> columns = model.getColumns().stream().filter(c -> !c.isHiddenFromExport()).collect(Collectors.toList());
        TableExport.export(out, this.mFormat == Format.TABS, this.mFormat == Format.COMMAS, includeChildren, columns, model.getRows());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void dumpWarnings(Analysis analysis, PrintStream out) throws IOException {
        @NonNull ArrayList<@NonNull SimpleColumn> columns = new ArrayList<SimpleColumn>();
        int i = 0;
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_NAME, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_TYPE, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_SEVERITY, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_DESC, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        @NonNull @NonNull List warningItems = analysis.getWarnings().getItems();
        @NonNull ArrayList<@NonNull WarningsRow> rows = new ArrayList<WarningsRow>();
        for (WarningItem item : warningItems) {
            rows.add(new WarningsRow(item));
        }
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        model.addNonHierarchicalRowsFast(rows);
        for (SimpleColumn column : columns) {
            model.addColumn(column);
        }
        this.dumpReport(out, model, CmdLineMessages.WARNINGS_TITLE, false, false);
    }

    private static class BookmarkRow
    extends Row<SimpleColumn> {
        private Bookmark mBookmark;
        private final @NonNull TimeUnit mTimeUnit;
        private final @NonNull ZoomLevel mZoomLevel;

        public BookmarkRow(Bookmark bookmark, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
            this.mBookmark = bookmark;
            this.mZoomLevel = zoomLevel;
            this.mTimeUnit = timeUnit;
        }

        @Override
        public double getDataAsDouble(SimpleColumn column) {
            return this.getDataAsLong(column);
        }

        @Override
        public long getDataAsLong(SimpleColumn column) {
            if (column.getID() == 0) {
                return Position.scale((long)this.mBookmark.getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)this.mZoomLevel);
            }
            return 0L;
        }

        @Override
        public String getDataAsText(SimpleColumn column) {
            if (column.getID() == 0) {
                return ReportProcessor.formatTime(this.getDataAsLong(column), this.mZoomLevel, this.mTimeUnit);
            }
            return this.mBookmark.getTitle();
        }

        @Override
        public void setData(SimpleColumn column, Object data) {
        }
    }

    public static enum Format {
        COMMAS,
        SPACES,
        TABS;

    }

    private static class ReportException
    extends Exception {
        public ReportException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }

        public ReportException(@NonNull String message) {
            super(message);
        }
    }

    private static class SeriesData {
        boolean isPercentage;
        int mCoreCount;
        double[][] mCoreData;
        double[] mData;

        SeriesData(IChartDataProvider chart, ISeriesDataProvider series, long start, long end, TIntHashSet selected, ValueReporting valueReporting) {
            @NonNull ProcessingElementReference @NonNull [] channels = chart.getCoreInformationProvider().getChannelDescriptors();
            @Nullable DeviceType deviceType = chart.getCoreInformationProvider().getDeviceType();
            this.isPercentage = chart.isPercentage();
            switch (valueReporting) {
                case PER_CORE: {
                    if (deviceType != null && channels.length > 1) {
                        this.mCoreCount = channels.length;
                        this.mCoreData = new double[channels.length][];
                        int k = 0;
                        while (k < channels.length) {
                            this.mCoreData[k] = series.getData(channels[k], (int)start, (int)end, (TIntSet)selected);
                            ++k;
                        }
                        break;
                    }
                }
                case AGGREGATE: {
                    this.mData = series.getData((int)start, (int)end, (TIntSet)selected);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown ValueReporting variant: " + String.valueOf((Object)valueReporting));
                }
            }
        }
    }

    private static class WarningsRow
    extends Row<SimpleColumn> {
        private @NonNull String mDesc;
        private @NonNull String mName;
        private @NonNull WarningSeverity mSeverity;
        private @NonNull WarningType mType;

        public WarningsRow(@NonNull WarningItem item) {
            this.mName = item.getTitle();
            this.mType = item.getType();
            this.mSeverity = item.getSeverity();
            this.mDesc = item.getDescription();
        }

        @Override
        public double getDataAsDouble(@NonNull SimpleColumn column) {
            return 0.0;
        }

        @Override
        public long getDataAsLong(@NonNull SimpleColumn column) {
            return 0L;
        }

        @Override
        public String getDataAsText(SimpleColumn column) {
            switch (column.getID()) {
                case 0: {
                    return this.mName;
                }
                case 1: {
                    return this.mType.getXmlKey();
                }
                case 2: {
                    return this.mSeverity.getXmlKey();
                }
            }
            return this.mDesc;
        }

        @Override
        public void setData(@NonNull SimpleColumn column, Object data) {
        }
    }
}

