/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.cmdline.IReportPrintStream;
import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.model.cam.CAMViewConfig;
import com.arm.streamline.utility.io.CharacterConversionOutputStream;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.Throwing;
import com.arm.utils.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ReportPrintStream
implements IReportPrintStream,
Closeable {
    private boolean appendHeader = true;
    private final @NonNull Map<@NonNull String, @Nullable String> callPathSourcesAndNames;
    private @Nullable String currentCaptureName;
    private final @NonNull String filenameBookmarks;
    private final @NonNull String filenameCam;
    private final @NonNull String filenameLog;
    private final @NonNull String filenameOpenCl;
    private final @NonNull String filenameTimeline;
    private final @NonNull String filenameWarnings;
    private final @NonNull String fileSuffix;
    private final @NonNull Map<@NonNull String, @Nullable String> functionSourcesAndNames;
    private final @NonNull List<@NonNull String> header = new ArrayList<String>();
    private final @NonNull Map<@NonNull String, @Nullable String> heatmapSourcesAndNames;
    private final @NonNull File parentDir;
    private final @NonNull List<@NonNull PrintStream> toClose = new ArrayList<PrintStream>();

    public ReportPrintStream(@NonNull File parentDir) throws IOException {
        this(parentDir, Collections.emptyMap(), Collections.emptyMap(), null, null, null, null, null, null, Collections.emptyMap(), null);
    }

    public ReportPrintStream(@NonNull File parentDir, @NonNull Map<@NonNull String, @Nullable String> callPathSourcesAndNames, @NonNull Map<@NonNull String, @Nullable String> functionSourcesAndNames, @Nullable String filenameLog, @Nullable String filenameTimeline, @Nullable String filenameCam, @Nullable String filenameOpenCl, @Nullable String filenameBookmarks, @Nullable String filenameWarnings, @NonNull Map<@NonNull String, @Nullable String> heatmapSourcesAndNames,  @Nullable ReportProcessor.Format format) throws IOException {
        this.parentDir = parentDir;
         @NonNull ReportProcessor.Format fileFormat = (ReportProcessor.Format)((Object)NullChecking.neverNullOr((Object)((Object)format), (Object)((Object)ReportProcessor.Format.COMMAS)));
        this.fileSuffix = fileFormat == ReportProcessor.Format.COMMAS ? ".csv" : ".txt";
        this.filenameLog = (String)NullChecking.neverNullOr((Object)filenameLog, (Object)("log" + this.fileSuffix));
        this.filenameTimeline = (String)NullChecking.neverNullOr((Object)filenameTimeline, (Object)("timeline" + this.fileSuffix));
        this.filenameCam = (String)NullChecking.neverNullOr((Object)filenameCam, (Object)("cam" + this.fileSuffix));
        this.filenameOpenCl = (String)NullChecking.neverNullOr((Object)filenameOpenCl, (Object)("opencl" + this.fileSuffix));
        this.filenameBookmarks = (String)NullChecking.neverNullOr((Object)filenameBookmarks, (Object)("bookmarks" + this.fileSuffix));
        this.filenameWarnings = (String)NullChecking.neverNullOr((Object)filenameWarnings, (Object)("warnings" + this.fileSuffix));
        this.callPathSourcesAndNames = callPathSourcesAndNames;
        this.heatmapSourcesAndNames = heatmapSourcesAndNames;
        this.functionSourcesAndNames = functionSourcesAndNames;
        CommonFileUtils.makeDirectory((File)parentDir);
    }

    @Override
    public void captureFooter() {
        this.appendHeader = true;
        this.header.clear();
    }

    @Override
    public void captureHeader(boolean firstFile, @NonNull File file) {
        this.currentCaptureName = file.getName();
    }

    @Override
    public void close() throws IOException {
        Throwable t = null;
        for (PrintStream c : this.toClose) {
            try {
                c.close();
            }
            catch (Throwable e) {
                if (t != null) {
                    e.addSuppressed(t);
                }
                t = e;
            }
        }
        if (t != null) {
            throw new IOException(t);
        }
    }

    @Override
    public @NonNull PrintStream forBookmarks() throws IOException {
        return this.allocate(this.filenameBookmarks);
    }

    @Override
    public @NonNull PrintStream forCallpath(@NonNull String srcName, boolean isDefault) throws IOException {
        @Nullable String filename = this.callPathSourcesAndNames.get(srcName);
        if (filename != null) {
            return this.allocate(filename);
        }
        if (isDefault) {
            return this.allocate("callpath" + this.fileSuffix);
        }
        return this.allocate("callpath-" + srcName.replaceAll("[^0-9A-Za-z_]+", "-") + this.fileSuffix);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull PrintStream forCAM(@NonNull CAMViewConfig config) throws IOException {
        @NonNull @NonNull @NonNull Pair components = FileUtils.splitFilename((String)this.filenameCam);
        return this.allocate(String.format("%s-%d-%d-%s%s", components.first, config.getVmUID(), config.getId(), config.getName().replaceAll("[^0-9A-Za-z_]+", "-"), components.second));
    }

    @Override
    public @NonNull PrintStream forDisasm(@NonNull String disasmFilename, @Nullable String sourceName) throws IOException {
        if (!disasmFilename.isEmpty()) {
            return this.allocate(disasmFilename);
        }
        if (sourceName == null || sourceName.isEmpty()) {
            return this.allocate("disasm.csv");
        }
        return this.allocate(String.format("disasm-%s.csv", sourceName.replaceAll("[^0-9A-Za-z_]+", "-")));
    }

    @Override
    public @NonNull PrintStream forFunctions(@NonNull String srcName, boolean isDefault) throws IOException {
        @Nullable String filename = this.functionSourcesAndNames.get(srcName);
        if (filename != null) {
            return this.allocate(filename);
        }
        if (isDefault) {
            return this.allocate("function" + this.fileSuffix);
        }
        return this.allocate("function-" + srcName.replaceAll("[^0-9A-Za-z_]+", "-") + this.fileSuffix);
    }

    @Override
    public @NonNull PrintStream forHeatmap(@NonNull String name) throws IOException {
        @Nullable String filename = this.heatmapSourcesAndNames.get(name);
        if (filename != null) {
            return this.allocate(filename);
        }
        if (name.equals("CPU Activity")) {
            return this.allocate("heatmap" + this.fileSuffix);
        }
        return this.allocate("heatmap-" + name.replaceAll("[^0-9A-Za-z_]+", "-") + this.fileSuffix);
    }

    @Override
    public @NonNull PrintStream forLog() throws IOException {
        return this.allocate(this.filenameLog);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull PrintStream forOpenCL(long vmUID) throws IOException {
        @NonNull @NonNull @NonNull Pair components = FileUtils.splitFilename((String)this.filenameOpenCl);
        return this.allocate(String.format("%s-%d%s", components.first, vmUID, components.second));
    }

    @Override
    public @NonNull PrintStream forTimeline() throws IOException {
        return this.allocate(this.filenameTimeline);
    }

    private @NonNull PrintStream forThread(int tid, String prefix) throws IOException {
        return this.allocate(String.format("%s_for_thread_%d%s", prefix, tid, this.fileSuffix));
    }

    @Override
    public @NonNull PrintStream forThreadTimeline(int tid) throws IOException {
        return this.forThread(tid, "timeline");
    }

    @Override
    public PrintStream forThreadCallpath(int tid) throws IOException {
        return this.forThread(tid, "callpath");
    }

    @Override
    public @NonNull PrintStream forWarnings() throws IOException {
        return this.allocate(this.filenameWarnings);
    }

    @Override
    public void message(@NonNull String format) {
        assert (this.appendHeader);
        this.header.add(format);
    }

    private @NonNull PrintStream allocate(@NonNull String filename) throws IOException {
        @Nullable String currentCaptureName = this.currentCaptureName;
        @NonNull File outputDir = currentCaptureName != null ? new File(this.parentDir, currentCaptureName) : this.parentDir;
        @NonNull File outputFile = new File(outputDir, filename);
        @NonNull PrintStream stream = (PrintStream)Throwing.closeIfThrows(PrintStream::new, (Object)((CharacterConversionOutputStream)Throwing.closeIfThrows(s -> new CharacterConversionOutputStream((OutputStream)s, '\u00b5', 'u'), (Object)((BufferedOutputStream)Throwing.closeIfThrows(BufferedOutputStream::new, (Object)new FileOutputStream(outputFile), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
        this.toClose.add(stream);
        this.appendHeader = false;
        for (String h : this.header) {
            stream.println(h);
        }
        return stream;
    }
}

