/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.cmdline.IReportPrintStream;
import com.arm.streamline.model.cam.CAMViewConfig;
import com.arm.streamline.utility.io.CharacterConversionOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class OutputStreamWrappingReportPrintStream
implements IReportPrintStream {
    private final @NonNull PrintStream out;

    public OutputStreamWrappingReportPrintStream(@NonNull OutputStream stream) {
        this.out = new PrintStream(new CharacterConversionOutputStream(new BufferedOutputStream(stream), '\u00b5', 'u'));
    }

    @Override
    public void captureFooter() {
        this.out.println();
    }

    @Override
    public void captureHeader(boolean firstFile, File file) {
        if (!firstFile) {
            this.out.println();
            this.out.println();
        }
        this.out.println(MessageFormat.format(CmdLineMessages.ANALYSIS_FILE, file.getAbsolutePath()));
        this.out.println();
    }

    @Override
    public @NonNull PrintStream forBookmarks() {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forCallpath(@NonNull String srcName, boolean isDefault) throws IOException {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forCAM(@NonNull CAMViewConfig config) {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forDisasm(@NonNull String disasmFilename, @Nullable String sourceName) throws IOException {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forFunctions(@NonNull String srcName, boolean isDefault) {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forHeatmap(@NonNull String name) {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forLog() {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forOpenCL(long vmUID) {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forTimeline() {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forThreadTimeline(int tid) throws IOException {
        return this.out;
    }

    @Override
    public PrintStream forThreadCallpath(int tid) throws IOException {
        return this.out;
    }

    @Override
    public @NonNull PrintStream forWarnings() {
        return this.out;
    }

    @Override
    public void message(@NonNull String message) {
        this.out.println(message);
    }
}

