/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capturemanagement;

import com.arm.io.Files;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.capture.apc.APCCapture;
import com.arm.streamline.capturemanagement.DetectableErrorHandler;
import com.arm.streamline.capturemanagement.Messages;
import com.arm.streamline.capturemanagement.StopHandlerForExternalProcess;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.captureservices.ICapturingController;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.IDocumentScanner;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SessionImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;

@Component
public class CapturingController
implements ICapturingController {
    public void setExternalCapture(@NonNull String processDisplayName, @NonNull Process process, @NonNull File captureLocation, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ICapturingController.OnSuccessAction onSuccessAction, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ICapturingController.OnErrorAction onErrorAction, @NonNull List<@NonNull File> elfImages, boolean useImagesInAnalysis) throws FileAlreadyExistsException {
        StopHandlerForExternalProcess stopHandler = new StopHandlerForExternalProcess(process);
        @NonNull IDocumentScanner scanner = DocumentScanner.INSTANCE;
        APCCapture capture = new APCCapture(captureLocation);
        capture.setHasBeenStopped(false);
        capture.setStopHandler(stopHandler, scanner);
        capture.setAsPlaceholder();
        Task.callOnAnotherThread(() -> {
            block11: {
                DetectableErrorHandler errorHandler = new DetectableErrorHandler(onErrorAction);
                try {
                    try {
                        @NonNull int exitCode = process.waitFor();
                        if (exitCode == 0) {
                            switch (onSuccessAction) {
                                case ANALYZE_AND_OPEN_REPORT: {
                                    CapturingController.analyze(scanner, capture, errorHandler, elfImages, useImagesInAnalysis);
                                    if (!errorHandler.wasErrorReported()) {
                                        capture.openAsync();
                                        break;
                                    }
                                    break block11;
                                }
                                case ANALYZE_ONLY: {
                                    CapturingController.analyze(scanner, capture, errorHandler, elfImages, useImagesInAnalysis);
                                    break;
                                }
                            }
                            break block11;
                        }
                        errorHandler.reportError(new Exception(String.format(Messages.CapturingController_NONZERO_EXIT_CODE_ERROR, processDisplayName)));
                    }
                    catch (InterruptedException e) {
                        errorHandler.reportError(new Exception(String.format(Messages.CapturingController_PROCESS_TIMEOUT_ERROR, processDisplayName)));
                        capture.setStopHandler(null, scanner);
                    }
                }
                finally {
                    capture.setStopHandler(null, scanner);
                }
            }
        });
    }

    private static void analyze(IDocumentScanner scanner, APCCapture capture, @NonNull IErrorHandler errorHandler, @NonNull List<@NonNull File> elfImages, boolean useImagesInAnalysis) {
        capture.validate();
        scanner.removePlaceholder(capture);
        IAnalysisInputSettings settings = capture.getAnalisysSettings();
        List<@NonNull T> sessionImages = elfImages.stream().map(imageFile -> {
            File imagesDir = new File(capture.getApcDirectory(), "images");
            File targetImageFile = new File(imagesDir, imageFile.getName());
            try {
                Files.copy((File)imageFile, (File)targetImageFile);
            }
            catch (IOException exception) {
                errorHandler.reportError((Throwable)exception);
            }
            return new SessionImage(imageFile.getName(), useImagesInAnalysis);
        }).collect(Collectors.toList());
        settings.getImages().addAll(sessionImages);
        capture.analyze(settings, new SessionProcessor(), capture, DocumentScanner.INSTANCE, errorHandler, true);
    }
}

