/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.apc;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.ApplicationsReader;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.api.profiling.BacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.gator.EnergyMeterCounterAnalysis;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.capture.apc.NoDataReceivedException;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.streamline.databrowser.AbstractDatabaseGenerator;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.jni.apcdbgen.AnalysisResult;
import com.arm.streamline.jni.apcdbgen.ApcDbGenerator;
import com.arm.streamline.jni.apcdbgen.IProgressMonitor;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.APCDirectory;
import com.arm.streamline.protocol.capture.apc.io.APCCaptureFrameStream;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameStream;
import com.arm.streamline.protocol.capture.apc.live.MultiplexedAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.APCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IPassOneGlobalStateNotificationCallbacks;
import com.arm.streamline.protocol.capture.apc.pass_two.APCPassTwo;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.NullChecking;
import com.arm.utils.function.ICloseableThrowingRunnable;
import com.arm.utils.function.IThrowingFunction;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class APCDatabaseGenerator
extends AbstractDatabaseGenerator {
    private static final String LIC_EDITION_ID = "performance-studio";

    public static @NonNull ICloseableThrowingRunnable<IOException> createLiveProcessor(@NonNull SessionProcessor sessionProcessor, @NonNull ICaptureDetails captureDetails, @NonNull File apcDirectory, @NonNull IClustersInfo clustersInfo, @Nullable EnergyCaptureSettings energyCaptureSettings, boolean generateSpeSampleLog, @NonNull IAPCCaptureFrameStream frameStream, @Nullable IAPCPassOne livePassOne) {
        ProtocolInfo protocolInfo = captureDetails.getProtocolInfo();
        if (protocolInfo.getType() == ProtocolType.PERF && AnalysisDatabaseFactory.useDbV3()) {
            return new LiveAPCDatabaseGeneratorProcessorV3(frameStream, livePassOne);
        }
        return new LiveAPCDatabaseGeneratorProcessor(sessionProcessor, captureDetails, apcDirectory, clustersInfo, energyCaptureSettings, generateSpeSampleLog, frameStream, livePassOne);
    }

    public static @NonNull IBacktraceSource findBacktraceSource(@NonNull List<@NonNull CounterRecord> counterRecordList) {
        @Nullable String ebsCounterBacktraceSourceName = counterRecordList.stream().map(StaticCounterSeriesKey::new).map(StaticCounterSeriesKey::getBacktraceSourceNameIfEbsCounter).filter(name -> name != null).findFirst().orElse(null);
        return ebsCounterBacktraceSourceName != null ? BacktraceSource.ebs((String)ebsCounterBacktraceSourceName) : IBacktraceSource.PERIODIC_SAMPLES;
    }

    private static void processRecordsV2(@Nullable EnergyCaptureSettings energyCaptureSettings, boolean generateSpeSampleLog, @NonNull String capturePath, @NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull SessionProcessor sessionProcessor, @NonNull AttachedApkEntries attachedApkEntries) throws Exception {
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (APCDatabaseGeneratorProcessor processingPass = new APCDatabaseGeneratorProcessor(sessionProcessor, captureDetails, new File(capturePath), clustersInfo, energyCaptureSettings, generateSpeSampleLog, attachedApkEntries);){
                processingPass.run();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClosedByInterruptException e) {
            throw new InterruptedException();
        }
    }

    private static void processRecordsV3(@Nullable EnergyCaptureSettings energyCaptureSettings, @NonNull ICaptureDetails captureDetails, @NonNull SessionProcessor sessionProcessor, @NonNull File apcDirectory, final IAnalysisHandler handler) throws Exception {
        long before;
        block27: {
            before = System.nanoTime();
            final Thread currentThread = Thread.currentThread();
            IProgressMonitor progressMonitor = new IProgressMonitor(apcDirectory){
                final @NonNull String capturePath;
                {
                    this.capturePath = file.getAbsolutePath();
                }

                public void done(long total_duration_ns) {
                    handler.progress((Object)this, 100);
                    if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                        System.out.printf("[%s]: Done%n", this.capturePath);
                    }
                }

                public void endStep(int step, long total_step_duration_ns) {
                    if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                        System.out.printf("[%s]: TOTAL TIME: %d.%09d%n", step, total_step_duration_ns / 1000000000L, total_step_duration_ns % 1000000000L);
                    }
                    if (currentThread.isInterrupted()) {
                        throw new AsyncInterruptedException();
                    }
                }

                public void primaryProgress(int step, long percent, long pos, long total, long running_time_in_step_ns) {
                    if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                        System.out.printf("[%s]: %d/8 : %d : %d/%d%n", this.capturePath, step, percent, pos, total);
                    }
                    handler.progress((Object)this, (int)((long)(step * 10 / 8) + percent / 10L));
                    if (currentThread.isInterrupted()) {
                        throw new AsyncInterruptedException();
                    }
                }

                public void secondaryProgress(int step, long percent, long pos, long total, long running_time_in_sub_step_ns) {
                    if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                        System.out.printf("[%s]: -----  %d/8 : %d : %d/%d%n", this.capturePath, step, percent, pos, total);
                    }
                    if (currentThread.isInterrupted()) {
                        throw new AsyncInterruptedException();
                    }
                }
            };
            try {
                ApcDbGenerator generator = new ApcDbGenerator(apcDirectory, LIC_EDITION_ID, progressMonitor);
                AnalysisResult result = generator.generateDb();
                if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                    System.out.printf("RESULT IS: %s (%s)%n", result.getResultCode(), result.isSuccessful());
                }
                if (result.isSuccessful()) break block27;
                switch (result.getResultCode()) {
                    case success: {
                        break;
                    }
                    case cancelled: {
                        throw new InterruptedException();
                    }
                    case failed_to_create_db_directory: {
                        throw new IOException("Failed to create db directory within " + String.valueOf(apcDirectory));
                    }
                    case invalid_capture_path: {
                        throw new IOException("Invalid capture path " + String.valueOf(apcDirectory));
                    }
                    case unsupported_protocol_type: {
                        throw new IOException("Invalid protocol type in " + String.valueOf(apcDirectory));
                    }
                    case unsupported_protocol_version: {
                        throw new IOException("Invalid protocol version in " + String.valueOf(apcDirectory));
                    }
                    default: {
                        throw new AssertionError(result.getResultCode());
                    }
                }
            }
            catch (AsyncInterruptedException e) {
                throw new InterruptedException();
            }
            catch (Throwable t) {
                if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                    System.out.printf("FAILED WITH: %s (%s)%n", t.getClass(), t.getMessage());
                    t.printStackTrace();
                }
                throw t;
            }
        }
        long afterDb = System.nanoTime();
        long deltaDb = afterDb - before;
        if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
            System.out.printf("CUMULATIVE TOTAL TIME: %d.%09d%n", deltaDb / 1000000000L, deltaDb % 1000000000L);
        }
        File dbPath = DatabaseLayout.getDatabaseRoot((File)apcDirectory);
        if (energyCaptureSettings != null) {
            DeviceTypeCalculator deviceTypeCalculator = captureDetails.createDeviceTypeCalculator();
            IUniqueIds applications = ApplicationsReader.read((File)new File(dbPath, "applications.xml"));
            try {
                Throwable throwable = null;
                Object var17_21 = null;
                try (IAnalysisReaderFactoryV2 readerFactory = AnalysisDatabaseFactory.create((File)new File(apcDirectory, "db"), (DeviceTypeCalculator)deviceTypeCalculator);){
                    EnergyMeterCounterAnalysis gatorCounters = new EnergyMeterCounterAnalysis(apcDirectory, applications.getIdleUIDSet(), sessionProcessor, energyCaptureSettings, captureDetails.getLiveEnergyDelta(), readerFactory, (IThrowingFunction<CounterRecord, IAnalysisHardwareCounterWriter, IOException>)((IThrowingFunction)arg_0 -> ((IAnalysisReaderFactoryV2)readerFactory).createEnergyProcessorCounterWriter(arg_0)));
                    gatorCounters.join();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (BadXmlException e) {
                throw new IOException(e);
            }
            long afterEm = System.nanoTime();
            long deltaEm = afterEm - afterDb;
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                System.out.printf("ENERGY DATA TOTAL TIME: %d.%09d%n", deltaEm / 1000000000L, deltaEm % 1000000000L);
            }
        }
    }

    @Override
    protected void processRecords(IAnalysisInputSettings analysisSettings, @Nullable EnergyCaptureSettings energyCaptureSettings, boolean generateSpeSampleLog, @NonNull String capturePath, @NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull SessionProcessor sessionProcessor, ICaptureProxy proxy, IAnalysisHandler handler, @NonNull AttachedApkEntries attachedApkEntries) throws Exception {
        ProtocolInfo protocolInfo = captureDetails.getProtocolInfo();
        if (protocolInfo.getType() == ProtocolType.PERF && AnalysisDatabaseFactory.useDbV3()) {
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                System.out.printf("Using DBv3 backend%n", new Object[0]);
            }
            APCDatabaseGenerator.processRecordsV3(energyCaptureSettings, captureDetails, sessionProcessor, new File(capturePath), handler);
        } else {
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                System.out.printf("Using legacy backend%n", new Object[0]);
            }
            APCDatabaseGenerator.processRecordsV2(energyCaptureSettings, generateSpeSampleLog, capturePath, captureDetails, clustersInfo, sessionProcessor, attachedApkEntries);
        }
    }

    private static final class APCDatabaseGeneratorProcessor
    extends AbstractAPCDatabaseGeneratorProcessor {
        public APCDatabaseGeneratorProcessor(@NonNull SessionProcessor sessionProcessor, @NonNull ICaptureDetails captureDetails, @NonNull File apcDirectory, @NonNull IClustersInfo clustersInfo, @Nullable EnergyCaptureSettings energyCaptureSettings, boolean generateSpeSampleLog, @NonNull AttachedApkEntries attachedApkEntries) {
            super(sessionProcessor, captureDetails, apcDirectory, clustersInfo, energyCaptureSettings, generateSpeSampleLog, attachedApkEntries);
        }

        public void close() throws IOException {
        }

        @Override
        protected @NonNull IAPCCaptureFrameStream createCaptureFileFrameStream() throws IOException {
            @NonNull APCDirectory directory = new APCDirectory(this.apcDirectory);
            if (directory.isEmpty()) {
                throw new IOException(AnalysisMessages.NO_APC_DATA);
            }
            return new APCCaptureFrameStream(directory);
        }
    }

    private static abstract class AbstractAPCDatabaseGeneratorProcessor
    implements ICloseableThrowingRunnable<IOException> {
        protected final @NonNull File apcDirectory;
        protected final boolean generateSpeSampleLog;
        private final @NonNull AttachedApkEntries attachedApkEntries;
        private final @NonNull IBacktraceSource backtraceSource;
        private final @NonNull IPassOneGlobalStateNotificationCallbacks callbacks;
        private final @NonNull String captureName;
        private final @NonNull IClustersInfo clustersInfo;
        private final @NonNull List<@NonNull CounterRecord> counterRecordList;
        private final @NonNull DeviceTypeCalculator deviceTypeCalculator;
        private final @Nullable EnergyCaptureSettings energyCaptureSettings;
        private final boolean isMultiGpu;
        private final @NonNull Supplier<@Nullable Integer> liveEnergyDeltaSupplier;
        private final int numberOfCores;
        private final @NonNull ProtocolInfo protocolInfo;
        private final @NonNull SessionProcessor sessionProcessor;
        private final @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords;
        private final @NonNull IWarnings warnings;

        protected AbstractAPCDatabaseGeneratorProcessor(@NonNull SessionProcessor sessionProcessor, @NonNull ICaptureDetails captureDetails, @NonNull File apcDirectory, @NonNull IClustersInfo clustersInfo, @Nullable EnergyCaptureSettings energyCaptureSettings, boolean generateSpeSampleLog, @NonNull AttachedApkEntries attachedApkEntries) {
            this.apcDirectory = apcDirectory;
            this.clustersInfo = clustersInfo;
            this.energyCaptureSettings = energyCaptureSettings;
            this.sessionProcessor = sessionProcessor;
            this.generateSpeSampleLog = generateSpeSampleLog;
            this.attachedApkEntries = attachedApkEntries;
            this.numberOfCores = captureDetails.getNumberOfCores();
            this.isMultiGpu = captureDetails.hasMutiGpu();
            this.protocolInfo = captureDetails.getProtocolInfo();
            this.counterRecordList = captureDetails.getCounterList();
            this.speCaptureRecords = captureDetails.getSpes();
            this.captureName = (String)NullChecking.neverNull((Object)captureDetails.getName());
            this.warnings = new Warnings();
            this.deviceTypeCalculator = captureDetails.createDeviceTypeCalculator();
            this.liveEnergyDeltaSupplier = captureDetails::getLiveEnergyDelta;
            this.backtraceSource = APCDatabaseGenerator.findBacktraceSource(this.counterRecordList);
            this.counterRecordList.forEach(cr -> {
                @Nullable Integer gpuCoresCount = captureDetails.getGpuCoresCount();
                this.deviceTypeCalculator.calcDeviceType(cr, this.numberOfCores, gpuCoresCount);
            });
            this.callbacks = new PassOneCallbacks();
        }

        public void run() throws IOException {
            TIntSet idleUtids;
            @NonNull File dbPath = DatabaseLayout.getDatabaseRoot((File)this.apcDirectory);
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (@NonNull APCPassOne apcPassOne = this.createPassOne(dbPath);){
                @NonNull IAPCPassOne wrappedPassOne = this.wrapAPCPassOne(apcPassOne);
                Throwable throwable3 = null;
                Object var8_15 = null;
                try (IAPCCaptureFrameStream frameStream = this.createCaptureFileFrameStream();){
                    IAPCPassOne.process((IAPCCaptureFrameStream)frameStream, (IAPCPassOne)wrappedPassOne);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                try {
                    throwable3 = null;
                    var8_15 = null;
                    try (APCPassTwo apcPassTwo = apcPassOne.createPassTwo(dbPath, this.captureName, this.generateSpeSampleLog, false, false, this.deviceTypeCalculator, this.speCaptureRecords, this.counterRecordList, this.clustersInfo, this.warnings, this.isMultiGpu, this.attachedApkEntries);){
                        apcPassTwo.run();
                        idleUtids = apcPassTwo.getIdleUtids();
                    }
                    catch (Throwable throwable5) {
                        if (throwable3 == null) {
                            throwable3 = throwable5;
                        } else if (throwable3 != throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        throw throwable3;
                    }
                }
                catch (ProtocolException e) {
                    switch (e.reason) {
                        case FAILED_TO_READ_FRAME_CONTENTS: 
                        case FAILED_TO_READ_FRAME_LENGTH: 
                        case INVALID_MALI_ENCAPSULATED_DATA: {
                            throw e;
                        }
                        case MISSING_SUMMARY_INFORMATION: {
                            throw new NoDataReceivedException();
                        }
                    }
                    throw new AssertionError(e.reason);
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
            @Nullable EnergyCaptureSettings energyCaptureSettings = this.energyCaptureSettings;
            if (energyCaptureSettings != null) {
                try {
                    throwable2 = null;
                    Object var5_8 = null;
                    try (IAnalysisReaderFactoryV2 readerFactory = AnalysisDatabaseFactory.create((File)dbPath, (DeviceTypeCalculator)this.deviceTypeCalculator);){
                        EnergyMeterCounterAnalysis gatorCounters = new EnergyMeterCounterAnalysis(this.apcDirectory, idleUtids, this.sessionProcessor, energyCaptureSettings, this.liveEnergyDeltaSupplier.get(), readerFactory, (IThrowingFunction<CounterRecord, IAnalysisHardwareCounterWriter, IOException>)((IThrowingFunction)arg_0 -> ((IAnalysisReaderFactoryV2)readerFactory).createEnergyProcessorCounterWriter(arg_0)));
                        gatorCounters.join();
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                }
                catch (BadXmlException e) {
                    throw new IOException(e);
                }
            }
        }

        protected abstract @NonNull IAPCCaptureFrameStream createCaptureFileFrameStream() throws IOException;

        protected @NonNull IAPCPassOne wrapAPCPassOne(@NonNull APCPassOne apcPassOne) {
            return apcPassOne;
        }

        private final @NonNull APCPassOne createPassOne(@NonNull File dbDirectory) {
            switch (this.protocolInfo.getType()) {
                case PERF: {
                    boolean useModernSyncThread = GatorProtocolVersion.isStreamline690OrLater(this.protocolInfo.getRawProtocolVersion());
                    return APCPassOne.forPerfProtocolV22((IBacktraceSource)this.backtraceSource, (File)dbDirectory, (boolean)useModernSyncThread, (int)this.numberOfCores, (IPassOneGlobalStateNotificationCallbacks)this.callbacks, (int)this.protocolInfo.getRawProtocolVersion());
                }
            }
            throw new AssertionError(this.protocolInfo.getType());
        }

        private class PassOneCallbacks
        implements IPassOneGlobalStateNotificationCallbacks {
            private PassOneCallbacks() {
            }

            public void notifyApplicationTracingMode(long vmUID, boolean applicationTracingMode) {
            }
        }
    }

    private static final class AsyncInterruptedException
    extends RuntimeException {
        private AsyncInterruptedException() {
        }
    }

    private static final class LiveAPCDatabaseGeneratorProcessor
    extends AbstractAPCDatabaseGeneratorProcessor {
        private final @NonNull IAPCCaptureFrameStream frameStream;
        private final @Nullable IAPCPassOne livePassOne;

        public LiveAPCDatabaseGeneratorProcessor(@NonNull SessionProcessor sessionProcessor, @NonNull ICaptureDetails captureDetails, @NonNull File apcDirectory, @NonNull IClustersInfo clustersInfo, @Nullable EnergyCaptureSettings energyCaptureSettings, boolean generateSpeSampleLog, @NonNull IAPCCaptureFrameStream frameStream, @Nullable IAPCPassOne livePassOne) {
            super(sessionProcessor, captureDetails, apcDirectory, clustersInfo, energyCaptureSettings, generateSpeSampleLog, new AttachedApkEntries(Collections.emptyMap()));
            this.frameStream = frameStream;
            this.livePassOne = livePassOne;
        }

        public void close() throws IOException {
            if (this.livePassOne != null) {
                this.livePassOne.close();
            }
        }

        @Override
        protected @NonNull IAPCCaptureFrameStream createCaptureFileFrameStream() throws IOException {
            return this.frameStream;
        }

        @Override
        protected @NonNull IAPCPassOne wrapAPCPassOne(@NonNull APCPassOne apcPassOne) {
            @Nullable IAPCPassOne livePassOne = this.livePassOne;
            if (livePassOne != null) {
                return new MultiplexedAPCPassOne(new IAPCPassOne[]{apcPassOne, livePassOne});
            }
            return apcPassOne;
        }
    }

    private static final class LiveAPCDatabaseGeneratorProcessorV3
    implements ICloseableThrowingRunnable<IOException> {
        private final @NonNull IAPCCaptureFrameStream frameStream;
        private final @Nullable IAPCPassOne livePassOne;

        public LiveAPCDatabaseGeneratorProcessorV3(@NonNull IAPCCaptureFrameStream frameStream, @Nullable IAPCPassOne livePassOne) {
            this.frameStream = frameStream;
            this.livePassOne = livePassOne;
        }

        public void close() throws IOException {
            if (this.livePassOne != null) {
                this.livePassOne.close();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() throws IOException {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                IAPCPassOne apcPassOne = (IAPCPassOne)NullChecking.neverNullOrCreate((Object)this.livePassOne, () -> new NullPassOne());
                try {
                    try (IAPCCaptureFrameStream frameStream = this.frameStream;){
                        IAPCPassOne.process((IAPCCaptureFrameStream)frameStream, (IAPCPassOne)apcPassOne);
                    }
                    if (apcPassOne == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (apcPassOne == null) throw throwable;
                    apcPassOne.close();
                    throw throwable;
                }
                apcPassOne.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private static final class NullPassOne
    implements IAPCPassOne {
        private NullPassOne() {
        }

        public void close() throws IOException {
        }

        public void consumeNextFrame(@NonNull APCFrame frame) throws IOException {
        }

        public void flushDelayedFrames() throws IOException {
        }
    }
}

