/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.IElfImageStore;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.streamline.model.session.SessionImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleAnalysisSettings
implements IAnalysisInputSettings {
    public static final String APC_FILE_PATH = "report/analysis-settings.xml";
    private static final String ANALYSIS_SETTINGS_ELEM = "analysis-settings";
    private static final String FILTER_CALL_STACKS_DATA_ATTR = "filter-call-stacks";
    private static final String PARSE_DEBUG_INFO_ATTR = "parse-debug-info";
    private static final String RESOLUTION_MODE_ATTR = "resolution-mode";
    private @Nullable File file;
    private boolean filterCallStacksData;
    private @NonNull List<@NonNull SessionImage> images;
    private boolean parseDebugInfo;
    private @NonNull ResolutionMode resolutionMode;

    public SimpleAnalysisSettings() {
        this.filterCallStacksData = true;
        this.images = new ArrayList<SessionImage>();
        this.parseDebugInfo = true;
        this.resolutionMode = ResolutionMode.NORMAL;
    }

    /*
     * Unable to fully structure code
     */
    public SimpleAnalysisSettings(@NonNull File file, @NonNull ResolutionMode defaultResolutionMode, @NonNull IElfImageStore elfImageStore) {
        block15: {
            super();
            this.filterCallStacksData = true;
            this.images = new ArrayList<SessionImage>();
            this.parseDebugInfo = true;
            this.resolutionMode = ResolutionMode.NORMAL;
            this.file = file;
            this.resolutionMode = defaultResolutionMode;
            try {
                var4_4 = null;
                var5_7 = null;
                try {
                    parser = XMLParser.create((File)file);
                    try {
                        this.load(parser);
                        break block15;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                catch (Throwable var5_8) {
                    if (var4_4 == null) {
                        var4_4 = var5_8;
                    } else if (var4_4 != var5_8) {
                        var4_4.addSuppressed(var5_8);
                    }
                    throw var4_4;
                }
            }
            catch (IOException exception) {
                this.parseDebugInfo = true;
                this.filterCallStacksData = true;
                this.resolutionMode = defaultResolutionMode;
                this.images.clear();
                ** for (elfImage : elfImageStore.getAvailableImages())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    elfImage.processFile();
                    this.images.add(new SessionImage(elfImage.getFile(), true));
                }
                catch (CodecException e) {
                    CommonPlugin.warning((Throwable)e);
                }
                catch (IOException e) {
                    CommonPlugin.warning((Throwable)e);
                }
                continue;
            }
        }
    }

    protected SimpleAnalysisSettings(@NonNull InputStream stream) throws IOException {
        this.filterCallStacksData = true;
        this.images = new ArrayList<SessionImage>();
        this.parseDebugInfo = true;
        this.resolutionMode = ResolutionMode.NORMAL;
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLParser parser = new XMLParser(stream);){
            this.load(parser);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull List<@NonNull SessionImage> getImages() {
        return this.images;
    }

    @Override
    public @NonNull List<@NonNull PathWithEnabledFlag> getJitDumpFilePaths() {
        return Collections.emptyList();
    }

    @Override
    public ResolutionMode getResolutionMode() {
        return this.resolutionMode;
    }

    @Override
    public boolean isFilterCallStacksDataEnabled() {
        return this.filterCallStacksData;
    }

    @Override
    public boolean isGenerateSpeSampleLogEnabled() {
        return false;
    }

    @Override
    public boolean isJitDumpProfilingSupported() {
        return false;
    }

    @Override
    public boolean isParseDebugInfoEnabled() {
        return this.parseDebugInfo;
    }

    @Override
    public void save() throws IOException {
        File file = this.file;
        if (file != null) {
            CommonFileUtils.makeDirectory((String)file.getParent());
            Throwable throwable = null;
            Object var3_4 = null;
            try (@NonNull XMLGenerator generator = XMLGenerator.create((File)file);){
                this.save(generator);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void setFilterCallStacksData(boolean enabled) {
        this.filterCallStacksData = enabled;
    }

    @Override
    public void setJitDumpFilePaths(@NonNull List<@NonNull PathWithEnabledFlag> pathsWithEnabledFlag) {
    }

    @Override
    public void setParseDebugInfoEnabled(boolean enabled) {
        this.parseDebugInfo = enabled;
    }

    @Override
    public void setResolutionMode(@NonNull ResolutionMode mode) {
        this.resolutionMode = mode;
    }

    protected void save(@NonNull XMLGenerator generator) throws IOException {
        generator.startDocument();
        generator.startTag(ANALYSIS_SETTINGS_ELEM);
        generator.addAttribute(PARSE_DEBUG_INFO_ATTR, this.parseDebugInfo);
        generator.addAttribute(FILTER_CALL_STACKS_DATA_ATTR, this.filterCallStacksData);
        generator.addAttribute(RESOLUTION_MODE_ATTR, this.resolutionMode.getStringValue());
        for (SessionImage image : this.getImages()) {
            image.save(generator);
        }
        generator.endTag();
        generator.endDocument();
    }

    private void load(@NonNull XMLParser parser) throws IOException {
        String tag = parser.nextTag(ANALYSIS_SETTINGS_ELEM);
        if (tag != null) {
            this.parseDebugInfo = parser.isAttributeSet(PARSE_DEBUG_INFO_ATTR, true);
            this.filterCallStacksData = parser.isAttributeSet(FILTER_CALL_STACKS_DATA_ATTR, true);
            this.resolutionMode = ResolutionMode.fromStringValue((String)parser.getAttribute(RESOLUTION_MODE_ATTR, RESOLUTION_DEFAULT.toString()));
        }
        while (parser.nextTag("image") != null) {
            this.images.add(new SessionImage(parser));
        }
    }
}

