/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.xml;

import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.barmancfg.configuration.DWTConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.configuration.DefaultConfigSettings;
import com.arm.streamline.barmancfg.configuration.ITMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.STMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.StreamingConfiguration;
import com.arm.streamline.barmancfg.xml.ThrowingFunction;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.NullChecking;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanConfigurationXML {
    private static final @NonNull String ATTR_AVERAGE_CORES = "average_cores";
    private static final @NonNull String ATTR_AVERAGE_SELECTION = "average_selection";
    private static final @NonNull String ATTR_CLASS = "class";
    private static final @NonNull String ATTR_COLOUR = "colour";
    private static final @NonNull String ATTR_CPUID = "cpuid";
    private static final @NonNull String ATTR_CYCLE_COUNTERS = "cycle-counter";
    private static final @NonNull String ATTR_DESCRIPTION = "description";
    private static final @NonNull String ATTR_DISPLAY = "display";
    private static final @NonNull String ATTR_EVENTS_XML = "events-xml";
    private static final @NonNull String ATTR_MULTIPLIER = "multiplier";
    private static final @NonNull String ATTR_NAME = "name";
    private static final @NonNull String ATTR_PER_CPU = "per_cpu";
    private static final @NonNull String ATTR_PERCENTAGE = "percentage";
    private static final @NonNull String ATTR_PMUS_XML = "pmus-xml";
    private static final @NonNull String ATTR_RENDERING_TYPE = "rendering_type";
    private static final @NonNull String ATTR_SAMPLE = "sample";
    private static final @NonNull String ATTR_SERIES_COMPOSITION = "series_composition";
    private static final @NonNull String ATTR_TYPE = "type";
    private static final @NonNull String ATTR_UNITS = "units";
    private static final @NonNull String ATTR_VERSION = "version";
    private static final @NonNull String TAG_CHART = "chart";
    private static final @NonNull String TAG_CUSTOM_CHARTS = "custom-charts";
    private static final @NonNull String TAG_DATA_STORE = "data-store";
    private static final @NonNull String TAG_ENABLE_DEBUG_LOGGING = "enable-debug-logging";
    private static final @NonNull String TAG_ENABLE_LOGGING = "enable-logging";
    private static final @NonNull String TAG_EVENT = "event";
    private static final @NonNull String TAG_MAX_MMAP_LAYOUT_ENTRIES = "max-mmap-layout-entries";
    private static final @NonNull String TAG_MAX_PROCESSORS = "max-processors";
    private static final @NonNull String TAG_MAX_TASK_ENTRIES = "max-task-entries";
    private static final @NonNull String TAG_MIN_SAMPLE_PERIOD = "min-sample-period";
    private static final @NonNull String TAG_PROCESSOR = "processor";
    private static final @NonNull String TAG_PROCESSORS = "processors";
    private static final @NonNull String TAG_ROOT = "bare-metal-agent";
    private static final @NonNull String TAG_RUNTIME_CONFIG_DEFAULTS = "runtime-config-defaults";
    private static final @NonNull String TAG_SERIES = "series";
    private static final @NonNull String TAG_USE_BUILTIN_MEMFUNCS = "use-builtin-memfuncs";
    private static final @NonNull String TAG_STM_CONFIG = "stm-storage-backend-config";
    private static final @NonNull String TAG_STREAMING_CONFIG = "streaming-config";
    private static final String TAG_STM_STARTING_CHANNEL_NUMBER = "starting-channel-number";
    private static final String TAG_STM_NUMBER_OF_CHANNELS = "number-of-channels";
    private static final String TAG_STM_HEADER_EVERY_N_RECORDS = "header-every-n-records";
    private static final String TAG_STM_MASTER_IDS = "master-ids";
    private static final String TAG_STM_MASTER_ID = "value";
    private static final @NonNull String TAG_DWT_CONFIG = "dwt-config";
    private static final @NonNull String TAG_DWT_PC_SAMPLING_PERIOD = "pc-sampling-period";
    private static final @NonNull String TAG_ITM_CONFIG = "itm-config";
    private static final @NonNull String TAG_ITM_PORT_NUMBER = "port-number";
    private static final @NonNull String TAG_ITM_NUM_PORTS = "occuppied-port-count";
    private static final @NonNull String TAG_TARGET_NAME = "target-name";
    private static final @NonNull String TAG_CLOCK_INFO = "clock-info";
    private static final String TAG_CLOCK_BASE = "timestamp-base";
    private static final String TAG_CLOCK_DIVISOR = "timestamp-divisor";
    private static final String TAG_CLOCK_MULTIPLIER = "timestamp-multiplier";
    private static final String TAG_CLOCK_UNIX_BASE = "unix-base";
    private static final int XML_VERSION = 1;

    public static @NonNull EventsAndPmusXmlPaths getEventsAndPmusXmlPaths(@NonNull String barmanConfigPath) {
        @Nullable String @NonNull [] attributes = BarmanConfigurationXML.getXmlAttributes(barmanConfigPath, ATTR_PMUS_XML, ATTR_EVENTS_XML);
        return new EventsAndPmusXmlPaths(attributes[0], attributes[1]);
    }

    public static @NonNull BarmanConfiguration parse(@NonNull InputStream stream, @NonNull Map<Integer, ProcessorPmu> processorPmuConfigurations, @Nullable Consumer<@NonNull String> warningConsumer) throws IOException {
        DefaultConfigSettings configSettings = null;
        Enum dataStorageBackend = null;
        List<BarmanProcessorConfiguration> processorConfigurations = null;
        List<CustomChart> customCharts = null;
        String pmusXmlPath = null;
        String eventsXmlPath = null;
        STMBackendConfiguration stmConfiguration = null;
        StreamingConfiguration streamingConfiguration = null;
        DWTConfiguration dwtConfiguration = null;
        ITMBackendConfiguration itmConfiguration = null;
        String targetName = null;
        BarmanHeaderDataV1.ClockInfo clockInfo = null;
        Throwable throwable = null;
        Object var16_17 = null;
        try (XMLParser parser = new XMLParser(stream);){
            String tag;
            if (!TAG_ROOT.equals(parser.nextTag())) {
                throw new IOException("Invalid XML document");
            }
            if (parser.getIntegerAttribute(ATTR_VERSION, 0) != 1) {
                throw new IOException("Invalid version");
            }
            pmusXmlPath = parser.getAttribute(ATTR_PMUS_XML);
            eventsXmlPath = parser.getAttribute(ATTR_EVENTS_XML);
            while ((tag = parser.nextTag()) != null) {
                String tagPath = (String)NullChecking.neverNull((Object)String.format("<%s>", tag));
                String marker = (String)NullChecking.neverNull((Object)parser.getMarker());
                switch (tag) {
                    case "runtime-config-defaults": {
                        if (configSettings != null) {
                            throw new IOException(String.format("Duplicate <%s>", tag));
                        }
                        configSettings = BarmanConfigurationXML.parseRuntimeConfigDefaults(parser, marker);
                        break;
                    }
                    case "data-store": {
                        dataStorageBackend = BarmanConfigurationXML.parseElement(parser, dataStorageBackend, DataStorageBackend::parseXmlElementText, tagPath);
                        break;
                    }
                    case "stm-storage-backend-config": {
                        stmConfiguration = BarmanConfigurationXML.parseStmConfig(parser);
                        break;
                    }
                    case "dwt-config": {
                        dwtConfiguration = BarmanConfigurationXML.parseDwtConfig(parser);
                        break;
                    }
                    case "itm-config": {
                        itmConfiguration = BarmanConfigurationXML.parseItmConfig(parser);
                        break;
                    }
                    case "streaming-config": {
                        streamingConfiguration = BarmanConfigurationXML.parseStreamingConfig(parser);
                        break;
                    }
                    case "processors": {
                        if (processorConfigurations != null) {
                            throw new IOException(String.format("Duplicate <%s>", tag));
                        }
                        processorConfigurations = BarmanConfigurationXML.parseProcessors(parser, marker, processorPmuConfigurations, warningConsumer);
                        break;
                    }
                    case "custom-charts": {
                        if (customCharts != null) {
                            throw new IOException(String.format("Duplicate <%s>", tag));
                        }
                        customCharts = BarmanConfigurationXML.parseCustomCharts(parser, marker);
                        break;
                    }
                    case "target-name": {
                        if (targetName != null) {
                            throw new IOException(String.format("Duplicate <%s>", tag));
                        }
                        targetName = parser.getText();
                        break;
                    }
                    case "clock-info": {
                        if (clockInfo != null) {
                            throw new IOException(String.format("Duplicate <%s>", tag));
                        }
                        clockInfo = BarmanConfigurationXML.parseClockInfo(parser);
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Unexpected element <%s>", tag));
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (configSettings == null) {
            throw new IOException(String.format("Missing <%s> element", TAG_RUNTIME_CONFIG_DEFAULTS));
        }
        if (dataStorageBackend == null) {
            throw new IOException(String.format("Missing <%s> element", TAG_DATA_STORE));
        }
        if (dataStorageBackend.equals((Object)DataStorageBackend.STM_INTERFACE) && stmConfiguration == null) {
            throw new IOException(String.format("Missing <%s> element - required when STM is selected storage backend", TAG_STM_CONFIG));
        }
        return new BarmanConfiguration(pmusXmlPath, eventsXmlPath, (DataStorageBackend)dataStorageBackend, configSettings, processorConfigurations, customCharts, stmConfiguration, streamingConfiguration, dwtConfiguration, itmConfiguration, targetName, clockInfo);
    }

    private static ITMBackendConfiguration parseItmConfig(XMLParser parser) throws IOException {
        String tag;
        @NonNull ITMBackendConfiguration result = new ITMBackendConfiguration();
        String marker = parser.getMarker();
        while ((tag = parser.nextTag(marker)) != null) {
            switch (tag) {
                case "port-number": {
                    int portNumber = Integer.parseInt(parser.getText());
                    result.setPortNumber((byte)portNumber);
                    break;
                }
                case "occuppied-port-count": {
                    int numPorts = Integer.parseInt(parser.getText());
                    result.setNumPortsUsed((byte)numPorts);
                    break;
                }
                default: {
                    throw new IOException(String.format("Invalid <%s> element in ITM configuration", tag));
                }
            }
        }
        try {
            result.validate();
        }
        catch (Throwable e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }

    private static DWTConfiguration parseDwtConfig(XMLParser parser) throws IOException {
        String tag;
        @NonNull DWTConfiguration result = new DWTConfiguration();
        String marker = parser.getMarker();
        while ((tag = parser.nextTag(marker)) != null) {
            switch (tag) {
                case "pc-sampling-period": {
                    int pcSamplingPeriod = Integer.parseInt(parser.getText());
                    result.setPCSamplingPeriod(pcSamplingPeriod);
                    break;
                }
                default: {
                    throw new IOException(String.format("Invalid <%s> element in DWT configuration", tag));
                }
            }
        }
        return result;
    }

    public static STMBackendConfiguration parseStmConfig(XMLParser parser) throws NullPointerException, IOException {
        String tag;
        STMBackendConfiguration result = new STMBackendConfiguration();
        String marker = parser.getMarker();
        block16: while ((tag = parser.nextTag(marker)) != null) {
            switch (tag) {
                case "master-ids": {
                    String marker2 = parser.getMarker();
                    while ((tag = parser.nextTag(marker2)) != null) {
                        switch (tag) {
                            case "value": {
                                int masterId = BarmanConfigurationXML.parseHexOrDecimal(parser);
                                result.getMasterIds().add(masterId);
                                break;
                            }
                            default: {
                                throw new IOException(String.format("Unexpected element <%s> in <%s>", tag, TAG_STM_MASTER_ID));
                            }
                        }
                    }
                    continue block16;
                }
                case "starting-channel-number": {
                    int startingChannelNumber = BarmanConfigurationXML.parseHexOrDecimal(parser);
                    result.setMinChannelNumber(startingChannelNumber);
                    break;
                }
                case "number-of-channels": {
                    int numberOfChannels = BarmanConfigurationXML.parseHexOrDecimal(parser);
                    result.setNumberOfChannels(numberOfChannels);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unexpected element <%s>", tag));
                }
            }
        }
        return result;
    }

    private static int parseHexOrDecimal(XMLParser parser) throws IOException {
        String addressString = parser.getText();
        int address = addressString.startsWith("0x") ? Integer.parseUnsignedInt(addressString.replace("0x", ""), 16) : Integer.parseUnsignedInt(addressString, 10);
        return address;
    }

    private static long parseLongHexOrDecimal(XMLParser parser) throws IOException {
        String addressString = parser.getText();
        long address = addressString.startsWith("0x") ? Long.parseUnsignedLong(addressString.replace("0x", ""), 16) : Long.parseUnsignedLong(addressString, 10);
        return address;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeXmlFile(@NonNull BarmanConfiguration configuration, @NonNull File file) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try (XMLGenerator generator = new XMLGenerator((OutputStream)stream);){
                    generator.startDocument();
                    generator.startTag(TAG_ROOT);
                    generator.addAttribute(ATTR_VERSION, 1);
                    if (configuration.getPmusXmlPath() != null) {
                        generator.addAttribute(ATTR_PMUS_XML, configuration.getPmusXmlPath());
                    }
                    if (configuration.getEventsXmlPath() != null) {
                        generator.addAttribute(ATTR_EVENTS_XML, configuration.getEventsXmlPath());
                    }
                    BarmanConfigurationXML.writeXml(generator, configuration.getConfigSettings());
                    BarmanConfigurationXML.addTextTag(generator, TAG_DATA_STORE, configuration.getDataStorageBackend().getXmlValue());
                    BarmanConfigurationXML.addTextTag(generator, TAG_TARGET_NAME, configuration.getTargetName());
                    BarmanConfigurationXML.writeClockInfo(generator, configuration.getClockInfo());
                    BarmanConfigurationXML.writeStmConfig(generator, configuration.getStmConfiguration());
                    BarmanConfigurationXML.writeStreamingConfig(generator, configuration.getStreamingConfiguration());
                    BarmanConfigurationXML.writeDwtConfig(generator, configuration.getDWTConfiguration());
                    BarmanConfigurationXML.writeItmConfig(generator, configuration.getITMConfiguration());
                    BarmanConfigurationXML.writeProcessorsXml(generator, configuration.getProcessors());
                    BarmanConfigurationXML.writeChartsXml(generator, configuration.getCustomCharts());
                    generator.endTag();
                    generator.endDocument();
                }
                if (stream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void writeDwtConfig(@NonNull XMLGenerator generator, @Nullable DWTConfiguration dwtConfiguration) throws IOException {
        if (dwtConfiguration != null) {
            int period = dwtConfiguration.getPCSamplingPeriod();
            generator.startTag(TAG_DWT_CONFIG);
            generator.startTag(TAG_DWT_PC_SAMPLING_PERIOD);
            generator.addText(Integer.toString(period));
            generator.endTag();
            generator.endTag();
        }
    }

    private static void writeItmConfig(@NonNull XMLGenerator generator, @Nullable ITMBackendConfiguration dwtConfiguration) throws IOException {
        if (dwtConfiguration != null) {
            byte portNumber = dwtConfiguration.getPortNumber();
            byte numPorts = dwtConfiguration.getNumPortsUsed();
            generator.startTag(TAG_ITM_CONFIG);
            generator.startTag(TAG_ITM_PORT_NUMBER);
            generator.addText(Integer.toString(portNumber));
            generator.endTag();
            generator.startTag(TAG_ITM_NUM_PORTS);
            generator.addText(Integer.toString(numPorts));
            generator.endTag();
            generator.endTag();
        }
    }

    public static void writeStreamingConfig(@NonNull XMLGenerator generator, @Nullable StreamingConfiguration streamingConfiguration) throws IOException {
        if (streamingConfiguration != null) {
            @NonNull StreamingConfiguration config = (StreamingConfiguration)NullChecking.neverNull((Object)streamingConfiguration);
            generator.startTag(TAG_STREAMING_CONFIG);
            generator.startTag(TAG_STM_HEADER_EVERY_N_RECORDS);
            generator.addText(Long.toString(config.getHeaderEveryNRecords()));
            generator.endTag();
            generator.endTag();
        }
    }

    public static void writeClockInfo(XMLGenerator generator, @Nullable BarmanHeaderDataV1.ClockInfo clockInfo) throws IOException {
        if (clockInfo != null) {
            generator.startTag(TAG_CLOCK_INFO);
            generator.startTag(TAG_CLOCK_BASE);
            generator.addText(Long.toString(clockInfo.getTimestampBase()));
            generator.endTag();
            generator.startTag(TAG_CLOCK_UNIX_BASE);
            generator.addText(Long.toString(clockInfo.getUnixBaseNs()));
            generator.endTag();
            generator.startTag(TAG_CLOCK_MULTIPLIER);
            generator.addText(Long.toString(clockInfo.getTimestampMultiplier()));
            generator.endTag();
            generator.startTag(TAG_CLOCK_DIVISOR);
            generator.addText(Long.toString(clockInfo.getTimestampDivisor()));
            generator.endTag();
            generator.endTag();
        }
    }

    public static void writeStmConfig(XMLGenerator generator, @Nullable STMBackendConfiguration stmConfiguration) throws IOException {
        if (stmConfiguration != null) {
            @NonNull STMBackendConfiguration config = (STMBackendConfiguration)NullChecking.neverNull((Object)stmConfiguration);
            generator.startTag(TAG_STM_CONFIG);
            generator.startTag(TAG_STM_STARTING_CHANNEL_NUMBER);
            generator.addText(Long.toString(config.getMinChannelNumber()));
            generator.endTag();
            generator.startTag(TAG_STM_NUMBER_OF_CHANNELS);
            generator.addText(Long.toString(config.getNumberOfChannels()));
            generator.endTag();
            generator.startTag(TAG_STM_MASTER_IDS);
            for (Integer masterId : config.getMasterIds()) {
                generator.startTag(TAG_STM_MASTER_ID);
                generator.addText(String.format("0x%x", masterId));
                generator.endTag();
            }
            generator.endTag();
            generator.endTag();
        }
    }

    private static void addTextTag(@NonNull XMLGenerator generator, @NonNull String tag, boolean value) throws IOException {
        BarmanConfigurationXML.addTextTag(generator, tag, (Object)value);
    }

    private static void addTextTag(@NonNull XMLGenerator generator, @NonNull String tag, int value) throws IOException {
        BarmanConfigurationXML.addTextTag(generator, tag, (Object)value);
    }

    private static void addTextTag(@NonNull XMLGenerator generator, @NonNull String tag, long value) throws IOException {
        BarmanConfigurationXML.addTextTag(generator, tag, (Object)value);
    }

    private static void addTextTag(@NonNull XMLGenerator generator, @NonNull String tag, Object value) throws IOException {
        generator.startTag(tag);
        generator.addText(String.valueOf(value));
        generator.endTag();
    }

    private static @NonNull Boolean booleanText(String text) throws IOException {
        if ("true".equals(text)) {
            return (Boolean)NullChecking.neverNull((Object)Boolean.TRUE);
        }
        if ("false".equals(text)) {
            return (Boolean)NullChecking.neverNull((Object)Boolean.FALSE);
        }
        throw new IOException(String.format("Invalid boolean value: '%s'", text));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static @Nullable String @NonNull [] getXmlAttributes(@NonNull String barmanConfigPath, String ... attrNames) {
        @Nullable String @NonNull [] result = new String[attrNames.length];
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream stream = new FileInputStream(barmanConfigPath);
                try {
                    try (XMLParser parser = new XMLParser((InputStream)stream);){
                        if (TAG_ROOT.equals(parser.nextTag()) && parser.getIntegerAttribute(ATTR_VERSION, 0) == 1) {
                            int i = 0;
                            while (i < attrNames.length) {
                                String attrValue = parser.getAttribute(attrNames[i]);
                                if (attrValue != null && !attrValue.isEmpty()) {
                                    result[i] = attrValue;
                                }
                                ++i;
                            }
                        }
                    }
                    if (stream == null) return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static @Nullable Boolean optionalBooleanText(@Nullable String text) throws IOException {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return BarmanConfigurationXML.booleanText(text);
    }

    private static <T extends Enum<T>> @Nullable T optionalEnumText(@NonNull T @NonNull [] values, @Nullable String text, String tagPath) throws IOException {
        if (text == null || text.isEmpty()) {
            return null;
        }
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (((Enum)value).name().equalsIgnoreCase(text)) {
                return value;
            }
            ++n2;
        }
        throw new IOException(String.format("Invalid value in %s: %s", tagPath, text));
    }

    private static <T> @Nullable T optionalValueText(@Nullable String text, @NonNull Function<String, T> transformer, String tagPath) throws IOException {
        block3: {
            try {
                if (text != null && !text.isEmpty()) break block3;
            }
            catch (Throwable t) {
                throw new IOException(String.format("Failed to parse %s: '%s'", tagPath, text), t);
            }
            return null;
        }
        return (T)NullChecking.neverNull(transformer.apply(text));
    }

    private static @NonNull List<@NonNull CustomChart> parseCustomCharts(@NonNull XMLParser parser, @NonNull String marker) throws IOException {
        String tag;
        TreeMap<String, CustomChart> map = new TreeMap<String, CustomChart>();
        block6: while ((tag = parser.nextTag(marker)) != null) {
            String tagPath = (String)NullChecking.neverNull((Object)String.format("<%s>/<%s>", TAG_CUSTOM_CHARTS, tag));
            switch (tag) {
                case "chart": {
                    String name = (String)NullChecking.neverNull((Object)parser.getAttribute(ATTR_NAME));
                    SeriesComposition seriesComposition = (SeriesComposition)BarmanConfigurationXML.optionalEnumText((Enum[])SeriesComposition.values(), (String)parser.getAttribute(ATTR_SERIES_COMPOSITION), (String)String.format("%s/@%s", tagPath, ATTR_SERIES_COMPOSITION));
                    GraphRenderingType renderingType = (GraphRenderingType)BarmanConfigurationXML.optionalEnumText((Enum[])GraphRenderingType.values(), (String)parser.getAttribute(ATTR_RENDERING_TYPE), (String)String.format("%s/@%s", tagPath, ATTR_RENDERING_TYPE));
                    Boolean averageSelection = BarmanConfigurationXML.optionalBooleanText(parser.getAttribute(ATTR_AVERAGE_SELECTION));
                    Boolean averageCores = BarmanConfigurationXML.optionalBooleanText(parser.getAttribute(ATTR_AVERAGE_CORES));
                    Boolean percentage = BarmanConfigurationXML.optionalBooleanText(parser.getAttribute(ATTR_PERCENTAGE));
                    Boolean perCpu = BarmanConfigurationXML.optionalBooleanText(parser.getAttribute(ATTR_PER_CPU));
                    List<@NonNull CustomChartSeries> series = BarmanConfigurationXML.parseCustomChartSeries(parser, (String)NullChecking.neverNull((Object)parser.getMarker()), name);
                    if (seriesComposition != null && !seriesComposition.canBeSwitchedTo()) {
                        throw new IOException(String.format("Invalid seriesComposition %s in element %s", parser.getAttribute(ATTR_SERIES_COMPOSITION), tagPath));
                    }
                    CustomChart newChart = new CustomChart(name, seriesComposition, renderingType, averageSelection, averageCores, percentage, perCpu, series);
                    CustomChart oldChart = map.put(newChart.getKeyName(), newChart);
                    if (oldChart == null) continue block6;
                    throw new IOException(String.format("Duplicate (or too similar) named chart: '%s' vs '%s'", newChart.getName(), oldChart.getName()));
                }
                default: {
                    throw new IOException(String.format("Unexpected element %s", tagPath));
                }
            }
        }
        ArrayList<@NonNull CustomChart> result = new ArrayList<CustomChart>(map.values());
        return result;
    }

    public static @NonNull BarmanHeaderDataV1.ClockInfo parseClockInfo(@NonNull XMLParser parser) throws IOException {
        String tag;
        long timestampBase = 0L;
        long timestampDivisor = 1L;
        long timestampMultiplier = 1L;
        long unixBaseNs = 0L;
        String marker = parser.getMarker();
        while ((tag = parser.nextTag(marker)) != null) {
            String tagPath = (String)NullChecking.neverNull((Object)String.format("<%s>/<%s>", TAG_CLOCK_INFO, tag));
            switch (tag) {
                case "timestamp-base": {
                    timestampBase = BarmanConfigurationXML.parseLongHexOrDecimal(parser);
                    break;
                }
                case "timestamp-divisor": {
                    timestampDivisor = BarmanConfigurationXML.parseLongHexOrDecimal(parser);
                    break;
                }
                case "timestamp-multiplier": {
                    timestampMultiplier = BarmanConfigurationXML.parseLongHexOrDecimal(parser);
                    break;
                }
                case "unix-base": {
                    unixBaseNs = BarmanConfigurationXML.parseLongHexOrDecimal(parser);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unexpected element %s", tagPath));
                }
            }
        }
        return new BarmanHeaderDataV1.ClockInfo(timestampBase, timestampMultiplier, timestampDivisor, unixBaseNs);
    }

    private static @NonNull List<@NonNull CustomChartSeries> parseCustomChartSeries(@NonNull XMLParser parser, @NonNull String marker, @NonNull String chartName) throws IOException {
        String tag;
        TreeMap<String, CustomChartSeries> map = new TreeMap<String, CustomChartSeries>();
        block6: while ((tag = parser.nextTag(marker)) != null) {
            String tagPath = (String)NullChecking.neverNull((Object)String.format("<%s>/<%s>/<%s>", TAG_CUSTOM_CHARTS, TAG_CHART, tag));
            switch (tag) {
                case "series": {
                    String name = (String)NullChecking.neverNull((Object)parser.getAttribute(ATTR_NAME));
                    String units = parser.getAttribute(ATTR_UNITS);
                    Boolean sample = BarmanConfigurationXML.optionalBooleanText(parser.getAttribute(ATTR_SAMPLE));
                    CounterClass clazz = (CounterClass)BarmanConfigurationXML.optionalEnumText((Enum[])CounterClass.values(), (String)parser.getAttribute(ATTR_CLASS), (String)String.format("%s/@%s", tagPath, ATTR_CLASS));
                    CounterDisplay display = (CounterDisplay)BarmanConfigurationXML.optionalEnumText((Enum[])CounterDisplay.values(), (String)parser.getAttribute(ATTR_DISPLAY), (String)String.format("%s/@%s", tagPath, ATTR_DISPLAY));
                    Double multiplier = BarmanConfigurationXML.optionalValueText(parser.getAttribute(ATTR_MULTIPLIER), Double::parseDouble, String.format("%s/@%s", tagPath, ATTR_MULTIPLIER));
                    Integer colour = BarmanConfigurationXML.optionalValueText(parser.getAttribute(ATTR_COLOUR), Integer::decode, String.format("%s/@%s", tagPath, ATTR_COLOUR));
                    String description = parser.getAttribute(ATTR_DESCRIPTION);
                    CustomChartSeries newSeries = new CustomChartSeries(name, units, sample, multiplier, clazz, display, colour, description);
                    CustomChartSeries oldSeries = map.put(newSeries.getKeyName(), newSeries);
                    if (oldSeries != null) {
                        throw new IOException(String.format("Duplicate (or too similar) series '%s' vs '%s' in '%s'", newSeries.getName(), oldSeries.getName(), chartName));
                    }
                    if (!newSeries.getDisplay().isCompatibleWith(newSeries.getClazz())) {
                        throw new IOException(String.format("Incompatible class and display values for series '%s' in '%s'", name, chartName));
                    }
                    if (!newSeries.getClazz().isActivity()) continue block6;
                    throw new IOException(String.format("Activity charts are not supported for series '%s' in '%s'", name, chartName));
                }
                default: {
                    throw new IOException(String.format("Unexpected element %s", tagPath));
                }
            }
        }
        ArrayList<@NonNull CustomChartSeries> result = new ArrayList<CustomChartSeries>(map.values());
        return result;
    }

    private static <T> @NonNull T parseElement(@NonNull XMLParser parser, @Nullable T value, @NonNull ThrowingFunction<String, T, IOException> transformer, @NonNull String tagPath) throws IOException {
        if (value != null) {
            throw new IOException(String.format("Duplicate %s", tagPath));
        }
        return (T)NullChecking.neverNull(transformer.apply(parser.getText()));
    }

    private static @NonNull Set<@NonNull Integer> parseProcessorEvents(@NonNull XMLParser parser, @NonNull String marker, @NonNull String parentPath, @NonNull ProcessorPmu processorPmu) throws IOException {
        String tag;
        HashSet<@NonNull Integer> result = new HashSet<Integer>();
        block6: while ((tag = parser.nextTag(marker)) != null) {
            String tagPath = (String)NullChecking.neverNull((Object)String.format("%s/<%s>", parentPath, tag));
            switch (tag) {
                case "event": {
                    if (!parser.hasAttribute(ATTR_TYPE)) {
                        throw new IOException(String.format("Missing type attribute in element %s", tagPath));
                    }
                    Integer type = (Integer)NullChecking.neverNull((Object)Integer.decode(parser.getAttribute(ATTR_TYPE)));
                    result.add((Integer)NullChecking.neverNull((Object)type));
                    if (processorPmu.getEvents().containsKey(type)) continue block6;
                    throw new IOException(String.format("Invalid event type %s in %s", type, tagPath));
                }
                default: {
                    throw new IOException(String.format("Unexpected element %s", tagPath));
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static @NonNull List<@NonNull BarmanProcessorConfiguration> parseProcessors(@NonNull XMLParser parser, @NonNull String marker, @NonNull Map<Integer, ProcessorPmu> processorPmuConfigurations, @Nullable Consumer<@NonNull String> warningConsumer) throws IOException {
        String tag;
        TreeSet<@NonNull ProcessorPmu> pmus = new TreeSet<ProcessorPmu>();
        ArrayList<@NonNull BarmanProcessorConfiguration> result = new ArrayList<BarmanProcessorConfiguration>();
        while ((tag = parser.nextTag(marker)) != null) {
            String tagPath = (String)NullChecking.neverNull((Object)String.format("<%s>/<%s>", TAG_PROCESSORS, tag));
            switch (tag) {
                case "processor": {
                    boolean hasName = parser.hasAttribute(ATTR_NAME);
                    boolean hasCpuid = parser.hasAttribute(ATTR_CPUID);
                    if (hasName && hasCpuid && warningConsumer != null) {
                        warningConsumer.accept(String.format("Name is ignored in %s if cpuid attribute is specified", tagPath));
                    } else if (!hasName && !hasCpuid) {
                        throw new IOException(String.format("Missing name or cpuid attribute in %s", tagPath));
                    }
                    ProcessorPmu pmuFound = null;
                    if (hasCpuid) {
                        String cpuidText = parser.getAttribute(ATTR_CPUID);
                        Integer cpuid = Integer.decode(cpuidText);
                        pmuFound = processorPmuConfigurations.get(cpuid);
                        if (pmuFound == null) throw new IOException(String.format("Invalid %s value: '%s'", tagPath, cpuidText));
                        if (pmus.contains(pmuFound)) {
                            throw new IOException(String.format("Processor variant cpuid=0x%s used in multiple processor entries in '%s'", Integer.toHexString(cpuid), tagPath));
                        }
                    } else {
                        assert (hasName);
                        String name = parser.getAttribute(ATTR_NAME);
                        for (ProcessorPmu pmu : processorPmuConfigurations.values()) {
                            if (!pmu.getId().equals(name)) continue;
                            pmuFound = pmu;
                            if (!pmus.contains(pmu)) continue;
                            throw new IOException(String.format("Processor variant name='%s' used in multiple processor entries in '%s'", name, tagPath));
                        }
                        if (pmuFound == null) {
                            for (ProcessorPmu pmu : processorPmuConfigurations.values()) {
                                if (!pmu.getCounterSet().equals(name)) continue;
                                pmuFound = pmu;
                                if (!pmus.contains(pmu)) continue;
                                throw new IOException(String.format("Processor variant name='%s' used in multiple processor entries in '%s'", name, tagPath));
                            }
                        }
                        if (pmuFound == null) {
                            throw new IOException(String.format("Invalid %s value: '%s'", tagPath, name));
                        }
                    }
                    String cycleCounters = parser.getAttribute(ATTR_CYCLE_COUNTERS);
                    Set<@NonNull Integer> events = BarmanConfigurationXML.parseProcessorEvents(parser, (String)NullChecking.neverNull((Object)parser.getMarker()), tagPath, (ProcessorPmu)NullChecking.neverNull((Object)pmuFound));
                    result.add(new BarmanProcessorConfiguration((ProcessorPmu)NullChecking.neverNull((Object)pmuFound), BarmanConfigurationXML.optionalBooleanText(cycleCounters), events));
                    pmus.add(pmuFound);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unexpected element %s", tagPath));
                }
            }
        }
        if (!result.isEmpty()) return result;
        throw new IOException("No processors provided");
    }

    private static @NonNull DefaultConfigSettings parseRuntimeConfigDefaults(@NonNull XMLParser parser, @NonNull String marker) throws IOException {
        String tag;
        Boolean useBuiltinMemfuncs = null;
        Boolean enableDebugLogging = null;
        Boolean enableLogging = null;
        Integer maxProcessors = null;
        Integer maxTaskEntries = null;
        Integer maxMmapLayoutEntries = null;
        Long minSamplePeriod = null;
        while ((tag = parser.nextTag(marker)) != null) {
            String tagPath = (String)NullChecking.neverNull((Object)String.format("<%s>/<%s>", TAG_RUNTIME_CONFIG_DEFAULTS, tag));
            switch (tag) {
                case "use-builtin-memfuncs": {
                    useBuiltinMemfuncs = BarmanConfigurationXML.parseElement(parser, useBuiltinMemfuncs, BarmanConfigurationXML::booleanText, tagPath);
                    break;
                }
                case "enable-debug-logging": {
                    enableDebugLogging = BarmanConfigurationXML.parseElement(parser, enableDebugLogging, BarmanConfigurationXML::booleanText, tagPath);
                    break;
                }
                case "enable-logging": {
                    enableLogging = BarmanConfigurationXML.parseElement(parser, enableLogging, BarmanConfigurationXML::booleanText, tagPath);
                    break;
                }
                case "max-processors": {
                    maxProcessors = BarmanConfigurationXML.parseElement(parser, maxProcessors, Integer::decode, tagPath);
                    break;
                }
                case "max-task-entries": {
                    maxTaskEntries = BarmanConfigurationXML.parseElement(parser, maxTaskEntries, Integer::decode, tagPath);
                    break;
                }
                case "max-mmap-layout-entries": {
                    maxMmapLayoutEntries = BarmanConfigurationXML.parseElement(parser, maxMmapLayoutEntries, Integer::decode, tagPath);
                    break;
                }
                case "min-sample-period": {
                    minSamplePeriod = BarmanConfigurationXML.parseElement(parser, minSamplePeriod, Long::decode, tagPath);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unexpected element %s", tagPath));
                }
            }
        }
        return new DefaultConfigSettings(enableLogging != null ? enableLogging : false, enableDebugLogging != null ? enableDebugLogging : false, useBuiltinMemfuncs != null ? useBuiltinMemfuncs : true, maxProcessors != null ? maxProcessors : 1, maxTaskEntries != null ? maxTaskEntries : 0, maxMmapLayoutEntries != null ? maxMmapLayoutEntries : 0, minSamplePeriod != null ? minSamplePeriod : 0L);
    }

    private static void writeChartsXml(@NonNull XMLGenerator generator, @NonNull List<@NonNull CustomChart> customCharts) throws IOException {
        generator.startTag(TAG_CUSTOM_CHARTS);
        for (CustomChart chart : customCharts) {
            BarmanConfigurationXML.writeXml(generator, chart);
        }
        generator.endTag();
    }

    private static void writeProcessorsXml(@NonNull XMLGenerator generator, @NonNull List<@NonNull BarmanProcessorConfiguration> processors) throws IOException {
        generator.startTag(TAG_PROCESSORS);
        for (BarmanProcessorConfiguration processor : processors) {
            BarmanConfigurationXML.writeXml(generator, processor);
        }
        generator.endTag();
    }

    private static void writeXml(@NonNull XMLGenerator generator, @NonNull BarmanProcessorConfiguration processor) throws IOException {
        ProcessorPmu pmu = processor.getProcessorPmu();
        generator.startTag(TAG_PROCESSOR);
        generator.addAttribute(ATTR_NAME, pmu.getId());
        generator.addAttribute(ATTR_CPUID, String.format("0x%x", pmu.getCpuids()[0]));
        generator.addAttributeBool(ATTR_CYCLE_COUNTERS, processor.isSampleCycleCounter());
        for (Integer event : processor.getEvents()) {
            generator.startEmptyTag(TAG_EVENT);
            generator.addAttribute(ATTR_TYPE, String.format("0x%x", event));
        }
        generator.endTag();
    }

    private static void writeXml(@NonNull XMLGenerator generator, @NonNull CustomChart chart) throws IOException {
        generator.startTag(TAG_CHART);
        generator.addAttribute(ATTR_NAME, chart.getName());
        generator.addAttribute(ATTR_SERIES_COMPOSITION, chart.getSeriesComposition().name().toLowerCase());
        generator.addAttribute(ATTR_RENDERING_TYPE, chart.getRenderingType().name().toLowerCase());
        generator.addAttributeBool(ATTR_AVERAGE_SELECTION, chart.isAverageSelection());
        generator.addAttributeBool(ATTR_AVERAGE_CORES, chart.isAverageCores());
        generator.addAttributeBool(ATTR_PERCENTAGE, chart.isPercentage());
        generator.addAttributeBool(ATTR_PER_CPU, chart.isPerCpu());
        for (CustomChartSeries series : chart.getSeries()) {
            BarmanConfigurationXML.writeXml(generator, series);
        }
        generator.endTag();
    }

    private static void writeXml(@NonNull XMLGenerator generator, @NonNull CustomChartSeries series) throws IOException {
        Integer colour = series.getColour();
        generator.startTag(TAG_SERIES);
        generator.addAttribute(ATTR_NAME, series.getName());
        generator.addAttribute(ATTR_DESCRIPTION, series.getDescription());
        generator.addAttribute(ATTR_MULTIPLIER, series.getMultiplier());
        generator.addAttribute(ATTR_UNITS, series.getUnits());
        if (colour != null) {
            generator.addAttribute(ATTR_COLOUR, String.format("0x%x", colour));
        }
        generator.addAttribute(ATTR_CLASS, series.getClazz().name().toLowerCase());
        generator.addAttribute(ATTR_DISPLAY, series.getDisplay().name().toLowerCase());
        generator.addAttributeBool(ATTR_SAMPLE, series.isSample());
        generator.endTag();
    }

    private static void writeXml(@NonNull XMLGenerator generator, @NonNull DefaultConfigSettings configSettings) throws IOException {
        generator.startTag(TAG_RUNTIME_CONFIG_DEFAULTS);
        BarmanConfigurationXML.addTextTag(generator, TAG_USE_BUILTIN_MEMFUNCS, configSettings.isEnableBuiltinMemFuncs());
        BarmanConfigurationXML.addTextTag(generator, TAG_ENABLE_DEBUG_LOGGING, configSettings.isEnableDebugLogging());
        BarmanConfigurationXML.addTextTag(generator, TAG_ENABLE_LOGGING, configSettings.isEnableLogging());
        BarmanConfigurationXML.addTextTag(generator, TAG_MAX_PROCESSORS, configSettings.getMaxCores());
        BarmanConfigurationXML.addTextTag(generator, TAG_MAX_MMAP_LAYOUT_ENTRIES, configSettings.getMaxMmapLayoutEntries());
        BarmanConfigurationXML.addTextTag(generator, TAG_MAX_TASK_ENTRIES, configSettings.getMaxTaskEntries());
        BarmanConfigurationXML.addTextTag(generator, TAG_MIN_SAMPLE_PERIOD, configSettings.getMinimumSamplePeriod());
        generator.endTag();
    }

    public static StreamingConfiguration parseStreamingConfig(@NonNull XMLParser parser) throws IOException {
        String tag;
        StreamingConfiguration result = new StreamingConfiguration();
        String marker = parser.getMarker();
        while ((tag = parser.nextTag(marker)) != null) {
            switch (tag) {
                case "header-every-n-records": {
                    int everyN = BarmanConfigurationXML.parseHexOrDecimal(parser);
                    result.setHeaderEveryNRecords(everyN);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unexpected element <%s>", tag));
                }
            }
        }
        return result;
    }

    public static class EventsAndPmusXmlPaths {
        public final @Nullable String pmusXmlPath;
        public final @Nullable String eventsXmlPath;

        public EventsAndPmusXmlPaths(@Nullable String pmusXmlPath, @Nullable String eventsXmlPath) {
            this.pmusXmlPath = pmusXmlPath;
            this.eventsXmlPath = eventsXmlPath;
        }
    }
}

