/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.utils;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class WizardUtils {
    private static final @NonNull IFileOrDirectoryDialogWrapper<IDirectoryInputHelper> DIALOG_WRAPPER_DIRECTORY = (shell, title, helper, currentValue) -> {
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setText(title);
        dialog.setFilterPath(helper.getFilterPath(currentValue));
        return dialog.open();
    };
    private static final @NonNull IFileOrDirectoryDialogWrapper<IFileInputHelper> DIALOG_WRAPPER_FILE = (shell, title, helper, currentValue) -> {
        FileDialog dialog = new FileDialog(shell);
        dialog.setFilterPath(helper.getFilterPath(currentValue));
        dialog.setText(title);
        dialog.setFilterExtensions(helper.getFilterExtensions());
        dialog.setFilterNames(helper.getFilterNames());
        return dialog.open();
    };

    public static Button addCheckbox(Composite parent, String label, String tooltip, final Function<@NonNull Boolean, @NonNull Boolean> handler) {
        return SWTUtils.createCheckbox(parent, label, tooltip, new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button widget = (Button)e.widget;
                boolean wasSelected = widget.getSelection();
                boolean isSelected = (Boolean)handler.apply((Boolean)NullChecking.neverNull((Object)wasSelected));
                if (isSelected != wasSelected) {
                    widget.setSelection(isSelected);
                }
            }
        });
    }

    public static @NonNull LabelAndTextField addDirectoryInput(@NonNull Composite composite, @NonNull String title, @NonNull String tooltip, @NonNull String tooltipButton, @Nullable String defaultValue, @NonNull IDirectoryInputHelper helper) {
        return WizardUtils.addFileOrFolderInput(composite, title, tooltip, tooltipButton, defaultValue, helper, DIALOG_WRAPPER_DIRECTORY);
    }

    public static @NonNull LabelAndTextField addDirectoryInputToExistingComposite(@NonNull Composite composite, @NonNull String title, @NonNull String tooltip, @NonNull String tooltipButton, @Nullable String defaultValue, @NonNull IDirectoryInputHelper helper) {
        return WizardUtils.addFileOrFolderInputToExistingComposite(composite, title, tooltip, tooltipButton, defaultValue, helper, DIALOG_WRAPPER_DIRECTORY);
    }

    public static @NonNull LabelAndTextField addFileInput(@NonNull Composite composite, @NonNull String title, @NonNull String tooltip, @NonNull String tooltipButton, @Nullable String defaultValue, @NonNull IFileInputHelper helper) {
        return WizardUtils.addFileOrFolderInput(composite, title, tooltip, tooltipButton, defaultValue, helper, DIALOG_WRAPPER_FILE);
    }

    public static @NonNull LabelAndTextField addFileInputToExistingComposite(@NonNull Composite composite, @NonNull String title, @NonNull String tooltip, @NonNull String tooltipButton, @Nullable String defaultValue, @NonNull IFileInputHelper helper) {
        return WizardUtils.addFileOrFolderInputToExistingComposite(composite, title, tooltip, tooltipButton, defaultValue, helper, DIALOG_WRAPPER_FILE);
    }

    public static Spinner addSpinner(Composite container, int min, int max, String label, String tooltip, final Function<@NonNull Integer, @NonNull Integer> handler) {
        return SWTUtils.addSpinner(container, min, max, label, tooltip, new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int newValue;
                Spinner widget = (Spinner)e.widget;
                int oldValue = widget.getSelection();
                if (oldValue != (newValue = ((Integer)handler.apply((Integer)NullChecking.neverNull((Object)oldValue))).intValue())) {
                    widget.setSelection(newValue);
                }
            }
        });
    }

    private static <T extends IFileOrDirectoryInputHelper> @NonNull LabelAndTextField addFileOrFolderInput(@NonNull Composite composite, @NonNull String title, @NonNull String tooltip, @NonNull String tooltipButton, @Nullable String defaultValue, @NonNull T helper, @NonNull IFileOrDirectoryDialogWrapper<T> dialogWrapper) {
        Composite box = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(box);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)box);
        return WizardUtils.addFileOrFolderInputToExistingComposite(box, title, tooltip, tooltipButton, defaultValue, helper, dialogWrapper);
    }

    private static <T extends IFileOrDirectoryInputHelper> @NonNull LabelAndTextField addFileOrFolderInputToExistingComposite(final @NonNull Composite composite, @NonNull String title, @NonNull String tooltip, final @NonNull String tooltipButton, @Nullable String defaultValue, final @NonNull T helper, final @NonNull IFileOrDirectoryDialogWrapper<T> dialogWrapper) {
        Label label = new Label(composite, 0);
        label.setText(title);
        label.setToolTipText(tooltip);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        final TextField input = new TextField(composite, StreamlinePlugin.getImage("Browse.png"));
        Color defaultColour = input.getTextForeground();
        Color errorColour = input.getDisplay().getSystemColor(3);
        input.setText(defaultValue != null ? defaultValue : "");
        input.setToolTipText(tooltip);
        input.addFieldModifiedListener(f -> {
            String currentLocation = (String)NullChecking.neverNull((Object)f.getText());
            String saveLocation = helper.onInputChanged(currentLocation);
            if (saveLocation != null) {
                input.setTextForeground(defaultColour);
                if (!saveLocation.equals(currentLocation)) {
                    input.setText(saveLocation);
                }
            } else {
                input.setTextForeground(errorColour);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)input);
        input.addClickListener(new TextField.IClickListener(){

            @Override
            public void buttonClicked(TextField field) {
                String saveLocation = dialogWrapper.open((Shell)NullChecking.neverNull((Object)composite.getShell()), tooltipButton, helper, (String)NullChecking.neverNull((Object)input.getText()));
                if (saveLocation != null) {
                    input.setText(saveLocation);
                }
            }
        });
        return new LabelAndTextField(label, input);
    }

    public static interface IDirectoryInputHelper
    extends IFileOrDirectoryInputHelper {
    }

    public static interface IFileInputHelper
    extends IFileOrDirectoryInputHelper {
        public @NonNull String @NonNull [] getFilterExtensions();

        public @NonNull String @NonNull [] getFilterNames();
    }

    @FunctionalInterface
    private static interface IFileOrDirectoryDialogWrapper<T extends IFileOrDirectoryInputHelper> {
        public @Nullable String open(@NonNull Shell var1, @NonNull String var2, @NonNull T var3, @NonNull String var4);
    }

    public static interface IFileOrDirectoryInputHelper {
        public @NonNull String getFilterPath(@NonNull String var1);

        public @Nullable String onInputChanged(@NonNull String var1);
    }

    public static class LabelAndTextField {
        public final @NonNull Label label;
        public final @NonNull TextField textField;

        public LabelAndTextField(@NonNull Label label, @NonNull TextField textField) {
            this.label = label;
            this.textField = textField;
        }
    }
}

