/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.utils;

import com.arm.streamline.barmancfg.wizard.utils.WizardUtils;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import com.arm.utils.NullChecking;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractFileOrDirectoryInputHelper
implements WizardUtils.IFileOrDirectoryInputHelper {
    private final @NonNull ILastFilterPathStore filterPathStore;

    private static @Nullable File makeDirectory(@NonNull String path) {
        File result;
        if (!path.isEmpty() && (result = new File(path)).exists()) {
            if (result.isDirectory()) {
                return result;
            }
            return result.getParentFile();
        }
        return null;
    }

    public AbstractFileOrDirectoryInputHelper(@NonNull ILastFilterPathStore filterPathStore) {
        this.filterPathStore = filterPathStore;
    }

    @Override
    public final @NonNull String getFilterPath(@NonNull String currentValue) {
        File currentDirectory = AbstractFileOrDirectoryInputHelper.makeDirectory(currentValue);
        if (currentDirectory != null) {
            return (String)NullChecking.neverNull((Object)currentDirectory.getAbsolutePath());
        }
        File lastDirectory = this.filterPathStore.getLastFilterPath();
        return (String)NullChecking.neverNull((Object)lastDirectory.getAbsolutePath());
    }

    @Override
    public final @Nullable String onInputChanged(@NonNull String currentValue) {
        File resultDirectory;
        String result = this.handleInputChanged(currentValue);
        if (result != null && (resultDirectory = AbstractFileOrDirectoryInputHelper.makeDirectory(result)) != null) {
            this.filterPathStore.setLastFilterPath(resultDirectory);
        }
        return result;
    }

    protected abstract @Nullable String handleInputChanged(@NonNull String var1);
}

