/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.events;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barmancfg.wizard.events.AvailableProcessorPmuRow;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventRow;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.text.NumericStringComparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ProcessorPmuCell
implements ICell<SimpleColumn> {
    private static final int H_MARGIN = 4;
    private static final int V_MARGIN = 1;

    private static String getData(@Nullable Row<SimpleColumn> row, @NonNull SimpleColumn column, boolean nullOK) {
        if (row != null) {
            String text = row.getDataAsText(column);
            return text == null ? (nullOK ? null : "") : text;
        }
        return column.toString();
    }

    private static Color getForegroundTextColor(@Nullable Row<SimpleColumn> row, boolean selected, boolean active) {
        if (row instanceof ProcessorPmuEventRow && ((ProcessorPmuEventRow)row).isHighlighted()) {
            selected = false;
        }
        if (row instanceof BaseRow) {
            return ((BaseRow)row).getForegroundTextColor(selected, active);
        }
        return Colors.getText(selected && active);
    }

    @Override
    public int compare(SimpleColumn column, Row<SimpleColumn> one, Row<SimpleColumn> two) {
        return NumericStringComparator.caselessCompareStrings((String)one.getDataAsText(column), (String)two.getDataAsText(column));
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<SimpleColumn> row, SimpleColumn column, boolean selected, boolean active) {
        int cellHeight = bounds.height - 2;
        int x = bounds.x + 4;
        int cellWidth = bounds.width - 8;
        int y = bounds.y + 1;
        if (row instanceof ProcessorPmuEventRow) {
            if (((ProcessorPmuEventRow)row).isHighlighted()) {
                gc.setBackground(Colors.lighten(Colors.getYellow(), 75));
                gc.fillRectangle(bounds);
            }
            Image target = StreamlinePlugin.getImage("Target.png");
            Rectangle imgBounds = target.getBounds();
            OutlineModel<SimpleColumn> owner = row.getOwner();
            int tmp = imgBounds.width - owner.getIndentWidth() + 4;
            x += tmp;
            cellWidth -= tmp;
        }
        Font savedFont = gc.getFont();
        gc.setFont(Fonts.getNormal());
        gc.setForeground(ProcessorPmuCell.getForegroundTextColor(row, selected, active));
        int right = TextDrawing.drawString(gc, ProcessorPmuCell.getData(row, column, false), x, y, cellWidth, cellHeight, 16384, 0x1000000);
        if (row instanceof AvailableProcessorPmuRow && (cellWidth -= (right += 4) - x) > 0) {
            gc.setFont(Fonts.getSmall());
            TextDrawing.drawString(gc, ((AvailableProcessorPmuRow)row).getAvailableText(), right, bounds.y, cellWidth, bounds.height, 131072, 0x1000000);
        }
        gc.setFont(savedFont);
    }

    @Override
    public int getMinimumContentWidth() {
        return 0;
    }

    @Override
    public Point getPreferredSize(Row<SimpleColumn> row, SimpleColumn column) {
        Point size;
        String data = ProcessorPmuCell.getData(row, column, true);
        Point point = size = data != null ? FontInfo.get(Fonts.getNormal()).getExtent(data) : new Point(0, 0);
        if (row instanceof AvailableProcessorPmuRow) {
            size.x += FontInfo.get(Fonts.getSmall()).getWidth(((AvailableProcessorPmuRow)row).getAvailableText()) + 4;
        }
        size.x += 8;
        size.y += 2;
        return size;
    }

    @Override
    public String getToolTipText(Outline<SimpleColumn> outline, Point where, Row<SimpleColumn> row, SimpleColumn column) {
        return null;
    }
}

