/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.events;

import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.IStickyHeader;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class AbstractProcessorPmuRow
extends BaseRow
implements IStickyHeader {
    protected final @NonNull ProcessorPmu pmu;

    public AbstractProcessorPmuRow(@NonNull ProcessorPmu pmu) {
        this.pmu = pmu;
        this.setCanHaveChildren(true);
        this.setOpen(true);
    }

    @Override
    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        return Colors.getBlack();
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        return String.format("%s (%s)", this.pmu.getCoreName(), Arrays.stream(this.pmu.getCpuids()).mapToObj(Integer::valueOf).map(c -> String.format("0x%05x", c)).collect(Collectors.joining("/")));
    }

    @Override
    public Color getForegroundTextColor(boolean selected, boolean active) {
        return Colors.getWhite();
    }

    public @NonNull ProcessorPmu getPmu() {
        return this.pmu;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }
}

