/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.custcounters;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.custcounters.CustomChartWidget;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CustomChartSeriesWidget
extends Composite {
    private @NonNull CounterClass configClazz = CustomChartSeries.DEFAULT_CLASS;
    private @NonNull RGB configColour = new RGB(1, 1, 1);
    private boolean configColourEnabled = false;
    private @NonNull String configDescription = "";
    private @NonNull CounterDisplay configDisplay = CounterDisplay.getDisplay(null, (CounterClass)CustomChartSeries.DEFAULT_CLASS);
    private @Nullable Double configMultiplier = 1.0;
    private @NonNull String configName = "";
    private boolean configSample = false;
    private @NonNull String configUnits = "";
    private final @NonNull CustomChartWidget parent;

    public CustomChartSeriesWidget(@NonNull CustomChartWidget parent, @Nullable CustomChartSeries defaults, @NonNull Composite seriesContainer) {
        super(seriesContainer, 0);
        this.parent = parent;
        if (defaults != null) {
            Integer colour = defaults.getColour();
            if (colour != null) {
                this.configColour = new RGB(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
                this.configColourEnabled = true;
            } else {
                this.configColourEnabled = false;
            }
            this.configClazz = defaults.getClazz();
            this.configDescription = defaults.getDescription();
            this.configDisplay = defaults.getDisplay();
            this.configMultiplier = defaults.getMultiplier();
            this.configName = defaults.getName();
            this.configSample = defaults.isSample();
            this.configUnits = defaults.getUnits();
            if (!this.configDisplay.isCompatibleWith(this.configClazz)) {
                this.configDisplay = CounterDisplay.getDisplay(null, (CounterClass)this.configClazz);
            }
        }
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 0;
        super.setLayout((Layout)layout);
        Composite children = new Composite((Composite)this, 2048);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(2, 2).spacing(2, 2).applyTo(children);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)children);
        Button removeButton = new Button((Composite)this, 8);
        removeButton.setImage(StreamlinePlugin.getImage("Remove.gif"));
        removeButton.addListener(13, e -> parent.removeSeries(this));
        Composite box = new Composite(children, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(box);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)box);
        Label label = new Label(box, 0);
        label.setText(BarmanWizardMessages.PAGE_4_LABEL_NAME_INPUT);
        label.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_NAME_INPUT);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        TextField input = new TextField(box);
        input.setText(this.configName);
        input.addFieldModifiedListener(f -> {
            this.configName = (String)NullChecking.neverNull((Object)f.getText());
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)input);
        box = new Composite(children, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(box);
        GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)box);
        label = new Label(box, 0);
        label.setText(ChartMessages.SERIES_UNIT);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        input = new TextField(box);
        input.setText(this.configUnits);
        input.addFieldModifiedListener(f -> {
            this.configUnits = (String)NullChecking.neverNull((Object)f.getText());
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(50, -1).applyTo((Control)input);
        box = new Composite(children, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(box);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 128).grab(true, false).applyTo((Control)box);
        label = new Label(box, 0);
        label.setText(ChartMessages.SERIES_DESCRIPTION_TITLE);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        input = new TextField(box);
        input.setText(this.configDescription);
        input.addFieldModifiedListener(f -> {
            this.configDescription = (String)NullChecking.neverNull((Object)f.getText());
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)input);
        Composite optionsBox = new Composite(children, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).extendedMargins(0, 0, 0, 5).equalWidth(false).applyTo(optionsBox);
        GridDataFactory.fillDefaults().span(2, 1).align(16384, 128).grab(true, false).applyTo((Control)optionsBox);
        Composite box2 = new Composite(optionsBox, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(box2);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)box2);
        Label label2 = new Label(box2, 0);
        label2.setText(BarmanWizardMessages.PAGE_4_LABEL_SERIES_CLASS_AND_DISPLAY);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label2);
        Combo classInput = new Combo(box2, 2048);
        Combo displayInput = new Combo(box2, 2048);
        classInput.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_CLASS);
        classInput.addListener(13, e -> {
            @NonNull List values = (List)classInput.getData();
            this.configClazz = (CounterClass)values.get(classInput.getSelectionIndex());
            if (!this.configDisplay.isCompatibleWith(this.configClazz)) {
                this.configDisplay = CounterDisplay.getDisplay(null, (CounterClass)this.configClazz);
            }
            SWTUtils.addAllCombo(displayInput, CounterDisplay.values(), this.configDisplay, s -> s.isCompatibleWith(this.configClazz) ? s.getPresentationName() : null);
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)classInput);
        displayInput.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_DISPLAY);
        displayInput.addListener(13, e -> {
            @NonNull List values = (List)displayInput.getData();
            this.configDisplay = (CounterDisplay)values.get(displayInput.getSelectionIndex());
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)displayInput);
        SWTUtils.addAllCombo(classInput, CounterClass.values(), this.configClazz, s -> !s.isActivity() ? s.getPresentationName() : null);
        SWTUtils.addAllCombo(displayInput, CounterDisplay.values(), this.configDisplay, s -> s.isCompatibleWith(this.configClazz) ? s.getPresentationName() : null);
        box2 = new Composite(optionsBox, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(box2);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)box2);
        label2 = new Label(box2, 0);
        label2.setText(BarmanWizardMessages.PAGE_4_LABEL_SERIES_MULTIPLIER);
        label2.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_MULTIPLIER);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label2);
        TextField input2 = new TextField(box2);
        Color defaultTextColour = input2.getTextForeground();
        Color errorTextColour = this.getDisplay().getSystemColor(3);
        input2.setText(((Double)NullChecking.neverNull((Object)this.configMultiplier)).toString());
        input2.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_MULTIPLIER);
        input2.addFieldModifiedListener(f -> {
            try {
                this.configMultiplier = Double.valueOf(f.getText());
                f.setTextForeground(defaultTextColour);
            }
            catch (NumberFormatException e) {
                this.configMultiplier = null;
                f.setTextForeground(errorTextColour);
            }
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)input2);
        Button input3 = new Button(optionsBox, 32);
        input3.setText(BarmanWizardMessages.PAGE_4_LABEL_SERIES_SAMPLE);
        input3.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_SAMPLE);
        input3.setSelection(this.configSample);
        input3.addListener(13, e -> {
            this.configSample = input3.getSelection();
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)input3);
        box2 = new Composite(optionsBox, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(box2);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)box2);
        Button enable = new Button(box2, 32);
        Button colourButton = new Button(box2, 8);
        enable.setSelection(this.configColourEnabled);
        enable.setText(BarmanWizardMessages.PAGE_4_LABEL_SERIES_COLOUR);
        enable.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_COLOUR);
        enable.addListener(13, e -> {
            this.configColourEnabled = enable.getSelection();
            colourButton.setVisible(this.configColourEnabled);
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)enable);
        colourButton.setVisible(this.configColourEnabled);
        colourButton.setImage(this.makeColourImage(this.configColour));
        colourButton.setToolTipText(BarmanWizardMessages.PAGE_4_TOOLTIP_SERIES_COLOUR);
        colourButton.addListener(13, e -> {
            ColorDialog picker = new ColorDialog(colourButton.getShell());
            picker.setRGB(this.configColour);
            picker.setText(BarmanWizardMessages.PAGE_4_TITLE_COLOUR_PICKER);
            RGB result = picker.open();
            if (result != null) {
                this.configColour = result;
                Image oldImage = colourButton.getImage();
                if (oldImage != null) {
                    oldImage.dispose();
                }
                colourButton.setImage(this.makeColourImage(result));
                this.configColourEnabled = true;
                enable.setSelection(true);
            }
            this.validateInput();
        });
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)colourButton);
    }

    public @NonNull CustomChartSeries getCustomChartSeries() {
        Integer colour = this.configColourEnabled ? Integer.valueOf((this.configColour.red & 0xFF) << 16 | (this.configColour.green & 0xFF) << 8 | this.configColour.blue & 0xFF) : null;
        return new CustomChartSeries(this.configName, this.configUnits, this.configSample, this.configMultiplier, this.configClazz, this.configDisplay, colour, this.configDescription);
    }

    public boolean isValid() {
        return !this.configName.isEmpty() && this.configDisplay.isCompatibleWith(this.configClazz) && this.configMultiplier != null;
    }

    public void setLayout(Layout layout) {
    }

    private @Nullable Image makeColourImage(@Nullable RGB rgb) {
        if (rgb == null) {
            return null;
        }
        ImageData imageData = new ImageData(16, 16, 24, new PaletteData(255, 65280, 0xFF0000));
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                imageData.setPixel(x, y, rgb.red & 0xFF | (rgb.green & 0xFF) << 8 | (rgb.blue & 0xFF) << 16);
                ++x;
            }
            ++y;
        }
        return new Image((Device)this.getDisplay(), imageData);
    }

    private void validateInput() {
        this.parent.notifySeriesChanged(this);
    }
}

