/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.ITMBackendConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class BarmanITMConfigPage
extends WizardPage {
    private static final String PAGE_NAME = "ITM_OPTIONS_PAGE";
    private final @NonNull IWizardPage nextPage;
    private final @NonNull BarmanConfiguration defaults;
    private static byte selectedPortNumber;
    private Spinner portNumberSpinner;

    protected BarmanITMConfigPage(@NonNull IWizard wizard, @NonNull IWizardPage nextPage, @NonNull BarmanConfiguration defaults) {
        super(PAGE_NAME);
        this.setWizard(wizard);
        this.setTitle(BarmanWizardMessages.BarmanITMConfigPage_TITLE);
        this.nextPage = nextPage;
        this.defaults = defaults;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(composite);
        Label portNumberLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)portNumberLabel);
        portNumberLabel.setText(BarmanWizardMessages.BarmanITMConfigPage_PORT_NUMBER_LABEL);
        this.portNumberSpinner = new Spinner(composite, 2048);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.portNumberSpinner);
        this.portNumberSpinner.setMinimum(0);
        this.portNumberSpinner.setMaximum(31);
        this.portNumberSpinner.setSelection(0);
        this.portNumberSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectedPortNumber = (byte)BarmanITMConfigPage.this.portNumberSpinner.getSelection();
            }
        });
        this.setDefaults();
        this.setControl((Control)composite);
    }

    private void setDefaults() {
        ITMBackendConfiguration config = this.defaults.getITMConfiguration();
        if (config != null) {
            selectedPortNumber = config.getPortNumber();
            this.portNumberSpinner.setSelection((int)config.getPortNumber());
        } else {
            this.portNumberSpinner.setSelection((int)selectedPortNumber);
        }
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public @NonNull ITMBackendConfiguration getItmConfiguration() {
        ITMBackendConfiguration result = new ITMBackendConfiguration();
        result.setPortNumber(selectedPortNumber);
        return result;
    }
}

