/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.configuration.DWTConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.configuration.DefaultConfigSettings;
import com.arm.streamline.barmancfg.configuration.ITMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.STMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.StreamingConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanAddCustomCountersPage;
import com.arm.streamline.barmancfg.wizard.BarmanDWTConfigPage;
import com.arm.streamline.barmancfg.wizard.BarmanITMConfigPage;
import com.arm.streamline.barmancfg.wizard.BarmanOutputOptionsPage;
import com.arm.streamline.barmancfg.wizard.BarmanSelectConfigOptionsPage;
import com.arm.streamline.barmancfg.wizard.BarmanSelectEventsPage;
import com.arm.streamline.barmancfg.wizard.BarmanSelectProcessorsPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.BarmanWizardSTMConfigPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardSummaryPage;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class BarmanGeneratorWizard
extends Wizard {
    private final @NonNull BarmanSelectConfigOptionsPage page1;
    private final @NonNull BarmanSelectProcessorsPage page2;
    private final @NonNull BarmanSelectEventsPage page3;
    private final @NonNull BarmanAddCustomCountersPage page4;
    private final @NonNull BarmanOutputOptionsPage page5;
    private final @NonNull BarmanWizardSummaryPage page6;
    private @Nullable ITMBackendConfiguration itmConfig = null;

    public BarmanGeneratorWizard(@Nullable File defaultOutputPath, @Nullable BarmanConfiguration barmanConfiguration) {
        boolean mustViewSummaryPage;
        boolean openAdvancedPage;
        boolean bl = openAdvancedPage = barmanConfiguration != null;
        if (barmanConfiguration == null) {
            mustViewSummaryPage = true;
            barmanConfiguration = new BarmanConfiguration(null, null, DataStorageBackend.LINEAR_RAM_BUFFER, new DefaultConfigSettings(), new ArrayList<BarmanProcessorConfiguration>(), new ArrayList<CustomChart>(), null, null, null, null, null, null);
        } else {
            mustViewSummaryPage = true;
            this.itmConfig = barmanConfiguration.getITMConfiguration();
        }
        this.page1 = new BarmanSelectConfigOptionsPage(barmanConfiguration, openAdvancedPage);
        this.page2 = new BarmanSelectProcessorsPage(barmanConfiguration, this.page1);
        this.page3 = new BarmanSelectEventsPage(barmanConfiguration, this.page1);
        this.page4 = new BarmanAddCustomCountersPage(barmanConfiguration);
        this.page5 = new BarmanOutputOptionsPage(defaultOutputPath, this.page1);
        this.page6 = new BarmanWizardSummaryPage(mustViewSummaryPage);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
        this.addPage((IWizardPage)this.page4);
        this.addPage((IWizardPage)this.page5);
        this.addPage((IWizardPage)this.page6);
    }

    public boolean canFinish() {
        if (super.canFinish()) {
            DefaultConfigSettings configs = this.page1.getDefaultConfigSettings();
            DataStorageBackend dataStoreBackend = this.page1.getDataStorageBackend();
            List<@NonNull BarmanProcessorConfiguration> processors = this.page3.getProcessorsAndEvents();
            return configs != null && dataStoreBackend != null && processors != null && this.page6.isPageComplete();
        }
        return false;
    }

    public IWizardPage getStartingPage() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setMinimumSize(800, 500);
        }
        return super.getStartingPage();
    }

    public @NonNull BarmanConfiguration getBarmanConfiguration() {
        DefaultConfigSettings configs = this.page1.getDefaultConfigSettings();
        DataStorageBackend dataStoreBackend = this.page1.getDataStorageBackend();
        List<@NonNull BarmanProcessorConfiguration> processors = this.page3.getProcessorsAndEvents();
        List<@NonNull CustomChart> customCharts = this.page4.getCustomCharts();
        STMBackendConfiguration stmConfiguration = null;
        StreamingConfiguration streamingConfiguration = null;
        DWTConfiguration dwtConfiguration = null;
        ITMBackendConfiguration itmConfiguration = null;
        if (dataStoreBackend != null) {
            switch (dataStoreBackend) {
                case STM_INTERFACE: {
                    BarmanWizardSTMConfigPage stmPage = (BarmanWizardSTMConfigPage)this.page1.getNextPage();
                    stmConfiguration = stmPage.getStmConfiguration();
                    streamingConfiguration = stmPage.getStreamingConfiguration();
                    break;
                }
                case ITM_INTERFACE: {
                    if (this.page3.getNextPage() instanceof BarmanDWTConfigPage) {
                        BarmanDWTConfigPage dwtPage = (BarmanDWTConfigPage)this.page3.getNextPage();
                        dwtConfiguration = dwtPage.getDWTConfiguration();
                    }
                    if (this.page1.getNextPage() instanceof BarmanITMConfigPage) {
                        BarmanITMConfigPage itmPage = (BarmanITMConfigPage)this.page1.getNextPage();
                        itmConfiguration = itmPage.getItmConfiguration();
                        break;
                    }
                    if (this.itmConfig != null) {
                        itmConfiguration = this.itmConfig;
                        break;
                    }
                    itmConfiguration = new ITMBackendConfiguration();
                    break;
                }
            }
        }
        return new BarmanConfiguration(this.page1.getPmusXmlPath(), this.page1.getEventsXmlPath(), (DataStorageBackend)((Object)NullChecking.neverNull((Object)((Object)dataStoreBackend))), (DefaultConfigSettings)NullChecking.neverNull((Object)configs), (List)NullChecking.neverNull(processors), customCharts, stmConfiguration, streamingConfiguration, dwtConfiguration, itmConfiguration, null, null);
    }

    public @Nullable File getOutputPath() {
        return this.page5.getOutputPath();
    }

    public String getWindowTitle() {
        return BarmanWizardMessages.WINDOWS_TITLE;
    }

    public boolean isGenerateSourceFiles() {
        return this.page5.isGenerateSourceFiles();
    }

    public boolean isSaveConfigFile() {
        return this.page5.isSaveConfigFile();
    }

    public boolean performFinish() {
        return true;
    }
}

