/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen.header;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.gen.header.IBarmanHeaderGenerator;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.utils.NullChecking;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class PmuEventConstantsGenerator
implements IBarmanHeaderGenerator {
    public static final String TOKEN = "PMU_EVENT_CONSTANTS";

    @Override
    public @NonNull String generate(@NonNull String token, @NonNull BarmanConfiguration configuration) {
        HashSet<String> duplicates = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        result.append(" * @brief Enumerates all the event type constants for all the supported processors.\n");
        result.append(" */\n");
        result.append("enum barman_processor_pmu_events {\n");
        boolean firstEnum = true;
        for (BarmanProcessorConfiguration processor : configuration.getProcessors()) {
            ProcessorPmu pmu = processor.getProcessorPmu();
            boolean firstPmu = true;
            for (ProcessorPmuEventDescription event : pmu.getEvents().values()) {
                if (!duplicates.add(event.getConstantName())) continue;
                if (!firstEnum) {
                    result.append(",\n");
                }
                firstEnum = false;
                if (firstPmu) {
                    result.append(String.format("\n    /* ---- Processor events for %s (%s) ---- */\n\n", pmu.getCoreName(), Arrays.stream(pmu.getCpuids()).mapToObj(Integer::valueOf).map(c -> String.format("0x%05x", c)).collect(Collectors.joining("/"))));
                }
                firstPmu = false;
                result.append(String.format("    /** %s */\n", event.getComment()));
                result.append(String.format("    %s = 0x%x", event.getConstantName(), event.getEventID()));
            }
        }
        if (!firstEnum) {
            result.append("\n");
        }
        result.append("};\n");
        return (String)NullChecking.neverNull((Object)result.toString());
    }
}

