/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.configuration;

import com.arm.streamline.barmancfg.BarmanGenerator;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum DataStorageBackend {
    CIRCULAR_RAM_BUFFER("circular", 0, (Set)BarmanGenerator.BARE_METAL_IN_MEMORY_CLASSIFICATIONS){

        @Override
        public void addRequiredSourceLines(@NonNull StringBuilder builder) {
            builder.append("#if BM_CONFIG_USE_DATASTORE == BM_CONFIG_USE_DATASTORE_CIRCULAR_RAM_BUFFER\n");
            builder.append("#include \"data-store/barman-circular-ram-buffer.c\"\n");
            builder.append("#endif\n\n");
        }

        @Override
        public @NonNull String getConstant() {
            return "BM_CONFIG_USE_DATASTORE_CIRCULAR_RAM_BUFFER";
        }

        @Override
        public @Nullable String getHelperScriptName() {
            return "barman_in_memory_helpers.py";
        }
    }
    ,
    ITM_INTERFACE("itm_interface", 3, (Set)BarmanGenerator.BARE_METAL_ITM_CLASSIFICATIONS){

        @Override
        public void addRequiredSourceLines(@NonNull StringBuilder builder) {
            builder.append("#if BM_CONFIG_USE_DATASTORE == BM_CONFIG_USE_DATASTORE_ITM\n");
            builder.append("#include \"data-store/barman-itm.c\"\n");
            builder.append("#endif\n\n");
        }

        @Override
        public @NonNull String getConstant() {
            return "BM_CONFIG_USE_DATASTORE_ITM";
        }

        @Override
        public @Nullable String getHelperScriptName() {
            return null;
        }
    }
    ,
    LINEAR_RAM_BUFFER("linear", 1, (Set)BarmanGenerator.BARE_METAL_IN_MEMORY_CLASSIFICATIONS){

        @Override
        public void addRequiredSourceLines(@NonNull StringBuilder builder) {
            builder.append("#if BM_CONFIG_USE_DATASTORE == BM_CONFIG_USE_DATASTORE_LINEAR_RAM_BUFFER\n");
            builder.append("#include \"data-store/barman-linear-ram-buffer.c\"\n");
            builder.append("#endif\n\n");
        }

        @Override
        public @NonNull String getConstant() {
            return "BM_CONFIG_USE_DATASTORE_LINEAR_RAM_BUFFER";
        }

        @Override
        public @Nullable String getHelperScriptName() {
            return "barman_in_memory_helpers.py";
        }
    }
    ,
    STM_INTERFACE("stm_interface", 4, (Set)BarmanGenerator.BARE_METAL_STM_CLASSIFICATIONS){

        @Override
        public void addRequiredSourceLines(@NonNull StringBuilder builder) {
            builder.append("#if BM_CONFIG_USE_DATASTORE == BM_CONFIG_USE_DATASTORE_STM\n");
            builder.append("#include \"data-store/barman-stm.c\"\n");
            builder.append("#endif\n\n");
        }

        @Override
        public @NonNull String getConstant() {
            return "BM_CONFIG_USE_DATASTORE_STM";
        }

        @Override
        public @Nullable String getHelperScriptName() {
            return null;
        }
    };

    private final @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> allowedClassifications;
    private final int sortOrder;
    private final @NonNull String xmlValue;

    public static @NonNull DataStorageBackend parseXmlElementText(String text) throws IOException {
        DataStorageBackend[] dataStorageBackendArray = DataStorageBackend.values();
        int n = dataStorageBackendArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataStorageBackend value = dataStorageBackendArray[n2];
            if (value.xmlValue.equals(text)) {
                return value;
            }
            ++n2;
        }
        throw new IOException(String.format("Invalid data store value '%s'", text));
    }

    public static @NonNull DataStorageBackend @NonNull [] valuesSorted() {
        @NonNull DataStorageBackend @NonNull [] values = DataStorageBackend.values();
        Arrays.sort(values, (a, b) -> Integer.compare(a.sortOrder, b.sortOrder));
        return values;
    }

    private DataStorageBackend(@NonNull String xmlValue, int sortOrder, Set<ProcessorPmu.ArchitectureProfile> allowedClassifications) {
        this.xmlValue = xmlValue;
        this.sortOrder = sortOrder;
        this.allowedClassifications = allowedClassifications;
    }

    public abstract void addRequiredSourceLines(@NonNull StringBuilder var1);

    public @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    ProcessorPmu.ArchitectureProfile> getAllowedClassifications() {
        return this.allowedClassifications;
    }

    public abstract @NonNull String getConstant();

    public abstract @Nullable String getHelperScriptName();

    public @NonNull String getXmlValue() {
        return this.xmlValue;
    }
}

