/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.BarmanMessages;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.databrowser.DocumentsMessages;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum BarmanWarningType {
    DATA_LOST(0){

        @Override
        public void process(@NonNull IBarmanEventStream eventStream, long timestamp, int core) throws IOException {
            eventStream.warning(timestamp, 0, new WarningItem(WarningType.CORRUPTION, WarningSeverity.LOW, BarmanMessages.DATA_LOST_TITLE, BarmanMessages.DATA_LOST_DESCRIPTION));
        }
    }
    ,
    DECODE_ERROR(5){

        @Override
        public void process(@NonNull IBarmanEventStream eventStream, long timestamp, int core) throws IOException {
            eventStream.warning(timestamp, 0, new WarningItem(WarningType.CORRUPTION, WarningSeverity.LOW, BarmanMessages.DECODE_ERROR_TITLE, BarmanMessages.DECODE_ERROR_DESCRIPTION));
        }
    }
    ,
    DWT_CYCLE_PERIOD_ROUNDED(3){

        @Override
        public void process(@NonNull IBarmanEventStream eventStream, long timestamp, int core) throws IOException {
            eventStream.warning(timestamp, 0, new WarningItem(WarningType.BARMAN_DWT, WarningSeverity.LOW, DocumentsMessages.ITM_WARNING_TITLE, BarmanWizardMessages.BarmanDWTConfigPage_INTERVAL_TRUNCATED));
        }
    }
    ,
    MISSING_CORE_INFO(4){

        @Override
        public void process(@NonNull IBarmanEventStream eventStream, long timestamp, int core) throws IOException {
            Integer coreNo = core;
            eventStream.warning(timestamp, 0, new WarningItem(WarningType.CORRUPTION, WarningSeverity.LOW, BarmanMessages.INVALID_CORE_NO_TITLE, MessageFormat.format(BarmanMessages.INVALID_CORE_NO_DESCRIPTION, coreNo)));
        }
    }
    ,
    TIME_OVERFLOW(1){

        @Override
        public void process(@NonNull IBarmanEventStream eventStream, long timestamp, int core) throws IOException {
            eventStream.warning(timestamp, 0, new WarningItem(WarningType.CORRUPTION, WarningSeverity.LOW, BarmanMessages.TIMER_OVERFLOW_TITLE, BarmanMessages.TIMER_OVERFLOW_DESCRIPTION));
        }
    };

    private final int protocolValue;

    public static @Nullable BarmanWarningType fromProtocolValue(int protocolValue) {
        BarmanWarningType[] barmanWarningTypeArray = BarmanWarningType.values();
        int n = barmanWarningTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BarmanWarningType value = barmanWarningTypeArray[n2];
            if (value.protocolValue == protocolValue) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private BarmanWarningType(int protocolValue) {
        this.protocolValue = protocolValue;
    }

    public int getProtocolValue() {
        return this.protocolValue;
    }

    public abstract void process(@NonNull IBarmanEventStream var1, long var2, int var4) throws IOException;
}

