/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.recordstream.AbstractBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanTaskSwitchRecordV1
extends AbstractBarmanRecord {
    private final int core;
    private final int taskId;
    private final @NonNull Reason reason;

    public BarmanTaskSwitchRecordV1(long timestamp, int core, int taskId, @NonNull Reason reason) {
        super(timestamp);
        this.core = core;
        this.taskId = taskId;
        this.reason = reason;
    }

    public int getCore() {
        return this.core;
    }

    public @NonNull Reason getReason() {
        return this.reason;
    }

    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void process(@NonNull IBarmanEventStream eventStream) throws IOException {
        eventStream.schedSwitch(this.timestamp, this.core, this.taskId, this.reason.getDatabaseValue());
    }

    public String toString() {
        return String.format("TaskSwitch {timestamp : %s, taskId : %s, reason : %s}", new Object[]{this.timestamp, this.taskId, this.reason});
    }

    public static enum Reason {
        PREEMPTED(0, 0),
        WAIT(1, 2);

        private final byte protocolValue;
        private final int databaseValue;

        public static @NonNull Reason findReason(byte protocolValue) throws BarmanDataError {
            Reason[] reasonArray = Reason.values();
            int n = reasonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Reason value = reasonArray[n2];
                if (value.protocolValue == protocolValue) {
                    return value;
                }
                ++n2;
            }
            throw new BarmanDataError();
        }

        private Reason(byte protocolValue, int databaseValue) {
            this.protocolValue = protocolValue;
            this.databaseValue = databaseValue;
        }

        public int getDatabaseValue() {
            return this.databaseValue;
        }

        public byte getProtocolValue() {
            return this.protocolValue;
        }
    }
}

