/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.analysis.gator.IProtocolState;
import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanRecordFactory;
import com.arm.streamline.barman.v1.BarmanAnnotationRecordV2;
import com.arm.streamline.barman.v1.BarmanHaltEventRecordV2;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barman.v1.BarmanHeaderV1;
import com.arm.streamline.barman.v1.BarmanProtocolStateV3;
import com.arm.streamline.barman.v1.BarmanRecordType;
import com.arm.streamline.barman.v1.BarmanSampleRecordV1;
import com.arm.streamline.barman.v1.BarmanSampleRecordWithoutTaskV3;
import com.arm.streamline.barman.v1.BarmanTaskSwitchRecordV1;
import com.arm.streamline.barman.v1.BarmanWarningRecordV3;
import com.arm.streamline.barman.v1.BarmanWarningType;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanRecordFactoryV1
implements IBarmanRecordFactory<IBarmanRecord> {
    private final boolean bits64;
    private final @NonNull BarmanHeaderV1 header;
    private final int idleTaskId;
    private @NonNull BarmanProtocolStateV3 protocolState;
    private final @NonNull TIntSet validCores;

    private static @NonNull IBarmanRecord createWarningRecord(int core, long timestamp, @NonNull ByteBuffer buffer) throws BarmanDataError {
        int typeValue = buffer.getInt();
        @Nullable BarmanWarningType type = BarmanWarningType.fromProtocolValue(typeValue);
        if (type == null) {
            throw new BarmanDataError();
        }
        return new BarmanWarningRecordV3(timestamp, core, type);
    }

    public BarmanRecordFactoryV1(@NonNull BarmanHeaderV1 header, int idleTaskId) {
        this.idleTaskId = idleTaskId;
        this.header = header;
        this.bits64 = header.getTypeAndVersion().isBits64();
        @NonNull BarmanHeaderDataV1.PmuSettings @NonNull [] pmuSettings = header.getPerCorePmuSettings();
        this.validCores = new TIntHashSet(pmuSettings.length + 1, 1.0f, Integer.MIN_VALUE);
        int i = 0;
        while (i < pmuSettings.length) {
            if (pmuSettings[i].isValid()) {
                this.validCores.add(i);
            }
            ++i;
        }
        this.validCores.add(-1);
        this.protocolState = header.createInitialProtocolState();
    }

    @Override
    public @NonNull IBarmanRecord create(@NonNull ByteBuffer buffer) throws BarmanDataError {
        long timestamp;
        this.protocolState = this.protocolState.clone();
        @Nullable BarmanRecordType recordType = BarmanRecordType.fromInt(buffer.getInt());
        int core = buffer.getInt();
        long rawTimestamp = buffer.getLong();
        if (rawTimestamp == -1L) {
            timestamp = this.protocolState.getLastTimestamp();
        } else {
            timestamp = this.header.getClockInfo().convertTimestampToNs(rawTimestamp);
            this.protocolState.setLastTimestamp(timestamp);
        }
        if (!this.validCores.contains(core)) {
            return new BarmanWarningRecordV3(timestamp, core, BarmanWarningType.MISSING_CORE_INFO);
        }
        if (recordType != null) {
            switch (recordType) {
                case SAMPLE: {
                    return this.createSampleRecord(core, timestamp, buffer, false);
                }
                case SAMPLE_WITH_PC: {
                    return this.createSampleRecord(core, timestamp, buffer, true);
                }
                case TASK_SWITCH: {
                    return this.createTaskSwitchRecord(core, timestamp, buffer);
                }
                case CUSTOM_COUNTER: {
                    return this.createCustomCounterRecord(core, timestamp, buffer);
                }
                case HALT_EVENT: {
                    return this.createHaltEventRecord(core, timestamp, buffer);
                }
                case ANNOTATION: {
                    return this.createAnnotationRecord(timestamp, buffer);
                }
                case EVENT_COUNTER_WITHOUT_TASK_ID: {
                    return this.createEventCounterRecord(core, timestamp, buffer);
                }
                case PC_WITHOUT_TASK_ID: {
                    return this.createPcRecord(core, timestamp, buffer);
                }
                case WARNING: {
                    return BarmanRecordFactoryV1.createWarningRecord(core, timestamp, buffer);
                }
            }
        }
        throw new AssertionError((Object)"Invalid record type");
    }

    @Override
    public @NonNull IProtocolState getCurrentState() {
        return this.protocolState;
    }

    @Override
    public void setCurrentState(@Nullable IProtocolState state) throws BarmanDataError {
        if (!(state instanceof BarmanProtocolStateV3)) {
            throw new BarmanDataError();
        }
        this.protocolState = (BarmanProtocolStateV3)state;
    }

    private @NonNull IBarmanRecord createAnnotationRecord(long timestamp, @NonNull ByteBuffer buffer) throws BarmanDataError {
        int taskId = this.getTaskIdOrDefault(buffer);
        int dataLength = (int)this.readMachineWord(buffer);
        int channel = buffer.getInt();
        int group = buffer.getInt();
        int color = buffer.getInt();
        byte type = buffer.get();
        byte[] data = new byte[dataLength];
        buffer.get(data);
        return new BarmanAnnotationRecordV2(timestamp, taskId, BarmanAnnotationRecordV2.Type.findType(type), channel, group, color, data);
    }

    private @NonNull IBarmanRecord createCustomCounterRecord(int core, long timestamp, @NonNull ByteBuffer buffer) {
        int taskId = this.getTaskIdOrDefault(buffer);
        int id = buffer.getInt();
        long value = buffer.getLong();
        int key = this.header.getCounters().getCustomCounterKey(id);
        TIntLongHashMap counterValues = new TIntLongHashMap();
        counterValues.put(key, value);
        this.updateLastActiveTask(core, taskId);
        return new BarmanSampleRecordV1(timestamp, core, taskId, this.protocolState.getLastTaskSwitchReasonPerCore(core), 0L, (TIntLongMap)counterValues);
    }

    private @NonNull IBarmanRecord createEventCounterRecord(int core, long timestamp, @NonNull ByteBuffer buffer) {
        int type = buffer.getInt();
        long value = buffer.getLong();
        int key = this.header.getCounters().getProcessorEventKeyFromEventType(core, type);
        TIntLongHashMap counterValues = new TIntLongHashMap();
        counterValues.put(key, value);
        return new BarmanSampleRecordWithoutTaskV3(timestamp, core, (TIntLongMap)counterValues);
    }

    private @NonNull IBarmanRecord createHaltEventRecord(int core, long timestamp, @NonNull ByteBuffer buffer) {
        BarmanTaskSwitchRecordV1.Reason reason;
        int taskId;
        boolean enteredHalt;
        boolean bl = enteredHalt = buffer.get() != 0;
        if (enteredHalt) {
            taskId = this.idleTaskId;
            reason = BarmanTaskSwitchRecordV1.Reason.PREEMPTED;
        } else {
            taskId = this.protocolState.getLastActiveTaskPerCore(core);
            reason = this.protocolState.getLastTaskSwitchReasonPerCore(core);
        }
        return new BarmanHaltEventRecordV2(timestamp, core, enteredHalt, taskId, reason);
    }

    private @NonNull IBarmanRecord createPcRecord(int core, long timestamp, @NonNull ByteBuffer buffer) {
        int taskId = this.protocolState.getLastActiveTaskPerCore(core);
        long pc = this.readMachineWord(buffer);
        TIntLongHashMap counterValues = new TIntLongHashMap();
        return new BarmanSampleRecordV1(timestamp, core, taskId, this.protocolState.getLastTaskSwitchReasonPerCore(core), pc, (TIntLongMap)counterValues);
    }

    private @NonNull IBarmanRecord createSampleRecord(int core, long timestamp, @NonNull ByteBuffer buffer, boolean readPc) {
        long counterValue;
        int numValues = this.header.getPerCorePmuSettings()[core].getNumCounters();
        int taskId = this.getTaskIdOrDefault(buffer);
        int numCustomCounters = this.header.getConfigConstants().getNumCustomCounters() > 0 ? buffer.getInt() : 0;
        long pc = readPc ? this.readMachineWord(buffer) : 0L;
        TIntLongHashMap counterValues = new TIntLongHashMap();
        int i = 0;
        while (i < numValues) {
            int key = this.header.getCounters().getProcessorEventKeyFromEventId(core, i);
            counterValue = buffer.getLong();
            long lastValue = this.protocolState.getLastCounterValuesPerCore(core, i);
            this.protocolState.setLastCounterValuesPerCore(core, i, counterValue);
            counterValues.put(key, counterValue - lastValue);
            ++i;
        }
        i = 0;
        while (i < numCustomCounters) {
            int id = buffer.getInt();
            counterValue = buffer.getLong();
            int key = this.header.getCounters().getCustomCounterKey(id);
            counterValues.put(key, counterValue);
            ++i;
        }
        this.updateLastActiveTask(core, taskId);
        return new BarmanSampleRecordV1(timestamp, core, taskId, this.protocolState.getLastTaskSwitchReasonPerCore(core), pc, (TIntLongMap)counterValues);
    }

    private @NonNull IBarmanRecord createTaskSwitchRecord(int core, long timestamp, @NonNull ByteBuffer buffer) throws BarmanDataError {
        int taskId = buffer.getInt();
        byte reason = buffer.get();
        BarmanTaskSwitchRecordV1.Reason reasonEnum = BarmanTaskSwitchRecordV1.Reason.findReason(reason);
        this.protocolState.setLastActiveTaskPerCore(core, taskId);
        this.protocolState.setLastTaskSwitchReasonPerCore(core, reasonEnum);
        return new BarmanTaskSwitchRecordV1(timestamp, core, taskId, reasonEnum);
    }

    private int getTaskIdOrDefault(@NonNull ByteBuffer buffer) {
        return this.header.getConfigConstants().getMaxTaskInfos() > 0 ? buffer.getInt() : 0;
    }

    private long readMachineWord(@NonNull ByteBuffer buffer) {
        return this.bits64 ? buffer.getLong() : (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    private void updateLastActiveTask(int core, int taskId) {
        if (this.protocolState.getLastActiveTaskPerCore(core) != taskId) {
            this.protocolState.setLastActiveTaskPerCore(core, taskId);
            this.protocolState.setLastTaskSwitchReasonPerCore(core, BarmanTaskSwitchRecordV1.Reason.PREEMPTED);
        }
    }
}

