/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.analysis.gator.IProtocolState;
import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barman.v1.BarmanTaskSwitchRecordV1;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanProtocolStateV3
implements IProtocolState,
Cloneable {
    private static final String ATTR_CORE = "core";
    private static final String COUNTER_SEPARATOR = ",";
    private static final String TAG_COUNTER_VALUES = "counter_values";
    private static final String TAG_COUNTER_VALUESS = "counter_valuess";
    private static final String TAG_TASK = "task";
    private static final String TAG_TASK_SWITCH_REASON = "task_switch_reason";
    private static final String TAG_TASK_SWITCH_REASONS = "task_switch_reasons";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_TIMESTAMP = "timestamp";
    private final @NonNull CopyOnFirstWriteArray<Integer> lastActiveTaskPerCore;
    private final @NonNull List<@NonNull CopyOnFirstWriteArray<Long>> lastCounterValuesPerCore;
    private final @NonNull CopyOnFirstWriteArray<BarmanTaskSwitchRecordV1.Reason> lastTaskSwitchReasonPerCore;
    private long lastTimestamp;
    private final int numCores;

    public BarmanProtocolStateV3(@NonNull BarmanProtocolStateV3 previousState, XMLParser xml) throws IOException {
        this(previousState);
        try {
            String tag;
            String marker = xml.getMarker();
            block33: while ((tag = xml.nextTag(marker)) != null) {
                switch (tag) {
                    case "timestamp": {
                        this.lastTimestamp = Long.parseLong(xml.getText());
                        break;
                    }
                    case "tasks": {
                        String marker_tasks = xml.getMarker();
                        while ((tag = xml.nextTag(marker_tasks)) != null) {
                            switch (tag) {
                                case "task": {
                                    int core = xml.getIntegerAttribute(ATTR_CORE);
                                    int task = Integer.parseInt(xml.getText());
                                    this.setLastActiveTaskPerCore(core, task);
                                    break;
                                }
                                default: {
                                    xml.skip();
                                }
                            }
                        }
                        continue block33;
                    }
                    case "task_switch_reasons": {
                        String marker_task_switch_reasons = xml.getMarker();
                        while ((tag = xml.nextTag(marker_task_switch_reasons)) != null) {
                            switch (tag) {
                                case "task_switch_reason": {
                                    int core = xml.getIntegerAttribute(ATTR_CORE);
                                    BarmanTaskSwitchRecordV1.Reason reason = BarmanTaskSwitchRecordV1.Reason.findReason(Byte.parseByte(xml.getText()));
                                    this.setLastTaskSwitchReasonPerCore(core, reason);
                                    break;
                                }
                                default: {
                                    xml.skip();
                                }
                            }
                        }
                        continue block33;
                    }
                    case "counter_valuess": {
                        String marker_counter_valuess = xml.getMarker();
                        block36: while ((tag = xml.nextTag(marker_counter_valuess)) != null) {
                            switch (tag) {
                                case "counter_values": {
                                    int core = xml.getIntegerAttribute(ATTR_CORE);
                                    String text = xml.getText();
                                    long[] counterValues = !text.isEmpty() ? Stream.of(text.split(COUNTER_SEPARATOR)).mapToLong(Long::parseLong).toArray() : new long[]{};
                                    int i = 0;
                                    while (i < counterValues.length) {
                                        this.setLastCounterValuesPerCore(core, i, counterValues[i]);
                                        ++i;
                                    }
                                    continue block36;
                                }
                                default: {
                                    xml.skip();
                                }
                            }
                        }
                        continue block33;
                    }
                    default: {
                        xml.skip();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        catch (BarmanDataError e) {
            throw new IOException(e);
        }
    }

    public BarmanProtocolStateV3(@NonNull BarmanHeaderDataV1.PmuSettings @NonNull [] pmuSettings, int defaultTaskId) {
        this.numCores = pmuSettings.length;
        this.lastCounterValuesPerCore = new ArrayList<CopyOnFirstWriteArray<Long>>(this.numCores);
        int core = 0;
        while (core < this.numCores) {
            this.lastCounterValuesPerCore.add(new CopyOnFirstWriteArray<Long>(new Long[pmuSettings[core].getNumCounters()], 0L, a -> (Long[])a.clone()));
            ++core;
        }
        this.lastActiveTaskPerCore = new CopyOnFirstWriteArray<Integer>(new Integer[this.numCores], defaultTaskId, a -> (Integer[])a.clone());
        this.lastTaskSwitchReasonPerCore = new CopyOnFirstWriteArray<BarmanTaskSwitchRecordV1.Reason>(new BarmanTaskSwitchRecordV1.Reason[this.numCores], BarmanTaskSwitchRecordV1.Reason.PREEMPTED, a -> (BarmanTaskSwitchRecordV1.Reason[])a.clone());
    }

    private BarmanProtocolStateV3(@NonNull BarmanProtocolStateV3 previousState) {
        this.numCores = previousState.numCores;
        this.lastTimestamp = previousState.lastTimestamp;
        this.lastCounterValuesPerCore = new ArrayList<CopyOnFirstWriteArray<Long>>(previousState.lastCounterValuesPerCore.size());
        for (CopyOnFirstWriteArray<Long> previousValue : previousState.lastCounterValuesPerCore) {
            this.lastCounterValuesPerCore.add(new CopyOnFirstWriteArray<Long>(previousValue));
        }
        this.lastActiveTaskPerCore = new CopyOnFirstWriteArray<Integer>(previousState.lastActiveTaskPerCore);
        this.lastTaskSwitchReasonPerCore = new CopyOnFirstWriteArray<BarmanTaskSwitchRecordV1.Reason>(previousState.lastTaskSwitchReasonPerCore);
    }

    public @NonNull BarmanProtocolStateV3 clone() {
        return new BarmanProtocolStateV3(this);
    }

    public int getLastActiveTaskPerCore(int core) {
        return this.lastActiveTaskPerCore.get(core);
    }

    public long getLastCounterValuesPerCore(int core, int counterIndex) {
        return this.lastCounterValuesPerCore.get(core).get(counterIndex);
    }

    public  @NonNull BarmanTaskSwitchRecordV1.Reason getLastTaskSwitchReasonPerCore(int core) {
        return (BarmanTaskSwitchRecordV1.Reason)((Object)NullChecking.neverNull((Object)((Object)this.lastTaskSwitchReasonPerCore.get(core))));
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastActiveTaskPerCore(int core, int taskId) {
        this.lastActiveTaskPerCore.set(core, taskId);
    }

    public void setLastCounterValuesPerCore(int core, int counterIndex, long value) {
        this.lastCounterValuesPerCore.get(core).set(counterIndex, value);
    }

    public void setLastTaskSwitchReasonPerCore(int core,  @NonNull BarmanTaskSwitchRecordV1.Reason reason) {
        this.lastTaskSwitchReasonPerCore.set(core, reason);
    }

    public void setLastTimestamp(long lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    @Override
    public void write(XMLGenerator xml) throws IOException {
        int i;
        xml.startTag(TAG_TIMESTAMP);
        xml.addText(Long.toString(this.lastTimestamp));
        xml.endTag();
        if (this.lastActiveTaskPerCore.isModified()) {
            xml.startTag(TAG_TASKS);
            i = 0;
            while (i < this.lastActiveTaskPerCore.length()) {
                xml.startTag(TAG_TASK);
                xml.addAttribute(ATTR_CORE, i);
                xml.addText(this.lastActiveTaskPerCore.get(i).toString());
                xml.endTag();
                ++i;
            }
            xml.endTag();
        }
        if (this.lastTaskSwitchReasonPerCore.isModified()) {
            xml.startTag(TAG_TASK_SWITCH_REASONS);
            i = 0;
            while (i < this.lastTaskSwitchReasonPerCore.length()) {
                xml.startTag(TAG_TASK_SWITCH_REASON);
                xml.addAttribute(ATTR_CORE, i);
                xml.addText(Byte.toString(this.lastTaskSwitchReasonPerCore.get(i).getProtocolValue()));
                xml.endTag();
                ++i;
            }
            xml.endTag();
        }
        xml.startTag(TAG_COUNTER_VALUESS);
        i = 0;
        while (i < this.lastCounterValuesPerCore.size()) {
            if (this.lastCounterValuesPerCore.get(i).isModified()) {
                xml.startTag(TAG_COUNTER_VALUES);
                xml.addAttribute(ATTR_CORE, i);
                String text = this.lastCounterValuesPerCore.get(i).stream().map(o -> o.toString()).collect(Collectors.joining(COUNTER_SEPARATOR));
                xml.addText(text);
                xml.endTag();
            }
            ++i;
        }
        xml.endTag();
    }

    private static class CopyOnFirstWriteArray<T> {
        private T[] array;
        private final @NonNull IArrayCloner<T> cloner;
        private boolean modified;

        public CopyOnFirstWriteArray(@NonNull CopyOnFirstWriteArray<T> that) {
            this.array = that.array;
            this.cloner = that.cloner;
            this.modified = false;
        }

        public CopyOnFirstWriteArray(T[] array, T fill, @NonNull IArrayCloner<T> cloner) {
            this.array = array;
            this.cloner = cloner;
            this.modified = false;
            Arrays.fill(array, fill);
        }

        public T get(int index) {
            return this.array[index];
        }

        public boolean isModified() {
            return this.modified;
        }

        public int length() {
            return this.array.length;
        }

        public void set(int index, T value) {
            if (!NullChecking.equalsNullable(this.array[index], value)) {
                if (!this.modified) {
                    this.modified = true;
                    this.array = this.cloner.clone(this.array);
                }
                this.array[index] = value;
            }
        }

        public Stream<T> stream() {
            return Arrays.stream(this.array);
        }
    }

    @FunctionalInterface
    private static interface IArrayCloner<T> {
        public T[] clone(T[] var1);
    }
}

